#include <alloc.h>
#include <dos.h>
#include <mem.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include "iolib.h"

/*=========================================================================*/
/*  ioedc.c   -- library of i/o functions for use from Turbo C             */
/*               part II : the editor-in-a-box (color version)             */
/*               by John Queern, Belleville, IL (public domain)            */
/*=========================================================================*/
/* NOTE: you must also link in iolib.obj if using ioed or ioedc            */

/* function prototypes */
void do_help (void);                        /* box editor help         */
void redraw (char *edscreen,int sx,         /* draw/redraw editor data */
   int sy, int wid, int lines);
void redrawc (char *edscreen,				/* redraw with color map   */
   char *colormap,int sx, int sy,
   int wid, int lines);
int  edit (char *edscreen, char *colormap,  /* editor-in-a-box         */
   int sx, int sy, int *px, int *py,
   int wid, int lines);

typedef struct BOX_CHARSET {
    char    bul;    /* box upper left */
    char    bh;     /* box horiz */
    char    bhc;    /* box upper horizontal with cross */
    char    bhlc;   /* box lower horizontal with cross */
    char    bur;    /* box upper right */
    char    bv;     /* box vertical */
    char    blvc;   /* box left vertical with cross */
    char    brvc;   /* box right vertical with cross */
    char    bll;    /* box lower left */
    char    bc;     /* box cross */
    char    blr;    /* box lower right */
    } BOXCHARS;


BOXCHARS *get_boxchar(void);        /* (fncn for internal use) */
BOXCHARS single = { '','','','','','','','','','',''};
BOXCHARS duble =  { '','','','','','','','','','',''};
BOXCHARS sindub = { '','','','','','','','','','',''};
BOXCHARS dubsin = { '','','','','','','','','','',''};
BOXCHARS ascii =  { '+','-','+','+','+','|','+','+','+','+','+'};
BOXCHARS half1 =  { '','','','','','','','','','',''};
BOXCHARS half2 =  { '','','','','','','','','','',''};
BOXCHARS half3 =  { '','','','','','','','','','',''};
BOXCHARS solid =  { '','','','','','','','','','',''};

BOXCHARS  *box = &single;       /* box char pointer, default style */

int colorsynch=0;   /* true to keep color map in synch with text */

/*========================================================================*/

void do_help (void)
/* help screen for the editor */
{
    char   ch;
	struct text_info t;

	savescreen(1);

/*	gettextinfo(&t);
	textmode(C80);     */

    bback=LIGHTGRAY;
	bfore=BLUE;
    bclear(0);
	bwrite(0,5,1, "ͻ");
	bwrite(0,5,2, "    Cursor Movement:         F1 -   show this help screen            ");
	bwrite(0,5,3, "                             F2 -   view/select special character    ");
	bwrite(0,5,4, "           ^e                F3 -   color a rectangular region       ");
	bwrite(0,5,5, "                             F4 -   UNDO                             ");
	bwrite(0,5,6, "            ^                F5 -   set working colors (for F3)      ");
	bwrite(0,5,7, "            |                F6 -   select box draw character set    ");
	bwrite(0,5,8, "            |                F7/F8, ^b/^u - make/unmake a box        ");
	bwrite(0,5,9, "    ^s <----o----> ^d        F9/F10 - horizontal/vertical line draw  ");
	bwrite(0,5,10,"            |                Home - go to top left hand corner       ");
	bwrite(0,5,11,"            |                PgUp, ^r - go to top line               ");
	bwrite(0,5,12," or use     v                PgDn, ^c - go to bottom line            ");
	bwrite(0,5,13," cursor                      End, ^w - save changes, exit            ");
	bwrite(0,5,14," keys...   ^x                Ins, ^v - toggle insert mode            ");
	bwrite(0,5,15,"                             Del, ^g - delete one character          ");
	bwrite(0,5,16,"                             Tab, ^i - go to next tab position       ");
	bwrite(0,5,17,"    NOTE: ^ = hold Ctrl      ^y - delete a line                      ");
	bwrite(0,5,18,"                             ^z - blank the entire screen            ");
	bwrite(0,5,19,"                             ^t - delete word right                  ");
	bwrite(0,5,20," ^l - deposit speciaL char   ^a/^f - advance one word left/right     ");
	bwrite(0,5,21," ^k - toggle color synch     ^qs/^qd - go to beginning/end of line   ");
	bwrite(0,5,22," (to make color follow txt)  ^n - insert line after this character   ");
	bwrite(0,5,23,"ͼ");
    bwrite(0,5,24,"Press any key to continue editing...");
    restorescreen(0);
	getch();
	/*
	textmode(t.currmode);
	textcolor(t.attribute & 0x0f);
	textbackground((t.attribute & 0x70) >> 4);
	*/
    restorescreen(1);

}

/*========================================================================*/

BOXCHARS *get_boxchar(void)
/* display box character set options, & return pointer to selected set */
{
    int     i,j;
    char    ch;
    BOXCHARS *b;

    savescreen(1);
	savescreen(0);
    bback=LIGHTGRAY;
	bfore=BLUE;
    bwrite(0,5,2, "ͻ");
    bwrite(0,5,3, "  Box Character Selection:        ");
    bwrite(0,5,4, "                                  ");
    bwrite(0,5,5, "               Ŀ              ");
    bwrite(0,5,6, "  a. single    ͻ             ");
    bwrite(0,5,7, "  b. double    ͸            ");
    bwrite(0,5,8, "  c. sing/doub  ȳķ           ");
    bwrite(0,5,9, "  d. doub/sing   Ժ+---+          ");
    bwrite(0,5,10,"  e. ascii        |         ");
    bwrite(0,5,11,"  f. half1         +        ");
    bwrite(0,5,12,"  g. half2                  ");
    bwrite(0,5,13,"  h. half3                  ");
	bwrite(0,5,14,"  i. solid                   ");
    bwrite(0,5,15,"                                  ");
    bwrite(0,5,16,"  Selection (a-i)?                ");
    bwrite(0,5,17,"                                  ");
    bwrite(0,5,18,"ͼ");
    restorescreen(0);
    gotoxy(26,16);
    fflush(stdin);
    ch=getche();
    ch=tolower(ch);
    switch (ch) {
        case 'a': b=&single; break;
        case 'b': b=&duble;  break;
        case 'c': b=&sindub; break;
        case 'd': b=&dubsin; break;
        case 'e': b=&ascii;  break;
        case 'f': b=&half1;  break;
        case 'g': b=&half2;  break;
        case 'h': b=&half3;  break;
        case 'i': b=&solid;
    }

    restorescreen(1);
    return(b);
}

/*========================================================================*/

int get_specchar(void)
/* display special characters, & return the selected char or 0 if none */
{
	unsigned     i,j;
	int     ch,col=0;
	char    buff[81];

    savescreen(1);
	savescreen(0);
    bback=LIGHTGRAY;
	bfore=BLUE;
	bwrite(0,5,1, "ͻ");
	bwrite(0,5,2, "  Special Character Selection:    ");
	bwrite(0,5,3, "     (use ctrl-L to deposit)      ");
	bwrite(0,5,4, "   0 1 2 3 4 5 6 7 8 9 A B C D E F");

	for (i=0; i<32; i += 16) {
		sprintf(buff,
			/*    "1  0 1 2 3 4 5 6 7 8 9 A B C D E F"  */
				  "%X  %c %c %c %c %c %c %c %c %c %c %c %c %c %c %c %c",
				  i/16,max(i,1),i+1,i+2,i+3,i+4,i+5,i+6,i+7,i+8,i+9,i+10,
				  i+11,i+12,i+13,i+14,i+15);
		bwrite(0,5,5+(i/16),buff);
	}

	for (i=0x80; i<0xff; i += 16) {
		sprintf(buff,
			/*    "1  0 1 2 3 4 5 6 7 8 9 A B C D E F"  */
				  "%X  %c %c %c %c %c %c %c %c %c %c %c %c %c %c %c %c",
				  i/16,i,i+1,i+2,i+3,i+4,i+5,i+6,i+7,i+8,i+9,i+10,
				  i+11,i+12,i+13,i+14,i+15);
		bwrite(0,5,7+(i-0x80)/16,buff);
	}

	bwrite(0,5,15,"  Selection (xx) ?                ");
	bwrite(0,5,16,"ͼ");
	restorescreen(0);
	strcpy(buff,"00");
	getstring(26,15,&col,buff,2);
	ch=0;
	sscanf(buff,"%x",&ch);
	restorescreen(1);
	return(ch);
}

/*========================================================================*/

int get_color(void)
/* display colors, & return the selected attribute value */
{
	unsigned     i,j;
	int     ch,col=0;
	char    buff[81];

    savescreen(1);
	savescreen(0);
	bback=LIGHTGRAY;
	bfore=BLUE;
	bwrite(0,5,1, "ͻ");
	bwrite(0,5,2, "  Color Attribute Selection:      ");
	bwrite(0,5,3, "     (use F3 to paint with it)    ");
	bwrite(0,5,4, "   0 1 2 3 4 5 6 7 8 9 A B C D E F");
	for (i=0; i<8; i++) bwrite(0,5,5+i,
	  "                                  ");
	bwrite(0,5,13,"  Selection (xx) ?                ");
	bwrite(0,5,14,"ͼ");
	restorescreen(0);


	for (i=0; i<8; i ++) {
	  cputchxy(6,5+i,i+'0',(LIGHTGRAY<<4)+BLUE);
	  for (j=0; j<16; j++) {
		cputchxy(9+(2*j),5+i,'x',(i<<4)+j);
	  }
	}

	strcpy(buff,"07");
	getstring(26,13,&col,buff,2);
	col=(WHITE<<4)+BLACK;
	sscanf(buff,"%x",&col);
	restorescreen(1);
	if (col==0) col=7;  /* don't permit NULL to be used */
	return(col);
}


/*========================================================================*/

void redraw (char *edscreen,int sx, int sy, int wid, int lines)
/* redraw internal part of screen */
/* NOTE: this routine uses screen buffer 1 */
{

    int     i;

    savescreen(1);
    for (i=0; i<lines; i++) pad(edscreen + i*wid+i,wid); /* pad lines */
	for (i=0; i<lines; i++)
		 bwrite(1,sx,i+sy,(edscreen + i*wid + i));
    restorescreen(1);
}

void redrawc (char *edscreen,char *colormap,int sx, int sy, int wid, int lines)
/* redraw internal part of screen with color map */
/* NOTE: this routine uses screen buffer 1 */
{

    int     i;

	if (colormap==NULL) {
		 redraw(edscreen,sx,sy,wid,lines);
		 return;
	}
    savescreen(1);
    for (i=0; i<lines; i++) pad(edscreen + i*wid+i,wid); /* pad lines */
	for (i=0; i<lines; i++)
		 cwrite(1,sx,i+sy,(edscreen + i*wid + i),
		   (colormap + i*wid + i));
    restorescreen(1);
}

/*========================================================================*/

int  edit (char *edscreen, char *colormap,
		   int sx, int sy, int *px, int *py, int wid, int lines)
/* editor in a box */
/* Initiate multiline editor using buffer edscreen, in a box at sx,sy;
   edscreen is a buffer which must contain at least (lines*wid+lines) bytes;
   The editor will assume it is set up as an array of <lines> strings,
   each <wid> long;  return special keys which aren't handled internally;
*/
{
    char        ch;
	int         a,b,ca,cb;
    int         i,j,n,retcd,_retcd;
    int         x,y,xx;
    char        *blank;
	int			special=0;  /* 'special' char */

	int         inbox,inclear,savetrim,incolor;
	int			foreground=WHITE, background=BLUE, color;
	char        *lptr, *cptr, *lcptr, *tcptr, *bcptr;
	char		*oldcolormap,*oldedscreen;

    blank=(char *)calloc(1,wid+1);
    blank[0]=0;
    pad(blank,wid);
    _retcd=0;
	inbox=inclear=insert=incolor=FALSE;
    savetrim=trimblanks;
	trimblanks=FALSE;

	/* insert NULLS into color map so that string routines can be used */
	for (i=0; i<lines; i++) *(colormap+i*wid+i+wid)=0;

	/* make backup areas and init them */
	oldcolormap = malloc(25*81);  /* size of colormap */
	if (oldcolormap==NULL) {
		printf("Not enough memory to save color map.\n");
		exit(1);
	}
	memcpy(oldcolormap,colormap,25*81);
	oldedscreen = malloc(25*81);  /* size of edscreen */
	if (oldedscreen==NULL) {
		printf("Not enough memory to save workspace.\n");
		exit(1);
	}
	memcpy(oldedscreen,edscreen,25*81);

	redrawc(edscreen,colormap,sx,sy,wid,lines);
    x=*px;
    y=*py; /* x and y are relative--(0,0) is upper l.h. corner of box */
	colx=14;
	coly=24;
	do  {
		textcolor(foreground);
		textbackground(background);
		gotoxy(1,24);
		cprintf(
"Row:%3d  Col:%3d                                                              ",
		y+1,x+1);
		gotoxy(24,24);
		if (inbox) cprintf("<box>");
		else if (inclear) cprintf("<clr>");
		else if (incolor) cprintf("<col>");
		else cprintf("     ");
		gotoxy(68,24);
		if (colorsynch) cprintf("<synch ON >");
		else cprintf("<synch OFF>");

        lptr=edscreen+y*wid+y;  /* pointer to current line (line y) */
        retcd=getstring(sx,sy+y,&x,lptr,wid);
        cptr=lptr+x;          /* pointer to char at cursor pos */

        switch (retcd) {
          case 0 :
          case 1 :
            x=0;
          case 6 :
            if (y<lines-1) y++;
			else beep();
            break;
          case 3 :
            if (y>0) y--;
			else beep();
            break;
          case 11 :         /* F1 */
            do_help();
			break;
		  case 12 :         /* F2 */
			special = get_specchar();
			break;

		  case 13 :         /* F3 */ /* create color box */
			if (! incolor) {
                /* save cursor position */
				ca=x; /* offset */
				cb=y;
				incolor = TRUE;
            }
			/* already in color -- color it */
			else {
				memcpy(oldcolormap,colormap,25*81); /* save current */
				color = (background << 4) + foreground;
				for (i=min(cb,y); i<=max(cb,y); i++) {
				  bcptr=colormap+i*wid+i+min(ca,x);
				  for (j=min(ca,x)+1;j<=max(ca,x)+1;j++)
					*(bcptr++)=color;
				}
				incolor = FALSE;
				x=ca;
				y=cb;
				redrawc(edscreen,colormap,sx,sy,wid,lines);
            }
			break;

		  case 14 :         /* F4 */ /* restore previous color/text */
			memcpy(colormap,oldcolormap,25*81);
			memcpy(edscreen,oldedscreen,25*81);
            redrawc(edscreen,colormap,sx,sy,wid,lines);
			break;

		  case 15 :         /* F5 */ /* select colors */
			color=get_color();
			foreground=color%16;
			background=(color>>4)%16;
			break;

          case 16 :         /* F6 */
            box = get_boxchar();
            break;
          case 24 :         /* Home */
            y = 0;
            x = 0;
            break;
          case 9 :          /* PgUp */
            y = 0;
            break;
          case 10:          /* PgDn */
            y = lines-1;
            break;

		  case 17:          /* F7 or  */
          case 25:          /* ctrl-b (box) */
            if (! inbox) {
                /* save cursor position */
                a=x; /* offset */
                b=y;
                inbox = TRUE;
            }
            /* already in box-- draw it */
			else {
                memcpy(oldedscreen,edscreen,25*81); /* save screen */
				memcpy(oldcolormap,colormap,25*81);
				/* draw horizontal pieces */
                bcptr=edscreen+y*wid+y+min(a,x);
                tcptr=edscreen+b*wid+b+min(a,x);
                for (i=min(a,x)+1;i<max(a,x);i++) {
                    *(++bcptr)=box->bh;
                    *(++tcptr)=box->bh;
                }
                /* draw vertical pieces */
                bcptr=edscreen+min(y,b)*wid+min(y,b)+a;
                tcptr=edscreen+min(y,b)*wid+min(y,b)+x;
                for (i=min(b,y); i<=max(b,y)-1; i++) {
                    *bcptr=box->bv;
                    *tcptr=box->bv;
                    bcptr += wid + 1;
                    tcptr += wid + 1;
                }
                /* add corners */
                *(edscreen+min(b,y)*wid+min(b,y)+min(a,x))=box->bul;
                *(edscreen+max(b,y)*wid+max(b,y)+min(a,x))=box->bll;
                *(edscreen+min(b,y)*wid+min(b,y)+max(a,x))=box->bur;
                *(edscreen+max(b,y)*wid+max(b,y)+max(a,x))=box->blr;
                inbox = FALSE;
                x=a;
                y=b;
				redrawc(edscreen,colormap,sx,sy,wid,lines);
            }
            break;

          case 18:          /* F8 or  */
		  case 26:          /* ctrl-u (box clear) */
            if (! inclear) {
                /* save cursor position */
                a=x; /* offset */
                b=y;
                inclear = TRUE;
            }
            /* already in clear-- clear it */
			else {
                memcpy(oldedscreen,edscreen,25*81); /* save screen */
				memcpy(oldcolormap,colormap,25*81);
				/* clear horizontal pieces */
                bcptr=edscreen+y*wid+y+min(a,x);
                tcptr=edscreen+b*wid+b+min(a,x);
                for (i=min(a,x)+1;i<max(a,x);i++) {
                    *(++bcptr)=' ';
                    *(++tcptr)=' ';
                }
                /* clear vertical pieces */
                bcptr=edscreen+min(y,b)*wid+min(y,b)+a;
                tcptr=edscreen+min(y,b)*wid+min(y,b)+x;
                for (i=min(b,y); i<=max(b,y)-1; i++) {
                    *bcptr=' ';
                    *tcptr=' ';
                    bcptr += wid + 1;
                    tcptr += wid + 1;
                }
                /* clear corners */
                *(edscreen+min(b,y)*wid+min(b,y)+min(a,x))=' ';
                *(edscreen+max(b,y)*wid+max(b,y)+min(a,x))=' ';
                *(edscreen+min(b,y)*wid+min(b,y)+max(a,x))=' ';
                *(edscreen+max(b,y)*wid+max(b,y)+max(a,x))=' ';
                inclear = FALSE;
                x=a;
                y=b;
				redrawc(edscreen,colormap,sx,sy,wid,lines);
            }
            break;

		  case 19:          /* F9 - draw horizontal line */
			memcpy(oldedscreen,edscreen,25*81); /* save screen */
			memcpy(oldcolormap,colormap,25*81);
            lcptr = cptr - 1;  /* char to left of current pos */
            tcptr = edscreen+(y-1)*wid+(y-1)+x;  /* char above current */
            bcptr = edscreen+(y+1)*wid+(y+1)+x;  /* char below current */

            /* fix up left hand connection if necessary */
            if (*cptr==box->bh || *cptr==box->bc) {  /* erasing a line? */
                if (*lcptr==box->bul) *lcptr=box->bv;
                else if (*lcptr==box->blvc) *lcptr=box->bv;
                else if (*lcptr==box->blvc) *lcptr=box->bv;
                else if (*lcptr==box->bhc) *lcptr=box->bur;
                else if (*lcptr==box->bhlc) *lcptr=box->blr;
                else if (*lcptr==box->bc) *lcptr=box->brvc;
            }
            else {                                  /* adding a line? */
                if (*lcptr==box->bv) {
                    if ((*(tcptr-1)==box->bv || *(tcptr-1)==box->bc
                        || *(tcptr-1)==box->blvc)
                        && (*(bcptr-1)==box->bv || *(bcptr-1)==box->bc
                        || *(bcptr-1)==box->blvc))
                        *lcptr=box->blvc;
                    else if (*(tcptr-1)==box->bv || *(tcptr-1)==box->bc)
                        *lcptr=box->bll;
                    else if (*(bcptr-1)==box->bv || *(bcptr-1)==box->bc)
                        *lcptr=box->bul;
                }
                else if (*lcptr==box->bur) *lcptr=box->bhc;
                else if (*lcptr==box->blr) *lcptr=box->bhlc;
                else if (*lcptr==box->brvc) *lcptr=box->bc;
            }
            for (i=x; i<wid; i++) {
                if (*cptr==box->bv) *cptr=box->bc;
                else if (*cptr==box->bh) *cptr=' ';
                else if (*cptr==box->brvc) *cptr=box->bv;
                else if (*cptr==box->blvc) *cptr=box->bv;
                else if (*cptr==box->bc) *cptr=box->bv;
                else if (*cptr==box->bhlc) *cptr=box->bv;
                else if (*cptr==box->bhc) *cptr=box->bv;
                else *cptr=box->bh;
                cptr++;
            }
			redrawc(edscreen,colormap,sx,sy,wid,lines);
            break;

		  case 20:          /* F10 - draw vertical line */
            memcpy(oldedscreen,edscreen,25*81); /* save screen */
			memcpy(oldcolormap,colormap,25*81);
            lcptr = cptr - 1;  /* char to left of current pos */
            tcptr = edscreen+(y-1)*wid+(y-1)+x;  /* char above current */
            bcptr = edscreen+(y+1)*wid+(y+1)+x;  /* char below current */

            /* fix up upper connection if necessary */
            if (*cptr==box->bv || *cptr==box->bc) {  /* erasing a line? */
                if (*tcptr==box->bur || *tcptr==box->bul
                    || *tcptr==box->bhc) *tcptr=box->bh;
                else if (*tcptr==box->blvc) *tcptr=box->bll;
                else if (*tcptr==box->brvc) *tcptr=box->blr;
                else if (*tcptr==box->bc) *tcptr=box->bhlc;
            }
            else {                                  /* adding a line? */
                if (*tcptr==box->bh) {
                    if ((*(tcptr-1)==box->bh || *(tcptr-1)==box->bc
                        || *(tcptr-1)==box->bhc) &&
                        (*(tcptr+1)==box->bh || *(tcptr-1)==box->bc
                        || *(tcptr+1)==box->bhc))
                        *tcptr=box->bhc;
                    else if (*(tcptr-1)==box->bh || *(tcptr-1)==box->bc)
                        *tcptr=box->bur;
                    else if (*(tcptr+1)==box->bv || *(tcptr+1)==box->bc)
                        *tcptr=box->bul;
                }
                else if (*tcptr==box->bll) *tcptr=box->blvc;
                else if (*tcptr==box->blr) *tcptr=box->brvc;
                else if (*tcptr==box->bhc) *tcptr=box->bc;
            }
            for (i=y; i<lines; i++) {
                if (*cptr==box->bh) *cptr=box->bc;
                else if (*cptr==box->bv) *cptr=' ';
                else if (*cptr==box->bc) *cptr=box->bh;
                else if (*cptr==box->blvc) *cptr=box->bh;
                else if (*cptr==box->brvc) *cptr=box->bh;
                else if (*cptr==box->bhlc) *cptr=box->bh;
                else if (*cptr==box->bhc) *cptr=box->bh;
                else *cptr=box->bv;
                cptr += (wid + 1);
            }
			redrawc(edscreen,colormap,sx,sy,wid,lines);
            break;

		  case 21:          /* ctrl-y */
            memcpy(oldedscreen,edscreen,25*81); /* save screen */
			memcpy(oldcolormap,colormap,25*81);
            for (i=y; i<lines-1; i++)
                strcpy(edscreen+i*wid+i,edscreen+(i+1)*wid+i+1);
			strcpy(edscreen+(lines-1)*wid+lines-1,blank);
			if (colorsynch) {
              for (i=y; i<lines-1; i++)
				strcpy(colormap+i*wid+i,colormap+(i+1)*wid+i+1);
			  strcpy(colormap+(lines-1)*wid+lines-1,blank);
			}
			redrawc(edscreen,colormap,sx,sy,wid,lines);
			break;

          case 22:          /* ctrl-z */
			gotoxy(1,24);
            clreol();
            cprintf("Zap entire screen -- you sure (Y/N)?");
            ch=getch();
            ch=toupper(ch);
			if (ch == 'Y') {
                memcpy(oldedscreen,edscreen,25*81); /* save screen */
				memcpy(oldcolormap,colormap,25*81);
                for (i=0; i<lines; i++) {
                    strcpy(edscreen+i*wid+i,blank);
				}
				if (colorsynch){
				  /* set everything to white on black */
				  memset(colormap,(BLACK<<4)+WHITE,25*81);
				  /* restore NULLS at end of "lines" */
				  for (i=0; i<lines; i++) *(colormap+i*wid+i+wid)=0;
				}

                y=1;
                x=0;
				redrawc(edscreen,colormap,sx,sy,wid,lines);
            }
            else {
			 gotoxy(1,24);
                clreol();
            }
			break;

		  case 28:      /* ctrl-k */
			if (colorsynch) colorsynch=FALSE;
			else colorsynch=TRUE;
			break;

		  case 27:      /* ctrl-l */
			*(edscreen+y*wid+y+x)=special;
			sputchxy(x+1,y+1,special);
			if (x<79) x++;
            break;

		  case 23:      /* ctrl-n */
            memcpy(oldedscreen,edscreen,25*81); /* save screen */
			memcpy(oldcolormap,colormap,25*81);
            for (i=lines-1; i>y; i--) strcpy(edscreen+i*wid+i,
              edscreen+(i-1)*wid+i-1);
            *(edscreen+y*wid+y+x)=0; /* cut orig line short */
            if (y<lines-1) {
              strdel(edscreen+(y+1)*wid+y+1,0,x);
              pad(edscreen+y*wid+y,wid);
              y++;
              x=0;
			}
			if (colorsynch) {
			  for (i=lines-1; i>y; i--) strcpy(colormap+i*wid+i,
			  colormap+(i-1)*wid+i-1);
			  /* let bottom line retain current color map */
			}
			redrawc(edscreen,colormap,sx,sy,wid,lines);
			break;

		  default:     /* any other special keys */
		  /*
            _retcd=retcd;
			retcd=8; */
			beep();
			break;
        } /* switch retcd */
    }
    while ((retcd != 7) && (retcd != 8));

    gotoxy(1,24);
    clreol();
    colx=0;
    coly=0;

    trimblanks=savetrim;
    if (trimblanks==TRUE)
      for (i=0; i<lines; i++) trim(edscreen+i*wid+i); /* trim blanks */

    *px = x; /* return position in box when leaving */
	*py = y;

	free(oldcolormap);

    return(_retcd);

} /* edit */
