{$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,R-,S-,V-,X-}
{$M $800,0,0 }

{ Este programa s pode ser compilado com o Turbo Pascal 6.0 ou superior ! }

{ A no ser que retirem os G-, e ,X- na 1 linha, e troquem os             }
{ asm/PUSHF/end mais abaixo pelos inlines respectivos...                   }

uses Dos;

const Version         = '1.0';
      HotKey          = $2E00;           { Activate with ALT-SHIFT-C }
      HotMask         = $03;
      AUTHOR          = '[1;32m              Fernando Madruga    [0m    ';
                      { Os 's so para apagar o 'lixo' que aparece }
                      { se no tiver o ANSI.SYS carregado...        }

const CurrFile  : integer  = 0;
      Activate  : boolean  = false;
      Busy      : boolean  = false;
      InDosFlag : ^byte    = NIL;
      ColorTable: array[0..7] of char = (
                  '0', '4', '2', '6', '1', '5', '3', '7');

var   KbdIntVec   : Procedure;
      TimerIntVec : Procedure;
      BusyIntVec  : Procedure;
      PrgDta      : pointer;
      MyDta       : pointer;
      F           : Text;
      X, Y        : integer;
      S           : PathStr;
      R           : Registers;
      Screen      : array[0..1999] of record
                      Ch    : char;
                      Color : byte;
                    end absolute $B800:$0000;
      CurrColor   : byte;
      OldColor    : byte;

function GetInDosFlag: pointer;
begin
  R.AH := $34;
  Intr($21, R);
  GetInDosFlag := Ptr(R.ES,R.BX);
end; { func GetInDosFlag }

procedure SetDta(DtaAddr : pointer);
begin
  R.AH := $1A;
  R.DS := Seg(DtaAddr^);
  R.DX := Ofs(DtaAddr^);
  Intr($21, R);
end; { proc SetDta }

function GetDta : pointer;
begin
  R.AH := $2F;
  Intr($21, R);
  GetDta := Ptr(R.ES,R.BX);
end; { func GetDta }

procedure SaveImage; far;

  procedure WriteColor;
  var S: string;
  begin
    S := #27 + '[';
    if ((CurrColor and $80) < (OldColor and $80)) or
       ((CurrColor and $08) < (OldColor and $08)) then begin
      {  preciso 'apagar' o BLINK ou o BOLD, e a nica maneira de }
      { o fazer  com um RESET dos atributos, e enviar tudo...     }
      S := S + '0;';
      OldColor := 255 - CurrColor;   { fora o envio de toda a cor }
    end;
    if (OldColor and $08) <> (CurrColor and $08) then begin  { Test Bold }
      if (CurrColor and $08) = $08 then begin                { Bold On   }
        S := S + '1;';
      end;
    end;
    if (OldColor and $80) <> (CurrColor and $80) then begin  { Test Blink }
      if (CurrColor and $80) = $80 then begin                { Blink On   }
        S := S + '5;';
      end;
    end;
    if (OldColor and $07) <> (CurrColor and $07) then begin  { Foreground }
      S := S + '3' + ColorTable[ CurrColor and $07 ] + ';';
    end;
    if (OldColor and $70) <> (CurrColor and $70) then begin  { Background }
      S := S + '4' + ColorTable[ (CurrColor and $70) shr 4] + ';';
    end;
    OldColor := CurrColor;
    if S[Length(S)] = ';' then begin
      Delete(S, Length(S), 1);
    end;
    Write(F, S, 'm');
  end;

begin
  PrgDta := GetDta;
  SetDta(MyDta);
  repeat
    Str(CurrFile, S);
    while length(S) < 4 do begin
      S := '0' + S;
    end;
    Inc(CurrFile);
    S := '\ANS-' + S + '.TXT';
    Assign(F, S);
    {$I-} ReSet(F); {$I+}
  until IOResult <> 0;    { passa ao prximo n se o ficheiro j existir }
  ReWrite(F);
  CurrColor := Screen[0].Color;
  OldColor  := 255 - CurrColor; { Fora o envio de toda a cor no 1 char }
  WriteColor;
  for y := 0 to 24 do begin
    for x := 0 to 79 do begin
      CurrColor := Screen[x+y*80].Color;
      if CurrColor <> OldColor then begin
        WriteColor;
      end;
      Write(F, Screen[x+y*80].Ch);
    end;
    WriteLn(F);
  end;
  Close(F);
  SetDta(PrgDta);
end; { proc SaveImage }

{$F+}
procedure KeyIntercept; interrupt;
var   Up  : boolean;
const Key : boolean = false;
begin
  if Port[$60] >= $80 then begin
    Up := true;
  end else begin
    Up := false;
  end;
  asm   { Call Old Interrupt }
    PUSHF
  end;
  KbdIntVec;
  if (MemW[$40:$1C] <> MemW[$40:$1A])   and
     (MemW[$40:MemW[$40:$1A]] = HotKey) and
     ((Mem[$40:$17] and HotMask) > 0) then begin
    MemW[$40:$1C] := MemW[$40:$1A];
    Key := true;
  end;
  if Up and Key then begin
    Key      := false;
    Activate := true;
  end;
end; { intr proc KeyIntercept }

procedure TimerIntercept; interrupt;
begin
  asm   { Call Old Interrupt }
    PUSHF
  end;
  TimerIntVec;
  if Activate and (InDosFlag^ = 0) and not Busy then begin
    Activate := false;
    Busy     := true;
    SaveImage;
    Busy     := false;
  end;
end; { intr proc TimerIntercept }

procedure BusyIntercept; interrupt;
begin
  if Activate and not Busy then begin
    Activate := false;
    Busy     := true;
    SaveImage;
    Busy     := false;
  end;
end; { intr proc BusyIntercept }
{$F-}

begin
  InDosFlag := GetInDosFlag;
  GetIntVec($9,@KbdIntVec);
  SetIntVec($9,Addr(KeyIntercept));
  GetIntVec($8,@TimerIntVec);
  SetIntVec($8,Addr(TimerIntercept));
  GetIntVec($28,@BusyIntVec);
  SetIntVec($28,Addr(BusyIntercept));
  MyDta := GetDta;
  WriteLn('[2J    ');
  WriteLn('[0mANSI Screen Capture Program. Version ', Version);
  WriteLn('(C) 1992 by: ', AUTHOR);
  WriteLn('Images are saved to \ANS-????.TXT, with ???? starting @ 0000.');
  WriteLn('Activate with ALT-SHIFT-C.');
  Keep(0);
end.

   Feel free to change this program, but don't forget to change the
   author's name ( defined in the constant AUTHOR ) so that I'm not
   blamed for any BUGs that you may insert in the program...
   And you could also change the version number...

   You can also use this as a template for building your own TSR.
   Just put the code you want in the SaveImage procedure and don't
   forget to change the program's name...

                                      (C) 1992, by Fernando Madruga
                                      Released to the Public Domain

   P.S.: Sorry about all this English stuff, but after all, begin, end,
         and the other Pascal keywords are in English, aren't they ?!
