#include "amy.h"

extern "C" {
#include <clib/dos_protos.h>
#include <stdlib.h>
#include <graphics/text.h>
}

#define ID_SLIPOFF	100
#define ID_SLIPON	101

class MyWindow : public AmyWindow {

public:
	MyWindow(int x, int y);

	AmyFont	ownfont;

	AmyButton on, off;

	int GadgetUp(AmyGadget &);
};

MyWindow::MyWindow(int x, int y) : AmyWindow(x, y, 140, 80), 
	ownfont("helvetica.font", 13, FSF_UNDERLINED),
	on(this, Dimension(20,20,100,15), "RHCSlip On", ID_SLIPON),
	off(this, Dimension(20,40,100,15), "RHCSlip Off", ID_SLIPOFF)
{
	SetSizeable(False);
	Set(ownfont);
	SetTitle("Slip Control");
	Show();
	EnableIconDrops(False);
	Draw("Slip Control V0.01", 10, 15);
}

int MyWindow::GadgetUp(AmyGadget &gadget)
{
	switch(gadget.GetID()) {
		
		case ID_SLIPON:
			Execute("AmiTCP:bin/online rhcslip.device 0", NULL, NULL);
			break;

		case ID_SLIPOFF:
			Execute("AmiTCP:bin/offline rhcslip.device 0", NULL, NULL);
			break;
	}

	return 0;
}

int AmyApp::Start(int argc, char **argv)
{
	int x = 200, y = 50;
	
	if(argc == 3) {
		x = atoi(argv[1]);
		y = atoi(argv[2]);
	}

	
	MyWindow ikkuna(x,y);

	ikkuna.WaitForAction();
	
	return 0;	
}
