#include "amy.h"

extern "C" {
#include <stdio.h>
}

/* $Id: test.c 1.1 1994/04/01 12:10:33 Delta stabile $ */

#define ID_TEST		100	// The ID's for all the interactive
#define ID_HELLO	101	// screen elements like buttons and lists
#define ID_INPUT	102
#define ID_PRINT	103
#define ID_INFO		104
#define ID_LIST		105
#define ID_BUTTON	106
#define ID_LIST2	107
#define ID_CYCLE	108

#define PRINTING 1
	// Activate the printing ? AmyPrinter won't be published yet...

char *__procname = "AmyGUI-demo";
	// The process name, works with SAS >V6.5 when linked with cback.o


class MyWindow : public AmyWindow {
	// Deriving a class from the AmyWindow base class.
	// The new class will have all amywindow's capabilities
	// and the same named functions will override the base classes'

protected:
    AmyFileReq filereq;		// A file requester

public:

    MyWindow();
	// The constructor,which gets called automatically when an instance
	// (a variable) of type "class MyWindow" is born.

    AmyButton button, test, hello, print;	// Some buttons
    AmyListview list, list2;			// Two listview gadgets
    AmyInputField input;			// A text input gadget
    AmyCycle cycle;				// A cycle gadget

    int GadgetUp(AmyGadget &);
	// This is interesting. This function gets called when the user
	// presses a gadget of any kind in this type of a window. As a
	// parameter it gets the gadget which was pressed.

    int IconDropped(const char *, AmyPoint &);
	// And this function gets called when an icon is dropped into this
	// window. The parameters are the name of the file (which is
	// depicted by the icon), and the (x,y) point where the icon was
	// dropped.
};

MyWindow::MyWindow() : AmyWindow(20,100,380,170),
	// Initialize the base class which this class was
	// derived from.
	// Then initialize the gadgets, first parameter is
	// the window they will be created in, MyWindow,
	// the second is the size and position, third is
	// the text of the gadget (not the contents of inputfield),
	// then there is the ID of the gadget, to be used to
	// determine which gadget the user pressed.

    button(this, Dimension(20, 10, 50, 12), "Info", ID_INFO),
    test(this, Dimension(20, 25, 50, 12), "Load", ID_TEST),
    hello(this, Dimension(20, 40, 50, 12), "Hello", ID_HELLO),
    print(this, Dimension(20, 55, 50, 12), "Print", ID_PRINT),

    list(this, Dimension(90, 20, 130, 110), "My list", ID_LIST),
    list2(this, Dimension(230, 20, 130, 110), "Schindler's list",
	ID_LIST2),

    cycle(this, Dimension(270, 140, 80, 12), "Cycle", ID_CYCLE),

    input(this, Dimension(70, 140, 150, 12), "Input:", ID_INPUT, 100),
	// The additional parameter here is the max
	// amount of characters in the inputfield.

    filereq(this, Dimension(150,50,300,400),
	"Load a file", "Load", "Cancel")
	// File requester, the three last params
	// are the title, positive and negative responses
{
    SetSizeable(False);	// Don't let the user change the size of this win
    SetTitle("AmyGUI demo - Drop an icon on me");
    Show();		// Voila, the window becomes visible
    EnableIconDrops(True); // Let the user drop icons in our window

    input.Activate();	// Activate the inputfield

    list.Add("Here").Add("Are").Add("Just").Add("A few").Add("Strings");
	// Add few strings to the listview

    cycle.Add("First").Add("Second").Add("Third").Add("Fourth");
	// And to the cycle gadget, with exactly
	// the same mechanism as to the listview...
}

int MyWindow::GadgetUp(AmyGadget &gadget)
{
    switch(gadget.GetID()) {

      case ID_LIST:

	list2.Add(list.GetActiveStr());
		// If the user pressed the listview, let's flip the pressed
		// listword to the other listview
	list.Delete(list.GetActive()+1);
		// and delete it from this one
		// The '+1' is changing, I promise
	break;

      case ID_LIST2:

	list.Add(list2.GetActiveStr());	     // And vice versa (look above)
	list2.Delete(list2.GetActive()+1);

	break;

      case ID_INPUT:

	list.Add(input.GetText());
		// If the inputfield was pressed (return key),
		// put the contents into the first listview
	input.SetText("");
		// and delete it from the inputfield
	break;

      case ID_TEST:

	if(filereq.Show())	// If the user pressed the positive reply
	    input.SetText(filereq.GetFilename());
		// Put the filename into our inputfield
	else
	    input.SetText("Filereq cancelled.");

	break;

      case ID_HELLO:

	if(AmyTextReq(this,
		"Announcement", "You pressed the 'hello' button.",
		"I confess|I did not").Show()) {

	    AmyTextReq thanks(this, "Thank you",
		"It's good that\nyou're honest.", "Of course");
	    thanks.Show();

	} else {

	    AmyTextReq(this, "Request", "Admit it !", "Well ok").Show();
	    input.SetText("The user lied to me.");
	}

	break;

      case ID_PRINT:

	if(AmyTextReq(this, "Attention",
		"Are you sure you wish to print\n"
		"the contents of the screen to paper ?",
		"Print|Cancel").Show()) {
			// Print-button returns 1, Cancel returns 0

#if PRINTING
	    AmyPrinter printer;

	    printer.Print(*this);
#else
	    AmyTextReq(this, "Excuse me",
		"This option is not in use.", "It's so unfair").Show();
#endif
	}

	break;

      case ID_INFO:

#if PRINTING
	char temp[200];
	{
	    AmyPrinter printer;

	    Dimension dpi = printer.GetDPI(), paper = printer.GetMaxDots();

	    sprintf(temp, "Driver: %s\nDPI: %dx%d\nPapersize: %dx%d\n",
		printer.GetDriver(),
		dpi.GetWidth(), dpi.GetHeight(),
		paper.GetWidth(), paper.GetHeight());

	    AmyTextReq(this, "Printer info", temp, "Ok").Show();
	}
#else
	AmyTextReq(this, "Printer info", "Not available", "Ok").Show();
#endif
	break;
    }

    input.Activate();

    return 0;
}

int MyWindow::IconDropped(const char *filename, AmyPoint &point)
{
    if(point.IsInside(list)) {	
		// If the icon was dropped somewhere in thelistview
	list.Add(filename);
		// add the given filename (of the icon) on the listview
	return 0;
    }

    if(point.IsInside(list2)) {
		// The same goes here concerning the other list
	list2.Add(filename);
	return 0;
    }

    if(point.IsInside(input)) {		// -The input field
	input.SetText(filename);
	return 0;
    }

    if(point.IsInside(cycle)) {		// -And the cyclegadget
	cycle.Add(filename);
	return 0;
    }
			// All of the above with the very same mechanism

    AmyTextReq(this, "Info",
	"You should drop the icons on\n -one of the listviews\n"
	" -the input field\n or\n -the cycle gadget", "Sure").Show();

    return 0;
}

int AmyApp::Start(int argc, char **argv)
	// This is the replacement of 'main()'
{
    MyWindow window;

    if(argc > 1) {

	AmyTextReq req(&window, "The first parameter",
			argv[1], "Yes|No");

	if(!req.Show()) {
	    AmyTextReq req2(&window, "Warning",
		"Don't try to fool me.", "I wont");
	    req2.Show();
	}
    }

    window.WaitForAction();

    return 0;
}
