/******************************************************************
*
*	AmyGUI++ - AmyMisc.h
*
*	Author: Erkki Tapola, Mika Kuoppala
*
******************************************************************/

#ifndef AMYMISC_H
#define AMYMISC_H

extern "C" {
#include <clib/alib_protos.h>
}

enum { True = 1, False = 0 };

class Boolean {

  short int value;

public:

  Boolean(int v = 0) { value = (short)(v != 0); }

  operator int() { return value != 0; }
};

class Dimension {

protected:
  int Top, Left, Width, Height;

public:

  Dimension(const int l, const int t, const int w, const int h) { Top = t; Left = l; Width = w; Height = h; }
  Dimension() { Top = Left = Width = Height = 0; }

  int GetLeft()   { return Left;   }
  int GetTop()    { return Top;    }
  int GetWidth()  { return Width;  }
  int GetHeight() { return Height; }

  Dimension operator += (Dimension &d) { Top += d.GetTop(); Left += d.GetLeft(); Width += d.GetWidth();
				Height += d.GetHeight(); return *this; }
};

class AmyPoint {

    unsigned int x, y;

public:

    AmyPoint() { x = y = 0; }
    AmyPoint(unsigned int xi, unsigned int yi) { x = xi; y = yi; }

    int GetX() { return x; }
    int GetY() { return y; }
    short int IsInside(Dimension &Box) {
	return x > Box.GetLeft() && y > Box.GetTop() &&
	       x < Box.GetLeft()+Box.GetWidth() && y < Box.GetTop()+Box.GetHeight();
    }
};

struct AmyListNode {

    Node node;		// Node struct for
			// system's default lists.
    
    void *data;		// Handle to Your 		
			// data in this node
};

class AmyList {

protected:

    List list;		
    AmyListNode *GetNode(int ItemNumber);
    void FreeNodeMem(AmyListNode *node);
	
public:

    AmyList();
    virtual ~AmyList();

    virtual void Attach() { }
    virtual void Detach() { }

    AmyList &Add(const char *text, void *data = NULL);
    AmyList &Add(int ItemNumber, const char *text, void *data = NULL);
    
    AmyList &AddFirst(const char *text, void *data = NULL);
 
    AmyListNode *FindNode(const char *Text);
    int FindItem(const char *Text);

    const char *GetItem(int ItemNumber);
    void *GetData(int ItemNumber);

    void *Delete(int ItemNumber);

    int Items();
    operator const List *() { return &list; }
};

char GetShortcut(const char *s);

#endif
