/******************************************************************
*
*	AmyGUI++ - AmyGadget.h
*
*	Author: Erkki Tapola
*
*	$Id: amygadget.h 1.4 1994/04/01 09:05:30 Delta stabile $
*
*	The base class of all gadgets, AmyGadget, has the basic
*	capabilities like Enable/Disable, create and so on.
*
*	The derived classes have the specific methods. E.g.
*	AmyListview has methods inherited from AmyList, like 
*	Add(const char *) and Delete(int).
*
******************************************************************/

#ifndef AMYGADGET_H
#define AMYGADGET_H

extern "C" {

#include <libraries/gadtools.h>

#if 0
#include <exec/types.h>
#include <intuition/intuition.h>
#include <graphics/text.h>

#include <clib/gadtools_protos.h>
#include <clib/intuition_protos.h>
#endif

}

#include "amymisc.h"
#include "amywindow.h"
#include "amycyclelist.h"

struct Gadget;		// Dummies to speed up compilation
struct Window;
struct TextAttr;

enum GadgetType { dummy_gadget = 0, StringGadget = 1, ButtonGadget, ListView, CycleGadget };
	// The gadget types implemented so far

class AmyGadget : public Dimension {

protected:

    NewGadget ng;	// The real system newgadget data lies here
    Gadget *gadget;	// The system gadget
    AmyWindow *window;	// The window it's in
    GadgetType type;	// The type of the gadget (Listview,cycle,...)

    AmyGadget(AmyWindow *Parent, Dimension Dimension,
	char *Text, long Gadgetid, TextAttr *Font = NULL);

public:

    // virtual void Activate() {}  // to be implemented in child
    //				// classes individually

    void Enable(short int Truefalse = True);
		// Make the gadget usable or ghosted
    void Disable() { Enable(False); }
		// Make the gadget ghosted

    long GetID();	// Ask the long int ID of the gadget
    int GetType() { return type; }
			// Ask the type
    int IsValid() { return gadget != NULL; }
			// Has the gadget been born ?
    operator Gadget* () { return gadget; }
			// Gimme the true gadget
};

class AmyButton : public AmyGadget {

public:

    AmyButton(AmyWindow *Parent, Dimension SizeandPos,
	char *Text, long ID, TextAttr *Font = NULL);
};

class AmyListview : public AmyGadget, public AmyList {

protected:

    int active;
    Boolean Flag_ShowSelected;

public:

    AmyListview(AmyWindow *Parent, Dimension SizeandPos,
	char *Title, long GadgetID, Boolean ShowSelected = False);

    AmyListview &Add(const char *Text);
    void Activate(int n) { active = n; }
    int GetActive() { return active; }
    const char *GetActiveStr() { return GetItem(active+1); }

    void Attach(); // Virtual functions to override AmyList's
    void Detach(); // these are called after a delete, an add or an insert
};

class AmyInputField : public AmyGadget {

protected:

    int maxsize;
    const char *initstr;

public:

    AmyInputField(AmyWindow *parent, Dimension PosandSize,
	char *Title, long GadgetID, int MaxChars = 80,
	const char *InitialString = "");

    const char *GetText();
	// Get the contents of the input field
	// The contents must not be modified
    void Activate();
	// Activate this input field, put the cursor in it
    void SetText(const char *Text);
	// Set the contents of the input field
};

class AmyCycle : public AmyGadget, public AmyCycleList {

protected:

    int active;

public:

    AmyCycle(AmyWindow *parent, Dimension PosandSize, char *Title, long GadgetID);

    void Update();	// Update the choices of the cycle gadget

    void Activate(int n) { active = n; }
    int GetActive() { return active; }
    const char *GetActiveStr() { return GetItem(active+1); }
    void Attach();
};

#endif
