/*
 *      INSTALL.CMD - Animated Mouse Pointer for OS/2 - C.Langanke 1996 - Installation
 *
 *      execute INSTALL /? to get online help in your language.
 */
/* The first comment is used as online help text */

 SIGNAL ON HALT NAME HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 env       = 'OS2ENVIRONMENT';
 TRUE      = (1 = 1);
 FALSE     = (0 = 1);
 Redirection = '1>NUL 2>&1';
 '@ECHO OFF'

 /* some OS/2 Error codes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.SHARING_VIOLATION  = 32;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;

 /* load RexxUtil */
 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;

 /* some defaults */
 Flag.Batch        = FALSE;
 Flag.InstPath     = FALSE;
 Flag.AnimFilePath = FALSE;

 Ini.FileName      = 'OS2.INI'
 Ini.Error         = 'ERROR:';
 Ini.All           = 'ALL:';
 Ini.Delete        = 'DELETE:';
 Ini.AppName       = 'WPAMPTR';
 Ini.KeyProgPath   = 'ProgramPath';
 Ini.KeyAnimPath   = 'AnimationFilePath';

 ClassName         = 'WPAnimatedMousePointer';
 InstallResult     = ERROR.NO_ERROR;
 CallDir           = GetCallDir();
 AppDir            = GetDrivePath(CallDir);

 BootDrive         = GetInstDrive();
 PointersDir       = '?:\OS2\POINTERS';
 DefInstPath       = '?:\WPS\WPAMPTR';

 ReplaceExec       = CallDir'\WPSREPLC.PRG';
 PointersFile      = CallDir'\POINTERS.ZIP';

 /* get NLS settings */
 MessageFile   = CallDir'\INSTALL.MSG';
 IF (\FileExist(MessageFile)) THEN
 DO
    Language    = GetLanguage(CallDir);
    MessageFile = GetMessageFile(CallDir, Language);
 END;
 ELSE
 DO
    MessageFileInfo =  LoadMsgString(0, MessageFile)
    PARSE VAR MessageFileInfo . Language .
 END;
 SIGNAL ON HALT NAME HALT_NLS

 /* show Title */
 Title = '[2J'GetNlsString('Title', GetNlsString('Install'));

 /* show help */
 ARG Parms
 IF (POS('/?', Parms) > 0) THEN
 DO
    SAY Title;
    SAY GetNlsString('InstHelp1', DefInstPath, PointersDir);
    SAY GetNlsString('InstHelp2');
    EXIT(ERROR.NO_ERROR)
 END;

 /* read commandline parameters */
 DO i = 1 TO WORDS(Parms)
    ThisParm = TRANSLATE(WORD(Parms, i));
    PARSE VAR ThisParm ThisTag':'ThisValue;

    SELECT
       WHEN (POS(ThisParm, '/BATCH') = 1) THEN
          Flag.Batch = TRUE;

       WHEN (POS(ThisTag, '/INSTALLPATH') = 1) THEN
       DO
          DefInstPath       = CheckBootDrive(ThisValue);
          Flag.InstPath     = TRUE;
       END;

       WHEN (POS(ThisTag, '/ANIMFILEPATH') = 1) THEN
       DO
          PointersDir       = CheckBootDrive(ThisValue);
          Flag.AnimFilePath = TRUE;
       END;

       OTHERWISE
       DO
          SAY GetNlsString('InvalidParm', ThisParm);
          EXIT(ERROR.INVALID_PARAMETER);
       END;
    END;

 END;

 /* install */
 DefInstPath = CheckBootDrive(DefInstPath);
 PointersDir = CheckBootDrive(PointersDir);
 DO WHILE (TRUE)

    SAY Title;
    InstallPath = InstalledPath(CallDir, ClassName, FALSE);
    IF (InstallPath \= '') THEN
    DO
       SAY GetNlsString('IsInstalled');
       LEAVE;
    END;

    /* should we install ? */
    IF (\ProceedWith(GetNlsString('QueryInst'))) THEN
       SIGNAL HALT;

    InstallPath = InstalledPath(CallDir, ClassName, TRUE);
    IF (InstallPath = '') THEN
    DO
       /* is everything there ? */
       MissingFiles = '';
       IF (\FileExist(ReplaceExec)) THEN
          MissingFiles = MissingFiles FILESPEC('N', ReplaceExec);

       IF (\FileExist(PointersFile)) THEN
          MissingFiles = MissingFiles FILESPEC('N', PointersFile);

       IF (MissingFiles \= '') THEN
       DO
          SAY GetNlsString('MissingFiles', MissingFiles, CallDir);
          InstallResult = ERROR.FILE_NOT_FOUND;
          LEAVE;
       END;

       /* is zip available ? */
       ZipExec = SysSearchPath( 'PATH', 'unzip.exe');
       IF (ZipExec = '') THEN
       DO
          SAY GetNlsString('MissingProgs', 'unzip.exe', PointersFile, PointersDir);
          SAY;
          'PAUSE'
       END;
       ELSE
       DO
          /* should we install  animations ? */
          SAY Title;
          IF (ProceedWith(GetNlsString('QueryUnzip'))) THEN
          DO

             IF (Flag.AnimFilePath) THEN
                PointersPath = PointersDir;
             ELSE
             DO
                PointersPath = SysIni(, Ini.AppName, Ini.KeyAnimPath);
                IF (PointersPath = Ini.Error) THEN
                   PointersPath = PointersDir;
             END;

             PointersPath = TRANSLATE(PullVariable( PointersPath, GetNlsString('PromptPtrPath')));
             Resources = '';

             rc = SysIni(, Ini.AppName, Ini.KeyAnimPath, PointersPath);

             /* check wether drive supports long filenames */
             PointersDrive = FILESPEC('D', PointersPath);
             IF (PointersDrive \= '') THEN
             DO
                LongNamesOk = CheckLongNamesSupported(PointersDrive);
                IF (\LongNamesOk) THEN
                DO
                   SAY Title;
                   SAY GetNlsString('NoPointerSets1');
                   SAY GetNlsString('NoPointerSets2');
                   IF (\ProceedWith(GetNlsString('QueryUnzip2'))) THEN
                      EXIT(1);
                   Resources = '*.and';
                END;
             END;

             SAY;
             '' ZipExec '-o' PointersFile '-d' PointersPath Resources
             IF (rc > 1) THEN
             DO
                SAY;
                SAY GetNlsString('ErrorUnzip', rc)
                'PAUSE'
             END;
             IF (rc = ERROR.NO_ERROR) THEN
             DO
                IF (PointersPath \= PointersDir) THEN
                DO
                   /* deferred setup of mouse object: set ANIMATIONPATH */
                   /* use something senseful for title, because */
                   /* this is displayed during update */
                   HelpData = GetNlsString('HelpData');
                   PARSE VAR HelpData HelpTitle'|'HelpPanel
                   App = 'PM_InstallObject';
                   Key = HelpTitle';WPProgram;<WP_CONFIG>;UPDATE';
                   Val = 'ANIMATIONPATH='PointersPath';OBJECTID=<WP_MOUSE>;';
                   rc = SysIni(, App, Key, Val);

                   IF (rc = 'ERROR:') THEN
                   DO
                      SAY GetNlsString('ErrorInit');
                     'PAUSE'
                   END;
                END;
             END;
          END;
       END;

       /* install the program */
       SAY Title;

       /* determine default install path */
       IF (Flag.InstPath) THEN
          InstallPath = DefInstPath;
       ELSE
       DO
          InstallPath = SysIni(, Ini.AppName, Ini.KeyProgPath);
          IF (InstallPath = Ini.Error) THEN
             InstallPath = DefInstPath;
       END;
      
       InstallPath =  PullVariable( InstallPath, GetNlsString('PromptInstPath'));
       LanguageTag = TranslateLanguageTag(Language);
       rc = CopyFiles( AppDir, InstallPath, Language, LanguageTag);
       IF (rc \= ERROR.NO_ERROR) THEN
       DO
          SAY;
          SAY GetNlsString('CopyError')
          LEAVE;
       END;

       /* save location */
       rc = SysIni(, Ini.AppName, Ini.KeyProgPath, InstallPath);
    END;
    ELSE
       SAY Title;

    /* replace the class */
    rc = ReplaceWpsClass( ReplaceExec, 'WPMouse', ClassName, InstallPath, 'WPAMPTR.DLL', TRUE);
    IF (rc \= ERROR.NO_ERROR) THEN
       LEAVE;

    /* deferred create information object and shadow */
    HelpData = GetNlsString('HelpData');
    PARSE VAR HelpData HelpTitle'|'HelpPanel

    App = 'PM_InstallObject';
    Key = HelpTitle';WPProgram;<WP_INFO>;REPLACE';
    Val = 'PROGTYPE=PM;EXENAME=VIEW.EXE;PARAMETERS='InstallPath'\WPAMPTR.INF' HelpPanel ';OBJECTID=<WPAMPTR_INFO>;';
    rc = SysIni(, App, Key, Val);

    App = 'PM_InstallObject';
    Key = HelpTitle';WPShadow;<WP_DESKTOP>;REPLACE';
    Val = 'SHADOWID=<WPAMPTR_INFO>;OBJECTID=<WPAMPTR_INFO_SHADOW>;';
    rc = SysIni(, App, Key, Val);


    /* we're done, so leave */
    SAY Title;
    SAY  GetNlsString('InstDone1', InstallPath);
    SAY  GetNlsString('InstDone2');
    SAY  GetNlsString('InstDone3');
    LEAVE;

 END;

 EXIT(InstallResult);

/* ------------------------------------------------------------------------- */

HALT_NLS:
 SAY GetNlsString('Halt');
 EXIT(ERROR.GEN_FAILURE);

HALT:
 SAY;
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE ExitMessage Title

 SAY;
 SAY Title
 SAY;

 PARSE SOURCE . . ThisFile

 /* skip header */
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 /* show help */
 DO WHILE (ThisLine \= ' */')
    ThisLine = LINEIN(Thisfile);
    SAY SUBSTR(ThisLine, 7);
 END;

 /* close file */
 rc = LINEOUT(Thisfile);

 RETURN('');

/* ========================================================================= */
PullVariable: PROCEDURE EXPOSE ExitMessage MessageFile Flag.
 PARSE ARG Default, Message

 IF (Flag.Batch) THEN RETURN(Default);

 SAY;
 CALL CHAROUT, Message '['Default'] : ';
 PARSE PULL PullVar;
 IF (LENGTH(PullVar) > 0) THEN
    RETURN(PullVar);
 ELSE
    RETURN(Default);

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ------------------------------------------------------------------------- */
LoadMsgString: PROCEDURE
 PARSE ARG MsgId, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9;

 Message = SysGetMessage(MsgId, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9);
 RETURN(LEFT(Message, LENGTH(Message) - 2));

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE EXPOSE ExitMessage
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
GetDrivePath: PROCEDURE
 PARSE ARG FileName

 FullPath = FILESPEC('D', FileName)||FILESPEC('P', FileName);
 IF (FullPath \= '') THEN
    RETURN(LEFT(FullPath, LENGTH(FullPath) - 1));
 ELSE
    RETURN('');

/* ------------------------------------------------------------------------- */
GetInstDrive: PROCEDURE EXPOSE env
 ARG DirName, EnvVarName

 /* Default: OS2 directory -> determines boot drive */
 IF (DirName = '') THEN DirName = '\OS2';

 /* Default: PATH  */
 IF (EnvVarName = '') THEN EnvVarName = 'PATH';

 /* get value */
 PathValue = VALUE(EnvVarName,,env);

 /* search entry */
 DirName = ':'DirName';';
 EntryPos = POS(DirName, PathValue) - 1;
 IF (EntryPos = -1) THEN
    RETURN('');
 InstDrive = SUBSTR(PathValue, EntryPos, 2);
 RETURN(InstDrive);

/* ------------------------------------------------------------------------- */
/* -                Routines for binary reading                            - */
/* ------------------------------------------------------------------------- */
DWORDIN: PROCEDURE
 ARG File, Offset

 IF (Offset = '') THEN
    b1 = CHARIN(File,,1);
 ELSE
    b1 = CHARIN(File, Offset,1);

 b2 = CHARIN(File,,1);
 b3 = CHARIN(File,,1);
 b4 = CHARIN(File,,1);

 RETURN(b4''b3''b2''b1)

WORDIN: PROCEDURE
 ARG File, Offset

 IF (Offset = '') THEN
    b1 = CHARIN(File,,1);
 ELSE
    b1 = CHARIN(File, Offset,1);

 b2 = CHARIN(File,,1);

 RETURN(b2''b1)

SZ2STR: PROCEDURE
 PARSE ARG sz

 str = sz;

 zeroPos = POS("00"x, str);
 IF (zeroPos \= 0) THEN
    str = LEFT(str, zeroPos - 1);

 RETURN(str);

/* ------------------------------------------------------------------------- */
CheckLongNamesSupported: PROCEDURE
 PARSE ARG DirName

 /* default values */
 ErrorCode = '';
 IF (RIGHT(DirName, 1) \= '\') THEN
    DirName = DirName'\';
 FileName  = DirName'filewithlongname';

 /* write file with long name */
 rc = LINEOUT(FileName);
 IF (\rc) THEN
    '@DEL' FileName;

 RETURN(\rc);

/* ------------------------------------------------------------------------- */
ReadSyslevelFile: PROCEDURE EXPOSE env TRUE FALSE
 PARSE ARG File, Request

 /* default values */
 result = '';
 Request = TRANSLATE(Request);

 /* valid tags */
 Tag.0      = 8;
 /* ------------------------------ */
 Tag.1      = 'SYSID';
 Tag.1.Exec = 'result = sysid';
 /* ------------------------------ */
 Tag.2      = 'EDITION';
 Tag.2.Exec = 'result = edition';
 /* ------------------------------ */
 Tag.3      = 'VERSION';
 Tag.3.Exec = 'result = version';
 /* ------------------------------ */
 Tag.4      = 'MODIFY';
 Tag.4.Exec = 'result = modify';
 /* ------------------------------ */
 Tag.5      = 'CURRCSD';
 Tag.5.Exec = 'result = currCsd';
 /* ------------------------------ */
 Tag.6      = 'PREVCSD';
 Tag.6.Exec = 'result = prevCsd';
 /* ------------------------------ */
 Tag.7      = 'ID';
 Tag.7.Exec = 'result = compId';
 /* ------------------------------ */
 Tag.8      = 'NAME';
 Tag.8.Exec = 'result = sysname';

 /* read header */
 header        = C2D(CHARIN(File,,2));
 sig           =     CHARIN(File,,8);
 DateJulian    = C2D(CHARIN(File,,5));
 Version       = C2D(CHARIN(File,,2));
 reserved      =     CHARIN(File,,16);
 offset        = C2D(DWORDIN(File,)) + 1;

 /* is signature valid */
 IF (sig \= 'SYSLEVEL') THEN
    RETURN('');

 /* read table */
 sysid          = C2D(WORDIN(File,offset));
 edition        = C2D(CHARIN(File,,1));
 version        = D2X(C2D(CHARIN(File,,1)));
 modify         = C2D(CHARIN(File,,1));
 DateValue      = CHARIN(File,,2);

 currCsd        = CHARIN(File,,8);
 prevCsd        = CHARIN(File,,8);
 sysName        = CHARIN(File,,80);
 compId         = CHARIN(File,,9); /* ignore the rest */

 /* transform version */
 version = LEFT(version,1)'.'SUBSTR(version,2)

 /* get result */
 IF (Request \= '') THEN
 DO i = 1 TO Tag.0
    IF (POS(Request, Tag.i) = 1) THEN
    DO
       INTERPRET(Tag.i.Exec);
    END;
 END;

 IF (Result = '') THEN
    result = sysid edition version modify currCsd prevCsd compId sysname;

 /* close file */
 rc = STREAM(File, 'C', 'CLOSE');

 RETURN(result);

/* ------------------------------------------------------------------------- */
SetSyslevelInfo: PROCEDURE EXPOSE ERROR. TRUE FALSE CmdName Language.
 PARSE ARG File, NewId, NewTitle

 /* read header */
 header        = C2D(CHARIN(File,,2));
 sig           =     CHARIN(File,,8);
 DateJulian    = C2D(CHARIN(File,,5));
 Version       = C2D(CHARIN(File,,2));
 reserved      =     CHARIN(File,,16);
 offset        = C2D(DWORDIN(File,)) + 1;

 /* is signature valid */
 IF (sig \= 'SYSLEVEL') THEN
    RETURN('');

 /* determine data offsets */
 sysidOffs      = offset;
 editionOffs    = offset + 2;
 versionOffs    = offset + 3;
 modifyOffs     = offset + 4;
 DateValueOffs  = offset + 5;

 currCsdOffs    = offset +  7;
 prevCsdOffs    = offset + 15;
 sysNameOffs    = offset + 23;
 compIdOffs     = offset + 103;

 /* read in CSD level tags */
 CurrLevel = CHARIN(File, currCsdOffs, 8);
 PrevLevel = CHARIN(File, prevCsdOffs, 8);

 Id1 = SUBSTR(CurrLevel, 1, 3);
 Id2 = SUBSTR(PrevLevel, 1, 3);
 CurrId = RIGHT(Id1, 1);
 NewTitle = STRIP(SUBSTR(NewTitle, 1, 79));  /* cut to max 79 chars */
 NewTitle = NewTitle'00'x;

 IF ((Id1 \= Id2) | (POS(CurrId, '0CDFGHIJLNPSUW') = 0)) THEN
    RETURN('');
 ELSE
 DO
    /* patch in new id and cose file */
    rc = CHAROUT(File, NewId, currCsdOffs + 2);
    rc = CHAROUT(File, NewId, prevCsdOffs + 2);
    rc = CHAROUT(File, NewTitle, sysNameOffs);
    rc = LINEOUT(File);
 END;
 RETURN('');

/* ========================================================================= */
CheckBootDrive: PROCEDURE EXPOSE BootDrive
 PARSE ARG Name

 IF (LEFT(Name, 2) = '?:') THEN
    Name = BootDrive''DELSTR(Name, 1, 2);

 RETURN(Name);

/* ========================================================================= */
ProceedWith: PROCEDURE EXPOSE NlsMsg. ExitMessage MessageFile Flag.
 PARSE ARG Prompt, Keys

 IF (Flag.Batch) THEN RETURN(1);

 ch            = ' ';
 IF (Keys = '') THEN
    ValidResponse = LEFT(GetNlsString(YesNoKeys), 2);
 ELSE
    ValidResponse = Keys;

 YesKey        = LEFT(ValidResponse, 1);
 NoKey         = RIGHT(ValidResponse, 1);

 SAY;
 CALL CHAROUT ,Prompt '('YesKey'/'NoKey') '
 DO WHILE (POS(ch, ValidResponse) = 0)
    ch = SysGetKey('NOECHO');
    ch = TRANSLATE(ch);
    IF (POS(ch, ValidResponse) = 0) THEN BEEP(800, 200);
 END;
 SAY ch;
 SAY;
 RETURN(ch = YesKey);

/* ========================================================================= */
GetNlsString: PROCEDURE EXPOSE ERROR. MessageFile
 PARSE ARG MessageId, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9;

 /* default values */
 Message     = '*** Message' Id 'not found. ***';

 /* default values */
 MessageFileIdText = 'WPAMPTR_MESSAGEFILE';

 /* load MessageIds and YesNo Keys*/
 MessageFileInfo        = LoadMsgString(0, MessageFile)
 PARSE VAR MessageFileInfo MessageFileId MessageLanguage MessageFileKeys MessageListcount
 IF ((MessageFileIdText \= MessageFileId) | (LENGTH(MessageFileKeys) \= 2))THEN
 DO
    SAY 'Invalid message file' MessageFile;
    EXIT(ERROR.INVALID_DATA);
 END;

 /* load Messagelist*/
 MessageList = '';
 DO i = 1 TO MessageListcount
    MessageList = MessageList LoadMsgString(i, MessageFile)
 END;

 /* handle special id YesNoKeys */
 IF (MessageId = 'YESNOKEYS') THEN
    RETURN(MessageFileKeys);

 /* read message ids */
 MessagePos   = WORDPOS(TRANSLATE(MessageId), TRANSLATE(MessageList));
 IF (MessagePos > 0) THEN
 DO
    ThisMessage = LoadMsgString(MessagePos + MessageListcount, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9);
    IF (ThisMessage \= '') THEN
       Message = ThisMessage;
 END;

 RETURN(Message);

/* ========================================================================= */
CopyFiles: PROCEDURE EXPOSE ERROR. Redirection MessageFile
 PARSE ARG SourceDir, TargetDir, Language, LanguageTag


 ClearLine  = '[A[K';
 CopyResult  = ERROR.NO_ERROR;
 CopyMessage = ClearLine''GetNlsString('PromptCopying');
 OkMessage   = GetNlsString('Ok');

 /* check parms */
 IF (Language = '') THEN
    RETURN(ERROR.INVALID_PARAMETER);

 /* files to copy */
 Package.0  = 16;
 /* copied with xcopy to create directory */
 Package.1  = 'file_id.diz'
 Package.2  = 'install\install.cmd install'
 Package.3  = 'and\makeand.cmd and'
 Package.4  = 'rexx\*.cmd rexx'

 Package.5  = 'wpamptr.dll'
 Package.6  = 'amptr'Language'.dll wpamptrs.dll'
 Package.7  = 'amptr'Language'.hlp wpamptr.hlp'
 Package.8  = 'install.cmd'
 Package.9  = 'sl.amp'
 Package.10 = 'readme.1st'
 Package.11 = 'install.cmd';
 Package.12 = 'install\instl'Language'.msg install\install.msg'
 Package.13 = 'install\remove.cmd install'
 Package.14 = 'install\*.prg install'
 Package.15 = 'and\mkand'Language'.msg and\makeand.msg'
 Package.16 = 'and\template.dll and'

 SAY;
 /* copy files */
 SAY;
 DO i = 1 TO Package.0

    PARSE VAR Package.i CopySource CopyTarget
    FilesToCopy = CopySource;
    CopySource = SourceDir'\'CopySource
    IF (CopyTarget = '') THEN
       CopyTarget = TargetDir;
    ELSE
       CopyTarget = TargetDir'\'CopyTarget;

    /* copy the first two files with xcopy */
    /* so that the directory is created */
    IF (i < 5 ) THEN
    DO
       CopyExec = 'XCOPY';
       CopyTarget = CopyTarget'\';
    END;
    ELSE
       CopyExec = 'COPY';

    SAY CopyMessage TRANSLATE(FilesToCopy) '... '
    CopyExec CopySource CopyTarget '> NUL'
    IF (rc \= ERROR.NO_ERROR) THEN
    DO
       CopyResult = rc;
       LEAVE;
    END;
 END;

 IF (rc = ERROR.NO_ERROR) THEN
 DO
    CALL CHAROUT, ClearLine;
    SAY GetNlsString('FilesCopied');
    SAY;
 END;

 /* convert HLP to INF file */
 rc = ConvertHlp2Inf( TargetDir'\wpamptr.hlp');

 /* patch the language id into our syslevel file */
 'DEL' TargetDir'\syslevel.amp 2>NUL'
 'REN' TargetDir'\sl.amp syslevel.*'
 HelpData = GetNlsString('HelpData');
 PARSE VAR HelpData HelpTitle'|'HelpPanel
 rc = SetSyslevelInfo( TargetDir'\syslevel.amp', LanguageTag, HelpTitle);

 RETURN(CopyResult);


/* ========================================================================= */
ConvertHlp2Inf: PROCEDURE EXPOSE ERROR. Redirection
 PARSE ARG HelpFile

 /* default values */
 HlpId  = 'HSP'||"10"x;
 InfId  = 'HSP'||"01"x;

 /* determine INF FileName */
 ExtPos = LASTPOS('.HLP', TRANSLATE(HelpFile));
 IF (ExtPos = 0) THEN
    RETURN(ERROR.INVALID_PARAMETER);

 InfFile = SUBSTR(HelpFile, 1, ExtPos)'inf';

 /* copy the file */
 '@COPY' HelpFile InfFile  Redirection
 /* convert target */
 rc = CHAROUT(InfFile, InfId, 1);
 rc = STREAM(InfFile, 'C', 'seek < 0');
 rc = LINEOUT(InfFile);

 RETURN(ERROR.NO_ERROR);

/* ========================================================================= */
ReplaceWpsClass: PROCEDURE EXPOSE ERROR. Redirection MessageFile
 PARSE ARG ReplaceExec, ClassName, ReplaceClassName, InstallPath, ClassDll, fReplace

 ReplaceResult    = ERROR.NO_ERROR;
 ClassDllFullname = InstallPath'\'ClassDll;
 ReplaceFlag      = 'U';
 IF (fReplace) THEN
    ReplaceFlag   = 'R';

 /* (un-)replacing */
  SAY GetNlsString('Replacing', ReplaceClassName);
 '' ReplaceExec ClassName ReplaceClassName ReplaceFlag ClassDllFullName Redirection
 ReplaceResult = rc;
 SAY;

 IF (ReplaceResult \= ERROR.NO_ERROR) THEN
     SAY GetNlsString('ReplaceError', ReplaceClassName, ReplaceResult);

 RETURN(ReplaceResult);

/* ========================================================================= */
GetMessageFile: PROCEDURE EXPOSE CmdName ERROR. Redirection
 PARSE ARG InstallDir, Language

 /* filenames */
 YourNlsFile = InstallDir'\instl'Language'.msg';
 MainNlsFile = InstallDir'\install.msg';

 /* if main nls file already exists, use this one */
 IF (FileExist(MainNlsFile)) THEN
    RETURN(MainNlsFile);

 /* if nls file does not exist, give error */
 IF (\FileExist(YourNlsFile)) THEN
 DO
    SAY CmdName': error:'
    SAY 'message file 'YourNlsFile' not found.';
    SAY 'Program aborted.';
    EXIT(ERROR.FILE_NOT_FOUND);
 END;

 /* try to copy appropriate message file */
 'COPY' YourNlsFile MainNlsFile Redirection;
 IF (rc = ERROR.NO_ERROR) THEN
    RETURN(MainNlsFile);
 ELSE
    RETURN(YourNlsFile);

/* ========================================================================= */
GetLanguage: PROCEDURE EXPOSE env ERROR.
 ARG InstallDir

 /* get language code */
 BootDrive    = GetInstDrive();
 SyslevelFile = BootDrive'\OS2\INSTALL\SYSLEVEL.OS2';
 CurrCsd      = ReadSyslevelFile(SyslevelFile, 'CURRCSD');

 DefaultLanguageAbbr = 'eng';
 DefaultLanguageTag  = '0';

 /* for test purposes only */
 TestCsd = VALUE('TESTCSD',,env);
 IF (TestCsd \= '') THEN CurrCsd = TestCsd;

 /* determine language */
 IF (CurrCsd = '') THEN
    LanguageTag = '?';   /* ask for default value */
 ELSE
    LanguageTag  = SUBSTR(CurrCsd, 3, 1);

 OsLanguage = TranslateLanguageTag(LanguageTag);

 /* test if the message file for the language is there */
 NlsFile = InstallDir'\instl'OsLanguage'.msg';
 IF (\FileExist(NlsFile)) THEN
 DO
    SAY;
    SAY 'This program currently does not support the language of your installed OS/2';
    SAY 'or the files supporting this language are not present.';
    SAY;
    SAY 'If you want to go on with installation, the program will be installed';
    SAY 'in the english version. Be aware of the fact that this program replaces';
    SAY 'parts of the Workplace Shell (the "Pointers" page of the mouse object)';
    SAY 'which are currently supporting the langauge of your OS/2.';
    SAY 'With this program installed this will not longer be the case.';
    SAY;
    SAY 'IF you want to go on to install this program in the english version, press Y.';
    SAY 'IF you want to abort this program, press N.';
    IF (\ProceedWith('Do you want to install this program in the english version', 'YN')) THEN
    DO
       SAY 'Installation program aborted.';
       EXIT(0);
    END;
    ELSE
       OsLanguage = DefaultLanguageAbbr;
 END;

 RETURN(OsLanguage);

/* ========================================================================= */
InstalledPath: PROCEDURE EXPOSE TRUE FALSE
 PARSE ARG CallDir, ClassName, fCheckFileBase

 InstalledPath     = '';

 DO WHILE (TRUE)

    IF (fCheckFileBase) THEN
    DO
       /* check file base */
       NlsDLL        = STREAM(CallDir'\..\WPAMPTRS.DLL', 'C', 'QUERY EXISTS');
       InstalledPath = GetDrivePath(NlsDLL);

       /* has file base nsl files ? */
       rc = SysFileTree(CallDir'\instl*.msg', 'file.', 'FO');
       IF (rc = 0) THEN
       DO
          IF (File.0 > 0) THEN
             InstalledPath = '';
       END;

    END;

    /* check class list */
    CALL SysQueryClassList "list."
    DO i = 1 to list.0
       PARSE VAR list.i ThisClass ThisDll
       IF (STRIP(Thisclass) = ClassName) THEN
       DO
          ClassInstalled = TRUE;
          InstalledPath = GetDrivePath(STRIP(ThisDll));
          LEAVE;
       END;
    END

    /* we're done */
    LEAVE;
 END;

 RETURN(InstalledPath);

/* ========================================================================= */
TranslateLanguageTag: PROCEDURE
 ARG SearchString


 /* default values */
 LanguageTag   = '0   U   G       D       F      H           S     I     W      N      F       J';
 LanguageAbbr  = 'eng eng deu     dan     fra    ndl         esp   ita   sve    nor    fin     jpn';
               /* us  uk  germany denmark france netherlands spain italy sweden norway finland japan */

 /* determine which list to search */
 SELECT
    WHEN (LENGTH(SearchString) = 1) THEN SearchPos = WORDPOS(SearchString, TRANSLATE(LanguageTag));
    WHEN (LENGTH(SearchString) = 3) THEN SearchPos = WORDPOS(SearchString, TRANSLATE(LanguageAbbr));
    OTHWERWISE NOP;
 END;

 /* use default if nothing found */
 IF (SearchPos = 0) THEN SearchPos = 1;

 /* now determine result */
 SELECT
    WHEN (LENGTH(SearchString) = 1) THEN SearchResult = WORD(LanguageAbbr, SearchPos);
    WHEN (LENGTH(SearchString) = 3) THEN SearchResult = WORD(LanguageTag,  SearchPos);
    OTHWERWISE;
 END;

 RETURN(SearchResult);

