/* AmiPOP By Scott Ellis */

#include "pop.h"

static const char VersionID[]="\0$VER:AmiPOP 1.7(15.11.93) By Scott Ellis";

/* Variables in pop.h */

char *pophost=NULL;
char *username=NULL;
char *password=NULL;
char *passfake=NULL;
char *maildir=NULL;
char *cxname=NULL;
char *cxdesc=NULL;
char *hotkey=NULL;
char *title=NULL;
char *temp=NULL;
char *buf=NULL;
UBYTE *PubScreenName=NULL;

char bum[]="Ok";

BOOL delmail=FALSE;
BOOL checkper=FALSE;
BOOL appfile=TRUE;
BOOL winop=TRUE;
BOOL notify=FALSE;

int timecheck=10;
int port=110;

struct MsgPort *amipop_mp=NULL;
struct MsgPort *timer_mp=NULL;
struct timerequest *timerio=NULL;
CxObj *broker=NULL;
struct Library *TimerBase=NULL;

struct NewBroker newbroker = {
    NB_VERSION,   /* nb_Version - Version of the NewBroker structure */
	"Not Active", /* nb_Name */
    "Amiga POP  1993 Scott Ellis",     /* nb_Title - Title of commodity that appears in CXExchange */
	"Not Active", /* nb_Descr */
    NBU_UNIQUE | NBU_NOTIFY ,            /* nb_Unique - Tells CX not to launch another commodity with same name */
    COF_SHOW_HIDE,            /* nb_Flags - Tells CX if this commodity has a window */
    0,            /* nb_Pri - This commodity's priority */
    0,            /* nb_Port - MsgPort CX talks to */
    0             /* nb_ReservedChannel - reserved for later use */
};

struct EasyStruct ereq =
	{
	sizeof(struct EasyStruct),
	0,
	"AmiPOP Notice",
	"%s",
	"%s",
	};

UWORD __chip waitPointer[] =
    {
    0x0000, 0x0000,     /* reserved, must be NULL */

    0x0400, 0x07C0,
    0x0000, 0x07C0,
    0x0100, 0x0380,
    0x0000, 0x07E0,
    0x07C0, 0x1FF8,
    0x1FF0, 0x3FEC,
    0x3FF8, 0x7FDE,
    0x3FF8, 0x7FBE,
    0x7FFC, 0xFF7F,
    0x7EFC, 0xFFFF,
    0x7FFC, 0xFFFF,
    0x3FF8, 0x7FFE,
    0x3FF8, 0x7FFE,
    0x1FF0, 0x3FFC,
    0x07C0, 0x1FF8,
    0x0000, 0x07E0,

    0x0000, 0x0000,     /* reserved, must be NULL */
    };

enum args
	{
	USERNAME,
	PASSWORD,
	POPHOST,
	MAILDIR,
	CHECKPER,
	TIME,
	DELETE,
	APPEND,
	NOWINDOW,
	PORT,
	NOTIFY,
	CX_POPKEY,
	PUBSCREEN
	};

/* Configure SAS Specific routines */

void __regargs __chkabort(void) {}
int __oslibversion=37;
long __stack = 20000;

/* End SAS */

ULONG			sigmask=NULL;
ULONG			cxsigflag=NULL;
ULONG			timesigflag=NULL;

struct Library *IconBase;

int main(int argc, char **argv )
{
	int foo=0;
	ULONG	mysig;

	if (makevars())
	{
		freevars();
		return(20);
	}

	if ( parse( argc, argv) )
	{
		if ( setuptime() )
		{
			timesigflag = 1L << timer_mp->mp_SigBit;
			timereq();
			foo=1;

			if ( setupcx() )
			{
				if (winop)
				{
					openup();
				}
			}
			else
			{
				foo=0;
			}
		}
	}
	else
	{
		foo=0;
	}

        while (foo)
	{
                if (winop)
		{
			sigmask= 1 << Project0Wnd->UserPort->mp_SigBit ;
		}
		else
		{
			sigmask= NULL;
		}

		mysig=Wait ( sigmask | cxsigflag | timesigflag | SIGBREAKF_CTRL_C );

		if ( mysig & cxsigflag )
		{
			foo=docx();
		}
       		if ( mysig & sigmask )
		{
			foo=HandleProject0IDCMP();
		}
		if ( mysig & timesigflag )
		{
			if (checkper)
			{
				MYGAD_BUTTONClicked();
			}
			timereq();
		}
		if (mysig & SIGBREAKF_CTRL_C )
		{
                	foo=0;
		}
	}

        closedown();

	closetime();

	closecx();

	freevars();

	return(0);
}

void openup(void)
{
	SetupScreen();
	OpenProject0Window();

	winop=TRUE;
}

void closedown(void)
{
	CloseProject0Window();
	CloseDownScreen();

	winop=FALSE;
}

int parse(int argc, char *argv[])
{
	struct RDArgs	*RDA;
	LONG 		ArgumentArray[14] = {NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL};
	char		**ToolArrayIndex,
				*ToolStringIndex,
				*Template;
	struct DiskObject	*DiskObject;
	char none[]="None Given";

	if (IconBase = OpenLibrary("icon.library", 36L ) )
        {

		RDA = AllocDosObjectTags(DOS_RDARGS, TAG_DONE);
		RDA->RDA_ExtHelp = NULL;

		if (_WBenchMsg)
		{
			CurrentDir(_WBenchMsg->sm_ArgList->wa_Lock);
			if ( DiskObject = GetDiskObject(_WBenchMsg->sm_ArgList->wa_Name) )
			{
				for (ToolArrayIndex = DiskObject->do_ToolTypes; *ToolArrayIndex; ToolArrayIndex++ )
				{
					RDA->RDA_Source.CS_Length += (strlen(*ToolArrayIndex)+1);
				}
				RDA->RDA_Source.CS_Buffer = AllocVec(RDA->RDA_Source.CS_Length+1,MEMF_CLEAR);
				ToolStringIndex = RDA->RDA_Source.CS_Buffer;
				for (ToolArrayIndex = DiskObject->do_ToolTypes; *ToolArrayIndex; ToolArrayIndex++ )
				{
						ToolStringIndex = stpcpy(stpcpy(ToolStringIndex, *ToolArrayIndex)," ");
				}
				*(ToolStringIndex-1) = '\n';
				FreeDiskObject(DiskObject);
			}

			Template = "Username/K,Password/K,POPHost/K,MailDir/K,CheckPer/S,Time/K/N,Delete/S,Append/S,NoWindow/S,Port/K/N,Notify/S,Cx_Popkey/K,PubScreen/K,ThrowAway/M";
		}
		else
		{
			Template = "Username/K,Password/K,POPHost/K,MailDir/K,CheckPer/S,Time/K/N,Delete/S,Append/S,NoWindow/S,Port/K/N,Notify/S,Cx_Popkey/K,PubScreen/K";
		}

		if (RDA = ReadArgs(Template, ArgumentArray, RDA) )
		{
			if (ArgumentArray[USERNAME])
			{
				strcpy(username,(char *)ArgumentArray[USERNAME]);
			}
			else
			{
				strcpy(username,none);
			}

			if (ArgumentArray[PASSWORD])
			{
				strcpy(password,(char *)ArgumentArray[PASSWORD]);
			}
			else
			{
				strcpy(password,"");
			}

			if (ArgumentArray[POPHOST])
			{
				strcpy(pophost,(char *)ArgumentArray[POPHOST]);
			}
			else
			{
				strcpy(pophost,none);
			}

			if (ArgumentArray[MAILDIR])
			{
				strcpy(maildir,(char *)ArgumentArray[MAILDIR]);
			}
			else
			{
				strcpy(maildir,none);
			}

			checkper=(BOOL)ArgumentArray[CHECKPER];

			if (ArgumentArray[TIME])
			{
				timecheck=*(int *)ArgumentArray[TIME];
			}

			delmail=(BOOL)ArgumentArray[DELETE];
			appfile=(BOOL)ArgumentArray[APPEND];
                        winop=!( (BOOL)ArgumentArray[NOWINDOW] );

			if (ArgumentArray[PORT])
			{
				port = *(int *)ArgumentArray[PORT];
			}

			notify=(BOOL)ArgumentArray[NOTIFY];

			if (ArgumentArray[CX_POPKEY])
			{
				strcpy(hotkey,(char *)ArgumentArray[CX_POPKEY]);
			}

			if (ArgumentArray[PUBSCREEN])
			{
				strcpy(PubScreenName,(UBYTE *)ArgumentArray[PUBSCREEN]);
			}

			if (RDA->RDA_Source.CS_Buffer)
			{
				FreeVec(RDA->RDA_Source.CS_Buffer);
			}

		}
		else
		{
			if (argc==0)
			{
				doreq("Arguments Incorrect",bum);
			}
			else
			{
				PrintFault(IoErr(), NULL);
			}

			return(0);
		}

		FreeArgs(RDA);
		FreeDosObject(DOS_RDARGS,RDA);
        	CloseLibrary(IconBase);
	}
	else
	{
		doreq("Can't open icon.library",bum);
		return(0);
	}
	return(1);
}

int doreq(char *mes, char *but)
{
	LONG answer;

	answer= EasyRequest(NULL, &ereq, NULL, mes, but);

	if (Project0Wnd)
	{
		SetWindowTitles(Project0Wnd,Project0Wdt, (UBYTE *) ~0);
	}

	return(answer);
}

BOOL makevars(void)
{
	if ( pophost=AllocVec((7*BIGSTRING)+(4*SMALLSTRING)+(2*BUFSIZE)+(256),MEMF_CLEAR) )
	{
		username=pophost+BIGSTRING;
		password=username+SMALLSTRING;
		passfake=password+SMALLSTRING;
		maildir=passfake+SMALLSTRING;
		cxname=maildir+BIGSTRING;
		cxdesc=cxname+BIGSTRING;
		hotkey=cxdesc+(3*BIGSTRING);
		title=hotkey+BIGSTRING;
		temp=title+256;
		buf=temp+BUFSIZE;
		PubScreenName=buf+SMALLSTRING;
		return(FALSE);
	}
	return(TRUE);
}

void freevars(void)
{
	if (pophost) FreeVec(pophost);
}