/* intui.c:
 *
 * System requester stuff.
 *
 * ----------------------------------------------------------------------
 * This code is (C) Copyright 1993 by Frank Munkert.
 * All rights reserved.
 * This software may be freely distributed and redistributed for
 * non-commercial purposes, provided this notice is included.
 * ----------------------------------------------------------------------
 * History:
 * 
 * 09-Oct-93   fmu   SAS/C support added
 */

#include <stdarg.h>
#include <stdio.h>

#include <exec/types.h>
#include <intuition/intuition.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#ifdef AZTEC_C
#include <pragmas/exec_lib.h>
#include <pragmas/intuition_lib.h>
#endif
#ifdef LATTICE
#include <pragmas/exec_pragmas.h>
#include <pragmas/intuition_pragmas.h>
#endif

#include "intui.h"

struct IntuitionBase *IntuitionBase;

void Init_Intui (void)
{
  IntuitionBase = (struct IntuitionBase *)
     OpenLibrary ((UBYTE *) "intuition.library", 37);
}

void Close_Intui (void)
{
  if (IntuitionBase)
    CloseLibrary ((struct Library *) IntuitionBase);
}

void Display_Error (char *p_message, ...)
{
  va_list arg;
  char buf[1000];

  static struct EasyStruct req = {
    sizeof (struct EasyStruct),
    0,
    (UBYTE *) "CDROM Handler Error",
    NULL,
    (UBYTE *) "Abort"
  };
  
  va_start (arg, p_message);
  if (IntuitionBase) {
    vsprintf (buf, p_message, arg);
    req.es_TextFormat = (UBYTE *) buf;
    EasyRequestArgs (NULL, &req, NULL, NULL);
  }
  va_end (p_message);
}
