/* cdrom.h: */

#ifndef _CDROM_H_
#define _CDROM_H_

#include <exec/types.h>
#include <exec/memory.h>
#include <exec/io.h>
#include <devices/scsidisk.h>

#define VERSION "1.3 (09.10.93)"

#define SCSI_BUFSIZE 2048

typedef struct CDROM {
  unsigned char 	*buffer;
  unsigned char		**buffers;
  unsigned char 	*buffer_data;
  unsigned char		sense[20];
  short			use_trackdisk;
  short			lun;
  short			std_buffers;
  short			file_buffers;
  long 			*current_sectors;
  unsigned long		*last_used;
  unsigned long		tick;
  struct MsgPort 	*port;
  struct IOStdReq	*scsireq;
  struct SCSICmd	cmd;
} CDROM;

CDROM *Open_CDROM (char *p_device, int p_scsi_id, int p_use_trackdisk,
		   int p_use_fast_mem, int p_std_buffers, int p_file_buffers);
int Read_Sector (CDROM *p_cd, long p_sector);
int Read_Contiguous_Sectors (CDROM *p_cd, long p_sector, long p_last_sector);
void Cleanup_CDROM (CDROM *p_cd);
int Test_Unit_Ready (CDROM *p_cd);

#endif /* _CDROM_H_ */
