/*****************************************************************************

       VGA Waiting For Call Screen by Logicom Softwares (C) 1994


    This mod is copyright 1992, 1993, 1994 by Nicolas LeBlanc, aka Spotnick,
    and Martin Bourdages, aka Dark Shadow, and is distributed as freeware.

    Permission is granted to distribute and post this mod on BBS systems and
    online services, provided no alterations are made (removal of message
    headers/taglines allowed).

    This mod may contain some parts of WWIV source code, which is copyright
    1988-1994 by Wayne Bell and licensed only to registered users of WWIV.
    Use of WWIV source without registration constitutes a license violation
    and could lead to legal prosecution and certain doom.

    Shareware distributors and CD-ROM publishers may not distribute this mod
    without express written permission of the Author or WWIV Software
    Services.  Distribution should be to Registered WWIV sysops only.

    You can reach the authors on Alternative Worlds BBS (514)-664-4503.
                WWIVnet @5497, WWIVLink @5497, IceNET @5497

         French Mod Division Support Sub: SubType: ESE, Host: 5497
               Subscribe today if you use this modification.

*****************************************************************************/

#include "vars.h"
#pragma hdrstop

#include <dir.h>
#include <mem.h>

#ifdef WFC_SCREEN

void set_43(void)
/* This function initialize the screen to 80x43 text mode */
{
  textmode(C4350);
  _asm {
    mov ah, 12h
    mov bl, 30h
    mov al, 01h
    int 10h

    xor ah, ah
    mov al, 03h
    int 10h

    mov ah, 11h
    mov al, 30h
    mov bh, 03h
    int 10h

    mov ah, 11h
    mov al, 12h
    xor bl, bl
    int 10h
  }
}

void set_25(void)
{
  ansic(0);
  textmode(C80);
  _asm {
    mov ah,12h
    mov bl,30h
    mov al,02h
    int 10h

    xor ah,ah
    mov al,03h
    int 10h

    mov ah, 11h
    mov al, 30h
    mov bh, 06h
    int 10h

    mov ah,11h
    mov al,14h
    xor bl,bl
    int 10h
  }
}




char *wfc_string(void)
/* This is the screen displayed in the scrolling bar of the WFC screen */
{
  char s[512];

  s[0]=0;
  sprintf(s, "System is waiting for caller - %dk left in memory - You are "
             "on instance %d - Modification by French Mod Division - (C) "
             "1994 Logicom Softwares - %s %s (C) 1988-1994 Wayne Bell - All "
             "rights reserved - Press ESC to quit - F1 for help - "
             "F2 to start screen saver - ",
             (int)(farcoreleft()/1024), instance, wwiv_version,
             (syscfg.wwiv_reg_number)? "Registered": "Unregistered");
  return (s);
}


char *wfc_menu [] = {
  "Log On System    ",
  "Show Network Info",
  "Network Callout  ",
  "Network Pending  ",
  "Network Redial   ",
  "Network DataFiles",
  "Network Log      ",
  "Activity Log     ",
  "Yesterday's Log  ",
  "Today's Log      ",
  "Read All-Mail    ",
  "Read Feedback    ",
  "Send Email       ",
  "Sub Editor       ",
  "Dir Editor       ",
  "Conference Editor",
  "Instance Editor  ",
  "G-Files Editor   ",
  "Chain Editor     ",
  "Vote Editor      ",
  "Users Editor     ",
  "Reset Files      ",
  "Answer Phone     ",
  "Shell to Dos     ",
  "Terminal Program ",
  "Send Loaded Mail ",
  "System Status    ",
  "Write A File     ",
  "Show Environment ",
  "Help             ",
  "About            "
};



void display(int i, int rep)
/* This function moves the cursor with the arrow keys */
{
  char s[81];

  if (i)
    curatr=0x19;
  else
    curatr=0x3f;

  sprintf(s, "%s", wfc_menu[rep-1]);
  gotoxy(4, rep+9);
  outs(s);
}



void wb(int x1, int x2, int y, unsigned char *s)
{
  int i,z;

  if ((x2<=x1) || (x1<1) || (x2>80) || (y<1) || (y>50) ||
    (strlen(stripcolors(s))<1))
    return;

  if (strlen(s)>(x2-x1+1))
    s[x2-x1+1]=0;

  i =(int) (((x2 - x1 + 1) - (strlen(s))) / 2) + x1;
  gotoxy(i,y);
  outs(s);
}


void wfc_screen(void)
/* This functions displays the waiting for caller screen */
{
  char s[161], s1[81],s2[81];
  int i1, dv, win,f;
  float i;
  instancerec ir;
  userrec ur;
  struct dfree free;
  long avail;

  set_43();
  sprintf(s2,"%sWFC.DAT",syscfg.datadir);
  if (exist(s2)) {
    f=sh_open1(s2,O_RDONLY | O_BINARY);
    read(f,scrn,(2*80*42));
    wfc_scr=1;
    close(f);
  } else {
    npr("\r\nWFC.DAT NOT FOUND!");
    end_bbs(noklevel);
  }


  alt_pending();
  alt_inst();
  alt_update();
  display(0, loc);
  _setcursortype(_NOCURSOR);
  curatr=0x1e;

  i=(status.activetoday*49/1440.0);
  sprintf(s, "%s", charstr((int)i, ''));
  i=i-(int)i;
  if (i>0)
    strcat(s, i>=0.5? "": "");
  curatr=0x0c;
  gotoxy(28, 40);
#ifdef ASYLUM
#else
  outs(s);
#endif
  curatr=0x1e;

  if (status.activetoday)
  {
    char perc[10];
    char time_today[20];
    time_t secs_now;
    struct tm *time_now;
    long daten, secs_dif;
    int min_dif;

    time(&secs_now);
    time_now=localtime(&secs_now);
    strftime(time_today, 20, "%m/%d/%y", time_now);
    daten=date_to_daten(time_today);

    secs_dif=(long)difftime(secs_now, daten);
    min_dif=(int)(secs_dif/60);


    i1=(int)(((float)status.activetoday/min_dif)*100);
    sprintf(s,"%s",charstr((i1/2),''));
#ifdef ASYLUM
    curatr=0x0c;
    curatr=0x04;
    gotoxy(28,40);
    outs(s);

    sprintf(perc, "%2d%%", i1);
    curatr=0x4f;
    gotoxy(51, 40);
    outs(perc);
    curatr=0x1e;
#endif

    sprintf(s,"%d minutes active out of %d", status.activetoday, min_dif);
    curatr=0x1b;
    wb(45,78,37,s);
    curatr=0x1e;

  }

  gotoxy(43, 9);
  outs(status.date1);

  sprintf(s, "%d", fwaiting);
  gotoxy(43, 10);
  outs(s);

  sprintf(s, "%hu", status.fbacktoday);
  gotoxy(43, 11);
  outs(s);

  sprintf(s, "%hu", status.emailtoday);
  gotoxy(43, 12);
  outs(s);

  sprintf(s, "%hu", status.msgposttoday);
  gotoxy(43, 13);
  outs(s);

  i1 =getdisk();
  getdfree(i1+1, &free);
  avail =(long) free.df_avail * (long) free.df_bsec * (long) free.df_sclus;
  sprintf(s, "%lu Megs", avail/1000000);
  gotoxy(43, 14);
  outs(s);

  sprintf(s, "%hu", status.localposts);
  gotoxy(43, 15);
  outs(s);

  s[0]=0;
  get_inst_info(instance, &ir);
  if ((ir.user < syscfg.maxusers) && (ir.user > 0)) {
    read_user(ir.user, &ur);
    sprintf(s1, "%-30.30s", nam(&ur, ir.user));
  }
  else
    sprintf(s1, "%-30.30s", get_string(1410));
  gotoxy(46, 25);
  outs(s1);

  sprintf(s, "%hu", status.users);
  gotoxy(70, 8);
  outs(s);

  sprintf(s, "%hu", status.callstoday);
  gotoxy(70, 9);
  outs(s);

  sprintf(s, "%ld", status.callernum1);
  gotoxy(70, 10);
  outs(s);

  sprintf(s, "%hu", status.activetoday);
  gotoxy(70, 13);
  outs(s);

  sprintf(s, "%hu", status.uptoday);
  gotoxy(70, 14);
  outs(s);

  gotoxy(51, 18);
  sprintf(s, "%5.5s To ", ctim(syscfg.netlowtime*60));
  sprintf(s1, "%s%5.5s", s, ctim(syscfg.nethightime*60));
  outs(s1);

  gotoxy(51, 22);
  sprintf(s, "%hu", status.net_version);
  outs(s);

  if (multitasker)
    switch (multitasker) {
      case 1 :
        dv=get_dv_version();
        sprintf(s, "DESQView %d.%02d\r\n", dv/256, dv%256);
      break;
      case 2 :
        win=get_win_version();
        sprintf(s, "Windows %d.%02d\r\n", win%256, win/256);
      break;
      case 3 :
        win=get_win_version();
        dv=get_dv_version();
        sprintf(s, "Win %d.%02d and DV %d.%02d\r\n",
        win%256, win/256, dv/256, dv%256);
      break;
      case 4 :
        sprintf(s, "OS/2 %d.%2.2d\r\n", _osmajor/10, _osminor);
      break;
      default:
        strcpy(s, get_string(1170));
    }
  else
    strcpy(s, "None");
  gotoxy(51, 23);
  outs(s);

  gotoxy(51, 21);
  sprintf(s, "%5.5s", ctim(syscfg.executetime*60));
  outs(s);

  gotoxy(70, 11);
  sprintf(s,"%u",status.days);
  outs(s);

  gotoxy(70, 12);
  i=(status.days*1.0);
  sprintf(s, "%.2f", (status.callernum1/i));
  outs(s);
  curatr=0x07;
}

void alt_update(void)
/* This function does the alternating network update times */
{
  char s[81], s1[81], s2[81];
  struct stat statbuf;

  curatr=0x1e;
  if (syscfg.systemnumber!=0) {
    sprintf(s1, "%sCONNECT.NET", net_networks[altp].dir);
    stat(s1, &statbuf);
    strcpy(s, ctime(&statbuf.st_mtime));
    sprintf(s2, "%-26.26s", net_networks[altp].name);
  } else {
    sprintf(s, "Not network detected");
    sprintf(s2, " ");
  }
  gotoxy(51, 19);
  outs(s);
  gotoxy(51, 20);
  outs(s2);
  altp++;
  if (altp==net_num_max)
    altp=0;
}

void alt_pending(void)
/* This function is doing the alternating network pending */
{
  char s[61][6], s1[81];
  int netpos[61], ipos[61], nn, i, i1, i2, netnum=0, num_call_sys,
      sn, num_ncn;
  net_call_out_rec *con;
  net_contact_rec *ncn;
  net_system_list_rec *csne;

  if (syscfg.systemnumber!=0) {
    for (nn=0; nn<net_num_max; nn++) {
      set_net_num(nn);
      read_call_out_list();
      read_contacts();
      con=net_networks[net_num].con;
      ncn=net_networks[net_num].ncn;
      num_call_sys=net_networks[net_num].num_con;
      num_ncn=net_networks[net_num].num_ncn;
      for (i1=0; i1<num_call_sys; i1++) {
        i2=-1;
        for (i=0; i<num_ncn; i++) {
          if (con[i1].sysnum==ncn[i].systemnumber) {
            i2=i;
            break;
           }
        }
        ipos[netnum]=i2;
        netpos[netnum]=nn;
        sprintf(s[netnum++], "%hu", ncn[i2].systemnumber);
      }
      if (netnum>60)
        break;
    }
    sn=atoi(s[netp]);
    set_net_num(netpos[netp]);
    read_call_out_list();
    read_contacts();
    ncn=net_networks[net_num].ncn;
    csne=next_system(sn);
    curatr=0x1e;
    sprintf(s1, "@%-5s %-21.21s %-14.14s %4ldk",
                s[netp], csne->name, net_name,
                bytes_to_k(ncn[ipos[netp]].bytes_waiting));
    netp++;
    gotoxy(28, 33);
    outs(s1);
    if (netp>netnum-1)
      netp=0;
    sn=atoi(s[netp]);
    set_net_num(netpos[netp]);
    read_call_out_list();
    read_contacts();
    ncn=net_networks[net_num].ncn;
    csne=next_system(sn);
    sprintf(s1, "@%-5s %-21.21s %-14.14s %4ldk", s[netp], csne->name,
                net_name, bytes_to_k(ncn[ipos[netp]].bytes_waiting));
    gotoxy(28, 34);
    outs(s1);
  } else {
    curatr=0x1e;
    gotoxy(28, 34);
    outs("No network detected");
  }
}

void make_wfc_inst_str(short wi, unsigned char *ss)
/* This function keeps in memory what users are doing on other instances */
{
  instancerec ir;
  char s1[81];

  get_inst_info(wi, &ir);

  switch (ir.loc) {
    case INST_LOC_DOWN:
      sprintf(s1, "%-25.25s", get_string(1207));
    break;
    case INST_LOC_INIT:
      sprintf(s1, "%-25.25s", get_string(1208));
    break;
    case INST_LOC_EMAIL:
      sprintf(s1, "%-25.25s", get_string(1209));
    break;
    case INST_LOC_MAIN:
      sprintf(s1, "%-25.25s", get_string(1210));
    break;
    case INST_LOC_XFER:
      sprintf(s1, "%-25.25s", get_string(1211));
    break;
    case INST_LOC_CHAINS:
      sprintf(s1, "%-25.25s", get_string(1212));
    break;
    case INST_LOC_NET:
      sprintf(s1, "%-25.25s", get_string(1213));
    break;
    case INST_LOC_GFILES:
      sprintf(s1, "%-25.25s", get_string(1214));
    break;
    case INST_LOC_BEGINDAY:
      sprintf(s1, "%-25.25s", get_string(1215));
    break;
    case INST_LOC_EVENT:
      sprintf(s1, "%-25.25s", get_string(1216));
    break;
    case INST_LOC_CHAT:
      sprintf(s1, "%-25.25s", get_string(1218));
    break;
    case INST_LOC_CHAT2:
      sprintf(s1, "%-25.25s", get_string(1217));
    break;
    case INST_LOC_CHATROOM:
      sprintf(s1, "%-25.25s", get_string(1219));
    break;
    case INST_LOC_LOGON:
      sprintf(s1, "%-25.25s", get_string(1220));
    break;
    case INST_LOC_LOGOFF:
      sprintf(s1, "%-25.25s", get_string(1221));
    break;
    case INST_LOC_FSED:
      sprintf(s1, "%-25.25s", get_string(1222));
    break;
    case INST_LOC_UEDIT:
      sprintf(s1, "%-25.25s", get_string(1223));
    break;
    case INST_LOC_CHAINEDIT:
      sprintf(s1, "%-25.25s", get_string(1224));
    break;
    case INST_LOC_BOARDEDIT:
      sprintf(s1, "%-25.25s", get_string(1225));
    break;
    case INST_LOC_DIREDIT:
      sprintf(s1, "%-25.25s", get_string(1226));
    break;
    case INST_LOC_GFILEEDIT:
      sprintf(s1, "%-25.25s", get_string(1227));
    break;
    case INST_LOC_CONFEDIT:
      sprintf(s1, "%-25.25s", get_string(1228));
    break;
    case INST_LOC_DOS:
      sprintf(s1, "%-25.25s", get_string(1229));
    break;
    case INST_LOC_DEFAULTS:
      sprintf(s1, "%-25.25s", get_string(1230));
    break;
    case INST_LOC_REBOOT:
      sprintf(s1, "%-25.25s", get_string(1231));
    break;
    case INST_LOC_RELOAD:
      sprintf(s1, "%-25.25s", get_string(1232));
    break;
    case INST_LOC_VOTE:
      sprintf(s1, "%-25.25s", get_string(1233));
    break;
    case INST_LOC_BANK:
      sprintf(s1, "%-25.25s", get_string(1234));
    break;
    case INST_LOC_AMSG:
      sprintf(s1, "%-25.25s", get_string(1235));
    break;
    case INST_LOC_SUBS:
      sprintf(s1, "%-25.25s", get_string(1236));
    break;
    case INST_LOC_CHUSER:
      sprintf(s1, "%-25.25s", get_string(1237));
    break;
    case INST_LOC_TEDIT:
      sprintf(s1, "%-25.25s", get_string(1238));
    break;
    case INST_LOC_MAILR:
      sprintf(s1, "%-25.25s", get_string(1239));
    break;
    case INST_LOC_RESETQSCAN:
      sprintf(s1, "%-25.25s", get_string(1240));
    break;
    case INST_LOC_VOTEEDIT:
      sprintf(s1, "%-25.25s", get_string(1241));
    break;
    case INST_LOC_VOTEPRINT:
      sprintf(s1, "%-25.25s", get_string(1401));
    break;
    case INST_LOC_RESETF:
      sprintf(s1, "%-25.25s", get_string(1406));
    break;
    case INST_LOC_FEEDBACK:
      sprintf(s1, "%-25.25s", get_string(1407));
    break;
    case INST_LOC_KILLEMAIL:
      sprintf(s1, "%-25.25s", get_string(1408));
    break;
    case INST_LOC_POST:
      sprintf(s1, "%-25.25s", get_string(1409));
    break;
    case INST_LOC_NEWUSER:
      sprintf(s1, "%-25.25s", get_string(1423));
    break;
    case INST_LOC_RMAIL:
      sprintf(s1, "%-25.25s", get_string(1424));
    break;
    case INST_LOC_DOWNLOAD:
      sprintf(s1, "%-25.25s", get_string(1425));
    break;
    case INST_LOC_UPLOAD:
      sprintf(s1, "%-25.25s", get_string(1426));
    break;
    case INST_LOC_BIXFER:
      sprintf(s1, "%-25.25s", get_string(1427));
    break;
    case INST_LOC_NETLIST:
      sprintf(s1, "%-25.25s", get_string(1428));
    break;
    case INST_LOC_WFC:
      sprintf(s1, "%-25.25s", get_string(1402));
    break;
    default:
      sprintf(s1, "%-25.25s", get_string(1403));
    break;
  }
  strcpy(ss, s1);
}



void alt_inst(void)
/* This function is the alternating instance display */
{
  char s[161], s1[81], s2[81];
  instancerec ir;
  userrec ur;

  s[0]=0;
  get_inst_info(insp, &ir);
  read_user(ir.user, &ur);
  if (ir.flags & INST_FLAGS_ONLINE)
    sprintf(s1, "%-25.25s (%d)", nam(&ur, ir.user), insp);
  else
    sprintf(s1, "Nobody On Instance %-10d", insp);
  gotoxy(46, 28);
  outs(s1);
  make_wfc_inst_str(insp, s2);
  gotoxy(46, 29);
  outs(s2);
  insp++;
  if (insp>num_instances())
    insp=1;
}

void greetings(void)
{
 /* This function display the help file of this modifications */
  savescreen(&screensave);
  curatr=0x3b;
  makewindow(5, 3, 70, 14);
  gotoxy(7, 5);
  outs("ALTW-02.MOD v4.0 by French Mod Division on 05/08/94");
  gotoxy(10, 8);
  outs("Use arrow keys to move across the screen");
  gotoxy(10, 10);
  outs("Scrolling time and time to start screen saver are defined");
  gotoxy(10, 11);
  outs("in VARS.H");
  gotoxy(10, 12);
  outs("If you need support, order French Mod Division Support Sub today!");
  gotoxy(10, 14);
  outs("Press F2 to start the Screen Saver, F3 to rotate.");
  getch();
  restorescreen(&screensave);
}

#endif
void wfcprt(char *s)
{
  int i, i1;

#ifdef WFC_SCREEN
  if (wfc_scr) {
    curatr=0x1f;
    gotoxy(2,3);
    for(i=0;i<76;i++)
     outs(" ");
    i1=strlen(stripcolors(s));
    gotoxy(2+((76-i1)/2),3);
    outs(s);
    curatr=0x07;
  } else
    outs(s);
#else
    outs(s);
#endif
}
#ifdef WFC_SCREEN

void push_screen(int h)
/* This function will push the screen to the left */
{
  int i, x;

  _setcursortype(_NOCURSOR);
  for (x=0; x<80; x++)
  {
    movetext(2, 1, 79, h, 1, 1);
    for (i=0; i<h; i++) {
      gotoxy(79, 1+i);
      outs(" ");
    }
  }
}

void split_screen(int h)
/* This function will split the screen in two */
{
  int i, x, y=1;

  if (wfc_scr==0) {
    clrscr();
    return;
  }
  _setcursortype(_NOCURSOR);
  for (x=0; x<41; x++)
  {
    movetext(2, 1, 41, h, 1, 1);
    if (y)
      for (i=0; i<h; i++) {
        gotoxy(41, 1+i);
        outs(" ");
      }
    movetext(41, 1, 79, h, 42, 1);
    if (y)
      for (i=0; i<h; i++) {
        gotoxy(41, 1+i);
        outs(" ");
      }
    y=0;
  }
}


void push_screen_down(int y)
/* This function will move the screen to the bottom */
{
  union REGS reg;
  int x;

  reg.h.ah =7;
  reg.h.al =1;
  reg.h.bh =0;
  reg.h.cl =0;
  reg.h.ch =0;
  reg.h.dl =80;
  reg.h.dh =y;

  for (x=0; x<y; x++)
    int86 (0x10, &reg, &reg);
}


void push_screen_up(int y)
/* This function will push the screen at the top */
{
  union REGS reg;
  int x;

  reg.h.ah =6;
  reg.h.al =1;
  reg.h.bh =0;
  reg.h.cl =0;
  reg.h.ch =0;
  reg.h.dl =80;
  reg.h.dh =y;
  for (x=0; x<y; x++)
    int86 (0x10, &reg, &reg);
}

int wfc_keys(int ch)
{
     if ((ch==' ') || (ch=='q') || (ch=='Q') || (ch==27) || (ch=='a') ||
        (ch=='A'))
       return(0);
     else
       return(1);
}

int wfc_run(void)
{
   if ((timer()-wfc_time)<SSTIME)
     return(1);
   else
     return(0);
}

void rotate(void)
{
    if ((timer()-t2)>=INTERVAL) {
     t2=timer();
     alt_update();
     alt_pending();
     alt_inst();
  }
}

int scrolling(void)
{
      if ((timer()-t1)>= SCROLL_TIME)
        return(1);
      else
        return(0);
}

int screensaver(void)
{
      if ((timer()-wfc_time)>(SSTIME+5))
        return(1);
      else
        return(0);
}

void maybe_wfc(void)
{
  if ((timer()-wfc_time)<SSTIME)
     wfc_screen();
}

#endif
/*****************************************************************************/
