{                 Alternative viewer for Norton Commander 4.0                 }
{                                                                             }
{          Copyright (C) 1994 Tom Hajn, XHajT03@vse.cz on Internet         }
{                                                                             }
{  Unit Spawno (swapping itself from conventional memory when calling viewer; }
{  only approximately 400 bytes remains !!!) Copyright (C) 1990-2 Ralf Brown, }
{    ralf@cs.cmu.edu - many thanks for this. Source code (C and assembler)    }
{              available on Simtel and its mirrors (directory C).             }
{                                                                             }
{   You may freely use and distribute this program. If you wish to modify it, }
{ you must let the user know that the code has been changed and you must keep }
{ my name here.                                                               }
{   Everybody distributing the program must be able to distribute this source }
{ file as well.                                                               }
{   This program is a solution for users of NC 4.0, as well as for users of   }
{ some archive viewers those call one viewer for every file in the archive.   }
{   Feel free to use e-mail adress above if you have any questions, problems  }
{ or suggestions.                                                             }
{                                                                             }
{      1) Installation                                                        }
{                                                                             }
{   The program breaks the limit of 10 viewers for NC 4.0. You simply remove  }
{ one of the viewers in your NC.CFG file (you don't lose this viewer, because }
{ you can write it later into the ALTVIEW.CFG), then write new section for    }
{ this 'viewer' (~ALTVIEW.EXE) AFTER (!) wpview.exe (i.e. it will be the last }
{ one except two graphic viewers) and move the $*.* specification from the    }
{ section of ~WPVIEW.EXE to this new section. The program (like other viewers }
{ in NC 4.0) must reside in the directory of NC, as well as the configuration }
{ file, i.e. file with the same name and the extension .CFG.                  }
{                                                                             }
{      2) Configuration file                                                  }
{                                                                             }
{   The structure of the configuration file is similar as in NC.CFG of NC 4.0 }
{ (i.e. it's a text file editable by any editor). Every line not beginning    }
{ with '~', '$', '%' or '&' is ignored. Characters '~' and '%' must be        }
{ immediately followed with a name of the viewer (without spaces and path!).  }
{ The following line(s) starting with characters '$' and '&' up to another    }
{ '~' or '%' characters are the patterns of files for this viewer             }
{ (e.g. $*.ext). If there is more than one pattern matching the viewed file,  }
{ the first one is used; the exception is the case of '&' at the begin of the }
{ line - then you can select one of all viewers having pattern matching the   }
{ viewed file. Use a '%' before a viewer name when you use it from NC 4.0 and }
{ the viewer doesn't have enough memory - normally viewers are called from    }
{ NCMAIN.EXE; in case of '%', a temporary batch file is created and then      }
{ called from command line - this causes NCMAIN.EXE to be terminated (not     }
{ NC.EXE). The last viewer should be WPVIEW.EXE with pattern $*.* for files   }
{ not matching any other pattern.                                             }
{                                                                             }
{      3) Limitations                                                         }
{                                                                             }
{   Yes, there are problems (known). If compiled with SPAWNO, it is no longer }
{ possible to use Quick view (in NC). As well, NC doesn't know, it should     }
{ load another viewer when Quick view is open and you move the cursor from    }
{ one to another file and both are handled by ALTVIEW, i.e. it uses the same  }
{ viewer for all files as long as you don't move the cursor to the file       }
{ handled by another viewer (but I don't know viewers able to handle Quick    }
{ view except the original ones - if you do, let me know about it) or to the  }
{ directory.                                                                  }
{                                                                             }
{                                                     That's all.             }
{
{ Of course, there is no warranty, either express or implied, about this      }
{ program and you use it at your own risk. (Stupid message, but who knows...) }

program AltView;
{ $DEFINE QUICKVIEW} (* if you delete the space before '$', the program will *)
                     (* have less memory to execute viewers, but it will be  *)
                     (* able to use Quick view in NC - see above             *)
{$IFNDEF QUICKVIEW}
{$M 4096,74000,74000}
{$ELSE}
{$M 4096,98000,98000}
{$ENDIF}
(* so much memory allocated to ensure, at least wpview can be started;       *)
(* you can change this number if you use another text viewer - but be sure   *)
(* to have enough memory for handling dynamically allocated variables, i.e.  *)
(* the list of viewer possible for particular file extension                 *)

{$G+,A+,R-,S-,D-,B-,F-,L-}

uses
{$IFNDEF QUICKVIEW}
 Spawno,
{$ENDIF}
 Crt, Dos, Memory;

type
 FileStr = string [12];
 PVRec = ^VRec;
 VRec = record
  VName: FileStr;
  Next: PVRec;
  Big: boolean;
 end;
 TPB = ^byte;

var
 R: registers;
 Cfg: text;
 B: text;
 T: file;
 TPath: PathStr;
 CfgName: PathStr;
 Dir, OwnDir: DirStr;
 Name: NameStr;
 Ext: ExtStr;
 Viewer: PathStr;
 I, J: byte;
 SR: SearchRec;
 EnvPath: string;
 Pattern: string;
 FName: PathStr;
 VName: PathStr;
 BV: PathStr;
 VA: array [1..5] of FileStr;
 OldX, OldY, OldC, OldB: byte;
 XX: string;
 Status: integer;
 ParP: pointer;
 PB: TPB absolute ParP;

const
 Found: boolean = false;
 Sec: boolean = false;
 Params: string = '';
 Line: string = '';
 ContStr1: string [3] = '$&+';
 ContStr2: string [2] = '~%';
 VNum: word = 0;
 First: PVRec = nil;
 Act: PVRec = nil;
 Big: boolean = false;
 Direct: boolean = false;

function KeyPressed: boolean;
var
 Is: boolean;
 Shifts1: byte absolute $40:$17;
 Shifts2: byte absolute $40:$18;
begin
 Is := false;
 asm
  mov ah, 11h
  int 16h
  jz @@1
  mov [Is], true
  mov ah, 10h
  int 16h
@@1:
 end;
 Keypressed := Is or (Shifts1 and $0F <> 0) or (Shifts2 <> 0);
end;

procedure LookT;
var
 DW, HS: word;
 DT: DateTime;
 L, M: Longint;
begin
 if ((WhereX = (Lo (WindMax) div 2) + 2) or (WhereX = 1)) and
                                 (WhereY = Hi (WindMax) - 1) then Sec := true;
{$I-}                              (* ^^^ started as Quick view ^^^ *)
 Reset (T);
 if IOResult = 0 then
 begin
  GetFTime (T, L);
  with DT do
  begin
   GetDate (Year, Month, Day, DW);
   GetTime (Hour, Min, Sec, HS);
  end;
  PackTime (DT, M);
  if M - L > 4096 then    (* temporary file older than 4 hours - rewrite it *)
   if Sec = true then
   begin
    Close (T);
    Erase (T);
   end else SetFTime (T, M)
  else Sec := true;
  Close (T);
 end else
 begin
  if Sec = false then
  begin
   Rewrite (T);
   Close (T);
  end;
 end;
 L := IOResult;
{$I+}
end;

procedure WriteStrDos (X: string);       (* enables redirection - WriteLn *)
begin                                    (* handled by Crt unit           *)
 XX := X + '$';
 asm
  mov ah, 9
  mov dx, OFFSET XX
  inc dx
  int 21h
 end;
end;

procedure NoCfg;
begin
 WriteStrDos ('Cannot open ' + CfgName);
 WriteLn;
 while not (KeyPressed) do begin end;
 Halt (2);
end;

procedure DelT;
begin
 if not (Sec) then
 {$I-}
 Erase (T);
 {$I+}
end;

procedure Disp;                     (* disposing allocated memory - if any *)
begin
 while First <> nil do
 begin
  Act := First^.Next;
  Dispose (First);
  First := Act;
 end;
end;

function Which: FileStr;           (* manual selection of the right viewer *)
var
 Y: byte;
 Y1: byte;
 C: char;
begin
 if VNum > 5 then J := 5 else J := VNum;
 Act := First;
 TextBackground (Blue);
 TextColor (Yellow);
 GotoXY (34, 8 - J - 1);
 Write ('ͻ');
 for I := 1 to J do
 begin
  VA [I] := Copy (Act^.VName + '            ', 1 , 12);
  Act := Act^.Next;
  GotoXY (34, 8 - J - 1 + I);
  Write ('            ');
 end;
 GotoXY (34, 8);
 Write ('ͼ');
 Y := 1;
 Y1 := 0;
 TextColor (LightCyan);
 repeat
  for I := 1 to J do
  begin
   GotoXY (35, 8 - J - 1 + I);
   Write (VA [I]);
  end;
  TextColor (Black);
  TextBackground (Cyan);
  GotoXY (35, 8 - J - 1 + Y);
  Write (VA [Y]);
  TextColor (Yellow);
  TextBackground (Blue);
  GotoXY (45, 8 - J - 1);
  if Y1 > 0 then Write (#24) else Write (#205);
  GotoXY (45, 8);
  if Y1 + J < VNum then Write (#25) else Write (#205);
  TextColor (LightCyan);
  C := ReadKey;
  if C = #0 then
  begin
   C := ReadKey;
   case C of
    #72: if Y > 1 then Dec (Y) else if Y1 > 0 then Dec (Y1);
    #80: if Y < J then Inc (Y) else if Y + Y1 < VNum then Inc (Y1);
    #71: begin
          Y1 := 0;
          Y := 1;
         end;
    #79: begin
          Y := J;
          Y1 := VNum - J;
         end;
    #73: if Y + Y1 <= J then
         begin
          Y1 := 0;
          Y := 1;
         end else if Y1 >= J then Dec (Y1, J) else
         begin
          Dec (Y, J - Y1);
          Y1 := 0;
         end;
    #81: if VNum - Y - Y1 < J then
         begin
          Y := J;
          Y1 := VNum - J;
         end else if VNum - Y1 >= 2 * J then Inc (Y1, J) else
         begin
          Inc (Y, 2 * J - VNum + Y1);
          Y1 := VNum - J;
         end else C := #0;
   end;
   if C > #0 then
   begin
    I := 0;
    Act := First;
    while I < Y1 do
    begin
     Act := Act^.Next;
     Inc (I);
    end;
    for I := 1 to J do
    begin
     VA [I] := Copy (Act^.VName + '            ', 1 , 12);
     Act := Act^.Next;
    end;
   end;
  end;
 until (C = #13);
 I := 1;
 Act := First;
 while I < Y + Y1 do
 begin
  Act := Act^.Next;
  Inc (I);
 end;
 VName := Act^.VName;
 Which := VName;
 Big := Act^.Big;
 TextColor (OldC);
 TextBackground (OldB);
end;

function GetParamsP: pointer; assembler;
asm
 mov ah, 62h
 int 21h
 mov dx, bx
 mov ax, 80h
end;

begin
 if Lo (DosVersion) < 3 then Viewer := 'ALTVIEW.EXE' else
 begin
  Viewer := FExpand (ParamStr (0));
  ParP := GetParamsP;
  Move (ParP^, Params, PB^ + 1);
  I := Pos (#0, Params);
  if I = 0 then Params := '' else
                          Params := Copy (Params, I, Length (Params) - I + 1);
 end;
 FSplit (Viewer, OwnDir, Name, Ext);
 CfgName := Dir + Name + '.CFG';
 FindFirst (CfgName, AnyFile, SR);
 if DosError <> 0 then
 begin
  EnvPath := GetEnv ('PATH');
  if EnvPath = '' then NoCfg;
  Dir := '';
  I := 1;
  J := 0;
  while (Dir = '') and (I > 0) do
  begin
   I := Pos (';', Copy (EnvPath, J + 1, Length (EnvPath) - J));
   Dir := Copy (EnvPath, J + 1, I - 1) + '\';
   
   FindFirst (Dir + Name + '.CFG', AnyFile, SR);
   if DosError <> 0 then Dir := '';
   J := J + I;
  end;
  if Dir = '' then NoCfg;
 end;
 CfgName := Dir + Name + '.CFG';
 Assign (Cfg, CfgName);
 TPath := GetEnv ('TEMP');
 if TPath = '' then TPath := GetEnv ('TMP');
 if TPath = '' then TPath := '.';
{$IFNDEF QUICKVIEW}
 Init_SpawnO (TPath, Swap_All, 20, 0);
{$ENDIF}
 TPath [byte (TPath [0]) + 1] := '\';
 Inc (TPath [0]);
 TPath := TPath + Name +'.TMP';
 Assign (T, TPath);
 {$I-}
 Reset (Cfg);
 if IOResult <> 0 then NoCfg;
 LookT;
 {$I+}
 FName := FExpand (ParamStr (1));
 FSplit (FName, Dir, Name, Ext);
 while not (Found) and not (Eof (Cfg)) do
 begin
  while not (Eof (Cfg)) and (Pos (Copy (Line, 1, 1), ContStr2) = 0) do
                                                         ReadLn (Cfg, Line);
  if Eof (Cfg) then Viewer := '' else
  begin
   Big := false;
   VName := Copy (Line, 2, 12);
   Viewer := OwnDir + VName;
   if (Line [1] = '%') and not (Sec) then Big := true;
  end;
  if Viewer <> '' then
  begin
   repeat
    repeat ReadLn (Cfg, Line) until Eof (Cfg)
                                 or (Pos (Line [1], ContStr1 + ContStr2) > 0);
    if (Pos (Line [1], ContStr1) > 0) then
    begin
     Pattern := Copy (Line, 2, Length (Line) - 1);
     FindFirst (Dir + Pattern, AnyFile, SR);
     I := VNum;
     while (DosError = 0) and (VNum = I) and not (Found) do
     begin
      if SR.Name = Name + Ext then
      begin
       if Line [1] = '&' then
       begin
        if VNum = 0 then
        begin
         Inc (VNum);
         New (First);
         First^.VName := VName;
         First^.Big := Big;
         First^.Next := nil;
        end else
        begin
         Act := First;
         I := 0;
         while (I < VNum) do
         begin
          if Act^.VName = VName then I := VNum + 1 else
          begin
           Inc (I);
           if Act^.Next <> nil then Act := Act^.Next;
          end;
         end;
         if I = VNum then
         begin
          New (Act^.Next);
          Act := Act^.Next;
          Act^.VName := VName;
          Act^.Big := Big;
          Act^.Next := nil;
          Inc (VNum);
         end;
        end;
       end else
       if VNum = 0 then
       begin
        if Line [1] = '+' then Direct := true;
        Found := true;
        Disp;
       end;
      end;
      FindNext (SR);
     end;
    end;
   until Eof (Cfg) or (Pos (Line [1], ContStr2) > 0) or Found;
  end;
 end;
 Close (Cfg);
 OldX := WhereX;
 OldY := WhereY;
 OldC := TextAttr and $8f;
 OldB := (TextAttr and $70) div 16;
 if Direct then FName := Name + Ext;
 if (VNum > 0) and not (Found) then
 begin
  if VNum > 1 then Viewer := OwnDir + Which else
  begin
   VName := First^.VName;
   Big := First^.Big;
   Viewer := OwnDir + VName;
  end;
  Disp;
  Found := true;
 end;
 if Found then
 begin
  GotoXY (OldX, OldY);
  if not (Sec) then
  begin
   WriteStrDos (Copy (VName + '           ', 1, 12));
   GotoXY (OldX, OldY);
  end;
  SetMemTop (HeapPtr);
  if not (Big) then
  begin
   SwapVectors;
{$IFNDEF QUICKVIEW}
   Status := Spawn (Viewer, FName + Params, 0);
   if Status = -1 then
{$ELSE}
   Exec (Viewer, FName + Params);
   if DosError <> 0 then
{$ENDIF}
   begin
    WriteStrDos ('Cannot execute ' + Viewer + '!!');
    WriteLn;
    while not (KeyPressed) do begin end;
{$IFNDEF QUICKVIEW}
    Status := Spawn (OwnDir + 'wpview.exe', FName + Params, 0);
    if Status = -1 then
{$ELSE}
    Exec (OwnDir + 'wpview.exe', FName + Params);
    if DosError <> 0 then
{$ENDIF}
    begin
     SwapVectors;
     DelT;
     Halt (8);
    end;
   end;
   SwapVectors;
   DelT;
  end else
  begin
   BV := Copy (Ext, 2, 3) + '.BAT';
   Assign (B, OwnDir + BV);
   {$I-}
   Rewrite (B);
   WriteLn (B, '@ECHO OFF');
   WriteLn (B, Viewer + ' ' + FName + '> NUL');
   WriteLn (B, 'DEL ' + TPath);
   Write (B, 'DEL ' + OwnDir + BV);
   Close (B);
   {$I+}
   asm
@1:
    mov ah, 11h
    int 16h
    jz @2
    mov ah, 10h
    int 16h
    jmp @1
@2:
   end;
   for I := 1 to Length (BV) do
   begin
    R.AH := 5;
    R.CL := Ord (BV [I]);
    Intr ($16, R);
   end;
   R.AH := 5;
   R.CL := 13;
   R.CH := $1C;
   Intr ($16, R);
  end;
 end else
 begin
  WriteStrDos ('No matching pattern found!!');
  WriteLn;
  while not (KeyPressed) do begin end;
  DelT;
  Halt (8);
 end;
end.