Frank Reid #1 @8213
Tue May 30 14:21:01 1995
0R 34 06/05 03:54 WWIVNET 4051->8421
0R 34 06/04 10:59 WWIVNet 4001->4051
0R 34 06/04 11:42 WWIVnet 4000->4001
0R 34 06/03 07:50 WWIVnet ->4000
0R 34 06/01 01:07 WWIVnet 4001->4000
0R 34 06/01 09:00 WWIVnet 2001->4001
0R 34 05/31 06:47 WWIVnet ->2001
0R 34 05/31 03:46 WWIVnet 8213->12001
0R 34 05/30 14:30 WWIVnet ->8213
Ŀ
  Mod Name: FR039.MOD         Mod Author: Frank Reid WWIVnet @8213         
  Difficulty: Beginner              Date: June 3, 1995                     
  WWIV Version: 4.24                                                       
  Description: Screen pause enhancements, beeps and warns after 30 seconds 
  and continues by itself after 60 seconds.  Includes an animated version. 


1.  Back up your source!  I take NO responsibility for ill effects of this or
any of my mods.  I'd be happy to help you get it working, though.

2.  Description:  An enhanced pausescr(), includes both an animated version
and a static one.  Beeps to remind the user he's paused after 30 seconds and
continues by itself after one minute if no key is hit (assuming the user has
spaced out on the distant end!)

3.  Mechanics:  The mod tracks the system clock using the structures time_t
and clock_t.  It loops, checking continually for a keypress, so it's friendly
to low speed users.  The animated version cycles through the system colors,
back and forth in a rhythmic wave pattern.  Uses standard str_pause calls, so
will work with a modified pause string or random pause string mods.

4.  Credits:  The idea for timing the length of a user pause came from an old
SkyNet mod, although I took an entirely different strategy to track the time.

-------------------------------------------------------------------------

Open <COM.C>

Search for void pausescr(void) and replace it with one of these:

void pausescr(void)
/*
 * Modified pause, beeps to remind user after 30 seconds and continues
 * after a minute.  Animated version -- cycles through the user colors
 * (except color #4) while it's counting.
 */
{

  int i, i1, i2, i3, i4, i5, i6, rev, cl1, cl2, oiia, warned;
  char *ss, s1[81], s2[81], s3[81];
  unsigned char ch;
  double ttotal;
  time_t tstart, tstop;
  clock_t cstop, cstart;

  if (x_only)
    return;

  oiia = iia;
  setiia(0);

  ss = str_pause;
  i2 = i1 = strlen(ss);
  for (i = 0; i < i2; i++)
    if ((ss[i] == 3) && (i1 > 1))
      i1 -= 2;

  if (okansi()) {
    i = curatr;
    setc((thisuser.sysstatus & sysstatus_color) ? thisuser.colors[3] :
         thisuser.bwcolors[3]);
    outstr(ss);
    npr("\x1b[%dD", i1);
    setc(i);
    if (rip)
      getkeymouse();
  } else
    outstr(ss);

  if (!rip) {
    time(&tstart);

    i3 = 0;
    cl1 = cl2 = 0;
    lines_listed = 0;
    warned = 0;
    rev = 0;
    cstart = clock();
    do {
      while (empty() && !hangup) {
        time(&tstop);
        ttotal = difftime(tstop, tstart);
        if (ttotal < 30) {
          cstop = clock();
          if ((cstop - cstart) > 1) {
            cstart = clock();
            if (okansi()) {
              if ((i3 == i1) && (!rev)) {
                rev = 1;
                do {
                  if (cl2++ > (sizeof(thisuser.colors)))
                    cl2 = 0;
                  if (cl2 == 4)
                    cl2 = 5;
                } while (cl1 == cl2);
              } else {
                if (i3 == 0) {
                  do {
                    if (cl1++ > (sizeof(thisuser.colors))) {
                      cl1 = 0;
                      if (cl1 == cl2)
                        cl1++;
                    } else {
                      if (cl1 == 4)
                        cl1 = 5;
                    }
                  } while (cl1 == cl2);
                }
              }
              if (rev) {
                if (i3 == 0)
                  rev = 0;
                else
                  i3--;
              } else
                i3++;
              for (i4 = 0; i4 < i3; i4++)
                s1[i4] = ss[i4];
              s1[i4++] = 0;
              i5 = 0;
              for (i4 = i3; i4 < i1; i4++)
                s2[i5++] = ss[i4];
              s2[i5++] = 0;
              setc((thisuser.sysstatus & sysstatus_color) ?
                   thisuser.colors[cl1] :
                   thisuser.bwcolors[cl1]);
              outstr(s1);
              setc((thisuser.sysstatus & sysstatus_color) ?
                   thisuser.colors[cl2] :
                   thisuser.bwcolors[cl2]);
              outstr(s2);
              npr("\x1b[%dD", i1);
              setc(i);
            }
          }
        } else {
          if (ttotal < 60) {
            if (!warned) {
              warned = 1;
              outchr(7);
              setc((thisuser.sysstatus & sysstatus_color) ?
                   thisuser.colors[3] :
                   thisuser.bwcolors[3]);
              sprintf(s3, "%s - Press a key to continue", ss);
              outstr(s3);
              i2 = i1 = (strlen(s3));
              for (i6 = 0; i6 < i2; i6++)
                if ((s3[i6] == 3) && (i1 > 1))
                  i1 -= 2;
              npr("\x1b[%dD", i1);
              setc(i);
            }
          } else {
            outchr(7);
            for (i6 = 0; i6 < i1; i6++)
              outchr(' ');
            npr("\x1b[%dD", i1);
            setc(i);
            setiia(oiia);
            return;
          }
        }
      }
      checkhangup();
      ch = inkey();
    } while (!ch && !in_extern && !hangup);
  }
  for (i6 = 0; i6 < i1; i6++)
    outchr(' ');
  npr("\x1b[%dD", i1);
  setc(i);
  setiia(oiia);
}

/* Or this static one */

void pausescr(void)
/*
 * Modified pause, beeps to remind user after 30 seconds and continues
 * after a minute.  Unanimated version.
 */
{

  int             i, i1, i2, i3, oiia, warned;
  char           *ss, s[81];
  unsigned char   ch;
  double          ttotal;
  time_t          tstart, tstop;

  if (x_only)
    return;

  oiia = iia;
  setiia(0);

  ss = str_pause;
  i2 = i1 = strlen(ss);
  for (i = 0; i < i2; i++)
    if ((ss[i] == 3) && (i1 > 1))
      i1 -= 2;

  if (okansi()) {
    i = curatr;
    setc((thisuser.sysstatus & sysstatus_color) ? thisuser.colors[3] :
         thisuser.bwcolors[3]);
    outstr(ss);
    npr("\x1b[%dD", i1);
    setc(i);
    if (rip)
      getkeymouse();
  } else
    outstr(ss);

  if (!rip) {
    time(&tstart);

    lines_listed = 0;
    warned = 0;
    do {
      while (empty() && !hangup) {
        time(&tstop);
        ttotal = difftime(tstop, tstart);
        if (ttotal == 30) {
          if (!warned) {
            warned = 1;
            outchr(7);
            setc((thisuser.sysstatus & sysstatus_color) ? thisuser.colors[3] :
                 thisuser.bwcolors[3]);
            sprintf(s, "%s - Press a key to continue", ss);
            outstr(s);
            i2 = i1 = (strlen(s));
            for (i3 = 0; i3 < i2; i3++)
              if ((s[i3] == 3) && (i1 > 1))
                i1 -= 2;
            npr("\x1b[%dD", i1);
            setc(i);
          }
        } else {
          if (ttotal > 60) {
            outchr(7);
            for (i3 = 0; i3 < i1; i3++)
              outchr(' ');
            npr("\x1b[%dD", i1);
            setc(i);
            setiia(oiia);
            return;
          }
        }
      }
      checkhangup();
      ch = inkey();
    } while (!ch && !in_extern && !hangup);
  }
  for (i3 = 0; i3 < i1; i3++)
    outchr(' ');
  npr("\x1b[%dD", i1);
  setc(i);
  setiia(oiia);
}

                  Drop me a note to say you like the mod!

70
2Eagle's Dare             WWIV Core Support Site               WWIVnet @82130
2FILEnet @1160                  Laurel, MD                    TerraNet @31040
2IceNET @3104                (301) 498-1984                Fidonet 1:109/5680
70
