/*****************************************************************************

				WWIV Version 4
                    Copyright (C) 1988-1993 by Wayne Bell

Distribution of the source code for WWIV, in any form, modified or unmodified,
without PRIOR, WRITTEN APPROVAL by the author, is expressly prohibited.
Distribution of compiled versions of WWIV is limited to copies compiled BY
THE AUTHOR.  Distribution of any copies of WWIV not compiled by the author
is expressly prohibited.


*****************************************************************************/

#include "vars.h"
#pragma hdrstop

#include <dir.h>
#include <mem.h>
#include <stdarg.h>
#include "ini.h"

/*****************************************************************************/

void set_43(void)
/* This function initialize the screen to 80x43 text mode */
{
  union REGS regs;

  textmode(C4350);

  regs.h.ah=0x12;
  regs.h.bl=0x30;
  regs.h.al=0x01;
  int86(0x10, &regs, &regs);

  regs.h.ah=0x00;
  regs.h.al=0x03;
  int86(0x10, &regs, &regs);

  regs.h.ah=0x11;
  regs.h.al=0x30;
  regs.h.bh=0x03;
  int86(0x10, &regs, &regs);

  regs.h.ah=0x11;
  regs.h.al=0x12;
  regs.h.bl=0x00;
  int86(0x10, &regs, &regs);
}

/*****************************************************************************/

void set_25(void)
/* This function will reset the screen to 80x25 mode */
{
  union REGS regs;

  regs.h.ah=0x12;
  regs.h.bl=0x30;
  regs.h.al=0x02;
  int86(0x10, &regs, &regs);

  regs.h.ah=0x00;
  regs.h.al=0x03;
  int86(0x10, &regs, &regs);

  regs.h.ah=0x11;
  regs.h.al=0x30;
  regs.h.bh=0x06;
  int86(0x10, &regs, &regs);

  regs.h.ah=0x11;
  regs.h.al=0x14;
  regs.h.bl=0x00;
  int86(0x10, &regs, &regs);

  textmode(C80);
}
/*****************************************************************************/

unsigned char *wfc_string(void)
/* This is the screen displayed in the scrolling bar of the WFC screen */
{
  unsigned char s[512];
  
  sprintf(s, "System is waiting for caller "
  "- You are on instance %d - %s %s (C) 1988-1995 Wayne Bell"
  " - Modification by Nicolas LeBlanc & Martin Bourdages - "
  "All rights reserved - Press ESC to quit - "
  "F1 to start screen saver - F2 to poll statistics - ", instance,
  wwiv_version,(syscfg.wwiv_reg_number)? "Registered": "Unregistered");
  return(s);
}

/*****************************************************************************/

unsigned char *wfc_menu [] =
{
  "Log On System",
  "Show Network Info",
  "Network Callout",
  "Network Pending",
  "Network Redial",
  "Network DataFiles",
  "Network Log",
  "Activity Log",
  "Yesterday's Log",
  "Today's Log",
  "Read All-Mail",
  "Read Feedback",
  "Send Email",
  "Sub Editor",
  "Dir Editor",
  "Conference Editor",
  "Instance Editor",
  "G-Files Editor",
  "Chain Editor",
  "Vote Editor",
  "Users Editor",
  "Reset Files",
  "Answer Phone",
  "Shell to Dos",
  "Terminal Program",
  "Send Loaded Mail",
  "System Status",
  "Write A File",
  "Show Environment",
  "Help",
  "Quit"
};

/*****************************************************************************/

void wfc_prlocate(int x, int y, int c, char *fmt, ...)
/* Output a fast string at a given position */
{
  va_list ap;
  char s[512];

  va_start(ap, fmt);
  vsprintf(s, fmt, ap);
  va_end(ap);
  gotoxy(x, y);
  curatr=c;
  outfast(stripcolors(s));
}

/*****************************************************************************/

void display(int type, int pos)
/* This function moves the cursor with the arrow keys */
{
  int i;
  char s[81];
  
  switch (type)
  {
    case 0:
      if (wfcinfo.flags & WFC_FLAGS_MENU_CENTERED)
      {
        i= strlen(wfc_menu[pos-1]);
        sprintf(s, "%s%s", charstr((17-i)/2, 32), wfc_menu[pos-1]);
        wfc_prlocate(3, pos+8, wfcinfo.wfc_high_color, " %-17.17s ", s);
      } else {
        wfc_prlocate(3, pos+8, wfcinfo.wfc_high_color, " %-17s ", wfc_menu[pos - 1]);
      }
    break;
    case 1:
      if (wfcinfo.flags & WFC_FLAGS_MENU_CENTERED)
      {
        i= strlen(wfc_menu[pos-1]);
        sprintf(s, "%s%s", charstr((17-i)/2, 32), wfc_menu[pos-1]);
        wfc_prlocate(3, pos+8, wfcinfo.wfc_low_color, " %-17.17s ", s);
      } else {
        wfc_prlocate(3, pos+8, wfcinfo.wfc_low_color, " %-17s ", wfc_menu[pos - 1]);
      }
    break;
  }
}

/*****************************************************************************/

void init_wfc(void)
{
  char *ss;

  wfcinfo.poll_time=10;
  wfcinfo.scrolling_time=0.25;
  wfcinfo.screen_saver_time=180;
  if (sysinfo.screen_saver_time==0)
    sysinfo.screen_saver_time=180;
  wfcinfo.options=31;
  wfcinfo.wfc_high_color=59;
  wfcinfo.wfc_low_color=113;
  wfcinfo.wfc_prt_color=126;
  wfcinfo.wfc_net_color=15;
  wfcinfo.wfc_bar_color=12;
  wfcinfo.wfc_sbar_color=127;
  wfcinfo.wfc_perc_color=15;
  wfcinfo.screen=C80;
  if (ini_init("WWIV.INI", "WFC", NULL)==0)
  {
    wfcinfo.flags &= ~WFC_FLAGS_EXIT_SAVER;
    wfcinfo.flags |= WFC_FLAGS_SCREEN_SAVER;
    wfcinfo.flags &= ~WFC_FLAGS_MENU_CENTERED;
    wfcinfo.flags &= ~WFC_FLAGS_STARFIELD;
    wfcinfo.flags &= ~WFC_FLAGS_SHOW_PERCENTAGE;
    if ((ss=ini_get("EXIT_SAVER", -1, NULL))!=NULL)
    {
      if (ss[0]==*str_yes)
        wfcinfo.flags |= WFC_FLAGS_EXIT_SAVER;
    }
    if ((ss=ini_get("SCREEN_SAVER", -1, NULL))!=NULL)
    {
      if (ss[0]==*str_yes)
        wfcinfo.flags |= WFC_FLAGS_SCREEN_SAVER;
    }
    if ((ss=ini_get("STARFIELD", -1, NULL))!=NULL)
    {
      if (ss[0]==*str_yes)
        wfcinfo.flags |= WFC_FLAGS_STARFIELD;
    }
    if ((ss=ini_get("SHOW_PERCENTAGE", -1, NULL))!=NULL)
    {
      if (ss[0]==*str_yes)
        wfcinfo.flags |= WFC_FLAGS_SHOW_PERCENTAGE;
    }
    if ((ss=ini_get("EXIT_MENU_CENTERED", -1, NULL))!=NULL)
    {
      if (ss[0]==*str_yes)
        wfcinfo.flags |= WFC_FLAGS_MENU_CENTERED;
    }
    if ((ss=ini_get("SCREEN", -1, NULL))!=NULL)
    {
       if (strcmpi(ss, "C4350")==NULL)
         wfcinfo.screen=C4350;
       else
         wfcinfo.screen=C80;
    }
    if ((ss=ini_get("POLLING_TIME", -1, NULL))!=NULL)
    {
      wfcinfo.poll_time=atoi(ss);
    }
    if ((ss=ini_get("SCROLL_TIME", -1, NULL))!=NULL)
    {
      wfcinfo.scrolling_time=atof(ss);
    }
    if ((ss=ini_get("OPTIONS", -1, NULL))!=NULL)
    {
      wfcinfo.options=atoi(ss);
    }
    if ((ss=ini_get("WFC_PRT_COLOR", -1, NULL))!=NULL)
    {
      wfcinfo.wfc_prt_color=atoi(ss);
    }
    if ((ss=ini_get("WFC_PERC_COLOR", -1, NULL))!=NULL)
    {
      wfcinfo.wfc_perc_color=atoi(ss);
    }
    if ((ss=ini_get("WFC_HIGH_COLOR", -1, NULL))!=NULL)
    {
      wfcinfo.wfc_high_color=atoi(ss);
    }
    if ((ss=ini_get("WFC_LOW_COLOR", -1, NULL))!=NULL)
    {
      wfcinfo.wfc_low_color=atoi(ss);
    }
    if ((ss=ini_get("WFC_NET_COLOR", -1, NULL))!=NULL)
    {
      wfcinfo.wfc_net_color=atoi(ss);
    }
    if ((ss=ini_get("WFC_BAR_COLOR", -1, NULL))!=NULL)
    {
      wfcinfo.wfc_bar_color=atoi(ss);
    }
    if ((ss=ini_get("WFC_SBAR_COLOR", -1, NULL))!=NULL)
    {
      wfcinfo.wfc_sbar_color=atoi(ss);
    }
    ini_done();
  }
}
/*****************************************************************************/

void wfc_screen(void)
/* This functions displays the waiting for caller screen */
{
  char s[161], s2[81], s3[81];
  int i1, dv, win, f, os2warp_ver_maj, os2warp_ver_min;
  float i;
  instancerec ir;
  userrec ur;
  struct dfree free;
  long avail;

  set_43();
  sprintf(s2, "%sWFC.DAT", syscfg.datadir);
  if (exist(s2)) 
  {
    f= sh_open1(s2, O_RDONLY | O_BINARY);
    sh_read(f, scrn, (2*80*42));
    wfcinfo.wfc_scr= 1;
    sh_close(f);
  } else {
    set_25();
    npr("\r\n\7WFC.DAT NOT FOUND!\r\n");
    npr("Please copy this file to your data directory.\r\n");
    end_bbs(noklevel);
  }
  init_wfc();
  for (i=0; i<wfcinfo.options; i++)
    display(1, i+1);
  write_inst(INST_LOC_WFC, 0, INST_FLAGS_NONE);
  wfc_prlocate(43, 8, wfcinfo.wfc_prt_color, times());
  wfc_prlocate(46, 24, wfcinfo.wfc_prt_color, ctim(timer() - wfcinfo.cur_time));
  if (sysop2()) 
  {
    wfc_prlocate(46, 20, wfcinfo.wfc_prt_color, "Available    ");
  } else {
    wfc_prlocate(46, 20, wfcinfo.wfc_prt_color, "Not Available");
  }
  _setcursortype(_NOCURSOR);
  i= (status.activetoday*49/1440.0);
  sprintf(s, "%s", charstr((int)i, ''));
  i= i - (int)i;
  if (i>0)
    strcat(s, i>=0.5? "": "");
  if (i) {
    if (i<100)
      sprintf(s3,"%4.1f%%",i);
    else
      sprintf(s3,"99.9%%");
  } else {
    sprintf(s3," 0.0%%");
  }
  wfc_prlocate(28, 40, wfcinfo.wfc_bar_color, s);
  if (wfcinfo.flags & WFC_FLAGS_SHOW_PERCENTAGE)
    wfc_prlocate(49, 40, wfcinfo.wfc_perc_color, s3);
  wfc_prlocate(43, 9, wfcinfo.wfc_prt_color, status.date1);
  wfc_prlocate(43, 10, wfcinfo.wfc_prt_color, "%d", fwaiting);
  wfc_prlocate(43, 11, wfcinfo.wfc_prt_color, "%hu", status.fbacktoday);
  wfc_prlocate(43, 12, wfcinfo.wfc_prt_color, "%hu", status.emailtoday);
  wfc_prlocate(43, 13, wfcinfo.wfc_prt_color, "%hu", status.msgposttoday);
  i1= getdisk();
  getdfree(i1 + 1, &free);
  avail= (long) free.df_avail * (long) free.df_bsec * (long) free.df_sclus;
  wfc_prlocate(43, 14, wfcinfo.wfc_prt_color, "%lu Megs", avail / 1000000);
  wfc_prlocate(43, 15, wfcinfo.wfc_prt_color, "%hu", status.localposts);
  get_inst_info(instance, &ir);
  if ((ir.user<syscfg.maxusers) && (ir.user>0)) 
  {
    read_user(ir.user, &ur);
    wfc_prlocate(46, 23, wfcinfo.wfc_prt_color, "%-30.30s", nam(&ur, ir.user));
  } else
    wfc_prlocate(46, 23, wfcinfo.wfc_prt_color, "%-30.30s", get_string(1410));
  wfc_prlocate(70, 8, wfcinfo.wfc_prt_color, "%hu", status.users);
  wfc_prlocate(70, 9, wfcinfo.wfc_prt_color, "%hu", status.callstoday);
  wfc_prlocate(70, 10, wfcinfo.wfc_prt_color, "%ld", status.callernum1);
  wfc_prlocate(70, 13, wfcinfo.wfc_prt_color, "%hu", status.activetoday);
  wfc_prlocate(70, 14, wfcinfo.wfc_prt_color, "%hu", status.uptoday);
#ifdef __OS2__
  wfc_prlocate(70, 15, wfcinfo.wfc_prt_color, "N/A");
#else
  wfc_prlocate(70, 15, wfcinfo.wfc_prt_color, "%ldk", bytes_to_k(memavail()));
#endif
  if (multitasker)
    switch (multitasker) 
    {
      case 1 :
        dv= get_dv_version();
        wfc_prlocate(46, 19, wfcinfo.wfc_prt_color, "DESQView %d.%02d", dv / 256, dv % 256);
      break;
      case 2 :
        win= get_win_version();
        wfc_prlocate(46, 19, wfcinfo.wfc_prt_color, "Windows %s%d.%02d",
                (win%256==4)?"95 ":"", win % 256, win / 256);
      break;
      case 3 :
        win= get_win_version();
        dv= get_dv_version();
        wfc_prlocate(46, 19, wfcinfo.wfc_prt_color, "Win %d.%02d and DV %d.%02d",
          win % 256, win / 256, dv / 256, dv % 256);
      break;
      case 4 :
       os2warp_ver_maj=_osmajor/10;
       os2warp_ver_min=_osminor;
       if ((os2warp_ver_maj>=2) && (os2warp_ver_min>=30))
       {
         if (os2warp_ver_min==30)
           wfc_prlocate(46, 19, wfcinfo.wfc_prt_color, "OS/2 Warp v%d", os2warp_ver_min/10);
         else
           wfc_prlocate(46, 19, wfcinfo.wfc_prt_color, "OS/2 v%d.x", os2warp_ver_min/10);
       } else {
         wfc_prlocate(46, 19, wfcinfo.wfc_prt_color, "OS/2 %d.%2.2d", _osmajor / 10, _osminor);
       }
      break;
      default:
        wfc_prlocate(46, 19, wfcinfo.wfc_prt_color, get_string(1170));
    } else
      wfc_prlocate(46, 19, wfcinfo.wfc_prt_color, "None");
  wfc_prlocate(46, 21, wfcinfo.wfc_prt_color, "%.30s", syscfgovr.primaryport?modem_i->name:"Local Node");
  wfc_prlocate(46, 18, wfcinfo.wfc_prt_color, "%5.5s", ctim(syscfg.executetime*60));
  wfc_prlocate(70, 11, wfcinfo.wfc_prt_color, "%u", status.days);
  if (status.days<1)
    status.days=1;
  wfc_prlocate(70, 12, wfcinfo.wfc_prt_color, "%.2f", (status.callernum1 / (status.days*1.0)));
  alternate_pending();
  alternate_instance();
  reset_colors();
}

/*****************************************************************************/

void alternate_pending(void)
/* This function is doing the alternating network pending */
{
  char s[61][6];
  int net_pendingos[61], ipos[61], nn, i, i1, i2, i3, y, netnum= 0;
  int sn,num_ncn, amount, num_call_sys;
  net_call_out_rec *con;
  net_contact_rec *ncn;
  net_system_list_rec *csne;
  
  if ((net_networks[0].sysnum==0) && (net_num_max==1)) {
    wfc_prlocate(43, 32, wfcinfo.wfc_net_color, "No network detected");
    return;
  }
  for (nn= 0; nn<net_num_max; nn++)
  {
    set_net_num(nn);
    read_call_out_list();
    read_contacts();
    con= net_networks[net_num].con;
    ncn= net_networks[net_num].ncn;
    num_call_sys= net_networks[net_num].num_con;
    num_ncn= net_networks[net_num].num_ncn;
    for (i1= 0; i1<num_call_sys; i1++)
    {
      i2= - 1;
      for (i= 0; i<num_ncn; i++)
      {
        if (con[i1].sysnum==ncn[i].systemnumber)
        {
          i2= i;
          break;
        }
      }
      ipos[netnum]= i2;
      net_pendingos[netnum]= nn;
      sprintf(s[netnum++], "%hu", ncn[i2].systemnumber);
    }
    if (netnum>60)
      break;
  }
  if (netnum<4)
    amount=netnum;
  else
    amount=4;
  for (i3=0; i3<amount; i3++) {
    if (wfcinfo.net_pending+i3<netnum)
      y=wfcinfo.net_pending+i3;
    if (wfcinfo.net_pending+i3==netnum)
      y=0;
    if (wfcinfo.net_pending+i3==netnum+1)
      y=1;
    if (wfcinfo.net_pending+i3==netnum+2)
      y=2;
    sn= atoi(s[y]);
    set_net_num(net_pendingos[y]);
    read_call_out_list();
    read_contacts();
    ncn= net_networks[net_num].ncn;
    csne= next_system(sn);
    wfc_prlocate(28, 31+i3, wfcinfo.wfc_net_color, "@%-5s %-25.25s %-10.10s %4ldk",
      s[y], csne->name, net_name,
      bytes_to_k(ncn[ipos[y]].bytes_waiting));
  }
  wfcinfo.net_pending++;
  if (wfcinfo.net_pending>netnum-1)
    wfcinfo.net_pending= 0;
}

/*****************************************************************************/

void alternate_instance(void)
/* This function is the alternating instance display */
{
  char s[161],s2[81];
  int i, i1= 0, ch;
  instancerec ir;
  userrec ur;
  
  s[0]= 0;
  get_inst_info(wfcinfo.alt_instance, &ir);
  read_user(ir.user, &ur);
  if (ir.flags & INST_FLAGS_ONLINE)
    wfc_prlocate(46, 26, wfcinfo.wfc_prt_color, "%-25.25s (%d)", nam(&ur, ir.user), wfcinfo.alt_instance);
  else
    wfc_prlocate(46, 26, wfcinfo.wfc_prt_color, "Nobody On Instance %-10d", wfcinfo.alt_instance);
  make_inst_str(wfcinfo.alt_instance, s2);
  for (i=strcspn(s2, ":")+4; ((i<strlen(s2)) && (ch!=13)); i++)
  {
    ch=s2[i];
    if (ch>31)
      s[i1++]=ch;
  }
  s[i1]=0;
  wfc_prlocate(46, 27, wfcinfo.wfc_prt_color, "%-30.25s", s);
  wfcinfo.alt_instance++;
  if (wfcinfo.alt_instance>num_instances())
    wfcinfo.alt_instance= 1;
}

/*****************************************************************************/

void wfcprt(char *fmt, ...)
/* Print in the bar up in the screen if wfc screen is present */
{
  int i1;
  va_list ap;
  char s[512];
  
  va_start(ap, fmt);
  vsprintf(s, fmt, ap);
  va_end(ap);

  if (sysinfo.flags & OP_FLAGS_WFC_SCREEN) 
  {
    if (wfcinfo.wfc_scr==1)
    {
      i1= strlen(stripcolors(s));
      wfc_prlocate(2, 3, wfcinfo.wfc_sbar_color, charstr(76, ' '));
      wfc_prlocate(2+((76-i1)/2), 3, wfcinfo.wfc_sbar_color, s);
    } else {
      outfast(s);
    }
  } else {
    outfast(s);
  }
}

/*****************************************************************************/

void reset_screen(int mode)
/* Reset the screen to 80x25 or SCREEN defined mode for an operation */
{
  union REGS regs;

  if (wfcinfo.wfc_scr==2)
  {
    regs.h.al=0x03;
    regs.h.ah=0x00;
    int86(0x10, &regs, &regs);
  }
  clrscr();
  set_25();
  if (mode)
  {
    textmode(wfcinfo.screen);
    defscreenbottom=(int) peekb(0x0000,0x0484);
    if (defscreenbottom<24)
      defscreenbottom=24;
    if (defscreenbottom>63)
      defscreenbottom=24;
    if ((defscreenbottom!=42) && (defscreenbottom!=49))
      defscreenbottom=24;
    screenbottom=defscreenbottom;
  }
  wfcinfo.wfc_scr= 0;
  reset_colors();
}

/*****************************************************************************/

long memavail(void)
/* This will return the amount of memory free */
{
   union REGS regs;

   regs.h.ah = 0x48;
   regs.x.bx = 0xFFFF;
   int86(0x21,&regs,&regs);
   return((long)regs.x.bx * 16L);
}

/*****************************************************************************/
/*                         Screen Saver Routines                             */
/*****************************************************************************/

unsigned int star[101][3] =
{
  214,45,0,  13,177,0,  194,167,0, 78,70,0,   179,182,0,
  122,154,0, 285,142,0, 38,57,0,   106,145,0, 152,38,0,  87,6,0,
  291,164,0, 304,115,0, 217,136,0, 120,157,0, 174,136,0, 106,104,0,
  130,105,0, 93,159,0,  314,31,0,  201,55,0,  33,59,0,   290,1,0,
  234,189,0, 210,64,0,  98,197,0,  133,87,0,  153,121,0, 141,132,0,
  274,161,0, 286,146,0, 272,131,0, 277,38,0,  66,115,0,  18,69,0,
  99,58,0,   158,138,0, 283,150,0, 30,71,0,   48,141,0,  145,90,0,
  18,18,0,   212,176,0, 209,17,0,  165,101,0, 76,182,0,  314,33,0,
  106,36,0,  73,106,0,  34,0,0,    26,48,0,   106,104,0, 77,62,0,
  147,31,0,  42,48,0,   297,50,0,  221,173,0, 90,62,0,   304,66,0,
  58,122,0,  248,44,0,  303,68,0,  187,57,0,  216,4,0,   128,150,0,
  176,88,0,  20,130,0,  138,155,0, 314,37,0,  109,34,0,  74,110,0,
  286,85,0,  115,45,0,  100,20,0,  239,30,0,  27,138,0,  271,162,0,
  284,17,0,  58,136,0,  273,18,0,  125,192,0, 244,34,0,  77,27,0,
  89,30,0,   276,56,0,  264,24,0,  44,117,0,  51,45,0,   158,20,0,
  86,114,0,  18,22,0,   215,196,0, 127,38,0,  240,160,0, 248,68,0,
  38,95,0,   78,34,0,   239,28,0,  121,134,0, 262,176,0, 20,93,0
};

void pixel(int x, int y, int attr)
{
  union REGS regs;

  regs.h.ah=12;
  regs.h.al=attr;
  regs.x.cx=x;
  regs.x.dx=y;
  int86(0x10, &regs, &regs);
}

void display_stars(void)
{
  int starc=0, c1, ypost, xpost;

  for(; starc<101; starc++)
  {
    xpost=star[starc][2];
    ypost=star[starc][1];
    pixel(xpost, ypost, 0);
    if (starc>0)
      star[starc][0]+=1, c1=22;
    if (starc>40)
      star[starc][0]+=2, c1=24;
    if (starc>70)
      star[starc][0]+=3, c1=27;
    if (starc>90)
      star[starc][0]+=4, c1=30;
    if (star[starc][0] > 320)
      star[starc][0]-=320;
    xpost=star[starc][0];
    ypost=star[starc][1];
    pixel(xpost, ypost, c1);
    star[starc][2]=xpost;
  }
}

/*****************************************************************************/

unsigned char InKey(void)
/* This function is the same than inkey(), but it is done to work with the
 * GetAllKeys() function.
 */
{
  unsigned char ch=0;

  if (x_only)
    return(0);

  if (charbufferpointer) {
    if (!charbuffer[charbufferpointer]) {
      charbufferpointer = charbuffer[0] = 0;
    } else {
      if ((charbuffer[charbufferpointer])==3)
        charbuffer[charbufferpointer]=16;
      return(charbuffer[charbufferpointer++]);
    }
  }
  if (kbhitb() || (in_extern == 2)) {
    ch = getchd1();
    lastcon = 1;
    if (!(g_flags & g_flag_allow_extended)) {
      if (!ch) {
        if (in_extern)
          in_extern = 2;
        else {
          ch = getchd1();
          skey(ch);
        if ((ch!=72) // UP
            && (ch!=75) // LEFT
            && (ch!=80) // DOWN
            && (ch!=77) // RIGHT
            && (ch!=71) // HOME
            && (ch!=79)) // END
          ch=0;
        }
      } else if (in_extern)
        in_extern = 1;
    }
    timelastchar1=timer1();
  } else if (incom && comhit()) {
    ch = (get1c() & andwith);
    lastcon = 0;
  }
  if (!(g_flags & g_flag_allow_extended))
    skey1(&ch);

  return(ch);
}

unsigned char GetAllKeys(void)
/* This function is the same that getkey(), but it allows you to use the
 * arrow keys (remote and locally) and the home/end keys. You can easily
 * add any other extended keys as long as you know its ANSI and Scan code
 * for this key.
 */
{
  unsigned char ch;
  int beepyet,done=0,pass=0;
  long dd,tv,tv1;

  beepyet = 0;
  timelastchar1=timer1();

  if (so())
    tv=10920L;
  else
    tv=3276L;

  tv1=tv/2;

  if (!tagging || (thisuser.sysstatus & sysstatus_no_tag))
    lines_listed = 0;
  do
  {
    switch (pass)
    {
      case 0: if ((ch>31) && (ch<123)) done=1; break;
      case 1:
        if ((incom) && (ch!=255))
          done=1;
        if ((incom) && (ch!='\x1b'))
        {
          switch (ch)
          {
            case 71: return(71); // HOME
            case 72: return(72); // UP
            case 75: return(75); // LEFT
            case 77: return(77); // RIGHT
            case 79: return(79); // END
            case 80: return(80); // DOWN
            default: return(27); // ESC
          }
        }
      break;
      case 2:
        switch(ch)
        {
          case 'A': return(72); // UP
          case 'B': return(80); // DOWN
          case 'C': return(77); // RIGHT
          case 'D': return(75); // LEFT
          case 'K': return(79); // END
          case 'H': return(71); // HOME
          default:  return(27); // ESC
        }
      default: done=1;
    }
    do
    {
      while (empty() && !hangup)
      {
        giveup_timeslice();
        dd = timer1();
        if ((dd<timelastchar1) && ((dd+1000)>timelastchar1))
          timelastchar1=dd;
        if (labs(dd - timelastchar1) > 65536L)
          timelastchar1 -= 1572480L;
        if (((dd - timelastchar1) > tv1) && (!beepyet))
        {
          beepyet = 1;
          outchr(7);
        }
        if (labs(dd - timelastchar1) > tv)
        {
          nl();
          if (!in_extern)
            outstr(get_string(924));
          nl();
          hangup = 1;
        }
        checkhangup();
      }
      ch = InKey();
    } while (!ch && !in_extern && !hangup);
    pass++;
  } while (!done && !hangup);
  if (checkit && (ch > 127)) {
    checkit = 0;
    ch = ch & (andwith = 0x7F);
  }
  return(upcase(ch));
}
