Ŀ
 Mod Name: FR040.MOD         Mod Author: Frank Reid WWIVnet @8213          
 Difficulty: Beginner              Date: June 3, 1995                      
 WWIV Version: 4.24                                                        
 Description: A two-up subboard listing which allows you to change to a    
 new conference or select a subboard by number when done displaying.       


1.  Back up your source!  I take NO responsibility for ill effects of this or
any of my mods.  I'd be happy to help you get it working, though.

2.  Description:  Companion to my two-column directory list (FR007E), this
displays the subboards in a two-column, top-to-bottom list, and prompts the
user for a sub number or conference change when done.

3.  Credits:  Same as FR007 -- mostly Morgul! :-)

4.  Drawback:  The mod provides non-ANSI support, however no support for 40
columns.  If your users still use 40 column mode(!), you'll have to use the
old sublist, too -- drop me a note if you need help there.

5.  Mechanics:  The mod itself is mainly a single block copy, but we have to
give sublist a new prototype with a 'mode' parameter.  (Mode '0' does not
prompt for a subboard number, which is needed for moving/extracting messages.)

Open <BBSOVL1.C>

At the top of the file, add these two new stock includes.  (For the curious,
math.h includes the prototype for "ceiling" which determines the top limit of
the number of directories, and ctype.h has prototypes for determining whether
keyboard input is numeric, alphabetic, etc.)

**** These should already be there if you have FR007E installed! ****

== #include "ripint.h"

++ #include <math.h>
++ #include <ctype.h>

== #define FRAME 7

Search for "void sublist(void)" and delete the entire function.  Replace
it with this:

void sublist(int mode)
{
  int i, i1, i2, i3, i4, oc, nc, os, done, next, abort, ns, ns1, sn, en, tt;
  int c1, c2, c3, c4;
  char *num, ch, s[100], s1[100], s2[100], s3[100], s4[40];
  double nsd;

  sn = 0;
  i4 = 0;
  next = 0;
  oc = nc = curconfsub;
  os = udir[cursub].subnum;
  en = subconfnum - 1;

  do {
    abort = 0;
    done = 0;
    if (!i4) {
      if (okconf(&thisuser)) {
        if ((uconfsub[1].confnum != -1) && (!next)) {
          nl();
          prt(2, get_string(1019));
          ch = onek("Q A");
          nl();
          switch (ch) {
          case ' ':
            sn = curconfsub;
            en = curconfsub;
            break;
          case 'A':
            mode = 0;
            break;
          case 'Q':
            return;
          }
        }
      } else
        oc = -1;
    } else {
      sn = curconfsub;
      en = curconfsub;
    }
    next = 1;
    i = sn;
    outchr(12);
    nl();
    while ((i <= en) && (uconfsub[i].confnum != -1) && (!abort)) {
      if ((uconfsub[1].confnum != -1) && (okconf(&thisuser))) {
        setuconf(CONF_SUBS, i, -1);
        sprintf(s, "[ %s %c - %s ]", get_string(1021),
           subconfs[uconfsub[i].confnum].designator,
          stripcolors(subconfs[uconfsub[i].confnum].name));
        if (okansi()) {
          tt = (40 - (strlen(s) / 2));
          npr("\x1B" "[0;1m%s\r\n", charstr(strlen(s) + (tt * 2 - 2), ''));
          npr("\x1B" "[0;34;47m%s", charstr(tt, ' '));
          npr("\x1B" "[0;34;47m%s", s);
          npr("\x1B" "[0;34;47m%s\x1B" "[40m\r\n", charstr(tt - 2, ' '));
          npr("\x1B" "[0;1;30m%s\r\n", charstr(strlen(s) + (tt * 2 - 2), ''));
        } else {
          for (i2 = 0; i2 < 78; i2++)
            outchr(45);
          nl();
          prt(1, s);
          nl();
          for (i2 = 0; i2 < 78; i2++)
            outchr(45);
          nl();
        }
      } else {
        sprintf(s, "[ %s Message Areas ]", syscfg.systemname);
        if (okansi()) {
          tt = (40 - (strlen(s) / 2));
          npr("\x1B" "[0;1m%s\r\n", charstr(strlen(s) + (tt * 2 - 2), ''));
          npr("\x1B" "[0;34;47m%s", charstr(tt, ' '));
          npr("\x1B" "[0;34;47m%s", s);
          npr("\x1B" "[0;34;47m%s\x1B" "[40m\r\n", charstr(tt - 2, ' '));
          npr("\x1B" "[0;1;30m%s\r\n", charstr(strlen(s) + (tt * 2 - 2), ''));
        } else {
          for (i2 = 0; i2 < 78; i2++)
            outchr(45);
          nl();
          prt(1, s);
          nl();
          for (i2 = 0; i2 < 78; i2++)
            outchr(45);
          nl();
        }
      }
      c1 = thisuser.colors[8];
      thisuser.colors[8] = 1;
      ansic(8);
      if (okansi())
        outchr(213);
      else
        outchr(43);
      for (i2 = 1; i2 < 77; i2++)
        if (okansi())
          outchr(205);
        else
          outchr(45);
      if (okansi())
        outchr(184);
      else
        outchr(43);
      nl();
      thisuser.colors[8] = c1;
      i1 = 0;
      ns = 0;
      while ((i1 <= num_subs) && (ns == 0)) {
        if ((usub[i1].subnum == -1) || (i1 == num_subs))
          ns = i1;
        else
          i1++;
      }
      ns1 = ns;
      nsd = ceil(((double) ns) / 2);
      ns = (int) nsd;
      i3 = 0;
      for (i1 = 0; ((i1 < ns) && (!abort) && (!hangup)); i1++) {
          if (atoi(usub[i1].keys) == 0)
            i3 = 1;
          strcpy(s4,subboards[usub[i1].subnum].name);
          if (okansi()) {
            if ((nc == oc) || (!okconf(&thisuser))) {
              if (usub[i1].subnum == os) {
                sprintf(s3, "%-30.30s", s4);
                sprintf(s1, "8 06%3s24 %-30s",
                  usub[i1].keys,
                  s3);
              } else {
                sprintf(s3, "%-30.30s", s4);
                sprintf(s1, "8 06%3s2 1%-30s",
                  usub[i1].keys,
                  s3);
              }
            } else {
              sprintf(s3, "%-30.30s", s4);
              sprintf(s1, "8 06%3s2 1%-30s",
                usub[i1].keys,
                s3);
            }
          } else {
            sprintf(s3, "%-30.30s", s4);
            sprintf(s1, " %3s | %-30s", usub[i1].keys,
              s3);
          }
          if ((usub[i1 + ns].subnum != -1)) {
            strcpy(s4,subboards[usub[i1+ns].subnum].name);
            if (okansi()) {
              if (usub[i1 + ns].subnum == os) {
                sprintf(s3, "%-30.30s", s4);
                sprintf(s2, " 06%3s24 %-30s 8",
                  usub[i1 + ns].keys,
                  s3);
              } else {
                sprintf(s3, "%-30.30s", s4);
                sprintf(s2, " 06%3s2 1%-30s 8",
                  usub[i1 + ns].keys,
                  s3);
              }
            } else {
              sprintf(s3, "%-30.30s", s4);
              sprintf(s2, "| %3s | %-30s",
                usub[i1 + ns].keys,
                s3, numf);
            }
            sprintf(s, "%35s %-35s", s1, s2);
          } else {
            if (okansi())
              sprintf(s, "%-35s %s8", s1, charstr(38, 32));
            else
              sprintf(s, "%-35s |     |", s1);
          }
          c1 = thisuser.colors[8];
          c2 = thisuser.colors[6];
          c3 = thisuser.colors[2];
          c4 = thisuser.colors[0];
          thisuser.colors[8] = 1;
          thisuser.colors[2] = 8;
          thisuser.colors[6] = 112;
          thisuser.colors[0] = 15;
          pla(s, &abort);
          thisuser.colors[8] = c1;
          thisuser.colors[6] = c2;
          thisuser.colors[2] = c3;
          thisuser.colors[0] = c4;
      }
      i++;
      c1 = thisuser.colors[8];
      thisuser.colors[8] = 1;
      ansic(8);
      if (okansi())
        outchr(212);
      else
        outchr(43);
      for (i2 = 1; i2 < 77; i2++)
        if (okansi())
          outchr(205);
        else
          outchr(45);
      if (okansi())
        outchr(190);
      else
        outchr(43);
      nl();
      thisuser.colors[8] = c1;
      if (!okconf(&thisuser))
        break;
    }
    if (i == 0) {
      pla(get_string(5), &abort);
      nl();
    }
    if ((!abort) && (mode == 1)) {
      prt(2, "Select [");
      sprintf(s, "%s-%d", i3 ? "0" : "1", i3 ? (ns1-1) : ns1);
      ansic(1);
      outstr(s);
      i3 = 0;
      if (okconf(&thisuser))
        outstr(",J");
      outstr(",?,Q2]: ");
      num = mmkey(0);
      if ((strcmp(num, "") == 0) || (strcmp(num, "Q") == 0)) {
        if (okconf(&thisuser))
          setuconf(CONF_SUBS, nc, 1);
        done = 1;
      }
      if (((strcmp(num, "C") == 0) || ((strcmp(num, "J") == 0))) &&
          (okconf(&thisuser))) {
        i4 = 1;
        jump_conf(CONF_SUBS);
        nc = curconfsub;
        done = 0;
      }
      if (isdigit(num[0])) {
        for (i2 = 0; i2 < num_subs; i2++) {
          if (strcmp(usub[i2].keys, num) == 0) {
            cursub = i2;
            os = usub[cursub].subnum;
            done = 1;
          }
        }
      }
    } else {
      if (okconf(&thisuser))
        setuconf(CONF_SUBS, oc, os);
      done = 1;
    }
  } while ((!hangup) && (!done));
  nl();
}

Save <BBSOVL1.C>

Load <MMENU.C>

In "void mainmenu(void)" search for "sublist" and change:

==      case '*':
==#ifdef RIPDRIVE
==        rd_coff();
==#endif
=+        sublist(1);
==#ifdef RIPDRIVE
==        rd_con();
==#endif
==        break;

Save <MMENU.C>

Load <MSGBASE1.C>

Search again for "sublist" and change:

==                    prt(2,get_string(686));
==                    ss1=mmkey(0);
==                    if (ss1[0]=='?') {
=+                      sublist(0);
==                    }

Save <MSGBASE1.C>

Open <QWK1.C>

Again, search for "sublist" and change the line:

==        else if(substr[0] == '?')
=+          sublist(0);
==        else
==          done5=1;

Save <QWK1.C>

Load <FCNS.H>

This step is unnecessary if you use 'MAKE FCNS'.

Search for "dirlist" again, and change:

=+void sublist(int mode);
==void dirlist(void);
==void text_edit(void);

Save <FCNS.H>

Recompile and drop me a note to say you like it (or hate it!)

40
4  Eagle's Dare             WWIV Core Support Site               WWIVnet @8213  0
4  FILEnet @1160                  Laurel, MD                    TerraNet @3104  0
4  IceNET @3104                 (301) 498-1984               Fidonet 1:109/568  0
40
