Ŀ
 Mod Name: FR007E.MOD        Mod Author: Frank Reid WWIVnet @8213          
 Difficulty: Beginner              Date: June 3, 1995                      
 WWIV Version: 4.24                                                        
 Description: A two-up directory listing which allows you to change to a   
 new conference or select a directory by number when done displaying.      


1.  Back up your source!  I take NO responsibility for ill effects of this or
any of my mods.  I'd be happy to help you get it working, though.

2.  Description:  Displays file directories in a two-column, top-to-bottom
list.  Prompts when completed, so the user can select a directory number or go
to a different conference.  The current conference is displayed on the white
banner at the top.  Directories are listed vertically rather than horizontally
(top to bottom rather than side to side), which I thought made more sense.  If
a new conference is selected, the directory list for that conference is
displayed.  '?' redisplays the listing and 'Q', obviously, quits it.  Here's
what it looks like:

[255D[40m
[0;1m[A
[69C
[0;34;47m[0;34;47m [0;34;47m [0;34;47m [0;34;47m [0;34;47m [40m[A
[5C[0;34;47m [0;34;47m [0;34;47m [0;34;47m [0;34;47m [0;34;47m [40m[A
[11C[0;34;47m [0;34;47m [0;34;47m [0;34;47m [0;34;47m [0;34;47m[40m[A
[16C[47m [0;34;47m [0;34;47m [0;34;47m [0;34;47m [0;34;47m[ Con[40m[A
[26C[47mference S - Sysop Support Areas ]                   [40m
[0;1;30m[A
[66C
[0;34m[A
[68C͸
 [0;1m[0;30;47m[0;30;47m [0;30;47m [0;30;47m0[0;1;30m [0;36mSysop[A
[13C's Mess[20C[0;1m[0;30;47m[0;30;47m [0;30;47m14[0;1;30m [0;36m[A
[46CFront Ends and Mailers[9C[0;34m
 [0;1m[0;30;47m[0;30;47m [0;30;47m [0;30;47m1[0;1;30m[A
[7C[0;1;44m[0;1;44m [0;1;44mNew SysOp Uploads               [0;1m[A
[41C[0;30;47m[0;30;47m [0;30;47m15[0;1;30m [0;36mSunrise Doors[18C[A
[77C[0;34m
 [0;1m[0;30;47m[0;30;47m [0;30;47m [0;30;47m2[0;1;30m [0;36mRemot[A
[13CeAccess[20C[0;1m[0;30;47m[0;30;47m [0;30;47m16[0;1;30m [0;36m[A
[46CWWIV Core Support Files[8C[0;34m
 [0;1m[0;30;47m[0;30;47m [0;30;47m [0;30;47m3[0;1;30m [0;36mWildc[A
[13Cat! Files[18C[0;1m[0;30;47m[0;30;47m [0;30;47m17[0;1;30m [A
[46C[0;36mWWIV Utility Programs[10C[0;34m
 [0;1m[0;30;47m[0;30;47m [0;30;47m [0;30;47m4[0;1;30m [0;36mPCBoa[A
[13Crd Files[19C[0;1m[0;30;47m[0;30;47m [0;30;47m18[0;1;30m [A
[46C[0;36mWWIV Network Programs[10C[0;34m
 [0;1m[0;30;47m[0;30;47m [0;30;47m [0;30;47m5[0;1;30m [0;36mPCBoa[A
[13Crd Files II[16C[0;1m[0;30;47m[0;30;47m [0;30;47m19[0;1;30m [A
[46C[0;36mWWIV v4.23 Mods Uploads[8C[0;34m
 [0;1m[0;30;47m[0;30;47m [0;30;47m [0;30;47m6[0;1;30m [0;36mGener[A
[13Cal BBS Files I[13C[0;1m[0;30;47m[0;30;47m [0;30;47m20[40m[A
[44C[0;1;30m [0;36mWWIV v4.23 Mods [A-L][10C[0;34m
 [0;1m[0;30;47m[0;30;47m [0;30;47m [0;30;47m7[0;1;30m [0;36mGener[A
[13Cal BBS Files II[12C[0;1m[0;30;47m[0;30;47m [0;30;47m21[40m[A
[44C[0;1;30m [0;36mFMD Software Support[11C[0;34m
 [0;1m[0;30;47m[0;30;47m [0;30;47m [0;30;47m8[0;1;30m [0;36mGener[A
[13Cal BBS Files III[11C[0;1m[0;30;47m[0;30;47m [0;30;47m22[40m[A
[44C[0;1;30m [0;36mAsylum Mod Support[13C[0;34m
 [0;1m[0;30;47m[0;30;47m [0;30;47m [0;30;47m9[0;1;30m [0;36mBBS O[A
[13Cnline Programs I[11C[0;1m[0;30;47m[0;30;47m [0;30;47m23[40m[A
[44C[0;1;30m [0;36mWWIV v4.23 Mods [M-Z][10C[0;34m
 [0;1m[0;30;47m[0;30;47m [0;30;47m10[0;1;30m [0;36mBBS Online Prog[A
[23Crams II[10C[0;1m[0;30;47m[0;30;47m [0;30;47m24[0;1;30m [0;36m[A
[46CWWIV Older Mods [A-L][10C[0;34m
 [0;1m[0;30;47m[0;30;47m [0;30;47m11[0;1;30m [0;36mBBS Online Prog[A
[23Crams III[9C[0;1m[0;30;47m[0;30;47m [0;30;47m25[0;1;30m [0;36m[A
[46CWWIV Older Mods [M-Z][10C[0;34m
 [0;1m[0;30;47m[0;30;47m [0;30;47m12[0;1;30m [0;36mBBS Online Prog[A
[23Crams IV[10C[0;1m[0;30;47m[0;30;47m [0;30;47m26[0;1;30m [0;36m[A
[46CWWIV Mod Collections[11C[0;34m
 [0;1m[0;30;47m[0;30;47m [0;30;47m13[0;1;30m [0;36mMailer-related [A
[23CFiles[12C[0;1m[0;30;47m[0;30;47m [0;30;47m27[0;1;30m [0;36mSt[A
[48Carport Valhalla Mods[9C[0;34m
[A
[75C;
[0;1;33mSelect [[0;1;36m0-27,J,?,Q[0;1;33m]:
[0m[255D

3.  Credits:  Inspired by Morgul's dirlist(), the best of many.  Morgul's took
too much landscape with a few hundred file areas here, so I sought out a way
to display the directories in a side-by-side format.  If I remember, there's
still some code from The Flying Chicken, Analog Kid and Jim Wire (who all did
excellent dirlist mods!)

4.  Drawback:  The mod provides non-ANSI support, however no support for 40
columns.  If your users still use 40 column mode(!), you'll have to use the
old dirlist, too -- drop me a note if you need help there.

5.  Mechanics:  The mod itself is mainly a single block copy, but we have to
give dirlist a new prototype with a 'mode' parameter.  (Mode '0' does not
prompt for a directory number, and is needed for moving files and the like.)
When the directory list is called in mode '0', it displays CDROM directories
in a subdued color (so you don't try to move files into them!)

6.  Note for ListPlus users:  The Asylum ListPlus mod calls a dirlist in one
or two places.  You need to change those calls from dirlist() to dirlist(0)
or you'll get errors in compile!

Open <BBSOVL1.C>

At the top of the file, add these two new stock includes.  (For the curious,
math.h includes the prototype for "ceiling" which determines the top limit of
the number of directories, and ctype.h has prototypes for determining whether
keyboard input is numeric, alphabetic, etc.)

== #include "ripint.h"

++ #include <math.h>
++ #include <ctype.h>

== #define FRAME 7

Search for "void extract_mod(char *b, long len)" and change the line
indicated:

==  do {
==    prt(2,get_string(1198));
==    ss1=mmkey(1);
==    if (ss1[0]=='?')
=+      dirlist(0);
==  } while ((!hangup) && (ss1[0]=='?'));

Now, search for "void dirlist(void)" and delete the entire function.  Replace
it with the following:

void dirlist(int mode)
{
  int i, i1, i2, i3, i4, oc, nc, os, done, next, abort, ns, ns1, sn, en, tt;
  int c1, c2, c3, c4;
  char *num, ch, s[100], s1[100], s2[100], s3[100], s4[40];
  double nsd;

  sn = 0;
  i4 = 0;
  next = 0;
  oc = nc = curconfdir;
  os = udir[curdir].subnum;
  en = dirconfnum - 1;

  do {
    abort = 0;
    done = 0;
    if (!i4) {
      if (okconf(&thisuser)) {
        if ((uconfdir[1].confnum != -1) && (!next)) {
          nl();
          prt(2, get_string(1019));
          ch = onek("Q A");
          nl();
          switch (ch) {
          case ' ':
            sn = curconfdir;
            en = curconfdir;
            break;
          case 'A':
            mode = 0;
            break;
          case 'Q':
            return;
          }
        }
      } else
        oc = -1;
    } else {
      sn = curconfdir;
      en = curconfdir;
    }
    next = 1;
    i = sn;
    outchr(12);
    nl();
    while ((i <= en) && (uconfdir[i].confnum != -1) && (!abort)) {
      if ((uconfdir[1].confnum != -1) && (okconf(&thisuser))) {
        setuconf(CONF_DIRS, i, -1);
        sprintf(s, "[ %s %c - %s ]", get_string(1021),
           dirconfs[uconfdir[i].confnum].designator,
          stripcolors(dirconfs[uconfdir[i].confnum].name));
        if (okansi()) {
          tt = (40 - (strlen(s) / 2));
          npr("\x1B" "[0;1m%s\r\n", charstr(strlen(s) + (tt * 2 - 2), ''));
          npr("\x1B" "[0;34;47m%s", charstr(tt, ' '));
          npr("\x1B" "[0;34;47m%s", s);
          npr("\x1B" "[0;34;47m%s\x1B" "[40m\r\n", charstr(tt - 2, ' '));
          npr("\x1B" "[0;1;30m%s\r\n", charstr(strlen(s) + (tt * 2 - 2), ''));
        } else {
          for (i2 = 0; i2 < 78; i2++)
            outchr(45);
          nl();
          prt(1, s);
          nl();
          for (i2 = 0; i2 < 78; i2++)
            outchr(45);
          nl();
        }
      } else {
        sprintf(s, "[ %s File Directories ]", syscfg.systemname);
        if (okansi()) {
          tt = (40 - (strlen(s) / 2));
          npr("\x1B" "[0;1m%s\r\n", charstr(strlen(s) + (tt * 2 - 2), ''));
          npr("\x1B" "[0;34;47m%s", charstr(tt, ' '));
          npr("\x1B" "[0;34;47m%s", s);
          npr("\x1B" "[0;34;47m%s\x1B" "[40m\r\n", charstr(tt - 2, ' '));
          npr("\x1B" "[0;1;30m%s\r\n", charstr(strlen(s) + (tt * 2 - 2), ''));
        } else {
          for (i2 = 0; i2 < 78; i2++)
            outchr(45);
          nl();
          prt(1, s);
          nl();
          for (i2 = 0; i2 < 78; i2++)
            outchr(45);
          nl();
        }
      }
      c1 = thisuser.colors[8];
      thisuser.colors[8] = 1;
      ansic(8);
      if (okansi())
        outchr(213);
      else
        outchr(43);
      for (i2 = 1; i2 < 77; i2++)
        if (okansi())
          outchr(205);
        else
          outchr(45);
      if (okansi())
        outchr(184);
      else
        outchr(43);
      nl();
      thisuser.colors[8] = c1;
      i1 = 0;
      ns = 0;
      while ((i1 <= num_dirs) && (ns == 0)) {
        if ((udir[i1].subnum == -1) || (i1 == num_dirs))
          ns = i1;
        else
          i1++;
      }
      ns1 = ns;
      nsd = ceil(((double) ns) / 2);
      ns = (int) nsd;
      i3 = 0;
      for (i1 = 0; ((i1 < ns) && (!abort) && (!hangup)); i1++) {
        if (atoi(udir[i1].keys) == 0)
          i3 = 1;
        strcpy(s4, directories[udir[i1].subnum].name);
        if (okansi()) {
          if ((nc == oc) || (!okconf(&thisuser))) {
            if (udir[i1].subnum == os) {
              sprintf(s3, "%-30.30s", s4);
              sprintf(s1, "8 06%3s24 %-30s",
                udir[i1].keys,
                s3);
            } else {
              sprintf(s3, "%-30.30s", s4);
              sprintf(s1, "8 06%3s2 %s%-30s",
                udir[i1].keys,
                ((mode == 2) ?
                ((directories[udir[i1].subnum].mask & mask_cdrom) ?
                 "a" : "1") : "9"),
                s3);
            }
          } else {
            sprintf(s3, "%-30.30s", s4);
            sprintf(s1, "8 06%3s2 %s%-30s",
              udir[i1].keys,
              ((mode == 2) ?
              ((directories[udir[i1].subnum].mask & mask_cdrom) ?
               "a" : "1") : "9"),
              s3);
          }
        } else {
          sprintf(s3, "%-30.30s", s4);
          sprintf(s1, " %3s | %-30s", udir[i1].keys,
            s3);
        }
        if ((udir[i1 + ns].subnum != -1)) {
          strcpy(s4, directories[udir[i1 + ns].subnum].name);
          if (okansi()) {
            if (udir[i1 + ns].subnum == os) {
              sprintf(s3, "%-30.30s", s4);
              sprintf(s2, " 06%3s24 %-30s 8",
                udir[i1 + ns].keys,
                s3);
            } else {
              sprintf(s3, "%-30.30s", s4);
              sprintf(s2, " 06%3s2 %s%-30s 8",
                udir[i1 + ns].keys,
                ((mode == 2) ?
                ((directories[udir[i1 + ns].subnum].mask & mask_cdrom) ?
                 "a" : "1") : "9"),
                s3);
            }
          } else {
            sprintf(s3, "%-30.30s", s4);
            sprintf(s2, "| %3s | %-30s",
              udir[i1 + ns].keys,
              s3, numf);
          }
          sprintf(s, "%35s %-35s", s1, s2);
        } else {
          if (okansi())
            sprintf(s, "%-35s %s8", s1, charstr(38, 32));
          else
            sprintf(s, "%-35s |     |", s1);
        }
        c1 = thisuser.colors[8];
        c2 = thisuser.colors[6];
        c3 = thisuser.colors[2];
        c4 = thisuser.colors[0];
        thisuser.colors[8] = 1;
        thisuser.colors[2] = 8;
        thisuser.colors[6] = 112;
        thisuser.colors[0] = 15;
        pla(s, &abort);
        thisuser.colors[8] = c1;
        thisuser.colors[6] = c2;
        thisuser.colors[2] = c3;
        thisuser.colors[0] = c4;
      }
      i++;
      c1 = thisuser.colors[8];
      thisuser.colors[8] = 1;
      ansic(8);
      if (okansi())
        outchr(212);
      else
        outchr(43);
      for (i2 = 1; i2 < 77; i2++)
        if (okansi())
          outchr(205);
        else
          outchr(45);
      if (okansi())
        outchr(190);
      else
        outchr(43);
      nl();
      thisuser.colors[8] = c1;
      if (!okconf(&thisuser))
        break;
    }
    if (i == 0) {
      pla(get_string(5), &abort);
      nl();
    }
    if ((!abort) && (mode == 1)) {
      prt(2, "Select [");
      sprintf(s, "%s-%d", i3 ? "0" : "1", i3 ? (ns1 - 1) : ns1);
      ansic(1);
      outstr(s);
      i3 = 0;
      if (okconf(&thisuser))
        outstr(",J");
      outstr(",?,Q2]: ");
      num = mmkey(1);
      if ((strcmp(num, "") == 0) || (strcmp(num, "Q") == 0)) {
        if (okconf(&thisuser))
          setuconf(CONF_DIRS, nc, 1);
        done = 1;
      }
      if (((strcmp(num, "C") == 0) || ((strcmp(num, "J") == 0))) &&
          (okconf(&thisuser))) {
        i4 = 1;
        jump_conf(CONF_DIRS);
        nc = curconfdir;
        done = 0;
      }
      if (isdigit(num[0])) {
        for (i2 = 0; i2 < num_dirs; i2++) {
          if (strcmp(udir[i2].keys, num) == 0) {
            curdir = i2;
            os = udir[curdir].subnum;
            done = 1;
          }
        }
      }
    } else {
      if (okconf(&thisuser))
        setuconf(CONF_DIRS, oc, os);
      done = 1;
    }
  } while ((!hangup) && (!done));
  nl();
}

Save <BBSOVL1.C>

Load <MMENU.C>

In "void dlmainmenu(void)" search for "dirlist" and change:

==      case '*':
==#ifdef RIPDRIVE
==        rd_coff();
==#endif
=+        dirlist(1);
==#ifdef RIPDRIVE
==        rd_con();
==#endif
==        break;

Save <MMENU.C>

Load <XFEROVL.C>

Search again for "dirlist" and change:

==        prt(2,get_string(823));
==        ss=mmkey(1);
==        if (ss[0]=='?') {
=+          dirlist(0);
==          dliscan();
==        }

Save <XFEROVL.C>

Open <XFERTMP.C>

Again, search for "dirlist" and change the line:

==          prt(2,get_string(823));
==          ss=mmkey(1);
==          if (ss[0]=='?') {
=+            dirlist(0);
==            dliscan1(batch[i2].dir);
==          }

Save <XFERTMP.C>

Load <FCNS.H>

This step is unnecessary if you use 'MAKE FCNS'.

Search for "dirlist" again, and change:

==void sublist(void);
=+void dirlist(int mode);
==void text_edit(void);

Save <FCNS.H>

Recompile and drop me a note to say you like it (or hate it!)

40
4  Eagle's Dare             WWIV Core Support Site               WWIVnet @8213  0
4  FILEnet @1160                  Laurel, MD                    TerraNet @3104  0
4  IceNET @3104                 (301) 498-1984               Fidonet 1:109/568  0
40
