Ŀ
 Mod Name      : JAFO20E.MOD              Mod Author: JAFO 1@1     TerraNET 
 Difficulty    : ۱                                1@3809  WWIVnet  
 WWIV Version  : 4.24                                      1@8857  IceNET   
 Mod Date      : 06/05/95                                  1@8857  SOLARnet 
 Files Affected: BATCH.C, COM.C, LILO.C, MMENU.C,          1@18857 WWIVLink 
                 NEWUSER.C, SYSOPF.C, UTILITY.C, XFER.C,                    
                 XFEROVL.C, VARDEC.H, VARS.H                                
 Description   : Configurable File Listings                                 

ͻ
   This mod is Copyright 1995, by Cris McRae, aka JAFO, and is distributed  
   as freeware.  Permission is granted to distribute and post this mod on   
   systems and online services, provided no alternations are made (removal  
   of message headers/taglines are allowed).  This mod may contain some     
   parts of WWIV source code, which is Copyright 1988-1995 by Wayne Bell    
   and licensed only to registered users of WWIV.  Use of WWIV source       
   without registration constitutes a license violation and could lead to   
   legal prosecution and certain doom.                                      
                                                                            
   Shareware distributors and CD-ROM publishers may not distribute this mod 
   without express written permission of the Author or WWIV Software        
   Services.                                                                
ͼ

[ Description ]

This modification allows your BBS to have configurable file listings.  What
this means is that every aspect of your file listings can be configured.  The
following list of options can be toggled on or off:

Filename
File extension
File size
File upload date
Number of file downloads
File description
Extended file description
File uploader

In addition to being able to toggle the above options on or off, you can also
change the color of each of the above to any of the 16 DOS colors.  You are
not limited to the colors used by WWIV.

This modification has been in use on my BBS for quite some time, so those of
you who have called my BBS probably will recognize this mod.

Revision A:
   Added the ability to view extended file descriptions when relisting files.
   Added the ability to tag and view files by using a scrolling highlight bar
    to highlight the file you want to tag or view.
   Added the ability to remove a file from the batch queue by tagging it a
    second time.
   The reset file listing function now turns on the extended description.
   New users are prompted to configure their file listings the first time
    they enter the transfer area on their first logon.
   If upgrading, do the following steps: 2,4,10,12,14,15,16,17,18,20,21,22,
                                          23,24,25,27,29,29,30

Revision B:
   Made minor cosmetic changes.
   Fixed problem with the file tag prompt appearing at top of a blank screen
    after doing a 'R'elist.
   Optimized listings for speed.
   Added display of "Copying file..." when a file on a CD-ROM is tagged and
    copied to the hard drive.  This can sometimes take a second or two and the
    user should be aware of what is going on.
   If upgrading, do the following steps: 7,11,15,17,18,19,24,27,28,32,33

Revision C:
   Fixed two bugs in the print_extended function.
   Added filelistlen declaration in VARS.H (was left out in last version).
   Fixed bug in the config_file_listing function that caused the extended
    description to be printed one space to the right of where it was supposed
    to begin.
   Changed how a highlighted file appears when that file has been tagged for
    downloading.  The filename is highlighted with bright red on blue.
   If upgrading, do the following steps: 17,24,28,32

Revision D:
   Fixed bug where file was highlighted as being tagged even after you have
    untagged the file.
   Fixed bug that caused a blue line to occasionally appear on the bottom of
    the screen after tagging/untagging a file.
   Fixed bug that caused the screen to go blank after a certain number of
    carriage returns during file tagging.
   If upgrading, do the following step: 24

Revision E:
   Updated for WWIV v4.24.
   If upgrading, do all steps again.  Make sure you //RESETFILELIST from the
    transfer main menu to reset all user file listing settings.  WWIV v4.24
    added a variable *before* the filelist variable in the userrec, so you
    will have blank listings unless you reset the listings (you could also
    move the "cbv" variable after the two variables added by this mod, but
    you probably want to keep that variable in its default position).
   Changed how listings work.  If the next listing cannot fit completely on
    the screen, it is not displayed.

[ Legend ]

  =  Existing line - Do not change
  +  Add this line
  -  Remove this line

[ Step 1 ]

Please back up your source code.  Even the best programmers make mistakes.

[ Step 2 ]

In BATCH.C, add the following functions after "void delbatch":

int find_batch_queue_fn(char *fn)
{
  int i;

  for (i=0; i<numbatch; i++)
    if (strcmp(fn,batch[i].filename)==0)
      return(i);
  return(-1);
}

void remove_batch(char *fn)
{
  int i;

  if ((i=find_batch_queue_fn(fn))>=0)
    delbatch(i);
}

[ Step 3 ]

In COM.C, make the following changes in "void outchr":

=         if (lines_listed >= screenlinest - 3) {
=           if(!in_extern) {
=             if ((tagging) && !(thisuser.sysstatus & sysstatus_no_tag) &&
-                 filelist && !chatting) {
+                 filelist && !chatting && !relisting) {
=               if(num_listed!=0)
=                 tag_files();
=               lines_listed = 0;
=             }
=           }
=         }

[ Step 4 ]

In COM.C, make the following changes in "unsigned char inkey":

=           ch = getchd1();
=           skey(ch);
-           ch = (((ch == 68) || (ch==103)) ? 2 : 0);
+           if (!tagging)
+             ch = (((ch == 68) || (ch==103)) ? 2 : 0);
=         }
=       } else if (in_extern)

Note:  If you are using JAFO21, my scrollbar matrix menu mod, you need to
       change the "if" statement above to:

+         if ((!tagging) && (!matrix))

[ Step 5 ]

Still in COM.C, add the following function after "void ansic":

void ansic2(char c)
{
  if (c == curatr)
    return;
  setc(c);
  makeansi((thisuser.sysstatus & sysstatus_color) ? thisuser.colors[0] :
        thisuser.bwcolors[0],endofline, 0);
}

[ Step 6 ]

Still in COM.C, add the following functions after "void goxy":

void outxy(int x, int y, char *s)
{
  if (okansi())
    npr("\x1b[%d;%dH%s",y,x,s);
}

void kill_line(void)
{
  if (okansi())
    outstr("\x1b[K");
}

[ Step 7 ]

In LILO.C, add the following lines in "void logon":

=   if (rip_on()) {
=         rip_popup = -1;      /* Re-enable */
=         cleared = -1;
=   }
+   filelistlen=0;
+   if (thisuser.filelist & filelist_filename) {
+     filelistlen+=9;
+     if (thisuser.filelist & filelist_extension)
+       filelistlen+=4;
+   }
+   if (thisuser.filelist & filelist_filesize)
+     filelistlen+=6;
+   if (thisuser.filelist & filelist_uldate)
+     filelistlen+=9;
+   if (thisuser.filelist & filelist_numdloads)
+     filelistlen+=3;
=   nscandate=thisuser.daten;
=   batchtime=0.0;

[ Step 8 ]

Still in MMENU.C, add the following lines in "void mainmenu":

=       case 'T':
=         if (syscfg.sysconfig & sysconfig_no_xfer) {
=           nl();
=           pl(get_string(30));
=           nl();
=           break;
=         }
=         if ((udir[0].subnum==-1) && (okconf(&thisuser))) {
=           for (curconfdir=0;
=                (curconfdir<dirconfnum) &&
=                (uconfdir[curconfdir].confnum!=-1);
=                curconfdir++) {
=             setuconf(CONF_DIRS, curconfdir, -1);
=             if (udir[0].subnum!=-1)
=               break;
=           }
=         }
=         if (udir[0].subnum!=-1) {
=           write_inst(INST_LOC_XFER,udir[curdir].subnum,INST_FLAGS_ONLINE);
=           curdloads=1;
=           existprint(get_string(1037));
+           if (thisuser.filelist & filelist_notset) {
+             nl();
+             ansic(1);
+             pl("Please configure your file listings with the 'K' command.  Thanks.");
+             thisuser.filelist ^= filelist_notset;
+           }
=         } else {
=           nl();

[ Step 9 ]

In MMENU.C, add the following lines in "void dlmainmenu":

=     if (strcmp(s,"DOS")==0) {
=       if (checkpw()) {
=         sysoplog(get_stringx(1,6));
=         extern_prog(getenv("COMSPEC"), EFLAG_SHRINK|EFLAG_COMIO|EFLAG_ABORT);
=         topscreen();
=       }
=     }
+
+     if (strcmp(s,"RESETFILELIST")==0)
+       reset_file_listings();
=   }

[ Step 10 ]

Still in MMENU.C, add the following lines in "void dlmainmenu":

=       case 'J':
=         if (okconf(&thisuser))
=           jump_conf(CONF_DIRS);
=         break;
+       case 'K':
+         config_file_listing();
+         break;
=       case 'L':
=         tagging=1;
=         listfiles();
=         tagging=0;
=         break;

[ Step 11 ]

Still in MMENU.C, make the following changes in "void dlmainmenu":

=       case 'N':
=         if (sysinfo.flags & OP_FLAGS_SETLDATE) {
=           helpl=13;
=           setldate();
=         }
=         abort=0;
=         num_listed=0;
=         tagging=1;
=         titled=1;
=         nl();
=         prt(5,get_string(39));
=         if (yn())
=           nscanall();
=         else {
-           nl();
+           new_scan_flag=0;
=           nscandir(curdir,&abort);
=           if (num_listed) {
=             endlist(2);

[ Step 12 ]

In NEWUSER.C, add the following lines in "void newuser":

=   thisuser.sl=syscfg.newusersl;
=   thisuser.dsl=syscfg.newuserdsl;
=
=   thisuser.ontoday=1;
=
+   thisuser.filelist = 0;
+
+   thisuser.filelist |= filelist_filename;    /* This is the default file */
+   thisuser.filelist |= filelist_extension;   /* listings configuration.  */
+   thisuser.filelist |= filelist_filesize;    /* If you want to make any  */
+   thisuser.filelist |= filelist_descript;    /* changes, do it here.     */
+
+   thisuser.filelist |= filelist_notset;
+
+   thisuser.num_extended=10;
+
=   thisuser.restrict=syscfg.newuser_restrict;
=
=   *qsc=999;
=   memset(qsc_n,0xff,((max_dirs+31)/32)*4);

[ Step 13 ]

Still in "void newuser", add the following lines:

=   if (!hangup) {
=     input_ansistat();
+     if (thisuser.sysstatus & sysstatus_color) { /* Default color settings */
+       thisuser.filelistcol[0]=9;                /* Filename */
+       thisuser.filelistcol[1]=9;                /* File extension */
+       thisuser.filelistcol[2]=3;                /* File size */
+       thisuser.filelistcol[3]=1;                /* Upload date */
+       thisuser.filelistcol[4]=5;                /* Number of downloads */
+       thisuser.filelistcol[5]=11;               /* File description */
+       thisuser.filelistcol[6]=3;                /* File uploader */
+       thisuser.filelistcol[7]=3;                /* Extended description */
+     } else {
+       thisuser.filelistcol[0]=15;
+       thisuser.filelistcol[1]=15;
+       thisuser.filelistcol[2]=7;
+       thisuser.filelistcol[3]=7;
+       thisuser.filelistcol[4]=7;
+       thisuser.filelistcol[5]=15;
+       thisuser.filelistcol[6]=7;
+       thisuser.filelistcol[7]=7;
+     }
=     if (incom) {
=       if (printfile("SYSTEM"))

[ Step 14 ]

In SYSOPF.C, add the following function to the end of the file:

void reset_file_listings(void)
{
  int i,i1;
  userrec u;

  nl();
  i1=number_userrecs();
  for (i=1; i<i1; i++) {
    if ((i % 10)==0)
      npr("Reseting file listing for user %d of %d\r",i,i1);
    read_user(i,&u);

    u.num_extended=10;

    u.filelist = 0;
    u.filelist |= filelist_filename;
    u.filelist |= filelist_extension;
    u.filelist |= filelist_filesize;
    u.filelist |= filelist_descript;
    u.filelist |= filelist_notset;

    if (u.sysstatus & sysstatus_color) {
      u.filelistcol[0]=9;
      u.filelistcol[1]=9;
      u.filelistcol[2]=3;
      u.filelistcol[3]=1;
      u.filelistcol[4]=5;
      u.filelistcol[5]=11;
      u.filelistcol[6]=3;
      u.filelistcol[7]=3;
    } else {
      u.filelistcol[0]=15;
      u.filelistcol[1]=15;
      u.filelistcol[2]=7;
      u.filelistcol[3]=7;
      u.filelistcol[4]=7;
      u.filelistcol[5]=15;
      u.filelistcol[6]=7;
      u.filelistcol[7]=7;
    }

    write_user(i,&u);
  }
  npr("\n");
}

[ Step 15 ]

In UTILITY.C, add the following line in "void frequent_init":

=   two_color=0;
=   using_modem=0;
+   relisting=0;
=   set_global_handle(0);
=   live_user=1;


[ Step 16 ]

In XFER.C, add the following line near the top:

= #include <dir.h>
=
+ int new_scan=0,cls=1;
=
= #define SETREC(f,i)  sh_lseek(f,((long) (i))*((long)sizeof(uploadsrec)),SEEK_SET);

[ Step 17 ]

Still in XFER.C, replace "void print_extended" with the following function:

void print_extended(char *ss, char *fn, int *abort, unsigned char numlist, int indent)
{
  int next=0;
  unsigned char numl=0;
  int cpos=0;
  char ch,s[81];
  int tag,length,numc=0,limit,flag=0;

  tag=tagging;
  if (!ss)
    ss=read_extended_description(fn);
  else
    flag=1;
  if (ss) {
    if (indent!=2) {
      length=filelistlen;
      if ((tagging) && !(thisuser.sysstatus & sysstatus_no_tag) &&
         ((!okansi()) || (!(thisuser.filelist & filelist_filename))))
        length+=3;

      ch=10;
    } else
      length=13;

    limit=thisuser.screenchars-length-2;

    tag=tagging;

    if (okansi())
      sprintf(s,"\x1b[%dC",length);
    else
      strcpy(s,charstr(length,32));

    while ((ss[cpos]) && (!(*abort)) && (numl<numlist) && (tag==tagging)) {
      if (ch==10) {
        if (indent) {
          outstr(s);
          if (okansi()) {
            if (indent!=2)
              ansic2(thisuser.filelistcol[7]);
            else
              ansic(2);
          }
        } else
          ansic(2);
      }
      while ((ch=ss[cpos++])=='\r')
        ;
      if (ch==10) {
        osan("\r\n",abort,&next);
        numc=0;
        ++numl;
      } else if (numc>limit) {
        do {
          ch=ss[cpos++];
        } while ((ch!='\n') && (ch!=0));
        if (ch!=0)
          --cpos;
      } else {
        outchr(ch);
        numc++;
      }
    }
    if (WhereX())
      nl();
    if (!flag)
      bbsfree(ss);
  } else {
    if (WhereX())
      nl();
  }
}

[ Step 18 ]

Still in XFER.C, replace "void printinfo" with the following function:

void printinfo(uploadsrec *u, int *abort)
{
  char s[100],s1[40],s2[81],*ss=NULL;
  int i,next,length,inbatch=0,numlines;

  if ((lines_listed>=(screenlinest-4)) &&
     (thisuser.filelist & filelist_uploader))  {
    tag_files();
    if (tagging==0)
      return;
  }
  if ((u->mask & mask_extended) && (tagptr) && (thisuser.num_extended)) {
    numlines=1;
    ss=read_extended_description(u->filename);
    if (ss) {
      for (i=0; i<strlen(ss); i++)
        if (ss[i]==10)
          ++numlines;
      if ((lines_listed+numlines >= screenlinest - 4)) {
        tag_files();
        if (tagging==0) {
          bbsfree(ss);
          return;
        }
      }
    }
  }

  length=filelistlen;
  if (titled!=0)
    printtitle(abort);
  if ((tagging==0) && (!x_only)) {
    if (ss)
      bbsfree(ss);
    return;
  }
  if ((tagging == 1) && !(thisuser.sysstatus & sysstatus_no_tag)
    && (!x_only)) {
    if (!filelist) {
      filelist=(tagrec *)malloca(50 * sizeof(tagrec));
      tagptr=0;
    }
    if (filelist) {
      filelist[tagptr].u=*u;
      filelist[tagptr].directory= udir[curdir].subnum;
      filelist[tagptr].dir_mask=  directories[udir[curdir].subnum].mask;
      filelist[tagptr].linenum=lines_listed+1;
      tagptr++;
      if ((!okansi()) || (!(thisuser.filelist & filelist_filename))) {
        length+=3;
        sprintf(s,"\r%d%2d ",
          (check_batch_queue(filelist[tagptr-1].u.filename)) ? 6 : 0,
          tagptr);
        outstr(s);
      }
    }
  } else
    if (!x_only)
      outstr("\r");

  if (thisuser.filelist & filelist_filename) {
    strncpy(s,u->filename,8);
    s[8]=0;
    if (numbatch) {
      if (check_batch_queue(filelist[tagptr-1].u.filename)) {
        inbatch=1;
        ansic((thisuser.filelistcol[0]!=12)?6:2);
      } else
        ansic2(thisuser.filelistcol[0]);
    } else
      ansic2(thisuser.filelistcol[0]);
    outstr(s);

    if (thisuser.filelist & filelist_extension) {
      strncpy(s,&((u->filename)[8]),4);
      s[4]=0;
      if (inbatch)
        ansic((thisuser.filelistcol[0]!=12)?6:2);
      else
        ansic2(thisuser.filelistcol[1]);
      outstr(s);
    }
    outchr(' ');
  }

  if (thisuser.filelist & filelist_filesize) {
    ltoa(bytes_to_k(u->numbytes),s1,10);
    strcat(s1,"k");

    if (!(directories[udir[curdir].subnum].mask & mask_cdrom)) {
      strcpy(s2,directories[udir[curdir].subnum].path);
      strcat(s2,u->filename);
      if (!exist(s2))
        strcpy(s1,get_string(741));
    }

    sprintf(s,"%s%s ",charstr(5-strlen(s1),32),s1);
    ansic2(thisuser.filelistcol[2]);
    outstr(s);
  }

  if (thisuser.filelist & filelist_uldate) {
    ansic2(thisuser.filelistcol[3]);
    outstr(u->date);
    outchr(' ');
  }

  if (thisuser.filelist & filelist_numdloads) {
    itoa(u->numdloads,s,10);
    sprintf(s1,"%2s ",s);
    ansic2(thisuser.filelistcol[4]);
    outstr(s1);
  }

  if (thisuser.filelist & filelist_descript) {
    strcpy(s,u->description);
    s[thisuser.screenchars-length-1]=0;
    ansic2(thisuser.filelistcol[5]);
    pl(s);
  } else
    nl();
  checka(abort,&next);
  if ((!*abort) && (thisuser.num_extended) && (u->mask & mask_extended))
    print_extended(ss,u->filename,abort,thisuser.num_extended,1);
  if ((!*abort) && (thisuser.filelist & filelist_uploader)) {
    if (okansi())
      sprintf(s2,"\x1b[%dC",length);
    else
      strcpy(s2,charstr(length,32));
    sprintf(s,"%sUploaded by: %s",s2,u->upby);
    ansic2(thisuser.filelistcol[6]);
    pl(s);
  }
  if (ss)
    bbsfree(ss);
  if (!(*abort)) {
    ++num_listed;
  } else {
    tagptr=0;
    tagging=0;
  }
}

[ Step 19 ]

Still in XFER.C, replace "void printtitle" with the following function:

void printtitle(int *abort)
{
  char s[100],s1[100],s2[81];

  if ((lines_listed >= screenlinest - 6) && (lines_listed) && (!x_only)
    && !(thisuser.sysstatus & sysstatus_no_tag) && filelist && num_listed) {
    tag_files();
    if (tagging==0)
      return;
  }
  if ((okansi()) && (thisuser.sysstatus & sysstatus_color)) {
    if ((new_scan) && (lines_listed>0))
      nl();
    ansic2(15);
    pla(charstr(thisuser.screenchars-1,220),abort);
    sprintf(s2,"%s - #%s",directories[udir[curdir].subnum].name,udir[curdir].keys);
    sprintf(s1," %-60s Total Files: %-4d",s2,numf);
    ansic2(112);
    pla(s1,abort);
    ansic2(8);
    pla(charstr(thisuser.screenchars-1,223),abort);
  } else {
    sprintf(s,"Area: %s - #%s",directories[udir[curdir].subnum].name,
            udir[curdir].keys);
    if (new_scan)
      nl();
    pla(s,abort);
    nl();
  }
  titled=0;
}

[ Step 20 ]

Still in XFER.C, make the following change in "void listfiles":

=   titled=1;
=   lines_listed=0;
+   outchr(12);
=   f=sh_open1(dlfn,O_RDONLY | O_BINARY);
=   for (i=1; (i<=numf) && (!abort) && (!hangup) && (tagging!=0); i++) {

[ Step 21 ]

Still in XFER.C, replace "void nscandir" and "void nscanall" with the
following functions:

void nscandir(int d, int *abort)
{
  int i,od,next=0,f,flag=0;
  uploadsrec u;

  if ((dir_dates[udir[d].subnum]) && (dir_dates[udir[d].subnum]<nscandate))
    return;

  od=curdir;
  curdir=d;
  dliscan();
  if (this_date>=nscandate) {
    f=sh_open1(dlfn,O_RDONLY | O_BINARY);
    for (i=1; (i<=numf) && (!(*abort)) && (!hangup) && (tagging!=0); i++) {
      checkhangup();
      SETREC(f,i);
      sh_read(f,(void *)&u,sizeof(uploadsrec));
      if (u.daten>=nscandate) {
        f=sh_close(f);
        if ((!flag) && (!new_scan_flag)) {
          outchr(12);
          flag=1;
          new_scan_flag=1;
        }
        printinfo(&u, abort);
        f=sh_open1(dlfn,O_RDONLY | O_BINARY);
      } else if (!empty())
        checka(abort,&next);

    }
    f=sh_close(f);
  }
  curdir=od;
}

void nscanall(void)
{
  int abort,i,i1,count,color,ac=0;
  char s[81];

  if ((uconfdir[1].confnum!=-1) && (okconf(&thisuser))) {
    if (!x_only) {
      nl();
      prt(5,get_string(1379));
      ac=yn();
      nl();
    } else
      ac=1;
    if (ac)
      tmp_disable_conf(1);
  }
  abort=0;
  num_listed=0;
  new_scan_flag=0;
  for (i=0; (i<num_dirs) && (!abort) && (udir[i].subnum!=-1) &&
       (tagging!=0); i++) {
    i1=udir[i].subnum;
    if (qsc_n[i1/32]&(1L<<(i1%32))) {
      titled=1;
      new_scan=1;
      nscandir(i,&abort);
      new_scan=0;
    }
  }
  nl();
  endlist(2);
  if (ac)
    tmp_disable_conf(0);
}

NOTE: If you have JAFO22 installed, you will need to add "newfscan=1;" at
      the top of "void nscandir".

[ Step 22 ]

Still in XFER.C, replace "void searchall" with the following function:

void searchall(void)
{
  int i,i1,pts,abort,ocd,next=0,f,f1,ac=0,flag=0;
  char s[81];
  uploadsrec u;

  if ((uconfdir[1].confnum!=-1) && (okconf(&thisuser))) {
    if (!x_only) {
      nl();
      prt(5,get_string(1379));
      ac=yn();
    } else
      ac=1;
    if (ac)
      tmp_disable_conf(1);
  }

  abort=0;
  ocd=curdir;
  if (x_only) {
    strcpy(s,"*.*");
    align(s);
  } else {
    nl();
    pl(get_string(745));
    file_mask(s);
  }
  num_listed=0;
  lines_listed=0;
  for (i=0; (i<num_dirs) && (!abort) && (!hangup) && (tagging || x_only)
    && (udir[i].subnum!=-1); i++) {
    i1=udir[i].subnum;
    pts=0;
    if (qsc_n[i1/32]&(1L<<(i1%32)))
      pts=1;
    pts=1;
    /* remove pts=1 to search only marked directories */
    if (pts) {
      curdir=i;
      dliscan();
      titled=1;
      f=sh_open1(dlfn,O_RDONLY | O_BINARY);
      f1=0;
      for (i1=1; (i1<=numf) && (!abort) && (!hangup) && (tagging || x_only); i1++) {
        SETREC(f,i1);
        sh_read(f,(void *)&u,sizeof(uploadsrec));
        if (compare(s,u.filename)) {
          f=sh_close(f);
          if (!flag) {
            outchr(12);
            flag=1;
          }
          printinfo(&u, &abort);
          f=sh_open1(dlfn,O_RDONLY | O_BINARY);
          f1=1;
        } else if (!empty())
          checka(&abort,&next);
      }
      f=sh_close(f);
    }
    if (f1)
      nl();
  }
  curdir=ocd;
  endlist(1);
  if (ac)
    tmp_disable_conf(0);
}

[ Step 23 ]

Still in XFER.C, make the following changes in "int printfileinfo":

=   if (u->mask & mask_extended) {
=     pl(get_string(753));
-     print_extended(u->filename,&abort,255,0);
+     print_extended(NULL,u->filename,&abort,255,0);
=   }
=
=   sprintf(s,"%s%s",directories[dn].path,u->filename);

[ Step 24 ]

In XFEROVL.C, add the following line to the top of the file:

= #include <time.h>
= #include <dir.h>
=
+ extern int new_scan;
=
= /* number of dots for searching */
= #define DOTS 5

[ Step 25 ]

Still in XFEROVL.C, replace "void relist" with the following function:

void relist(void)
{
  char s[100],s1[40],s2[81];
  int i,next,abort=0,inbatch;
  int tcd=-1, otag;

  if (!filelist)
    return;
  outchr(12);
  lines_listed=0;
  otag=tagging;
  tagging=0;
  relisting=1;
  for (i=0;i<tagptr;i++) {
    if (!okansi() || !(thisuser.filelist & filelist_filename)) {
      sprintf(s,"%d%2d ",
        check_batch_queue(filelist[i].u.filename) ? 6 : 0, i+1);
      outstr(s);
      checka(&abort,&next);
    }

    if (thisuser.filelist & filelist_filename) {
      filelist[i].linenum=lines_listed+1;
      strncpy(s,filelist[i].u.filename,8);
      s[8]=0;
      inbatch=0;
      if (check_batch_queue(filelist[i].u.filename)) {
        inbatch=1;
        ansic((thisuser.filelistcol[0]!=12)?6:2);
      } else
        ansic2(thisuser.filelistcol[0]);
      outstr(s);

      if (thisuser.filelist & filelist_extension) {
        strncpy(s,&((filelist[i].u.filename)[8]),4);
        s[4]=0;
        if (inbatch)
          ansic((thisuser.filelistcol[0]!=12)?6:2);
        else
          ansic2(thisuser.filelistcol[1]);
        outstr(s);
      }
      outchr(' ');
      checka(&abort,&next);
    }

    if (thisuser.filelist & filelist_filesize) {
      ltoa(bytes_to_k(filelist[i].u.numbytes),s1,10);
      strcat(s1,"k");

      if (!(sysinfo.flags & OP_FLAGS_FAST_TAG_RELIST)) {
        if (!(directories[tcd].mask & mask_cdrom)) {
          strcpy(s2,directories[udir[curdir].subnum].path);
          strcat(s2,filelist[i].u.filename);
          if (!exist(s2))
            strcpy(s1,get_string(741));
        }
      }

      sprintf(s,"%s%s ",charstr(5-strlen(s1),32),s1);
      ansic2(thisuser.filelistcol[2]);
      outstr(s);
      checka(&abort,&next);
    }

    if (thisuser.filelist & filelist_uldate) {
      ansic2(thisuser.filelistcol[3]);
      outstr(filelist[i].u.date);
      outchr(' ');
      checka(&abort,&next);
    }

    if (thisuser.filelist & filelist_numdloads) {
      itoa(filelist[i].u.numdloads,s,10);
      sprintf(s1,"%2s ",s);
      ansic2(thisuser.filelistcol[4]);
      outstr(s1);
      checka(&abort,&next);
    }

    if (thisuser.filelist & filelist_descript) {
      ansic2(thisuser.filelistcol[5]);
      plal(filelist[i].u.description,thisuser.screenchars-filelistlen-1,
           &abort);
      if ((!abort) && (thisuser.num_extended) &&
          (filelist[i].u.mask & mask_extended))
        print_extended(NULL,filelist[i].u.filename,&abort,
                       thisuser.num_extended,1);
    } else
      pla("",&abort);
  }
  tag_linenum=lines_listed+1;
  lines_listed=0;
  relisting=0;
  tagging=otag;
  lines_listed=0;
}

[ Step 26 ]

In XFEROVL.C, replace "void finddescription" with the following function:

void finddescription(void)
{
  uploadsrec u;
  int i,i1,i2,abort,ocd,pts,next=0,f,ac=0,flag=0;
  char s[81],s1[81];

  new_scan=1;
  if ((uconfdir[1].confnum!=-1) && (okconf(&thisuser))) {
    if (!x_only) {
      nl();
      prt(5,get_string(1379));
      ac=yn();
    } else
      ac=1;
    if (ac)
      tmp_disable_conf(1);
  }
  nl();
  ansic(1);
  pl(get_string(793));
  nl();
  ansic(5);
  pl(get_string(794));
  prt(2,":");
  mpl(58);
  input(s1,58);
  if (s1[0]==0) {
    tmp_disable_conf(0);
    return;
  }

  ocd=curdir;
  abort=0;
  num_listed=0;
  lines_listed=0;
  for (i=0; (i<num_dirs) && (!abort) && (!hangup) && (tagging!=0)
    && (udir[i].subnum!=-1); i++) {
    i1=udir[i].subnum;
    pts=0;
    titled=1;
    if (qsc_n[i1/32]&(1L<<(i1%32)))
      pts=1;
    pts=1;
    /* remove pts=1 to search only marked directories */
    if ((pts) && (!abort) && (tagging!=0)) {
      curdir=i;
      dliscan();
      f=sh_open1(dlfn,O_RDONLY | O_BINARY);
      for (i1=1; (i1<=numf) && (!abort) && (!hangup) && (tagging !=0); i1++) {
        SETREC(f,i1);
        sh_read(f,(void *)&u,sizeof(uploadsrec));
        strcpy(s,u.description);
        for (i2=0; i2<strlen(s); i2++)
          s[i2]=upcase(s[i2]);
        if (strstr(s,s1)!=NULL) {
          f=sh_close(f);
          if (!flag) {
            outchr(12);
            flag=1;
          }
          printinfo(&u, &abort);
          f=sh_open1(dlfn,O_RDONLY | O_BINARY);
        } else if (!empty())
          checka(&abort,&next);
      }
      f=sh_close(f);
    }
  }
  if (ac)
    tmp_disable_conf(0);
  curdir=ocd;
  nl();
  endlist(1);
  new_scan=0;
}

[ Step 27 ]

Still in XFEROVL.C, add the following function to the end of the file:

void config_file_listing(void)
{
  char ch,s[9];
  struct date d;
  int length;

  if (okansi()) {
    getdate(&d);
    sprintf(s,"%02d/%02d/%02d",d.da_mon,d.da_day,d.da_year-1900);
    printfile("FILELIST.ANS");
    outxy(53,8,(thisuser.filelist & filelist_filename)?"1On":"1Off");
    outxy(53,9,(thisuser.filelist & filelist_extension)?"1On":"1Off");
    outxy(53,10,(thisuser.filelist & filelist_filesize)?"1On":"1Off");
    outxy(53,11,(thisuser.filelist & filelist_uldate)?"1On":"1Off");
    outxy(53,12,(thisuser.filelist & filelist_numdloads)?"1On":"1Off");
    outxy(53,13,(thisuser.filelist & filelist_descript)?"1On":"1Off");
    outxy(53,14,(thisuser.num_extended>0)?"1On":"1Off");
    outxy(53,15,(thisuser.filelist & filelist_uploader)?"1On":"1Off");
    do {
      length=1;
      if (thisuser.filelist & filelist_filename) {
        length+=9;
        if (thisuser.filelist & filelist_extension)
          length+=4;
      }
      if (thisuser.filelist & filelist_filesize)
        length+=6;
      if (thisuser.filelist & filelist_uldate)
        length+=9;
      if (thisuser.filelist & filelist_numdloads)
        length+=3;
      goxy(1,20);
      if (thisuser.filelist & filelist_filename) {
        ansic2(thisuser.filelistcol[0]);
        outstr("FILENAME");
      }
      if ((thisuser.filelist & filelist_filename) &&
          (thisuser.filelist & filelist_extension)) {
        ansic2(thisuser.filelistcol[1]);
        outstr(".ZIP");
      }
      if (thisuser.filelist & filelist_filesize) {
        if (thisuser.filelist & filelist_filename)
          prt(8," ");
        ansic2(thisuser.filelistcol[2]);
        outstr("  27k");
      }
      if (thisuser.filelist & filelist_uldate) {
        if ((thisuser.filelist & filelist_filename) ||
            (thisuser.filelist & filelist_filesize))
          prt(8," ");
        ansic2(thisuser.filelistcol[3]);
        outstr(s);
      }
      if (thisuser.filelist & filelist_numdloads) {
        if ((thisuser.filelist & filelist_filename) ||
            (thisuser.filelist & filelist_filesize) ||
            (thisuser.filelist & filelist_uldate))
          prt(8," ");
        ansic2(thisuser.filelistcol[4]);
        outstr("18");
      }
      if (thisuser.filelist & filelist_descript) {
        if ((thisuser.filelist & filelist_filename) ||
            (thisuser.filelist & filelist_filesize) ||
            (thisuser.filelist & filelist_uldate) ||
            (thisuser.filelist & filelist_numdloads))
          prt(8," ");
        ansic2(thisuser.filelistcol[5]);
        outstr("File description");
      }
      kill_line();
      if (thisuser.num_extended>0) {
        goxy(1,21);
        kill_line();
        goxy(length,21);
        ansic2(thisuser.filelistcol[7]);
        outstr("Extended description");
      } else {
        goxy(length,21);
        kill_line();
        if (thisuser.filelist & filelist_uploader) {
          goxy(length,22);
          kill_line();
        }
      }
      if (thisuser.filelist & filelist_uploader) {
        if (thisuser.num_extended>0)
          goxy(1,22);
        else
          goxy(1,21);
        kill_line();
        if (thisuser.num_extended>0)
          goxy(length,22);
        else
          goxy(length,21);
        ansic2(thisuser.filelistcol[6]);
        npr("Uploaded by: %s",syscfg.sysopname);
      } else {
        if (thisuser.num_extended>0)
          goxy(length,22);
        else
          goxy(length,21);
        kill_line();
      }
      goxy(47,18);
      ch=onek("Q12345678!@#$%^&*");
      outxy(47,18," ");
      switch (ch) {
        case 'Q':
          break;
        case '1':
          if (thisuser.filelist & filelist_filename) {
            outxy(53,8,"1Off");
            outxy(53,9,"1Off");
            thisuser.filelist &= ~filelist_filename;
            thisuser.filelist &= ~filelist_extension;
          } else {
            outxy(53,8,"1On ");
            thisuser.filelist |= filelist_filename;
          }
          break;
        case '!':
          if (thisuser.filelist & filelist_filename) {
            if (thisuser.sysstatus & sysstatus_color) {
              thisuser.filelistcol[0]++;
              if (thisuser.filelistcol[0]>15)
                thisuser.filelistcol[0]=1;
            } else {
              if (thisuser.filelistcol[0]==7)
                thisuser.filelistcol[0]=15;
              else
                thisuser.filelistcol[0]=7;
            }
          }
          break;
        case '2':
          if (thisuser.filelist & filelist_extension) {
            outxy(53,9,"1Off");
            thisuser.filelist &= ~filelist_extension;
          } else if (thisuser.filelist & filelist_filename) {
            outxy(53,9,"1On ");
            thisuser.filelist |= filelist_extension;
          }
          break;
        case '@':
          if ((thisuser.filelist & filelist_filename) &&
              (thisuser.filelist & filelist_extension)) {
            if (thisuser.sysstatus & sysstatus_color) {
              thisuser.filelistcol[1]++;
              if (thisuser.filelistcol[1]>15)
                thisuser.filelistcol[1]=1;
            } else {
              if (thisuser.filelistcol[1]==7)
                thisuser.filelistcol[1]=15;
              else
                thisuser.filelistcol[1]=7;
            }
          }
          break;
        case '3':
          if (thisuser.filelist & filelist_filesize) {
            outxy(53,10,"1Off");
            thisuser.filelist &= ~filelist_filesize;
          } else {
            outxy(53,10,"1On ");
            thisuser.filelist |= filelist_filesize;
          }
          break;
        case '#':
          if (thisuser.filelist & filelist_filesize) {
            if (thisuser.sysstatus & sysstatus_color) {
              thisuser.filelistcol[2]++;
              if (thisuser.filelistcol[2]>15)
                thisuser.filelistcol[2]=1;
            } else {
              if (thisuser.filelistcol[2]==7)
                thisuser.filelistcol[2]=15;
              else
                thisuser.filelistcol[2]=7;
            }
          }
          break;
        case '4':
          if (thisuser.filelist & filelist_uldate) {
            outxy(53,11,"1Off");
            thisuser.filelist &= ~filelist_uldate;
          } else {
            outxy(53,11,"1On ");
            thisuser.filelist |= filelist_uldate;
          }
          break;
        case '$':
          if (thisuser.filelist & filelist_uldate) {
            if (thisuser.sysstatus & sysstatus_color) {
              thisuser.filelistcol[3]++;
              if (thisuser.filelistcol[3]>15)
                thisuser.filelistcol[3]=1;
            } else {
              if (thisuser.filelistcol[3]==7)
                thisuser.filelistcol[3]=15;
              else
                thisuser.filelistcol[3]=7;
            }
          }
          break;
        case '5':
          if (thisuser.filelist & filelist_numdloads) {
            outxy(53,12,"1Off");
            thisuser.filelist &= ~filelist_numdloads;
          } else {
            outxy(53,12,"1On ");
            thisuser.filelist |= filelist_numdloads;
          }
          break;
        case '%':
          if (thisuser.filelist & filelist_numdloads) {
            if (thisuser.sysstatus & sysstatus_color) {
              thisuser.filelistcol[4]++;
              if (thisuser.filelistcol[4]>15)
                thisuser.filelistcol[4]=1;
            } else {
              if (thisuser.filelistcol[4]==7)
                thisuser.filelistcol[4]=15;
              else
                thisuser.filelistcol[4]=7;
            }
          }
          break;
        case '6':
          if (thisuser.filelist & filelist_descript) {
            outxy(53,13,"1Off");
            thisuser.filelist &= ~filelist_descript;
          } else {
            outxy(53,13,"1On ");
            thisuser.filelist |= filelist_descript;
          }
          break;
        case '^':
          if (thisuser.filelist & filelist_descript) {
            if (thisuser.sysstatus & sysstatus_color) {
              thisuser.filelistcol[5]++;
              if (thisuser.filelistcol[5]>15)
                thisuser.filelistcol[5]=1;
            } else {
              if (thisuser.filelistcol[5]==7)
                thisuser.filelistcol[5]=15;
              else
                thisuser.filelistcol[5]=7;
            }
          }
          break;
        case '7':
          if (thisuser.num_extended>0) {
            outxy(53,14,"1Off");
            thisuser.num_extended=0;
          } else {
            outxy(53,14,"1On ");
            thisuser.num_extended=10;
          }
          break;
        case '&':
          if (thisuser.num_extended>0) {
            if (thisuser.sysstatus & sysstatus_color) {
              thisuser.filelistcol[7]++;
              if (thisuser.filelistcol[7]>15)
                thisuser.filelistcol[7]=1;
            } else {
              if (thisuser.filelistcol[7]==7)
                thisuser.filelistcol[7]=15;
              else
                thisuser.filelistcol[7]=7;
            }
          }
          break;
        case '8':
          if (thisuser.filelist & filelist_uploader) {
            outxy(53,15,"1Off");
            thisuser.filelist &= ~filelist_uploader;
          } else {
            outxy(53,15,"1On ");
            thisuser.filelist |= filelist_uploader;
          }
          break;
        case '*':
          if (thisuser.filelist & filelist_uploader) {
            if (thisuser.sysstatus & sysstatus_color) {
              thisuser.filelistcol[6]++;
              if (thisuser.filelistcol[6]>15)
                thisuser.filelistcol[6]=1;
            } else {
              if (thisuser.filelistcol[6]==7)
                thisuser.filelistcol[6]=15;
              else
                thisuser.filelistcol[6]=7;
            }
          }
          break;
      }
    } while ((ch!='Q') && (!hangup));
    if ((thisuser.num_extended>0) && (thisuser.filelist & filelist_uploader))
      goxy(1,23);
    else
      if ((thisuser.num_extended>0) ||
          (thisuser.filelist & filelist_uploader))
        goxy(1,22);
      else
        goxy(1,21);
    filelistlen=length-1;
  } else {
    nl();
    pl("Option only available to ANSI users.");
  }
}

[ Step 28 ]

In XFEROVL2.C, make the following changes near the top of the file:

= /* the archive type to use */
= #define ARC_NUMBER 0
=
- extern int foundany;
+ extern int foundany,cls;

[ Step 29 ]

Still in XFEROVL2.C, add the following function before "void tag_it":

int scroll_tag(int mode)
{
  int i,tagged,bad,fp;
  char s[81],s1[81];
  unsigned char ch=0,endkey;
  double t;
  long fs;

  outstr("2Use 1Arrows2/1SPACE 2to move, 1ENTER2 to select, 1Q2 to stop");
  i=0;
  tagged=0;
  goxy(1,filelist[i].linenum);
  if (check_batch_queue(filelist[i].u.filename))
    ansic2(28);
  else
    ansic(4);
  if (thisuser.filelist & filelist_extension)
    outstr(filelist[i].u.filename);
  else {
    strncpy(s,filelist[i].u.filename,8);
    s[8]=0;
    outstr(s);
  }
  outchr('\r');
  ansic(0);
  endkey=(!mode)?'Q':13;
  while ((ch!=endkey) && (!hangup)) {
    ch=upcase(getkey());
    if ((!incom) && (ch==255))
      ch=getkey();
    if ((incom) && (ch=='\x1b')) {
      ch=getkey();
      if (ch=='[') {
        ch=getkey();
        if (ch=='A')
          ch=72;
        else if (ch=='B')
          ch=80;
        else if (ch=='H')
          ch=71;
        else if (ch=='K')
          ch=79;
      }
    }
    switch (ch) {
      case 'Q':
        if (mode>0)
          endkey='Q';
        break;
      case 13:
        if (mode==0) {
          goxy(1,tag_linenum);
          kill_line();
          bad=0;
          if (check_batch_queue(filelist[i].u.filename)) {
            remove_batch(filelist[i].u.filename);
            ansic(1);
            outstr(filelist[i].u.filename);
            outstr(" has been removed from the batch queue.");
            bad=1;
          }
          if ((numbatch>=sysinfo.max_batch) && (bad==0)) {
            ansic(6);
            outstr(get_string(1330));
            npr("%d",sysinfo.max_batch);
            outstr(get_string(1331));
            bad=1;
          }
          if ((syscfg.req_ratio>0.0001)
            && (ratio()<syscfg.req_ratio)
            && (!thisuser.exempt & exempt_ratio)
            && (bad==0)) {
            ansic(2);
            outstr(get_string(730));
            sprintf(s," %-5.3f.  ",ratio());
            outstr(s);
            outstr(get_string(731));
            sprintf(s," %-5.3f ",syscfg.req_ratio);
            outstr(s);
            outstr(get_string(732));
            bad=1;
          }
          if (bad==0) {
            sprintf(s,"%s%s",directories[filelist[i].directory].path,
              stripfn(filelist[i].u.filename));
            if (filelist[i].dir_mask & mask_cdrom) {
              prt(2,"Copying file...");
              sprintf(s1,"%s%s",
                directories[filelist[i].directory].path,
              stripfn(filelist[i].u.filename));
              sprintf(s,"%s%s",
                syscfgovr.tempdir,stripfn(filelist[i].u.filename));
              if (!exist(s))
                copy_file(s1,s);
              outchr('\r');
              kill_line();
            }
            fp=sh_open1(s,O_RDONLY | O_BINARY);
            if (fp<0) {
              ansic(6);
              outstr(get_string(1332));
              outstr(stripfn(filelist[i].u.filename));
              outstr(get_string(1333));
              bad=1;
            } else {
              fs=filelength(fp);
              fp=sh_close(fp);
            }
          }
          if (bad==0) {
            t=(12.656) / ((double) (modem_speed)) * ((double)(fs));
            if (nsl()<=(batchtime + t)) {
              ansic(6);
              outstr(get_string(1334));
              outstr(filelist[i].u.filename);
              outstr(".");
              bad=1;
            }
          }
          if (bad==0) {
            batchtime += t;
            strcpy(batch[numbatch].filename,filelist[i].u.filename);
            batch[numbatch].dir=filelist[i].directory;
            batch[numbatch].time=t;
            batch[numbatch].sending=1;
            batch[numbatch].len=fs;
            numbatch++;
            ++numbatchdl;
            ansic(1);
            outstr(filelist[i].u.filename);
            outstr(get_string(1335));
          }
          goxy(1,tag_linenum+1);
          pausescr();
          goxy(1,tag_linenum);
          kill_line();
          outstr("2Use 1Arrows2/1SPACE 2to move, 1ENTER2 to select, 1Q2 to stop");
          goxy(1,filelist[i].linenum);
          if (bad==0)
            ansic2(28);
          else
            ansic(4);
          strncpy(s,filelist[i].u.filename,8);
          s[8]=0;
          outstr(s);
          if (thisuser.filelist & filelist_extension) {
            strncpy(s,&((filelist[i].u.filename)[8]),4);
            s[4]=0;
            outstr(s);
          }
          ansic(0);
          goxy(1,filelist[i].linenum);
        }
        break;
      case 32: /* Space */
      case 71: /* Home  */
      case 72: /* Up    */
      case 79: /* End   */
      case 80: /* Down  */
        if (((ch==71) && (i==0)) || ((ch==79) && (i==tagptr-1)))
          break;
        tagged=0;
        if (check_batch_queue(filelist[i].u.filename))
          tagged=1;
        goxy(1,filelist[i].linenum);
        if (tagged)
          ansic((thisuser.filelistcol[0]!=12)?6:2);
        else
          ansic2(thisuser.filelistcol[0]);
        strncpy(s,filelist[i].u.filename,8);
        s[8]=0;
        outstr(s);
        if (thisuser.filelist & filelist_extension) {
          if (tagged)
            ansic((thisuser.filelistcol[0]!=12)?6:2);
          else
            ansic2(thisuser.filelistcol[1]);
          strncpy(s,&((filelist[i].u.filename)[8]),4);
          s[4]=0;
          outstr(s);
        }
        switch (ch) {
          case 71: /* Home */
            i=0;
            break;
          case 72: /* Up */
            if (i-1>=0)
              i--;
            else
              i=tagptr-1;
            break;
          case 79: /* End */
            i=tagptr-1;
            break;
          case 32: /* Space */
          case 80: /* Down */
            if (i+1<tagptr)
              i++;
            else
              i=0;
            break;
        }
        goxy(1,filelist[i].linenum);
        if (check_batch_queue(filelist[i].u.filename))
          ansic2(28);
        else
          ansic(4);
        if (thisuser.filelist & filelist_extension)
          outstr(filelist[i].u.filename);
        else {
          strncpy(s,filelist[i].u.filename,8);
          s[8]=0;
          outstr(s);
        }
        outchr('\r');
        ansic(0);
        break;
    }
  }
  goxy(1,filelist[i].linenum);
  tagged=0;
  if (check_batch_queue(filelist[i].u.filename)) {
    tagged=1;
    ansic((thisuser.filelistcol[0]!=12)?6:2);
  } else
    ansic2(thisuser.filelistcol[0]);
  strncpy(s,filelist[i].u.filename,8);
  s[8]=0;
  outstr(s);
  if (thisuser.filelist & filelist_extension) {
    strncpy(s,&((filelist[i].u.filename)[8]),4);
    s[4]=0;
    if (tagged)
      ansic((thisuser.filelistcol[0]!=12)?6:2);
    else
      ansic2(thisuser.filelistcol[1]);
    outstr(s);
  }
  ansic(0);
  goxy(1,tag_linenum);
  kill_line();
  if ((mode>0) && (ch!='Q'))
    return(i);
  else
    return(-1);
}

[ Step 30 ]

Still in XFEROVL2.C, replace "void tag_it" and "void tagfiles" with the
following functions:

void tag_it(void)
{
  int i,i1,i2,i3,i4,bad,fp,tagged;
  char s[161],s1[161],s2[81],s3[400];
  unsigned char ch;
  double t;
  long fs;

  if (!filelist)
    return;
  if (numbatch>=sysinfo.max_batch) {
    prt(6,get_string(1325));
    getkey();
    return;
  }
  if ((okansi()) && (thisuser.filelist & filelist_filename)) {
    scroll_tag(0);
    lines_listed=0;
  } else {
    outstr(get_string(1326));
    npr("%d",tagptr);
    outstr(get_string(1327));
    mpl(30);
    input(s3,30);
    if (s3[0]=='*') {
      s3[0]=0;
      for(i2=0;i2<tagptr && i2<78;i2++) {
        sprintf(s2,"%d ",i2+1);
        strcat(s3,s2);
        if (strlen(s3)>sizeof(s3)-10)
          break;
      }
      nl();
      outstr(get_string(1328));
      pl(s3);
    }
    for(i2=0;i2<strlen(s3);i2++) {
      sprintf(s1,"%s",s3+i2);
      i4=0;
      bad=0;
      for(i3=0;i3<strlen(s1);i3++) {
        if ((s1[i3]==' ') || (s1[i3]==',') || (s1[i3]==';')) {
          s1[i3]=0;
          i4=1;
        } else {
          if (i4==0)
            i2++;
        }
      }
      i=atoi(s1);
      if (i==0)
        break;
      i--;
      if ((s1[0]) && (i>=0) && (i<tagptr)) {
        if (check_batch_queue(filelist[i].u.filename)) {
          ansic(6);
          outstr(filelist[i].u.filename);
          pl(get_string(1329));
          bad=1;
        }
        if (numbatch>=sysinfo.max_batch) {
          ansic(6);
          outstr(get_string(1330));
          npr("%d",sysinfo.max_batch);
          pl(get_string(1331));
          bad=1;
        }
        if ((syscfg.req_ratio>0.0001)
          && (ratio()<syscfg.req_ratio)
          && (!thisuser.exempt & exempt_ratio)
          && (bad==0)) {
          ansic(2);
          outstr(get_string(730));
          sprintf(s," %-5.3f.  ",ratio());
          outstr(s);
          outstr(get_string(731));
          sprintf(s," %-5.3f ",syscfg.req_ratio);
          outstr(s);
          outstr(get_string(732));
          nl();
          bad=1;
        }
        if (bad==0) {
          sprintf(s,"%s%s",directories[filelist[i].directory].path,
            stripfn(filelist[i].u.filename));
          if (filelist[i].dir_mask & mask_cdrom) {
            sprintf(s2,"%s%s",
              directories[filelist[i].directory].path,
              stripfn(filelist[i].u.filename));
            sprintf(s,"%s%s",
              syscfgovr.tempdir,stripfn(filelist[i].u.filename));
           if (!exist(s))
             copy_file(s2,s);
          }
          fp=sh_open1(s,O_RDONLY | O_BINARY);
          if (fp<0) {
            ansic(6);
            outstr(get_string(1332));
            outstr(stripfn(filelist[i].u.filename));
            pl(get_string(1333));
            bad=1;
          } else {
            fs=filelength(fp);
            fp=sh_close(fp);
          }
        }
        if (bad==0) {
          t=(12.656) / ((double) (modem_speed)) * ((double)(fs));
          if (nsl()<=(batchtime + t)) {
            ansic(6);
            outstr(get_string(1334));
            outstr(filelist[i].u.filename);
            pl(".");
            bad=1;
          }
        }
        if (bad==0) {
          batchtime += t;
          strcpy(batch[numbatch].filename,filelist[i].u.filename);
          batch[numbatch].dir=filelist[i].directory;
          batch[numbatch].time=t;
          batch[numbatch].sending=1;
          batch[numbatch].len=fs;
          numbatch++;
          ++numbatchdl;
          ansic(1);
          outstr(filelist[i].u.filename);
          pl(get_string(1335));
        }
      } else {
        ansic(6);
        outstr(get_string(1336));
        npr("%d.",i+1);
        nl();
      }
      lines_listed=0;
    }
  }
}

void tag_files(void)
{
  int i, i1, done=0, abort, had, bad, oh, next, ohl, tagged;
  char s[161],s1[161],s2[81],s3[81];
  unsigned char ch;
  double d;

  if ((lines_listed==0) || (tagging==0) || (num_listed==0))
    return;
  abort=0;
  if ((x_only) || (tagging==2)) {
    tagptr=0;
    return;
  }
  tleft(1);
  if (hangup)
    return;
  if (thisuser.sysstatus & sysstatus_no_tag) {
    if (thisuser.sysstatus & sysstatus_pause_on_page)
      pausescr();
    tagptr=0;
    return;
  }
  if (menu_on())
    printmenu(17);

  tag_linenum=lines_listed+1;
  lines_listed=0;

  oh=helpl;
  helpl=43;
  done=0;
  while ((!done) && (!hangup)) {
    ohl=helpl;
    helpl=43;
    lines_listed=0;
    ch=fancy_prompt(get_string(1341),"CDEMNQRTV?");
    lines_listed=0;
    helpl=ohl;
    switch (ch) {
      case '?':
        i=tagging;
        tagging=0;
        printmenu(17);
        pausescr();
        tagging=i;
        relist();
        break;
      case 'C':
      case ' ':
      case '\r':
        if (cls)
          outchr(12);
        lines_listed=0;
        tagptr=0;
        done=1;
        break;
      case 'D':
        batchdl(1);
        tagging=0;
        if (!had) {
          nl();
          pausescr();
          outchr(12);
        }
        done=1;
        break;
      case 'E':
        lines_listed=0;
        i1=tagging;
        if ((okansi()) && (thisuser.filelist & filelist_filename)) {
          i=scroll_tag(1);
          s[0]=1;
        } else {
          tagging=0;
          prt(2,get_string(1342));
          npr("2%d)? ",tagptr);
          mpl(2);
          input(s,2);
          i=atoi(s)-1;
        }
        if ((s[0]) && (i>=0) && (i<tagptr)) {
          d=XFER_TIME(filelist[i].u.numbytes);
          nl();
          if (menu_on()) {
            i1 = rip_printfileinfo(&filelist[i].u,filelist[i].directory);
            getkey();
            rip_restoreall();
          } else {
            npr("%s%s, %s\r\n",
              get_string(1343),
              udir[filelist[i].directory].keys,
              directories[filelist[i].directory].name);
            ansic(1);
            outstr(get_string(746));
            ansic(2);
            pl(filelist[i].u.filename);
            ansic(1);
            outstr(get_string(747));
            ansic(2);
            pl(filelist[i].u.description);
            if (filelist[i].u.mask & mask_extended) {
              strcpy(s1,edlfn);
              sprintf(edlfn,"%s%s.EXT",syscfg.datadir,
                directories[filelist[i].directory].filename);
              zap_ed_info();
              npr(get_string(1344));
              print_extended(NULL,filelist[i].u.filename,&abort,
                             sysinfo.max_extend_lines,2);
              zap_ed_info();
              strcpy(edlfn, s1);
            }
            ansic(1);
            outstr(get_string(748));
            ansic(2);
            npr("%dk\r\n", bytes_to_k(filelist[i].u.numbytes));
            ansic(1);
            outstr(get_string(749));
            ansic(2);
            pl(ctim(d));
            ansic(1);
            outstr(get_string(750));
            ansic(2);
            pl(filelist[i].u.date);
            ansic(1);
            outstr(get_string(751));
            ansic(2);
            pl(filelist[i].u.upby);
            ansic(1);
            outstr(get_string(752));
            ansic(2);
            pln(filelist[i].u.numdloads);
            if (directories[filelist[i].directory].mask & mask_cdrom) {
              nl();
              pl(get_string(1345));
            } else {
              sprintf(s,"%s%s",directories[filelist[i].directory].path,
                filelist[i].u.filename);
              if (!exist(s)) {
                nl();
                pl(get_string(754));
              }
            }
            nl();
            pausescr();
            tagging=i1;
            relist();
          }
        }
        break;
      case 'N':
        tagging=2;
        done=1;
        break;
      case 'M':
        if (dcs()) {
          i=tagging;
          tagging=0;
          move_file_t();
          tagging=i;
          if (num_listed==0) {
            done=1;
            return;
          }
          relist();
        }
        break;
      case 'Q':
        tagging=0;
        titled=0;
        tagptr=0;
        lines_listed=0;
        done=1;
        return;
      case 'R':
        relist();
        break;
      case 'T':
        tag_it();
        break;
      case 'V':
        if ((okansi()) && (thisuser.filelist & filelist_filename)) {
          i=scroll_tag(2);
          s[0]=1;
        } else {
          prt(2,get_string(1342));
          npr("2%d)? ",tagptr);
          mpl(2);
          input(s,2);
          i=atoi(s)-1;
        }
        if ((s[0]) && (i>=0) && (i<tagptr)) {
          sprintf(s1,"%s%s",directories[filelist[i].directory].path,
            stripfn(filelist[i].u.filename));
          if (directories[filelist[i].directory].mask & mask_cdrom) {
            sprintf(s2,"%s%s",directories[filelist[i].directory].path,
              stripfn(filelist[i].u.filename));
            sprintf(s1,"%s%s",syscfgovr.tempdir,
               stripfn(filelist[i].u.filename));
            if (!exist(s1))
              copy_file(s2,s1);
          }
          if (!exist(s1)) {
            prt(6,get_string(1346));
            nl();
            pausescr();
            break;
          }
          get_arc_cmd(s,s1,0,"");
          if (!okfn(stripfn(filelist[i].u.filename)))
            s[0]=0;
          if (s[0]!=0) {
            nl();
            tagging=0;
            extern_prog(s, sysinfo.spawn_opts[10]);
            nl();
            pausescr();
            tagging=1;
            topscreen();
            outchr(12);
            relist();
          } else {
            prt(6,get_string(1347));
            nl();
            pausescr();
            break;
          }
        }
        break;
      default:
        outchr(12);
        done=1;
        break;
    }
  }
  helpl=oh;
  tagptr=0;
  lines_listed=0;
}

[ Step 31 ]

Still in XFEROVL2.C, replace "void endlist" with the following function:

void endlist(int mode)
{
  char s[81];

  if (tagging!=0) {
    if (num_listed)  {
      if ((tagging==1) && (!(thisuser.sysstatus&sysstatus_no_tag)) &&
          (filelist)) {
        cls=0;
        tag_files();
        cls=1;
        return;
      }
      switch(mode) {
        case 1:
          sprintf(s,"\r%s %ld",get_string(744), num_listed);
        break;
        case 2:
          sprintf(s,"\r%s %ld",get_string(744), num_listed);
        break;
      }
      pl(s);
    } else {
      switch(mode) {
        case 1:
          outstr("\r");
          pl(get_string(1352));
          break;
        case 2:
          outstr("\r");
          pl(get_string(1353));
          break;
      }
    }
  }
}

[ Step 32 ]

In VARDEC.H, make the following changes:

=       language,       /* language to use */
-       cbv;            /* called back */
+       cbv,            /* called back */
+       filelist,       /* user's file listing configuration */
+       filelistcol[8]; /* user's file listing configuration colors */
=
=     char
-       res_byte[49];   /* reserved for byte values */
+       res_byte[40];   /* reserved for byte values */
=
=     unsigned short

[ Step 33 ]

Still in VARDEC.H, make the following changes in the "tagrec" structure:

= typedef struct {
=         uploadsrec      u;                      /* file information */
=         short           directory;              /* directory number */
=         unsigned short  dir_mask;               /* directory mask */
+         char            linenum;                /* line position */
= } tagrec;

[ Step 34 ]

Still in VARDEC.H, add the following lines:

= /* userrec.exempt */
= #define exempt_ratio 0x01
= #define exempt_time  0x02
= #define exempt_all   0x04
= #define exempt_post  0x08
=
+ /* userrec.filelist */
+ #define filelist_filename  0x01
+ #define filelist_extension 0x02
+ #define filelist_filesize  0x04
+ #define filelist_uldate    0x08
+ #define filelist_numdloads 0x10
+ #define filelist_descript  0x20
+ #define filelist_uploader  0x40
+ #define filelist_notset    0x80
+
= /* userrec.restrict */

[ Step 35 ]

In VARS.H, make the following changes:

=               instance,debuglevel,multitasker,tagging,tagptr,cursormove,
-               titled, abortext;
+               titled, abortext, tag_linenum, new_scan_flag, filelistlen,
+               relisting;
=
= __EXTRN__ unsigned short com_speed, *csn_index, crc, *gat, modem_flag,

[ Step 36 ]

Type MAKE FCNS to add the new functions to FCNS.H.  Now compile your source.
We have changed VARDEC.H and VARS.H so this means the source will need a full
re-compile.

[ Step 37 ]

Now you must enable the file listings.  Do this by loading the BBS and typing
//RESETFILELIST from the transfer menu.  This will go through your entire
USER.LST and set each user's file listings to the default configuration.

You should also copy FILELIST.ANS to your GFILES directory, and add 'K' to
your transfer menu so that users know about the new command.

[ Disclaimer ]

Don't complain to me if your board gets fried, your hard disk goes nuts, or
something terrible happens.  The code in this mod should be harmless, but I
can't guarantee it will work for you.  It works on my board.

JAFO 1@1     TerraNET
     1@3809  WWIVnet
     1@8857  IceNET
     1@8857  SOLARnet
     1@18857 WWIVLink
