Ŀ
 Mod Name      : JAFO14E.MOD              Mod Author: JAFO 1@1     TerraNET 
 Difficulty    : ۱                                1@3809  WWIVnet  
 WWIV Version  : 4.24                                      1@8857  IceNET   
 Mod Date      : 06/10/95                                  1@8857  SOLARnet 
 Files Affected: BATCH.C, CONIO.C, DIREDIT.C, EXTRN1.C,    1@18857 WWIVLink 
                 MMENU.C, RETURN.C, RIPOVL.C, SR.C,                         
                 UEDIT.C, XFER.C, XFEROVL2.C, XFERTMP.C,                    
                 XINIT.C, FCNS.H, VARDEC.H, VARS.H                          
 Description   : The Multiple UL/DL Ratios Mod                              

ͻ
   This mod is Copyright 1995, by Cris McRae, aka JAFO, and is distributed  
   as freeware.  Permission is granted to distribute and post this mod on   
   systems and online services, provided no alternations are made (removal  
   of message headers/taglines are allowed).  This mod may contain some     
   parts of WWIV source code, which is Copyright 1988-1995 by Wayne Bell    
   and licensed only to registered users of WWIV.  Use of WWIV source       
   without registration constitutes a license violation and could lead to   
   legal prosecution and certain doom.                                      
                                                                            
   Shareware distributors and CD-ROM publishers may not distribute this mod 
   without express written permission of the Author or WWIV Software        
   Services.                                                                
ͼ

[ Description ]

This modification will enable you to set up different upload/download ratios
for each directory on your system.  You can even give directories a ratio of
0.000, which would mean they are free.  So if you are using JAFO10, my Free
Download Directories mod, then you should remove it.

Revision A Note:  Fixed a MAJOR bug!  The original mod effectively made all
                  non-free dirs free and made free dirs non-free!  This was
                  all because a simple '!' was misplaced.  SORRY.

                  The other major change is that batch downloads will now
                  work fine in ratio free directories.

Revision B Note:  Updated for WWIV v4.23.

Revision C Note:  Added ratio check during file tagging.  Revision B checked
                  against the INIT defined ratio instead of the one defined
                  for the particular directory where the file being tagged
                  was located.

                  If you are upgrading from Revision B, you only need to do
                  Step 16.

Revision D Note:  Forgot about the fact that WWIV v4.23 added the ability to
                  swap directories.  This version adds that code.  Thanks to
                  The Bishop for the code, since his TB15 mod (included in
                  v4.23) provided provisions for use with my mod.

                  Another problem occured in batch downloading.  Users could
                  not batch download files from free directories.  This
                  version fixes that problem.

                  If you are upgrading from Revision C, you only need to do
                  Step 5 and 11.

Revision E Note:  Upgraded for WWIV v4.24.

                  Added exempted download credits so that when downloading
                  files when exempted, it does not affect a users ratio when
                  the exemption is removed.

[ Legend ]

  =  Existing line - Do not change
  +  Add this line
  -  Remove this line

[ Step 1 ]

Please back up your source code.  Even the best programmers make mistakes.

[ Step 2 ]

In BATCH.C, make the following changes in "void downloaded":

= void downloaded(char *fn, long cps)
= {
=   int i,i1,f;
=   uploadsrec u;
=   char s[161];
=   userrec ur;
=
=   for (i1=0; i1<numbatch; i1++) {
=     if ((strcmp(fn,batch[i1].filename)==0) && (batch[i1].sending)) {
=       dliscan1(batch[i1].dir);
=       i=recno((batch[i1].filename));
=       if (i>0) {
=         f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
=         SETREC(i);
=         sh_read(dlf,(void *)&u,sizeof(uploadsrec));
-         ++thisuser.downloaded;
-         thisuser.dk += (int) (bytes_to_k(u.numbytes));
+         if (dir_ratios[batch[i1].dir]) {
+           if (thisuser.exempt & exempt_ratio) {
+             ++thisuser.edownloaded;
+             thisuser.edk += (int) (bytes_to_k(u.numbytes));
+           } else {
+             ++thisuser.downloaded;
+             thisuser.dk += (int) (bytes_to_k(u.numbytes));
+           }
+         } else {
+           ++thisuser.edownloaded;
+           thisuser.edk += (int) (bytes_to_k(u.numbytes));
+         }
=         ++u.numdloads;
=         SETREC(i);

[ Step 3 ]

In "void ymbatchdl", make the following changes:

=   rr=0;
=   do {
=     tleft(1);
-     if ((syscfg.req_ratio>0.0001) && (ratio()<syscfg.req_ratio))
+     if ((dir_ratios[batch[cur].dir]>0.0001) &&
+         (ratio()<dir_ratios[batch[cur].dir]))
=       rr=1;
=     if (thisuser.exempt & exempt_ratio)
=       rr=0;

[ Step 4 ]

In "void make_dl_batch_list", make the following changes:

=       if (nsl() < (batch[i].time + at)) {
=         ok=0;
=         npr("%s%s%s\r\n",
=             get_string(1478),
=             batch[i].filename,
=             get_string(1479));
=       }
=       thisk=bytes_to_k(batch[i].len);
-       if ((syscfg.req_ratio>0.0001) && (ratio1(addk+thisk)<syscfg.req_ratio)
-           && (!(thisuser.exempt & exempt_ratio))) {
+       if ((dir_ratios[batch[i].dir]>0.0001) &&
+           (ratio1(addk+thisk)<dir_ratios[batch[i].dir]) &&
+           (!(thisuser.exempt & exempt_ratio))) {
=         ok=0;
=         npr("%s%s%s\r\n",
=             get_string(1478),
=             batch[i].filename,
=             get_string(1480));
=       }
=       if (ok) {

[ Step 5 ]

In "void batchdl", make the following changes:

=       case 'D':
=         if (numbatchdl==0) {
=           nl();
=           pl(get_string(882));
=           nl();
=           done=1;
=           break;
=         }
=
=         nl();
+         for (i=0; i<numbatch; i++)
+           if (!ratio_ok(batch[i].dir))
+             break;
+
-         if (!ratio_ok()) {
+         if (i<numbatch) {
=           nl();
=           pl(get_string(883));
=           nl();
=           done=1;
=           break;
=         }

[ Step 6 ]

In CONIO.C, make the following changes in "void topscreen":

=       movecsr(0,1);
=       if (thisuser.wwiv_regnum)
=         sprintf(calls,"%lu",thisuser.wwiv_regnum);
=       else
=         strcpy(calls,thisuser.callsign);
=       sprintf(ol,"%-20s %12s  %-6s DL=%4u/%6lu DL=%3u TO=%5.0lu ES=%4u",
=           thisuser.realname,thisuser.phone,calls,
-           thisuser.downloaded,thisuser.dk,thisuser.dsl,
+           thisuser.downloaded+thisuser.edownloaded,
+           thisuser.dk+thisuser.edk,thisuser.dsl,
=           ((long) ((thisuser.timeon+timer()-timeon)/60.0)),
=           thisuser.emailsent+thisuser.emailnet);
=       outs(ol);

[ Step 7 ]

In DIREDIT.C, add the following function before "void dirdata":

void save_dir_ratios(void)
{
  int f,i;
  char s[81];

  sprintf(s,"%sRATIOS.DAT",syscfg.datadir);
  f=sh_open(s,O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
  if (f>0) {
    for (i=0; i<num_dirs; i++)
      sh_write(f,&dir_ratios[i],sizeof(float));
    sh_close(f);
  }
}

[ Step 8 ]

In "void modify_dir", make the following changes:

=     if (r.mask & mask_cdrom) {
=       outstr(get_string(1497));
=       if (r.mask & mask_offline)
=         pl(str_no);
=       else
=         pl(str_yes);
=     }
+     npr("N. Dir Ratio  : %-5.3f\r\n",dir_ratios[n]);
=     nl();
-     prt(2,get_string(1498));
-     ch=onek("QABCDEFGHIJKLM[]");
+     prt(2,"Which (A-N,Q) ? ");
+     ch=onek("QABCDEFGHIJKLMN[]");
=     switch(ch) {

[ Step 9 ]

Farther down in "void modify_dir", add the following lines:

=       case 'M':
=         if (r.mask & mask_cdrom) {
=           r.mask ^= mask_offline;
=         }
=       break;
+       case 'N':
+         nl();
+         prt(5,"New ratio? ");
+         input(s,5);
+         if (s[0]) {
+           dir_ratios[n]=atof(s);
+           save_dir_ratios();
+         }
+         break;
=     }
=   } while ((!done) && (!hangup));
=   directories[n]=r;
= }

[ Step 10 ]

Replace "void swap_dirs" with the following function:

void swap_dirs(int dir1, int dir2)
{
  int i,i1,i2,nu;
  unsigned long *qsc, *qsc_n, tl;
  directoryrec drt;
  float tf;
  SUBCONF_TYPE dir1conv, dir2conv;

  dir1conv=(SUBCONF_TYPE) dir1;
  dir2conv=(SUBCONF_TYPE) dir2;

  if ((dir1<0) || (dir1>=num_dirs) || (dir2<0) || (dir2>=num_dirs))
    return;

  update_conf(CONF_DIRS, &dir1conv, &dir2conv, CONF_UPDATE_SWAP);

  dir1=(int) dir1conv;
  dir2=(int) dir2conv;

  nu=number_userrecs();

  qsc=(unsigned long *)malloca(syscfg.qscn_len);
  if (qsc) {
    for (i=1; i<=nu; i++) {
      read_qscn(i,qsc,1);
      qsc_n=qsc+1;

      if (qsc_n[dir1/32] & (1L<<(dir1%32)))
        i1=1;
      else
        i1=0;
      if (qsc_n[dir2/32] & (1L<<(dir2%32)))
        i2=1;
      else
        i2=0;
      if (i1+i2==1) {
        qsc_n[dir1/32] ^= (1L<<(dir1%32));
        qsc_n[dir2/32] ^= (1L<<(dir2%32));
      }

      write_qscn(i,qsc,1);
    }
    close_qscn();
    bbsfree(qsc);
  } 

  drt=directories[dir1];
  directories[dir1]=directories[dir2];
  directories[dir2]=drt;

  tl=dir_dates[dir1];
  dir_dates[dir1]=dir_dates[dir2];
  dir_dates[dir2]=tl;

  tf=dir_ratios[dir1];
  dir_ratios[dir1]=dir_ratios[dir2];
  dir_ratios[dir2]=tf;
  save_dir_ratios();
}

[ Step 11 ]

In "void insert_dir", add the following lines:

= void insert_dir(int n)
= {
=   directoryrec r;
=   int i,i1,nu;
=   unsigned long *qsc, *qsc_n, m1, m2, m3;
=   SUBCONF_TYPE nconv;
=
=   nconv=(SUBCONF_TYPE) n;
=
=   if ((n<0) || (n>num_dirs))
=     return;
=
=   update_conf(CONF_DIRS, &nconv, NULL, CONF_UPDATE_INSERT);
=
=   n=(int) nconv;
=
=   for (i=num_dirs-1; i>=n; i--) {
=     directories[i+1]=directories[i];
=     dir_dates[i+1]=dir_dates[i];
+     dir_ratios[i+1]=dir_ratios[i];
=   }
=   strcpy(r.name,get_string(159));
=   strcpy(r.filename,get_string(82));
=   strcpy(r.path,syscfg.dloadsdir);
=   r.dsl=10;
=   r.age=0;
=   r.maxfiles=50;
=   r.dar=0;
=   r.type=0;
=   r.mask=0;
=   directories[n]=r;
=   ++num_dirs;
=
+   dir_ratios[n]=syscfg.req_ratio;
+   save_dir_ratios();
+
=   nu=number_userrecs();

[ Step 12 ]

In "void delete_dir", add the following lines:

= void delete_dir(int n)
= {
=   int i,i1,nu;
=   unsigned long *qsc, *qsc_n, m2, m3;
=   SUBCONF_TYPE nconv;
=
=   nconv=(SUBCONF_TYPE) n;
=
=   if ((n<0) || (n>=num_dirs))
=     return;
=
=   update_conf(CONF_DIRS, &nconv, NULL, CONF_UPDATE_DELETE);
=
=   n=(int)nconv;
=
=   for (i=n; i<num_dirs; i++) {
=     directories[i]=directories[i+1];
=     dir_dates[i]=dir_dates[i+1];
+     dir_ratios[i]=dir_ratios[i+1];
=   }
=   --num_dirs;
=
+   save_dir_ratios();
+
=   nu=number_userrecs();

[ Step 13 ]

In EXTRN1.C, make the following changes "static void create_drop_files":

=     fprintf(f," \n%d\n%ld\n%s\n%s\n%d\n%ld\n%.5s\n0\nABCD\n0\n0\n0\n0\n",
=       thisuser.sl, l,
=       (thisuser.sysstatus & sysstatus_ansi)?"COLOR":"MONO",
=       "X" /* thisuser.pw */, usernum, ((long)(timeon/60)), times());
=     fprintf(f,"%s\n%s 00:01\nEXPERT\nN\n%s\n%d\n%d\n1\n%d\n%d\n%s\n%s\n%d\n",
=       thisuser.phone, thisuser.laston, thisuser.laston, thisuser.logons,
-       thisuser.screenlines, thisuser.uploaded, thisuser.downloaded,
+       thisuser.screenlines, thisuser.uploaded,
+       thisuser.downloaded+thisuser.edownloaded,
=       (andwith==0x7f)?"7E1":"8N1",
=       (incom)?"REMOTE":"LOCAL",
=       (incom)?0:syscfgovr.primaryport);
=     strcpy(s1,"00/00/00");
=     sprintf(s2,"%d",thisuser.month);
=     memmove(&(s1[2-strlen(s2)]),&(s2[0]),strlen(s2));
=     sprintf(s2,"%d",thisuser.day);
=     memmove(&(s1[5-strlen(s2)]),&(s2[0]),strlen(s2));
=     sprintf(s2,"%d",thisuser.year);
=     memmove(&(s1[8-strlen(s2)]),&(s2[0]),strlen(s2));
=     fprintf(f,"%s\n",s1);
=     fprintf(f,"%s\n",(incom)?cspeed:"14400");
=     fsh_close(f);
=   }
=
=   /* make DOOR.SYS (Generic) */
=   create_filename(CHAINFILE_DOOR, s);
=   unlink(s);
=   f=fsh_open(s,"wt");
=   if (f) {
=     fprintf(f,"COM%d\n%s\n%c\n%u\n%u\n%c\n%c\n%c\n%c\n%s\n%s, %s\n",
=       (using_modem)?syscfgovr.primaryport:0,
=       cspeed,
=       (andwith==0x7f)?'7':'8',
=       instance,  /* node */
=       (using_modem)?modem_speed:14400,
=       'Y', /* screen display */
=       (syscfg.sysconfig & sysconfig_printer)?'Y':'N',
=       'N',  /* page bell */
=       'N',  /* caller alarm */
=       thisuser.realname,
=       thisuser.city,
=       thisuser.state);
=     fprintf(f,"%s\n%s\n%s\n%d\n%u\n%s\n%ld\n%ld\n",
=       thisuser.phone,
=       thisuser.dataphone,
=       "X", /* thisuser.pw */
=       thisuser.sl,
=       thisuser.logons,
=       thisuser.laston,
=       (unsigned long)(60L*l),
=       l);
=     sprintf(s1,"%s",okansi()?"GR":"NG");
=     if (andwith==0x7f)
=       strcpy(s1,"7E");
=     fprintf(f,"%s\n%u\n%c\n%s\n%u\n%s\n%u\n%c\n%u\n%u\n%u\n%u\n",
=       s1,
=       thisuser.screenlines,
=       (thisuser.sysstatus & sysstatus_expert)?'Y':'N',
=       "1,2,3", /* conferences */
=       cursub,  /* current 'conference' */
=       "12/31/99", /* expiration date */
=       usernum,
=       'Y', /* default protocol */
=       thisuser.uploaded,
-       thisuser.downloaded,
+       thisuser.downloaded+thisuser.edownloaded,
=       0,  /* kb dl today */
=       0); /* kb dl/day max */
=     strcpy(s1,"00/00/00");
=     sprintf(s2,"%d",thisuser.month);
=     memmove(&(s1[2-strlen(s2)]),&(s2[0]),strlen(s2));
=     sprintf(s2,"%d",thisuser.day);
=     memmove(&(s1[5-strlen(s2)]),&(s2[0]),strlen(s2));
=     sprintf(s2,"%d",thisuser.year);
=     memmove(&(s1[8-strlen(s2)]),&(s2[0]),strlen(s2));
=     fprintf(f,"%s\n%s\n%s\n%s\n%s\n%s\n%c\n%c\n%c\n%u\n%u\n%s\n%-.5s\n%s\n",
=       s1,
=       syscfg.datadir,
=       syscfg.gfilesdir,
=       syscfg.sysopname,
=       thisuser.name,
=       "00:01", /* event time */
=       (modem_flag & flag_ec)?'Y':'N',
=       (okansi())?'N':'Y',  /* ansi ok but graphics turned off? */
=       'N', /* record-locking */
=       thisuser.colors[0],
=       thisuser.banktime,
=       thisuser.laston, /* last n-scan date */
=       times(),
=       "00:01"); /* time last call */
=     fprintf(f,"%u\n%u\n%ld\n%ld\n%s\n%u\n%ld\n",
=       99, /* max files dl/day */
=       0,  /* files dl today so far */
=       thisuser.uk,
-       thisuser.dk,
+       thisuser.dk+thisuser.edk,
=       thisuser.note,
=       thisuser.chainsrun,
=       thisuser.msgpost);
=     fsh_close(f);
=   }
= }

[ Step 14 ]

In "char *create_chain_file", make the following changes:

=     if (using_modem)
=       fprintf(f,"%u\n",modem_speed);
=     else
=       fprintf(f,"KB\n");
=     fprintf(f,"%d\n%s\n%s\n%ld\n%ld\n%lu\n%u\n%lu\n%u\n%s\n%s\n%u\n",
=             syscfgovr.primaryport, syscfg.systemname, syscfg.sysopname, l, l1,
-             thisuser.uk, thisuser.uploaded, thisuser.dk, thisuser.downloaded,
+             thisuser.uk, thisuser.uploaded, thisuser.dk+thisuser.edk,
+             thisuser.downloaded+thisuser.edownloaded,
=             (andwith==0x7f)?"7E1":"8N1", cspeed, net_sysnum);
=     fprintf(f,"%c\n%c\n%c\n",(rip)?'Y':'N',(menu_on())?'Y':'N',

[ Step 15 ]

In MMENU.C, add the following lines to "void dlmainmenu":

=       case 'H':
=         hop_dir();
=         break;
+       case 'I':
+         nl();
+         npr("The up/download ratio for the current directory is %-5.3f.",
+             dir_ratios[udir[curdir].subnum]);
+         nl();
+         break;
=       case 'J':
=         if (okconf(&thisuser))
=           jump_conf(CONF_DIRS);
=         break;

[ Step 16 ]

In RETURN.C, make the following changes to "char *interpret":

=     case 'D':                   // Files downloaded
-       sprintf(s, "%u", thisuser.downloaded);
+       sprintf(s, "%u", thisuser.downloaded+thisuser.edownloaded);
=       break;

[ Step 17 ]

Farther down in "char *interpret", make the following changes:

=     case 'k':                   // Kb downloaded
-       sprintf(s, "%lu", thisuser.dk);
+       sprintf(s, "%lu", thisuser.dk+thisuser.edk);
=       break;

[ Step 18 ]

In RIPOVL.C, make the following changes to "char *interpret":

=         case 'D':                   // Files downloaded
-           sprintf(s, "%u", thisuser.downloaded);
+           sprintf(s, "%u", thisuser.downloaded+thisuser.edownloaded);
=           break;

[ Step 19 ]

Farther down in "char *interpret", make the following changes:

=         case 'k':                   // Kb downloaded
-           sprintf(s, "%lu", thisuser.dk);
+           sprintf(s, "%lu", thisuser.dk+thisuser.edk);
=           break;

[ Step 20 ]

In SR.C, make the following changes to "void ascii_send":

=     if (!abort)
=       *sent=1;
=     else {
=       *sent=0;
-       thisuser.dk += bytes_to_k(pos);
+       if (thisuser.exempt & exempt_ratio)
+         thisuser.edk += bytes_to_k(pos);
+       else
+         thisuser.dk += bytes_to_k(pos);
=     }
=     *percent=((double) pos)/((double)max);

[ Step 21 ]

In UEDIT.C, make the following changes in "void print_data":

=     outstr_x2(get_string(250));
=       npr("%d  %d  I=%d\r\n",
=         u->logons,(strcmp(u->laston,date()))?0:u->ontoday,u->illegal);
=     outstr_x2(get_string(251));
-       npr("U=%d-%ldk   D=%d-%ldk\r\n",
+       npr("U=%d-%ldk   D=%d-%ldk",
=         u->uploaded, u->uk, u->downloaded, u->dk);
+     if (u->edownloaded)
+       npr("   ED=%d-%ldk\r\n",u->edownloaded, u->edk);
+     else
+       outstr("\r\n");
=     outstr_x2(get_string(252)); pln(u->lastrate);
=   }

[ Step 22 ]

In XFER.C, change the following lines in "int ratio_ok":

- int ratio_ok(void)
+ int ratio_ok(int dn)
= {
=   int ok=1;
=   char s[250];
=
=   if (!(thisuser.exempt & exempt_ratio))
-     if ((syscfg.req_ratio>0.0001) && (ratio()<syscfg.req_ratio)) {
+     if ((dir_ratios[dn]>0.0001) && (ratio()<dir_ratios[dn])) {
=       ok=0;
=       nln(2);
=       sprintf(s,"%s %-5.3f.  %s %-5.3f %s.",
=               get_string(730), ratio(),
-               get_string(731), syscfg.req_ratio,
+               get_string(731), dir_ratios[dn],
=               get_string(732));
=       pl(s);
=       nl();
=     }

[ Step 23 ]

In XFEROVL2.C, make the following changes to "int try_to_download":

=     if ((strncmp(u.filename,"WWIV4",5)==0) &&
=         (!(sysinfo.flags & OP_FLAGS_NO_EASY_DL)))
=       i1=1;
=     else {
-       if (!ratio_ok()) {
+       if (!ratio_ok(dn)) {
=         if (menu_on())
=           rip_restoreall();
=         return(-1);
=       }
=     }

[ Step 24 ]

Still in "int try_to_download", make the following changes:

=         send_file(s1,&sent,&abort,u.filetype,u.filename,dn, u.numbytes);
=       if (sent) {
-         ++thisuser.downloaded;
-         thisuser.dk += (int) (bytes_to_k(u.numbytes));
+         if (dir_ratios[dn]) {
+           if (thisuser.exempt & exempt_ratio) {
+             ++thisuser.edownloaded;
+             thisuser.edk += (int) (bytes_to_k(u.numbytes));
+           } else {
+             ++thisuser.downloaded;
+             thisuser.dk += (int) (bytes_to_k(u.numbytes));
+           }
+         } else {
+           ++thisuser.edownloaded;
+           thisuser.edk += (int) (bytes_to_k(u.numbytes));
+         }
=         ++u.numdloads;
=         f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);

[ Step 25 ]

In "void tag_it", make the following changes:

=         bad=1;
=       }
-       if ((syscfg.req_ratio>0.0001)
-         && (ratio()<syscfg.req_ratio)
+       if ((dir_ratios[filelist[i].directory]>0.0001)
+         && (ratio()<dir_ratios[filelist[i].directory])
=         && (!thisuser.exempt & exempt_ratio)
=         && (bad==0)) {
=         ansic(2);
=         outstr(get_string(730));
=         sprintf(s," %-5.3f.  ",ratio());
=         outstr(s);
=         outstr(get_string(731));
-         sprintf(s," %-5.3f ",syscfg.req_ratio);
+         sprintf(s," %-5.3f ",dir_ratios[filelist[i].directory]);
=         outstr(s);
=         outstr(get_string(732));
=         nl();
=         bad=1;
=       }

[ Step 26 ]

In "void yourinfodl", make the following changes:

=   pl(get_string(798));
=   ansic_x(1); outstr(get_string(799));
-   ansic_x(2); npr("%ldk",thisuser.dk);
+   ansic_x(2); npr("%ldk",thisuser.dk+thisuser.edk);
=   ansic_x(1); outstr(get_string(797));
-   ansic_x(2); npr("%d",thisuser.downloaded);
+   ansic_x(2); npr("%d",thisuser.downloaded+thisuser.edownloaded);
=   pl(get_string(798));

[ Step 27 ]

In XFERTMP.C, make the following changes in "void download_temp_arc":

= void download_temp_arc(char *fn, int xfer)
= {
=   char s[81],s1[81];
=   long numbytes;
=   int f,sent,abort;
=   double d;
=
=   outstr(get_string(847));
=   npr("%s.%s:\r\n\r\n", fn, syscfg.arcs[ARC_NUMBER].extension);
-   if (xfer && !ratio_ok()) {
+   if (xfer && !ratio_ok(max_dirs)) {
=     pl(get_string(848));
=     return;
=   }

[ Step 28 ]

In XINIT.C, add the following function before "void read_chains":

void read_dir_ratios(void)
{
  int f,i;
  char s[81];

  if (dir_ratios)
    bbsfree(dir_ratios);
  dir_ratios=NULL;
  dir_ratios=(float *) mallocx((long)(max_dirs+1)*sizeof(float),"dir_ratios");
  sprintf(s,"%sRATIOS.DAT",syscfg.datadir);
  f=sh_open1(s,O_RDONLY | O_BINARY);
  if (f>0) {
    for (i=0; i<num_dirs; i++)
      sh_read(f,&dir_ratios[i],sizeof(float));
    dir_ratios[max_dirs]=syscfg.req_ratio;
    sh_close(f);
  } else {
    f=sh_open(s,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
    if (f>0) {
      for (i=0; i<num_dirs; i++) {
        dir_ratios[i]=syscfg.req_ratio;
        sh_write(f,&dir_ratios[i],sizeof(float));
      }
      dir_ratios[max_dirs]=syscfg.req_ratio;
      sh_close(f);
    }
  }
}

[ Step 29 ]

In "void init", add the following lines:

=   directories=NULL;
=
=   if(read_dirs())
=     end_bbs(noklevel);
=
+   dir_ratios=NULL;
+   read_dir_ratios();
+
=   numchain=0;
=   chains=NULL;
=   read_chains();

[ Step 30 ]

In VARDEC.H, make the following changes:

=       gfilesread,     /* how many gfiles read */
=       banktime,       /* how many mins in timebank */
-       homenet;        /* home net number */
+       homenet,        /* home net number */
+       edownloaded;    /* number files downloaded while exempted */
=
=     char
-       res_short[48];   /* reserved for short values */
+       res_short[46];   /* reserved for short values */
=
=     unsigned long
=       msgread,        /* total num msgs read */
=       uk,             /* number of k uploaded */
=       dk,             /* number of k downloaded */
=       daten,          /* numerical time last on */
=       sysstatus,      /* status/defaults */
=       wwiv_regnum,    /* user's WWIV reg number */
=       filepoints,     /* points to spend for files */
=       registered,     /* numerical registration date */
-       expires;        /* numerical expiration date */
+       expires,        /* numerical expiration date */
+       edk;            /* number of k downloaded while exempted */
=
=     char
-       res_long[48];   /* reserved for long values */
+       res_long[44];   /* reserved for long values */
=
=     float
=       timeontoday,    /* time on today */

[ Step 31 ]

In VARS.H, make the following changes:

= __EXTRN__ unsigned long *qsc, *qsc_n, *qsc_q, *qsc_p;
=
=
- __EXTRN__ float batchtime;
+ __EXTRN__ float batchtime, *dir_ratios;
=
= __EXTRN__ double extratimecall, last_time, timeon, time_event, xtime;

[ Step 32 ]

Type MAKE FCNS to add the new functions to FCNS.H.  Now compile your source.
We have changed VARS.H so this means the board will need a full re-compile.

[ Step 33 ]

Load the board and do //DIREDIT.  If you want to create a new free directory,
call it something like "Free Downloads" and give that directory a ratio of
0.000.  By default, all directories have the ratio assigned in INIT.  If you
wish to change them, do so by selecting 'L' while editing a particular dir
and assign it whatever ratio you like.

Also, don't forget to edit your menus to reflect the new 'I' command in
transfers.  This will let users see what the ratio is on a particular dir.

[ Disclaimer ]

Don't complain to me if your board gets fried, your hard disk goes nuts, or
something terrible happens.  The code in this mod should be harmless, but I
can't guarantee it will work for you.  It works on my board.

JAFO 1@1     TerraNET
     1@3809  WWIVnet
     1@8857  IceNET
     1@8857  SOLARnet
     1@18857 WWIVLink
