Ŀ
 Mod Name: FR020B.MOD         Mod Author: Frank Reid 1@8213.WWIVNET        
 Difficulty: Intermediate          Date: June 10, 1995                     
 WWIV Version: 4.24                                                        
 Description: File Attach mod. Allows users to upload a file as an attach  
 to Email for another user. SysOp can attach from any DOS drive/path.      


1.  Description:  Overhaul of East Bay Ray's ATTACH.MOD for v4.12 with upward
compatibility and the ability to add local files, which was my main purpose
for rewriting it.

2.  Description:  You can attach files two ways.  An //ATTACH command scans
Email you've sent and prompts to attach a file (good for responding to offline
requests).  The more common method is a prompt when saving E-mail.  Like many
other BBS types, you're asked if you wish to attach a file to the message.
The sysop (or any 255 SL) can attach files from a local drive; regular users
can upload a file as an attachment only.  A remote 255 can either upload or
attach from local.  (If you need to be warned, be careful who you give 255 SL
on your system -- remotes can attach any file they want to Email and download
it!)

3.  Mechanics:  Creates and maintains a data structure in your DATA directory
to store information about attached files.  The directory to store files is
specified in WWIV.INI.  Files are deleted if a user deletes, autoreplies or
downloads, making the process entirely self-maintaining.  (A sysyop has the
option of saving an attached file when autoreplying.)

4.  Limitations:  One file of the same name can exist in the attach directory
at a time (a DOS limitation).  If you want to send the same file to more than
one user, you can rename the target file on the fly.

** Step One **

Back up your source code!  This is an extensive mod, and if you have problems 
you'll regret not having a backup!

** Step Two **

Open <MMENU.C>

Search for "void mainmenu(void)" and add the following:

==  if ((strcmp(s,"NET")==0) || (strncmp(s,"NET=",4)==0))
==    print_net_listing(0);
++  if (strcmp(s,"ATTACH")==0)
++    attach_file(0);
==  if (strcmp(s,"QSCAN")==0) {

Save <MMENU.C>

** Step Three **

Open <VARDEC.H>

After the conference structure, add the a filestatusrec structure:

==                *subs;            /* "Sub" numbers in this conference */
==} confrec;

++typedef struct {
++  int             user;
++  char            filename[13];
++  long            id;
++  unsigned long   numbytes;
++} filestatusrec;

Save <VARDEC.H>

** Step Four **

Open <VARS.H>

Search for the char declarations and add the following:

==               ver_no2[51],wwiv_net_no[20], xdate[9], *xenviron[50],
==               dlfn[81],edlfn[81], nete[5], irt_sub[81];
==
++__EXTRN__ char attach_dir[81];
++
==__EXTRN__ unsigned char actsl, andwith, checksum;

Save <VARS.H>

*** Step Five ***

Open <READMAIL.C>

Near the top of the file, add the following #include (prototypes the ffblk
structure):

==#pragma hdrstop

++#include <dir.h>

Search for "void readmail(void)" and declare these variables:

==  tmpmailrec *mloc;
++  filestatusrec fsr;
++  int f1, found, attach_exists, sentt, abortt;
++  long l1;
==
==  emchg=0;

Hop down about 300 lines and add this chunk of code:

==      if (!abort) {
==        read_message1(&m.msg, (m.anony & 0x0f), i, &next, "EMAIL");
==        if (!(m.status & status_seen)) {
==          read_same_email(mloc, mw, curmail, &m, 0, status_seen);
==        }
==      }
/* BEGIN BLOCK READ */
      found = 0;
      attach_exists = 0;
      if (m.status & status_file) {
        sprintf(s, "%sATTACH.DAT", syscfg.datadir);
        f1 = sh_open(s, O_RDONLY | O_BINARY, S_IREAD | S_IWRITE);  /* B */
        if (f1 > -1) {
          l1 = sh_read(f1, (void *)(&fsr), sizeof(fsr));
          while ((l1 > 0) && (!found)) {
            if (m.daten == fsr.id) {
              found = 1;
              sprintf(s, "%s%s", attach_dir, fsr.filename);
              if (exist(s)) {
                sprintf(s, "'T' to download attached file \"%s\" (%ld bytes).",
                    fsr.filename, fsr.numbytes);
                pl(s);
                attach_exists = 1;
              } else {
                sprintf(s, "Attached file \"%s\" (%ld bytes) is missing!",
                    fsr.filename, fsr.numbytes);
                pl(s);
              }
            }
            if (!found)
              l1 = sh_read(f1, (void *)(&fsr), sizeof(fsr));
          }
          if (!found)
            pl("File attached but attachment data missing.  Alert sysop!");
        } else {
          pl("File attached but attachment data missing.  Alert sysop!");
        }
        f1 = sh_close(f1);
      }
/* END BLOCK READ HERE */
==#ifdef RIPDRIVE
==      rd_con();
==#endif

A few lines below there, you'll need to make several changes.  These changes
"stack" the user's options for reading mail, allowing you to add a 'T' if a
file attach exists.  Follow the changed lines (=+) carefully -- this is the
one place where most folks made errors in the past.

==      if (so()) {
==        if (sysinfo.flags & OP_FLAGS_MAIL_PROMPT)
==          npr(get_string(1365));
=+        strcpy(s,"QSRIDAMF?-+GEZPVUOLCN");
==      } else {
==        if (cs()) {
==          if (sysinfo.flags & OP_FLAGS_MAIL_PROMPT)
==            npr(get_string(1366));
=+          strcpy(s, "QSRIDAMF?-+GZPVUOC");
==        } else {
==          if (!okmail) {
==            if (sysinfo.flags & OP_FLAGS_MAIL_PROMPT)
==              npr(get_string(1367));
=+            strcpy(s, "QI?-+G");
==          } else {
==            if (sysinfo.flags & OP_FLAGS_MAIL_PROMPT)
==              npr(get_string(1368));
=+            strcpy(s, "QSRIDAMF?+-G");
==          }
==        }
==      }
++      if ((m.status & status_file) && (found) && (attach_exists)) {
++        if (sysinfo.flags & OP_FLAGS_MAIL_PROMPT)
++          npr("\b\b7{1T7} 2: 0");
++        strcat(s, "T");
++      }
++      ch = onek(s);
==      if (okmail && !read_same_email(mloc, mw, curmail, &m, 0, 0)) {

A few lines below here, add the entire case 'T' to transfer the file:

==      switch (ch) {
/* BEGIN BLOCK READ */
        case 'T':
          nl();
          sprintf(s1, "%s%s", attach_dir, fsr.filename);
          send_file(s1, &sentt, &abortt, 0, fsr.filename, -1, fsr.numbytes);
          if (sentt) {
            nl();
            pl("Attached file sent.");
            sprintf(s1,"Downloaded %ldk of attached file %s.",
              (fsr.numbytes+1023)/1024, fsr.filename);
            sysoplog(s1);
          } else {
            nl();
            pl("Attached file not completely sent.");
            sprintf(s1,"Tried to download attached file %s.", fsr.filename);
            sysoplog(s1);
          }
          nl();
          break;
/* END BLOCK READ */
==        case 'N':

Jump down a hundred lines, and add this to case 'Z':

==        case 'Z':
==          if (!okmail)
==            break;
==          read_same_email(mloc, mw, curmail, &m, 1, 0);
==          ++curmail;
==          if (curmail>=mw)
==            done=1;
/* BEGIN BLOCK READ */
          found = 0;
          if (m.status & status_file) {
            sprintf(s, "%sATTACH.DAT", syscfg.datadir);
            f1 = sh_open1(s, O_RDWR | O_BINARY);
            if (f1 > -1) {
              l1 = sh_read(f1, (void *)(&fsr), sizeof(fsr));
              while ((l1 > 0) && (!found)) {
                if (m.daten == fsr.id) {
                  found = 1;
                  fsr.id = 0;
                  sh_lseek(f1, sizeof(filestatusrec) * -1L, SEEK_CUR);
                  sh_write(f1, (void *)(&fsr), sizeof(filestatusrec));
                  sprintf(s1, "%s%s", attach_dir, fsr.filename);
                  unlink(s1);
                } else
                  l1 = sh_read(f1, (void *)(&fsr), sizeof(filestatusrec));
              }
              f1 = sh_close(f1);
            }
          }
/* END BLOCK READ */
==          if (!wfc)
==            topscreen();
==          break;
==        case 'P':

Just below that, add this to case 'F' so a file is deleted when forwarding
mail:

==        case 'F':
==          if (!okmail)
==            break;
==          if (m.status & status_multimail) {
==            nl();
==            pl(get_string(715));
==            nl();
==            break;
==          }
/* BEGIN BLOCK READ */
          if (m.status & status_file) {
            sprintf(s, "%sATTACH.DAT", syscfg.datadir);
            f1 = sh_open1(s, O_RDWR | O_BINARY);
            if (f1 > -1) {
              l1 = sh_read(f1, (void *)(&fsr), sizeof(fsr));
              while ((l1 > 0) && (!found)) {
                if (m.daten == fsr.id) {
                  found = 1;
                  fsr.id = 0;
                  sh_lseek(f1, sizeof(filestatusrec) * -1L, SEEK_CUR);
                  sh_write(f1, (void *)(&fsr), sizeof(filestatusrec));
                  if (so()) {
                    prt(5, "Delete attached file? ");
                    if (yn()) {
                      sprintf(s1, "%s%s", attach_dir, fsr.filename);
                      unlink(s1);
                    } else {
                      npr("\r\nOrphaned attach %s remains in %s\r\n",
                          fsr.filename, attach_dir);
                      pausescr();
                    }
                  }
                } else
                  l1 = sh_read(f1, (void *)(&fsr), sizeof(filestatusrec));
              }
              f1 = sh_close(f1);
            }
          }
/* END BLOCK READ HERE */
==          nln(2);
==          prt(2,get_string(716));


Another hundred or so lines down, add this block:

==          if ((ch=='A') || (ch=='M')) {
==            if (num_mail!=num_mail1) {
==              if (m.fromsys!=0)
==                sprintf(s,"%s: %s",net_name,
==                    nam1(&thisuser,usernum,net_sysnum));
==              else
==                strcpy(s,nam1(&thisuser,usernum,net_sysnum));
==              if (m.anony & anony_receiver)
==                strcpy(s,get_string(482));
==              strcat(s,get_string(713));
==              strcat(s,date());
==              if (!(m.status & status_source_verified))
==                ssm(m.fromuser,m.fromsys,s);
==              read_same_email(mloc, mw, curmail, &m, 1, 0);
==              ++curmail;
==              if (curmail>=mw)
==                done=1;
/* BEGIN BLOCK READ */
              found = 0;
              if (m.status & status_file) {
                sprintf(s, "%sATTACH.DAT", syscfg.datadir);
                f1 = sh_open1(s, O_RDWR | O_BINARY);
                if (f1 > -1) {
                  l1 = sh_read(f1, (void *)(&fsr), sizeof(fsr));
                  while ((l1 > 0) && (!found)) {
                    if (m.daten == fsr.id) {
                      found = 1;
                      fsr.id = 0;
                      sh_lseek(f1, sizeof(filestatusrec) * -1L, SEEK_CUR);
                      sh_write(f1, (void *)(&fsr), sizeof(filestatusrec));
                      if (so()) {
                        prt(5, "Delete attached file? ");
                        if (yn()) {
                          sprintf(s1, "%s%s", attach_dir, fsr.filename);
                          unlink(s1);
                        } else {
                          npr("\r\nOrphaned attach %s remains in %s\r\n",
                              fsr.filename,
                              attach_dir);
                          pausescr();
                        }
                      }
                    } else
                      l1 = sh_read(f1, (void *)(&fsr), sizeof(filestatusrec));
                  }
                  f1 = sh_close(f1);
                }
              }
/* END BLOCK READ */
==              if (!wfc)
==                topscreen();

Now, the "guts" of the mod!  Go to the very bottom of the file, and add these
two routines:

void attach_file(int mode)
{
  int cur, max, i, i1, f, done, done1, done2, done3;
  int forward, f1, remote_upld, newname, found, ok, d1, d2;
  char s[81], s1[81], s2[81], s3[31], ch, ch1, *b;
  long l, l1;
  mailrec m;
  userrec u;
  slrec ss;
  filestatusrec fsr, fsr1;
  unsigned char u_filetype;
  union REGS r;

  nl();
  forward = 1;
  ss = syscfg.sl[actsl];
  f = open_email(1);
  if (f == -1) {
    nl();
    pl("No mail.");
    f = sh_close(f);
    return;
  }
  max = (int) (filelength(f) / sizeof(mailrec));
  if (forward)
    cur = max - 1;
  else
    cur = 0;
  done = newname = 0;
  do {
    sh_lseek(f, ((long) cur) * ((long) sizeof(mailrec)), SEEK_SET);
    sh_read(f, (void *) &m, sizeof(mailrec));
    while (((m.fromsys != 0) || (m.fromuser != usernum) ||
      (m.touser == 0)) && (cur < max) && (cur >= 0)) {
      if (forward)
        --cur;
      else
        ++cur;
      if ((cur < max) && (cur >= 0)) {
        sh_lseek(f, ((long) cur) * ((long) sizeof(mailrec)), SEEK_SET);
        sh_read(f, (void *) &m, sizeof(mailrec));
      }
    }
    if ((m.fromsys != 0) || (m.fromuser != usernum) ||
        (m.touser == 0) || (cur >= max) || (cur < 0))
      done = 1;
    else {
      do {
        done1 = 0;
        nl();
        if (m.tosys == 0) {
          read_user(m.touser, &u);
          outstr(get_string(325));
          strcpy(s1, nam(&u, m.touser));
          if ((m.anony &
              (anony_receiver | anony_receiver_pp | anony_receiver_da)) &&
              ((ss.ability & ability_read_email_anony) == 0))
            strcpy(s1, ">UNKNOWN<");
          pl(s1);
        } else {
          itoa(m.touser, s, 10);
          itoa(m.tosys, s1, 10);
          outstr(get_string(325));
          npr("User %s System %s\r\n", s1, s);
        }
        outstr(get_string(326)); pl(m.title);
        time(&l);
        i = (int) ((l - m.daten) / 24.0 / 3600.0);
        itoa(i, s, 10);
        npr("1Sent0........2 %s days ago\r\n", s);
        if (m.status & status_file) {
          sprintf(s2, "%sATTACH.DAT", syscfg.datadir);
          f1 = sh_open(s2, O_RDONLY | O_BINARY, S_IREAD | S_IWRITE); /* B */
          if (f1 > -1) {
            found = 0;
            l1 = sh_read(f1, (void *) (&fsr), sizeof(fsr));
            while ((l1 > 0) && (!found)) {
              if (m.daten == fsr.id) {
                if (E_C)
                  sprintf(s, "%s2%s (%ld bytes)0",
                    get_string(659), fsr.filename, fsr.numbytes);
                else
                  sprintf(s, "File : %s (%ld bytes)", fsr.filename,
                    fsr.numbytes);
                pl(s);
                found = 1;
              }
              if (!found)
                l1 = sh_read(f1, (void *) (&fsr), sizeof(fsr));
            }
            if (!found)
              if (E_C) {
                sprintf(s, "%s2Unknown or missing0", get_string(659));
                pl(s);
              } else
                pl("File : Unknown or Missing");
            f1 = sh_close(f1);
          } else
            if (E_C) {
              sprintf(s, "%s2Unknown or missing0", get_string(659));
              pl(s);
            } else
              pl("File : Unknown or Missing");
        }
        nl();
        if (mode == 0) {
          prt(2, "R:ead, A:ttach, N:ext, Q:uit : ");
          ch = onek("QRAN");
        } else {
          prt(2, "R:ead, A:ttach, Q:uit : ");
          ch = onek("QRA");
        }
        switch (ch) {
        case 'Q':
          done1 = 1;
          done = 1;
          break;
        case 'A':
          done2 = 0;
          if (m.status & status_file) {
            prt(6, "File already attached, D:elete, O:verwrite, or Q:uit? : ");
            ch1 = onek("QDO");
            switch (ch1) {
            case 'Q':
              done2 = 1;
              break;
            case 'D':
            case 'O':
              m.status ^= status_file;
              sh_lseek(f, ((long) sizeof(mailrec)) * -1L, SEEK_CUR);
              sh_write(f, (void *) (&m), sizeof(mailrec));
              sprintf(s2, "%sATTACH.DAT", syscfg.datadir);
              f1 = sh_open1(s2, O_RDWR | O_BINARY);
              if (f1 > -1) {
                found = 0;
                l1 = sh_read(f1, (void *) (&fsr), sizeof(fsr));
                while ((l1 > 0) && (!found)) {
                  if (m.daten == fsr.id) {
                    fsr.id = 0;
                    sprintf(s, "%s%s", attach_dir, fsr.filename);
                    unlink(s);
                    sh_lseek(f1, sizeof(filestatusrec) * -1L, SEEK_CUR);
                    sh_write(f1, (void *) (&fsr), sizeof(fsr));
                  }
                  if (!found)
                    l1 = sh_read(f1, (void *) (&fsr), sizeof(fsr));
                }
                f1 = sh_close(f1);
                pl("File attachment removed.");
              }
              if (ch1 == 'D')
                done2 = 1;
              break;
            }
          }
          if (freek1(attach_dir) < 500) {
            pl("Not enough free space to attach a file.");
          } else {
            if (!done2) {
              remote_upld = found = 0;
              nl();
              if (so()) {
                if (incom) {
                  prt(5, "Upload from remote? ");
                  if (yn())
                    remote_upld = 1;
                }
                if (!remote_upld) {
                  prt(2, "Path and filename (wildcards okay) : ");
                  mpl(50);
                  input(s, 50);
                  if (s[0]) {
                    nl();
                    if (strchr(s, '*') != NULL || strchr(s, '?') != NULL)
                      strcpy(s, get_wildlist(s));
                    if (!exist(s))
                      found = 1;
                    if ((!okfn(stripfn(s))) || (strchr(s, '?')))
                      found = 1;
                  }
                  if ((!found) && (s[0])) {
                    sprintf(s1, "%s%s", attach_dir, stripfn(s));
                    nl();
                    npr("5%s? ", s);
                    if (!yn())
                      found = 1;
                  }
                }
              }
              if ((!so()) || (remote_upld)) {
                prt(2, get_string(44));
                mpl(12);
                input(s, 12);
                sprintf(s1, "%s%s", attach_dir, s);
                if ((!okfn(s)) || (strchr(s, '?')))
                  found = 1;
              }
              if (exist(s1)) {
                pl("Target file exists.");
                do {
                  found = 1;
                  prt(5, "New name? ");
                  if (yn()) {
                    prt(5, get_string(44));
                    mpl(12);
                    input(s3, 12);
                    sprintf(s1, "%s%s", attach_dir, s3);
                    if ((okfn(s3)) && (!strchr(s3, '?')) && (!exist(s1))) {
                      found = 0;
                      done3 = newname = 1;
                    } else
                      pl("Try Again.");
                  } else
                    done3 = 1;
                } while ((!done3) && (!hangup));
              }
              sprintf(s2, "%sATTACH.DAT", syscfg.datadir);
              f1 = sh_open(s2, O_RDONLY|O_BINARY, S_IREAD|S_IWRITE); /* B */
              if (f1 > -1) {
                l1 = sh_read(f1, (void *) (&fsr), sizeof(fsr));
                while ((l1 > 0) && (!found))
                  if (m.daten == fsr.id)
                    found = 1;
                  else
                    l1 = sh_read(f1, (void *) (&fsr), sizeof(fsr));
                f1 = sh_close(f1);
              }
              if (found) {
                pl("File already exists or invalid filename.");
              } else {
                if ((so()) && (!remote_upld)) {
                  if ((b = malloca(16400)) == NULL) {
                    f = sh_close(f);
                    return;
                  }
                  d1 = sh_open1(s,
                      O_RDONLY | O_BINARY);
                  d2 = sh_open(s1,
                      O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
                  if ((d1 > -1) && (d2 > -1)) {
                    i = sh_read(d1, (void *) b, 16384);
                    outstr("Copying.");
                    while (i > 0) {
                      outstr(".");
                      sh_write(d2, (void *) b, i);
                      i = sh_read(d1, (void *) b, 16384);
                    }
                    r.h.ah = 0x57;
                    r.h.al = 0;
                    r.x.bx = d1;
                    int86(0x21, &r, &r);
                    r.h.ah = 0x57;
                    r.h.al = 1;
                    r.x.bx = d2;
                    int86(0x21, &r, &r);
                    d1 = sh_close(d1);
                    d2 = sh_close(d2);
                    bbsfree(b);
                    outstr("done.");
                    nl();
                    ok = 1;
                  } else {
                    nl();
                    ansic(6);
                    pl("Error in copy.");
                    getkey();
                  }
                } else {
                  sprintf(s1, "%s%s", attach_dir, s);
                  receive_file(s1, &ok, &u_filetype, "", 0);
                }
                if (ok) {
                  f1 = sh_open1(s1, O_RDONLY | O_BINARY);
                  if (f1 < 0) {
                    ok = 0;
                    nl();
                    nl();
                    pl("DOS error - File not found.");
                    nl();
                  } else {
                    fsr.numbytes = filelength(f1);
                    f1 = sh_close(f1);
                    if (newname)
                      strcpy(fsr.filename, stripfn(s3));
                    else
                      strcpy(fsr.filename, stripfn(s));
                    fsr.id = m.daten;
                    sprintf(s, "Attach %s (%ld bytes) to Email? ",
                      fsr.filename, fsr.numbytes);
                    prt(5, s);
                    if (yn()) {
                      m.status ^= status_file;
                      sh_lseek(f, ((long) sizeof(mailrec)) * -1L, SEEK_CUR);
                      sh_write(f, (void *) (&m), sizeof(mailrec));
                      sprintf(s2, "%sATTACH.DAT", syscfg.datadir);
                      f1 = sh_open(s2,
                          O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
                      if (f1 < 0) {
                        pl("Could not write attachment data.");
                        m.status ^= status_file;
                        sh_lseek(f, ((long) sizeof(mailrec)) * -1L, SEEK_CUR);
                        sh_write(f, (void *) (&m), sizeof(mailrec));
                      } else {
                        fsr1.id = 1;
                        do {
                          l1 = sh_read(f1, (void *) (&fsr1),
                              sizeof(filestatusrec));
                        } while ((l1 > 0) && (fsr1.id != 0));
                        if (fsr1.id == 0)
                          sh_lseek(f1, sizeof(filestatusrec) * -1L, SEEK_CUR);
                        else
                          sh_lseek(f1, 0L, SEEK_END);
                        sh_write(f1, (void *) (&fsr), sizeof(filestatusrec));
                        f1 = sh_close(f1);
                        sprintf(s1, "Attached %s (%ld bytes) in message to %s",
                          fsr.filename, fsr.numbytes, nam(&u, m.touser));
                        pl("File attached.");
                        sysoplog(s1);
                      }
                    } else {
                      sprintf(s1, "%s%s", attach_dir, fsr.filename);
                      unlink(s1);
                    }
                  }
                }
              }
            }
          }
          break;
        case 'N':
          done1 = 1;
          if (forward)
            --cur;
          else
            ++cur;
          if ((cur >= max) || (cur < 0))
            done = 1;
          break;
        case 'R':
          nl();
          nl();
          strcpy(s, "Title: ");
          strcat(s, m.title);
          pl(s);
          setorigin(0, 0);
          read_message1(&m.msg, (m.anony & 0x0f), 0, &i1, "EMAIL");
          if (m.status & status_file) {
            sprintf(s, "%sATTACH.DAT", syscfg.datadir);
            f1 = sh_open(s, O_RDONLY | O_BINARY, S_IREAD | S_IWRITE); /* B */
            if (f1 > -1) {
              found = 0;
              l1 = sh_read(f1, (void *) (&fsr), sizeof(fsr));
              while ((l1 > 0) && (!found)) {
                if (m.daten == fsr.id) {
                  sprintf(s, "Attached file: %s (%ld bytes).",
                    fsr.filename, fsr.numbytes);
                  pl(s);
                  found = 1;
                }
                if (!found)
                  l1 = sh_read(f1, (void *) (&fsr), sizeof(fsr));
              }
              if (!found)
                pl("File attached but attachment data missing.  Alert sysop!");
              f1 = sh_close(f1);
            } else
              pl("File attached but attachment data missing.  Alert sysop!");
          }
          break;
        }
      } while ((!hangup) && (!done1));
    }
  } while ((!done) && (!hangup));
  f = sh_close(f);
}

unsigned char *get_wildlist(char *s)
{
  int i, mark;
  char *path, t;
  struct ffblk mrff;

  if (findfirst(s, &mrff, 0) == -1) {
    pl("No files found");
    s[0] = 0;
    return (s);
  } else
    npr("%12.12s ", mrff.ff_name);
  if (strchr(s, '\\') == NULL)
    s[0] = 0;
  else
    for (i = 0; i < strlen(s); i++)
      if (s[i] == '\\')
        mark = i + 1;
  t = s[mark];
  s[mark] = 0;
  strcpy(path, s);
  s[mark] = t;
  t = strlen(path);
  strcat(path, mrff.ff_name);
  for (i = 1;; i++) {
    if (i % 5 == 0)
      nl();
    if (findnext(&mrff) == -1)
      break;
    npr("%12.12s ", mrff.ff_name);
    if (inkey() == 32) {
      nl();
      break;
    }
  }
  nl();
  if (i == 1) {
    npr("One file found: %s\r\n", mrff.ff_name);
    outstr("Use this file? ");
    if (yn())
      return (path);
    else {
      path[0] = 0;
      return (path);
    }
  }
  path[t] = 0;
  outstr("Filename: ");
  mpl(12);
  input(s, 12);
  strcat(path, s);
  return (path);
}

Save <READMAIL.C>

*** Step Six ***

Open <MISCCMD.C>

Search for "void kill_old_email(void)" and add/modify the declarations:

==  int cur,max,i,i1,f,done,done1,forward;
=+  char s[161],s1[81],ch;   /* Expands the size of 's' and adds 's1' */
==  long l;
==  mailrec m, m1;
==  userrec u;
==  slrec ss;
++  filestatusrec fsr;
++  int f1, found;
++  long l1;
==
==  if (rip_on()) {

Search down about a hundred lines and add this chunk of code where indicated:

==        npr("%d ",i);
==        pl(get_string(506));
/* BEGIN BLOCK READ */
        if (m.status & status_file) {
          sprintf(s, "%sATTACH.DAT", syscfg.datadir);
          f1 = sh_open(s, O_RDONLY | O_BINARY, S_IREAD | S_IWRITE); /* B */
          if (f1 > -1) {
            found = 0;
            l1 = sh_read(f1, (void *)(&fsr), sizeof(fsr));
            while ((l1 > 0) && (!found)) {
              if (m.daten == fsr.id) {
                if (E_C)
                  sprintf(s, "%s2%s (%ld bytes)0",
                    get_string(659), fsr.filename, fsr.numbytes);
                else
                  sprintf(s, "File : %s (%ld bytes)",
                    fsr.filename, fsr.numbytes);
                pl(s);
                found = 1;
              }
              if (!found)
                l1 = sh_read(f1, (void *)(&fsr), sizeof(fsr));
            }
            if (!found)
              if (E_C) {
                sprintf(s, "%s2Unknown or missing0", get_string(659));
                pl(s);
              } else
                pl("File : Unknown or Missing");
            sh_close(f1);
          } else
            if (E_C) {
              sprintf(s, "%s2Unknown or missing0", get_string(659));
              pl(s);
            } else
              pl("File : Unknown or Missing");
        }
/* END BLOCK READ */
==        nl();
==        prt(2,get_string(507));
==        ch=onek("QRDN");

A few lines further down, delete case 'D' and replace it with this:

==          case 'D':
/* BEGIN BLOCK READ */
            done1=1;
            f=open_email(1);
            sh_lseek(f,((long) cur) * sizeof(mailrec), SEEK_SET);
            sh_read(f,(void *)&m1,sizeof(mailrec));
            if (memcmp(&m, &m1, sizeof(mailrec))==0) {
              delmail(f,cur);
              found = 0;
              if (m.status & status_file) {
                sprintf(s, "%sATTACH.DAT", syscfg.datadir);
                f1 = sh_open1(s, O_RDWR | O_BINARY);
                if (f1 > -1) {
                  l1 = sh_read(f1, (void *)(&fsr), sizeof(fsr));
                  while ((l1 > 0) && (!found)) {
                    if (m.daten == fsr.id) {
                      found = 1;
                      fsr.id = 0;
                      sh_lseek(f1, sizeof(filestatusrec) * -1L, SEEK_CUR);
                      sh_write(f1, (void *)(&fsr), sizeof(filestatusrec));
                      sprintf(s1, "%s%s", attach_dir, fsr.filename);
                      unlink(s1);
                    } else
                      l1 = sh_read(f1, (void *)(&fsr), sizeof(filestatusrec));
                  }
                  f1 = sh_close(f1);
                }
              }
              nl();
              if (found) {
                pl("Mail and file deleted.");
                nl();
                sprintf(s, "Deleted mail and attached file %s.",
                    fsr.filename);
                sysoplog(s);
              } else {
                pl(get_string(508));
                nl();
                sprintf(s1,get_stringx(1, 100),nam(&u,m1.touser));
                sysoplog(s1);
              }
            } else {
              pl(get_string(1174));
            }
            f=sh_close(f);
            break;
/* END BLOCK READ */
==          case 'R':

Save <MISCCMD.C>

** Step Seven **

Open <SYSOPF.C>

Search for "void mailr(void)" and add these to the declarations:

==  userrec u;
++  filestatusrec fsr;
++  int f1, found;
++  long l1;
++  char s[161],s1[81];
==
==  f=open_email(0);

Hop down a few lines and block read in this chunk of code:

==          set_net_num(nn);
==          outstr(get_string(326)); pl(m.title);
/* BEGIN BLOCK READ */
          if (m.status & status_file) {
            sprintf(s, "%sATTACH.DAT", syscfg.datadir);
            f1 = sh_open(s, O_RDONLY | O_BINARY, S_IREAD | S_IWRITE); /* B */
            if (f1 > -1) {
              found = 0;
              l1 = sh_read(f1, (void *)(&fsr), sizeof(fsr));
              while ((l1 > 0) && (!found)) {
                if (m.daten == fsr.id) {
                  if (E_C)
                    sprintf(s, "%s2%s (%ld bytes)0",
                      get_string(659), fsr.filename, fsr.numbytes);
                  else
                    sprintf(s, "File : %s (%ld bytes)",
                      fsr.filename, fsr.numbytes);
                  pl(s);
                  found = 1;
                }
                if (!found)
                  l1 = sh_read(f1, (void *)(&fsr), sizeof(fsr));
              }
              if (!found)
                if (E_C) {
                  sprintf(s, "%s2Unknown or missing0", get_string(659));
                  pl(s);
                } else
                  pl("File : Unknown or Missing");
              f1 = sh_close(f1);
            } else {
              if (E_C) {
                sprintf(s, "%s2Unknown or missing0", get_string(659));
                pl(s);
              } else
                pl("File : Unknown or Missing");
            }
          }
/* END BLOCK READ */
==          setorigin(m.fromsys, m.fromuser);
==          read_message1(&(m.msg),m.anony & 0x0f,1,&next,"EMAIL");

A few lines further down, modify this code (note the two changed lines before
and after the block read!)

==          if (c=='D') {
==            f=open_email(1);
==            sh_lseek(f,((long) (i)) * ((long) sizeof(mailrec)),SEEK_SET);
==            sh_read(f,(void *)&m1,sizeof(mailrec));
=+            if (memcmp(&m, &m1, sizeof(mailrec))==0) {/* CHANGE THIS LINE! */
==              delmail(f,i);
/* BEGIN BLOCK READ */
              found = 0;
              if (m.status & status_file) {
                sprintf(s, "%sATTACH.DAT", syscfg.datadir);
                f1 = sh_open1(s, O_RDWR | O_BINARY);
                if (f1 > -1) {
                  l1 = sh_read(f1, (void *)(&fsr), sizeof(fsr));
                  while ((l1 > 0) && (!found)) {
                    if (m.daten == fsr.id) {
                      found = 1;
                      fsr.id = 0;
                      sh_lseek(f1, sizeof(filestatusrec) * -1L, SEEK_CUR);
                      sh_write(f1, (void *)(&fsr), sizeof(filestatusrec));
                      sprintf(s1, "%s%s", attach_dir, fsr.filename);
                      unlink(s1);
                    } else
                      l1 = sh_read(f1, (void *)(&fsr), sizeof(filestatusrec));
                  }
                  f1 = sh_close(f1);
                }
              }
/* END BLOCK READ */
=+            } else       /* CHANGE THIS LINE! */
==              pl(get_string(1308));
==            f=sh_close(f);

Save <SYSOPF.C>

** Step Eight **

Open <MSGBASE.C>

Search for "void sendout_email(char *title, ..etc.. int fwd, int fnn)" and add
the following lines:

==      sysoplog(s1);
==      strcat(s,get_string(482));
==    }
++    if ((sy==0) && (actsl>syscfg.newusersl) && (ur.forwardsys==0)) {  /*C*/
++      nln(2);
++      prt(5,"Attach a file to this message? ");
++      if (yn())
++        attach_file(1);
++    }
==  } else {
==    if (net_num_max>1) {

Save <MSGBASE.C>

** Step Nine **

Open <XINIT.C>

Search for "void init(void)" and add the declaration near the top:

==void init(void)
=={
==  char *ss,s[161];
++  unsigned char olddir[81];
==  int i,i1,sm;
==  int f1,f2,f3,f4,f5,f6,f7, pk;
==#ifndef __OS2__

Hop down a couple hundred lines and add this code:

==  if (!read_ini_info()) {
==    printf("Insufficient memory for system info structure.\n");
==    end_bbs(noklevel);
==  }
/* BEGIN BLOCK READ */
  get_dir(olddir,1);

  attach_dir[0] = 0;
  if (ini_init("WWIV.INI", "WWIV", NULL) == 0) {
    if ((ss = ini_get("ATTACH_DIR", -1, NULL)) != NULL)
      if (ss)
        strcpy(attach_dir, ss);
    ini_done();
  }
  if (attach_dir[0] == 0)
    sprintf(attach_dir, "%sATTACHES\\", syscfg.datadir);
  strcpy(s, attach_dir);
  i = strlen(s);
  if (s[0] == 0)
    i1 = 1;
  else {
    if (s[i-1] != '\\') {
      attach_dir[i] = '\\';
      attach_dir[i+1] = 0;
    } else
      if (s[i-2] != ':')
        s[i-1]=0;
    i1=chdir(s);
  }

  if (i1) {
    cd_to(cdir);
    if (mkdir(s)) {
      printf("Unable to create attach directory: %s\r\n", attach_dir);
      getkey();
    }
  } else
    cd_to(cdir);
  cd_to(olddir);
/* END BLOCK READ */
==  net_networks=NULL;

Save <XINIT.C>

** Step Ten **

This is not necessary if you can/do use 'MAKE FCNS' from the commandline.

Open <FCNS.H>

Search for "/* File: readmail.c */" and prototype the new functions:

==void add_netsubscriber(unsigned short sn);
==void readmail(void);
++void attach_file(int mode);
++unsigned char *get_wildlist(char *s);

Save <FCNS.H>

** Last Step **

Open <WWIV.INI>

In the [WWIV] section, add the path for your directory to store attached
files, like:

==[WWIV]
++;
++; Directory for attached files
++;
++ATTACH_DIR      = C:\WWIV\ATTACH
==;
==; Default spawn options
==;
==;SPAWNOPT[TIMED]        = SHRINK, FILES                 ; for timed event

Save <WWIV.INI>

Recompile.  Update your menu to reflect the //ATTACH command, if you want.

Drop me a note to say you like (or hate) this mod so I make more!

