/*
**	Routines to parse Waffle configuration files (dirs or usenet)
**
**	Otto J. Makela <otto@jyu.fi>, Jyvaskyla, Finland, 1992
**	BBS V.32bis/HST +358 41 211 562
**	Distributed under the GNU General Public Licence:
**	see file COPYING for details
*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>
#include	"wafcfg.h"

	/* Local collection arrays for parsed tokens and values */
static int tokens=0;
static char *token[MAXTOKENS],*value[MAXTOKENS];

/*
**	Parse one line from configuration file into separate tokens and
**	their values; missing values are returned as NULL and separate
**	values (not under any /token) are parsed under "" tokens
*/
int parse_line(char *line)	{
	register char c;
	int quoted=0;

	for(token[tokens=0]=NULL; c=*line; line++)
		if(quoted)	{
			if(c==quoted)	{
				*line='\0';
				quoted=0;
			}
		} else if(c=='/')	{
			token[tokens]=line+1;
			value[tokens++]=NULL;
			token[tokens]=NULL;
		} else if((c=='=' || c==':') && tokens)	{
			*line='\0';
			value[tokens-1]=line+1;
		} else if(c=='"' || c=='\'')	{
			quoted=c;
			if(value[tokens-1]==line)
				value[tokens-1]++;
		} else if(c==';' || c=='#')	{
			*line='\0';
			break;
		} else if(isspace(c))
			*line='\0';
		else	{
			if(isupper(c)) *line=tolower(c);
			if(!tokens && !token[tokens])	{
				value[tokens++]=line;
				token[tokens]=NULL;
			}
		}

	return tokens;
}


/*
**	Return position of requested token (or NULL) in the token[]
**	array, or -1 if none
*/
int token_set(char *searched)	{
	register int i;

	for(i=0; i<tokens; i++)
		if(token[i]==searched || !strcmp(searched,token[i]))
			return i;
	return -1;
}


/*
**	Return value of requested token, or defvalue if it has no value
*/
char *token_value(char *searched,char *defvalue)	{
	register int i;

	if((i=token_set(searched))!=-1 && value[i])
		return value[i];
	return defvalue;
}


#ifdef	MAIN

/*
**	A test main program
*/

main(int argc,char *argv[])	{
	int line=0,loop;
	char *p,buffer[BUFSIZ];
	FILE *f;

	if(argc<2) argv[1]="/waffle/system/dirs";

	if(!(f=fopen(argv[1],"r")))	{
		perror(argv[1]);
		exit(1);
	}

	while(fgets(buffer,sizeof(buffer),f))	{
		printf("%u: %s",++line,buffer);
		if(!parse_line(buffer)) continue;
		printf("(%u)",tokens);
		if(p=token_value(NULL,NULL)) printf("\t\"%s\"\n",p);
		for(loop=0; loop<tokens; loop++)
			if(token[loop])
				printf(value[loop]?"\t/%s=\"%s\"\n":"\t/%s\n",
					token[loop],value[loop]);
	}

	printf("%s: %u lines\n",argv[1],line);
	fclose(f);
	exit(0);
}
#endif
