	page	60,132
;--------------------------------------------------------------------------
;
; TRAP  V1.2  -  break using alt-esc
;
; TRAP   is a resident program that uses ctrl-esc to go to debug if it
;        is loaded  else DOS is resarted and current program aborted.
;
; NOTE: When Alt-esc   is hit the hardware interrupts (below 20H) are
;	all reset to their values as of when the program was installed.
;	Therefore, if you are installing resident programs which steal
;	these interrupts they should be installed BEFORE this program.
;	This program steals int 09H and int 1BH.
;
;	Cntl-esc   resets the system timer to run at the normal rate,
;	and restores the video mode to the state it was in when EBREAK
;	was installed.
;
;-------------------------------------------------------------------------
;PURPOSE:  TRAP will recover from most computer failures when
;          interrupts are enabled.  Optionally, it will envoke DEBUG
;          if any breakpoints are set.  If DEBUG is not loaded the
;          current DOS process is aborted and DOS given control.
;
;          Programmers (or maybe just hackers) are always putting the
;          computer in an infinite loop somewhere, followed by a long
;          debug secession to find the problem.  TRAP will speed up
;          the process by aborting out of loops and jumping to DEBUG.
;
;          Another use for TRAP is to improve upon the DOS break key.
;          Sometimes the break key is disabled and not available
;          or the break logic isn't working.  In either case TRAP
;          will force a break and avoid the slow Ctrl-ALT-DEL option.
;
;USAGE:    TRAP is memory resident and should be loaded when the computer
;          is turned on or before a debugging scession.  It waits for
;          the keys  Alt-Esc using the following logic:
;
;          Alt-Esc
;          pressed? --yes--> debug   --yes--> simulate breakpoint.
;            |               present?         jump to DEBUG
;           no                 |
;            |                 no
;          exit                |
;                            abort current
;                            DOS process
;
;          The presense of DEBUG is detected by looking at the break interrupt
;          (interrupt 3) to see if any breaks are set.  Thus, any debugger
;          with a breakpoint set will work with TRAP.  The location of the
;          breakpoint is not important.  DEBUG will be passed the location
;          where the real break occured and will report that address.
;
;CAUTIONS: The break to DOS  restores all interrupt vectors and other
;          machine states at the point TRAP was loaded.  If other memory
;          resident programs are loaded after TRAP, they may be disabled.
;          It is important that TRAP be loaded as the last memory resident
;          program.
;
;          The break key can hang the system if it conflicts with another
;          memory resident program.  The origional TRAP used ctrl-esc which
;          conflicted with several resident pop ups.  If the new alt-esc
;          is a problem then location 104 can be patched as follows:
;                  08 -  alt-esc active
;                  04 -  ctrl-esc active
;                  02 -  right shift-esc active
;                  01 -  left shift-esc active
;                                                
;CREDITS:  TRAP was programmed by Jeff Owens using some material from public
;          domain programs EBREAK and BREAKPT.
;          
;
;          Comments, suggestions, complaints, or changes you have made would be
;          appreciated.  Jeff Owens kowens@teleport.com
;
;----------------------------------------------------------------------
;trap.com:    trap.obj
;            link trap;
;            exe2bin trap trap.com
;            del trap.exe
;
;trap.obj:    trap.asm
;            masm trap;
;------------------------------------------------------------------------
  
code	segment	para	public
	assume	cs:code

IntVecs	segment	at	0
	org	9 * 4
int_9		dd	?
	org	417H
KB_FLAG	DB	?
	org	449H
video_state	db	?
IntVecs	ends

	org	2Ch
environment	label	word
;
; the psp is used to hold variables as follows
;
	org	07cH
	
orig_int_tbl	db	80H dup(?)	; room for copy of int tbl
					; Note that table is on a double word
initial_mode	db	?		; initial video mode
int_mask	db	?		; original interrupts enabled

debug	label	dword
debug_offset 	dw	?
debug_segment	dw	?

;-------------------------------------------------------------------------
	org	100h
start:	jmp	setup
trigger_mask	db	08h		; enable key

	assume	ds:nothing, es:nothing

handle_9	proc	far		; grabs the code segment of
	push	ax
	push	ds	
        IN      AL,60H          ;CHECK SCAN CODE
        CMP     AL,01           ;IS IT END KEY?
        JNZ     no_break        ;NO, ON TO KEYBOARD ROUTINE
        XOR     AX,AX           ;CONTROL KEY SHIFT
        MOV     DS,AX           ;GET DOWN TO THE BOTTOM
        MOV     AL,BYTE PTR DS:KB_FLAG ;GET KEYBOARD FLAG BYTE FROM ROM DATA
        TEST    AL,cs:trigger_mask  ;alt? ctrl? etc
        jnz	ctrl_esc_found	;jump if ctrl_esc pressed
no_break:
	pop	ds
	pop	ax
	db	0eah
real_int_9  dd	?
        
;
; eat this key and re-enable the keyboard
;
ctrl_esc_found:
        IN      AL,61H          ;OTHERWISE, WE TAKE IT FROM HERE
        MOV     AH,AL           ;RESET
        OR      AL,80H          ;THE
        OUT     61H,AL          ;KEYBOARD
        MOV     AL,AH           ;CONTROL
        OUT     61H,AL          ;PORT
        CLI                     ;TURN OFF INTERRUPTS
        MOV     AL,20H          ;RESET INTERRUPT CONTROLLER (8259)
        OUT     20H,AL
        STI                     ;LET PENDING INTERRUPTS EXECUTE
;
; check if debug is active
;
	sub	ax,ax
	mov	ds,ax			;point at low ram
	mov	ax,cs			;get our segment
	cmp	word ptr ds:[0eh],ax	;check if debug has int 3
	jbe	no_debug		;jump if debug missing
;
; go to debug without desturbing the stack
;
	mov	ax,word ptr ds:[0ch]
	mov	cs:debug_offset,ax
	mov	ax,word ptr ds:[0eh]
	mov	cs:debug_segment,ax
        POP     DS
        POP     AX
;
; adjust the return address seen by debug
;
	push	bp
	mov	bp,sp
	inc	word ptr [bp+2]		;adjust the return address
	pop	bp
	       
        jmp	debug

no_debug:
	in	al,61H			; turn off sound
	jmp	short $+2
	and	al,0FCH
	out	61H,al

	mov	al,36H			; reset system timer
	out	43H,al
	xor	al,al
	jmp	short $+2
	out	40H,al
	jmp	short $+2
	out	40H,al

	mov	cx,40H			; restore int tbl
	push	cs
	pop	ds
	assume	ds:code
	xor	ax,ax
	mov	es,ax
	assume	es:IntVecs
	mov	di,ax
	mov	si,offset orig_int_tbl
	cli
	cld
	rep	movsw

	mov	al,int_mask		; restore enabled ints
	out	21H,al
	sti

	mov	al,initial_mode		; set video back to original
	cmp	video_state,al
	je	vid_ok
	xor	ah,ah
	int	10H
vid_ok:

	mov	ax,4C01h		; can we really do this?!!?
	int	21H			; YOW!
handle_9	endp
handler_end	label	byte


installing_msg	db	'TRAP V1.2 installed.',0dh,0ah
		db	'Alt-Esc will abort any program or call DEBUG if a breakpoint is set.'
		db	0dh,0ah
		db	'Written by Jeff Owens',
		db	 0Dh, 0Ah,'$'
	assume	ds:code, es:nothing
steal	proc	far
setup:
;	mov	es,environment		; free environment area
;	mov	ax,4900H
;	int	21H
;
; take over int9
;
	xor	ax,ax			; set up es to IntVecs
	mov	es,ax
	assume	es:IntVecs

	cli
	mov	bx,9*4			;vector address
	mov	ax,word ptr es:[bx]
	mov	word ptr real_int_9,ax
	mov	ax,word ptr es:[bx+2]
	mov	word ptr real_int_9+2,ax
	mov	word ptr es:[bx], offset handle_9
	mov	word ptr es:[bx+2],cs
	sti
;
; save interrupt vector state
;
	mov	cx,40H			; save int tbl
	push	cs
	pop	es
	assume	es:code
	xor	ax,ax
	mov	ds,ax
	assume	ds:IntVecs
	mov	si,ax
	mov	di,offset orig_int_tbl
	cld
	rep	movsw

	in	al,21H			; save enabled ints
	mov	int_mask,al

	mov	al,video_state		; save video mode
	mov	initial_mode,al

	push	cs
	pop	ds			; restore segment
	assume	ds:code
	mov	dx,offset installing_msg
	mov	ah,9
	int	21h
	mov	dx,offset handler_end
	int	27H			; terminate and stay resident
steal	endp

code	ends
	end	start
