;
; SHIFT.ASM - For the QuickBasic Toolbox
;             Integer Shifting Routines
;

SHIFT_TEXT      segment para public 'CODE'
		assume  cs:SHIFT_TEXT

		public  ishl,ishr,lshl,lshr

;
; ISHL Subprogram
;
ishl            proc    far
count           equ     <6[bp]>
intptr          equ     <8[bp]>
		push    bp              ;Save BP
		mov     bp,sp           ;Point it to the stack
		mov     bx,count        ;Get the shift
		mov     cl,[bx]         ; count into CL
		mov     bx,intptr       ;BX=Integer pointer
		shl     word ptr [bx],cl ;Shift the integer value
		pop     bp              ;Restore BP
		ret     4               ;Return and clean up the stack
ishl            endp


;
; ISHR Subprogram
;
ishr            proc    far
count           equ     <6[bp]>
intptr          equ     <8[bp]>
		push    bp              ;Save BP
		mov     bp,sp           ;Point it to the stack
		mov     bx,count        ;Get the shift
		mov     cl,[bx]         ; count into CL
		mov     bx,intptr       ;BX=Integer pointer
		shr     word ptr [bx],cl ;Shift the integer value
		pop     bp              ;Restore BP
		ret     4               ;Return and clean up the stack
ishr            endp

;
; LSHL Subprogram
;
lshl            proc    far
count           equ     <6[bp]>
intptr          equ     <8[bp]>
		push    bp              ;Save BP
		mov     bp,sp           ;Point it to the stack
		mov     bx,count        ;Get the shift
		mov     cx,[bx]         ; count into CX
		jcxz    lshl2           ;Jump if zero count
		mov     bx,intptr       ;BX=Long integer pointer
lshl1:          shl     word ptr [bx],1 ;Shift the LSW
		rcl     word ptr 2[bx],1 ;Shift the MSW
		loop    lshl1           ;Loop till done
lshl2:          pop     bp              ;Restore BP
		ret     4               ;Return and clean up the stack
lshl            endp

;
; LSHR Subprogram
;
lshr            proc    far
count           equ     <6[bp]>
intptr          equ     <8[bp]>
		push    bp              ;Save BP
		mov     bp,sp           ;Point it to the stack
		mov     bx,count        ;Get the shift
		mov     cx,[bx]         ; count into CX
		jcxz    lshr2           ;Jump if zero count
		mov     bx,intptr       ;BX=Long integer pointer
lshr1:          shr     word ptr 2[bx],1 ;Shift the MSW
		rcr     word ptr [bx],1 ;Shift the LSW
		loop    lshr1           ;Loop till done
lshr2:          pop     bp              ;Restore BP
		ret     4               ;Return and clean up the stack
lshr            endp

SHIFT_TEXT      ends

		end
