;; MASM code demonstrating how to navigate through all the
;; subdirectories on an MS-DOS-formatted disk.  This sample
;; COM program lists every file containing neither hidden
;; nor system attributes on the current drive.
;;
;; To assemble, link, and convert to COM format, type:
;;      MASM RDIR;
;;      LINK RDIR;
;;      EXE2BIN RDIR RDIR.COM
 
FFName          equ     byte ptr [bp+30]        ;File name in DTA
FFAttr          equ     byte ptr [bp+21]        ;File attribute in DTA
IsDirectory     equ     10h                     ;Subdirectory attribute
LocalAlloc      equ     2Ch                     ;Local stack allocation
 
code            segment
                assume  cs:code,ds:code
                org     100h
begin:          jmp     Main
 
FileName        db      128 dup (?)
Directory       db      "\",64 dup (?)
StarDotStar     db      "*.*",0
UpOneLevel      db      "..",0
RootDir         db      "\",0
crlf            db      13,10,"$"
 
;; Main saves the current directory, switches to the root directory,
;; calls the procedure Searchdir, and then restores the current directory.
Main            proc    near
                cld                             ;Clear direction flag
                mov     ah,47h                  ;Save the current directory
                xor     dl,dl
                mov     si,offset Directory+1
                int     21h
 
                mov     ah,3Bh                  ;Change to the root directory
                mov     dx,offset RootDir
                int     21h
 
                call    SearchDir               ;List all the files
 
                mov     ah,3Bh                  ;Restore the directory that
                mov     dx,offset Directory     ;was current when we started
                int     21h
 
                mov     ax,4C00h                ;Exit
                int     21h
Main            endp
 
;; SearchDir lists all the files in the current directory, then calls
;; itself recursively to list files in descendant directories.
 
SearchDir       proc    near
                push    bp                      ;Save BP
                mov     ah,2Fh                  ;Get DTA address
                int     21h
                push    bx                      ;Save it on the stack
                push    es
                sub     sp,LocalAlloc           ;Allocate stack space
                mov     bp,sp                   ;Stack pointer in BP
                mov     ah,1Ah                  ;Change DTA to location
                mov     dx,bp                   ;on the stack
                int     21h
; List all the files in the current directory.
                mov     ah,4Eh                  ;Find first file
                xor     cx,cx
                mov     dx,offset StarDotStar
                int     21h
                jc      FindFirstDir            ;Branch if none found
 
ListFile:       mov     ah,60h                  ;Add the drive and path to
                mov     si,bp                   ;the file name by calling
                add     si,30                   ;undocumented MS-DOS
                mov     di,offset FileName      ;function 60h
                int     21h
 
                xor     al,al                   ;Convert the ASCIIZ file
                mov     cx,128                  ;name to one delimited by
                mov     di,offset FileName      ;a dollar sign
                repne   scasb
                mov     byte ptr [di-1],"$"
 
                mov     ah,09h                  ;Display the file name
                mov     dx,offset FileName      ;by calling MS-DOS
                int     21h                     ;function 09h
 
                mov     ah,09h                  ;Move the cursor to the
                mov     dx,offset crlf          ;next line
                int     21h
 
                mov     ah,4Fh                  ;Find next file and display
                int     21h                     ;the file name if the search
                jnc     ListFile                ;was successful
; Now search for descendants of the current directory.  If found, change
; to each subdirectory in turn and call SearchDir recursively.
FindFirstDir:   mov     ah,4Eh                  ;Find first subdirectory
                mov     cx,17h
                mov     dx,offset StarDotStar
                int     21h
                jc      SearchDirExit           ;Branch if none found
 
TestEntry:      cmp     FFName,"."              ;Skip "." and .." entries
                je      FindNextDir
                test    FFAttr,IsDirectory      ;Branch if its not a
                jz      FindNextDir             ;subdirectory name
 
                mov     ah,3Bh                  ;Change to the directory
                mov     dx,bp                   ;whose name was just
                add     dx,30                   ;returned
                int     21h
 
                call    SearchDir               ;List the files in it
 
                mov     ah,3Bh                  ;Return to the parent
                mov     dx,offset UpOneLevel    ;directory
                int     21h
 
FindNextDir:    mov     ah,4Fh                  ;Find next subdirectory
                int     21h
                jnc     TestEntry
; Clean up the stack, restore the DTA address, and exit.
SearchDirExit:  add     sp,LocalAlloc           ;Deallocate stack space
                mov     bx,ds                   ;Save DS in BX
                mov     ah,1Ah                  ;Restore the DTA address
                pop     ds
                pop     dx
                int     21h
                mov     ds,bx                   ;Restore DS from BX
                pop     bp                      ;Restore BP
                ret
SearchDir       endp
 
code            ends
                end     begin
