; 
; This code creates a debug abort key which will transfer control
; back to most debug programs.  Hitting the '5' key forces an
; int 3 (debug breakpoint).
;
; By Garrett P. Nievin
;
; To add a hardware breakout switch just put a switch between
; pins 17 (NMI) and 40 (+5V) on your 8088 chip, and a switch between
; pins 21 (RESET) and 40 will do a system reset/reboot.)
;
; This is a .COM program

code    segment para public 'code'
        assume cs:code,ds:nothing,es:nothing
        org     0100h

hotkey  equ     4ch         ; scan code for hot key = "5" on keypad
portA   equ     60h         ; 8255A port A, usually keybd scan code
portB   equ     61h         ; 8255A port B, various switches
release equ     80h         ; hi bit in scan code means key release
hibiton equ     80h         ; hi bit in byte for or'ing in
hbitoff equ     7fh         ; hi bit in byte for and'ing out

start   proc    far
begcode:
    jmp  implant            ; jump around interrupt handler code
begres:                     ; area to remain core resident

rescode  proc               ; keystroke causes jump to here
    jmp  over               ; jump over memory signature
    db  'bcGN'              ; program signature in memory
over:                       ;
    sti                     ; allow interrupts
    push ax                 ; save that register
    in   al,portA           ; get keyboard scan code
    cmp  al,hotkey          ; hotkey?
    jne  normal             ; yes, go hanlit
    push dx                 ; save register
    mov  dx,0020h           ; port 20h = PIC port to send EOI to
    mov  al,dl              ; 20h turns on EOI bit
    out  dx,al              ; tell interrupt controller we be done
    pop  dx                 ; restore register
    in   al,portB           ; get portB
    or   al,hibiton         ; set acknowledge / clear keyboard bit
    out  portB,al           ; and out it again
    and  al,hbitoff         ; clear ack bit
    out  portB,al           ; out that, enabling keyboard again
    pop  ax                 ; restore original register
    int  3                  ;
    iret                    ;

normal:                     ;
    pop  ax                 ; restore that register
    jmp  dword ptr cs:oldint9    ; goto old int9 handler
oldint9  dw  0,0            ; doubleword value of old int9 vector
rescode  endp

endres:                     ; end of core res area

reslen  equ endres - begres           ; length of new resident code
strtres equ begres - begcode + 100h   ; start of resident code
psplen  equ 5ch                       ; length of necessary PSP

implant:                    ; code to put new int 9 front end in core
    mov  ax,3509h           ; get int vector function
    int  21h                ; get vector of interrupt 9 handler
    cmp  es:[bx+3],'cb'     ; already loaded?
    jne  fresh              ; nope, go install
    cmp  es:[bx+5],'NG'     ; make sure
    jne  fresh              ; naaah, go install
    lea  dx,cs:stalemsg     ; DX points to already installed message
    mov  ah,09h             ; DOS display string func
    int  21h                ; go display message
    mov  ax,4cffh           ; terminate with code = 0xff
    int  21h                ;
        
fresh:
    lea  dx,cs:instlmsg     ; DX points to installation message
    mov  ah,09h             ; display string function
    int  21h                ; give the user the poop
    mov  ax,3509h           ; get int vector function
    int  21h                ; get vector of old interrupt 9 handler
    mov  oldint9,bx         ; int location in ES:BX, save it
    mov  oldint9+2,es       ; "
    mov  ax,2509h           ; set new interrupt 9 vector to me
    mov  dx,offset rescode  ; address of which is in DX
    int  21h                ; go do it
    push cs                 ; DS and ES both end
    pop  es                 ; up pointing at
    push cs                 ; code area
    pop  ds                 ; "
    mov  di,psplen          ; where program will end up
    mov  si,strtres         ; start of resident code
    mov  cx,reslen          ; amount of resident code to move
    cld                     ; go forward in move
    rep  movsb              ; move code back in mem
    mov  dx,psplen + reslen ; DX pointing to next free paragraph
    mov  ax,3100h           ; keep, return code of 0
    int  21h                ; terminate
stalemsg db 'Bugout already resident.',10,13,7,'$'
instlmsg db 'Bugout loaded and active, keypad-5 is break key.',10,13,'$'
start    endp
code     ends
    end  start
