%
%
%                           Areafix Revision 1.30
%
%                      Originally written by Greg Dawson
%
%            (C) Copyright 1988-91 by Greg Dawson and George Peace.
%                            All Rights Reserved.
%
%
% *---------------------------------------------------------------------------*
% *                      SYSTEM CONFIGURATION INFORMATION                     *
% *---------------------------------------------------------------------------*
% *-----------------------------------------*
% * Your primary matrix address (with zone) * Limit: 1
% *-----------------------------------------*
%
  Address 1:13/13
%
%
% *-----------------------------------------*
% * Additional 'aka' addresses.             * Limit: 255
% *-----------------------------------------*
%
% Address 1:270/101
%
%
% *-----------------------------------------*
% * Zone / Net assumption                   * Limit: 1
% * Tells Areafix to try to match remote    *
% * address to an Aka ZONE or zone+NET      *
% *-----------------------------------------*
%
% Assume  ZONE
% Assume  NET
%
%
% *-----------------------------------------*
% * Private (point) network number          * Limit: 1
% * Don't use this if operating in full 4D  *
% *-----------------------------------------*
%
% PointNet 30500
%
%
% *-----------------------------------------*
% * Net mail path.                          * Limit: 1
% *-----------------------------------------*
%
  NetMail C:\Net\Mail
%
%
% *-----------------------------------------*
% * Additional message paths to scan.       * Limit: 3
% * Required for NewAreasCreate when tosser *
% * places unknown areas in special subdir. *
% *-----------------------------------------*
%
% ScanPath  V:\Bad_Msgs
%
%
% *-----------------------------------------*
% * EchoMail control file.                  * Limit: 10 (or 2048 total areas)
% *-----------------------------------------*
%
  AreasFile  C:\Opus\Areas.Bbs
%
%
% *-----------------------------------------*
% * Type of EchoMail software.              * Limit: 1
% * Defines echomail control file format.   *
% *-----------------------------------------*
%
  SystemType   ConfMail
% SystemType   QM
% SystemType   Opus
% SystemType   QuickBBS
% SystemType   Squish
%
%
% *-----------------------------------------*
% * Your name.                              *
% *-----------------------------------------*
%
% Sysop  Rodney Dangerfield
%
%
% *-----------------------------------------*
% * The log file.                           * Limit: 1
% *-----------------------------------------*
%
  LogFile  C:\Log\Areafix.Log
%
%
% *-----------------------------------------*
% * Log all command line changes.           *
% *-----------------------------------------*
%
  LogAllChanges
%
%
% *-----------------------------------------*
% * Sort the nodes on any new entries.      *
% *-----------------------------------------*
%
% SortNodes
%
%
% *-----------------------------------------*
% * Format of nodes on new/changed entries. *
% * Short - abbreviate entries              *
% * Long  - full zone:net/node on entries   *
% * Zone  - zone: on first entry            *
% * If the command is not provided all      *
% * entries will default to net/node. Zone  *
% * will only be added when different from  *
% * primary or previous.                    *
% *-----------------------------------------*
%
% Format Short
% Format Long
% Format Zone
%
%
% *-----------------------------------------*
% * One word alias names to look under.     * Limit: 10
% * 35 characters max per one-word alias.   *
% *-----------------------------------------*
%
  Alias  AutoEcho
  Alias  AutoFix
%
%
% *-----------------------------------------*
% * Activate file sharing protection.       *
% * When enabled all files except           *
% * Areafix.Ctl are opened DENYNO           *
% *-----------------------------------------*
%
% FileShare
%
%
%
% *---------------------------------------------------------------------------*
% *                  AUTOMATIC CREATION OF NEW ECHOMAIL AREAS                 *
% *---------------------------------------------------------------------------*
% *-----------------------------------------*
% * Allow processing of new echo areas.     *
% *-----------------------------------------*
%
% NewAreasProcess
%
%
% *-----------------------------------------*
% * Message subdirectory for new areas.     * Limit: 1
% *-----------------------------------------*
%
% NewAreasPath    D:\Msg\
%
%
% *-----------------------------------------*
% * Don't create subdirectory for new areas *
% *-----------------------------------------*
%
% NewAreasNoDir
%
%
% *-----------------------------------------*
% * Don't make new areas passthru (no #)    *
% *-----------------------------------------*
%
% NewAreasNoPassthru
%
%
% *-----------------------------------------*
% * For Opus/QuickBBS - new area number.    *
% *-----------------------------------------*
%
% NewAreaNumber P
%
%
% *-----------------------------------------*
% * Nodes to add for new areas.             * Limit: 255 on 1 line
% *-----------------------------------------*
%
% NewAreasNodes   1/217 12/12 13/13 124/4115 396/1
%
%
% *-----------------------------------------*
% * Only allow these nodes to create areas: * Limit: 255 on 1 line
% *-----------------------------------------*
%
% NewAreasCreate 13/13 396/1
%
%
%
% *---------------------------------------------------------------------------*
% *                  AUTOMATIC DELETION OF IDLE ECHOMAIL AREAS                *
% *---------------------------------------------------------------------------*
% *-----------------------------------------*
% * Allow purge of idle passthru echo areas * 
% *-----------------------------------------*
%
% PurgeAreas
%
%
% *-----------------------------------------*
% * Allow purge of idle echo areas.         *
% *-----------------------------------------*
%
% PurgeFile Areafix.Del
%
%
% *-----------------------------------------*
% * Remove purged message directories.      * 
% *-----------------------------------------*
%
% PurgeRemove
%
%
%
% *---------------------------------------------------------------------------*
% *                        SYSTEM PROTECTION INFORMATION                      *
% *---------------------------------------------------------------------------*
% *-----------------------------------------*
% * Default protection KEY for nodes.       *
% *-----------------------------------------*
%
  KeyDefault ?*
%
%
% *-----------------------------------------*
% * Passwords.                              * Limit: no fixed limit
% *                                         *
% *  Key definitions:                       *
% *                                         *
% *   A-Z 0-5 32 key bits                   *
% *   -  Do not use defaults for this node  *
% *   .  Assign defaults to this node       *
% *   +  List key/priv values in responses  *
% *   ~  Allow remote deletions from node   *
% *   @  Allow deletion forwarding to node  *
% *   ?  Forward area add requests          *
% *   *  Purge dead-end area with this feed *
% *   &  Allow this address to create areas *
% *   #  Add this address to new areas      *
% *   $  Always add active area list to msg *
% *                                         *
% *-----------------------------------------*
%
%           Net/Node  Password  Level  Key ( A-Z 0-5 etc )  Sysop Name
% --------  -------   --------  -----  -------------------  ----------
% Password  13/13     Happy        99  ABCDEFGH35~@?#
% Password  270/102   HolyMoly      5  .                    My Name_Jr
% Password  163/115   Tree         99  AFIGREGPROTOSOFT&+*
%
%
% *-----------------------------------------*
% * Default protection LEVEL for areas.     *
% *-----------------------------------------*
%
  ProtectDefault 0
%
%
% *-----------------------------------------*
% * Default protection LOCK for areas.      *
% *-----------------------------------------*
%
  LockDefault 
%
%
% *-----------------------------------------*
% * Protected areas.                        * Limit: no fixed limit
% *-----------------------------------------*
%
%          Area              Level  Lock
% -------  ----------------  -----  ----
% Protect  ECHODIST             80  
% Protect  COORD                50  
% Protect  QM_BETA             100  GREG
%
%
%
% *---------------------------------------------------------------------------*
% *                     USER SUBJECT LINE SWITCH OVERRIDES                    *
% *---------------------------------------------------------------------------*
% *-----------------------------------------*
% * Attach file.  '-l'                      * Limit: 1
% *-----------------------------------------*
%
% Echo_List  C:\Opus\Filereq\Echo_270.*
%
%
% *-----------------------------------------*
% * To disallow user rescans.  '-r'         *
% *-----------------------------------------*
%
% NoRescan
%
%
% *-----------------------------------------*
% * To disallow Query requests. '-q'        *
% *-----------------------------------------*
%
% NoQuery
%
%
% *-----------------------------------------*
% * To enable rescans w/QuickBBS & FastFwd. * Limit: 1
% *-----------------------------------------*
%
% QuickBBSRescanList  Fastfwd.bat
%
%
% *-----------------------------------------*
% * To enable rescans w/other formats.      * Limit: 1
% *-----------------------------------------*
%
% RescanList  ReScan.Bat ReScan
%
%
% *-----------------------------------------*
% * Controls format of RescanList address.  * Limit: 1
% *   List: zone net node point             *
% * String: zone:net/node.point             *
% *-----------------------------------------*
%
% RescanListAddress List
% RescanListAddress String
%
%
%
% *---------------------------------------------------------------------------*
% *                       RETURN MESSAGE CUSTOMIZING                          *
% *---------------------------------------------------------------------------*
% *-----------------------------------------*
% * To show feeds on return messages.       *
% *-----------------------------------------*
%
  ShowFeeds
%
%
% *-----------------------------------------*
% * Save processed msgs, mark Recv'd.       *
% *-----------------------------------------*
%
  SaveProcessedMsgs
%
%
% *-----------------------------------------*
% * Mark return messages as Kill/Sent.      *
% *-----------------------------------------*
%
% KillSent
%
%
% *-----------------------------------------*
% * Force ^AINTL lines on all return msgs.  *
% *-----------------------------------------*
%
% ForceIntl
%
%
% *-----------------------------------------*
% * Send a copy of return messages to:      * Limit: 1
% *-----------------------------------------*
%
% AlertNode 270/102
%
%
% *-----------------------------------------*
% * Turns off the list of active areas in   *
% * netmail replies.                        *
% * Overrides available via -L switch and $ *
% * Password flag.                          *
% *-----------------------------------------*
%
% No_Response_List
%
%
%
% *---------------------------------------------------------------------------*
% *                      'NOTIFY' FUNCTION INFORMATION                        *
% *---------------------------------------------------------------------------*
% *-----------------------------------------*
% * Substitute 'Notify' header file.        *
% * Override available via -N switch.       *
% *-----------------------------------------*
%
% NotifyHeader C:\Opus\Notify.Txt
%
%
% *-----------------------------------------*
% * Nodes to exclude from a 'Notify'.       * Limit: 64
% *-----------------------------------------*
%
% NotifyExclude  270/1 0 9999/1 2 3
%
%
% *-----------------------------------------*
% * To attach the 'EchoList'.               *
% *-----------------------------------------*
%
% NotifyWithEchoList
%
%
% *-----------------------------------------*
% * Turns off the list of active areas in   *
% * notify messages.                        *
% * Overrides available via -L switch and $ *
% * Password flag.                          *
% *-----------------------------------------*
%
% No_Notify_List
%
%
%
% *---------------------------------------------------------------------------*
% *                       REMOTE DELETION CONFIGURATION                       *
% *---------------------------------------------------------------------------*
%
% Note: Please see the documentation before enabling these options!
%
%
% *-----------------------------------------*
% * Send a notice to the affected nodes.    *
% *-----------------------------------------*
%
% RemoteDeletionNotify
%
%
% *-----------------------------------------*
% * Send AutoDelete requests to affected    *
% * downlink nodes.                         *
% * This is a Global switch. Actual         *
% * forwarding is controlled on a node-by-  *
% * node basis according to privilege flags.*
% * To entirely disable forwarding leave    *
% * commented out.                          *
% *-----------------------------------------*
%
% RemoteDeletionForward
%
%
% *-----------------------------------------*
% * Remove deleted message directories.     *
% *-----------------------------------------*
%
% RemoteDeletionRemove
%
%
% *-----------------------------------------*
% * To enable remote area maintainence in   * Limit: 255 nodes
% * in a more secure environment.           *
% * This is independent of ~areaname        *
% * remote deletions which are controlled   *
% * on a node-by-node basis. (see Password) *
% *-----------------------------------------*
%
%                 Net/Node:     Message to:  Password (subj):
% --------------  ------------  -----------  ----------------
% RemoteDeletion  163/115       HubbaBubba   dingdong
% RemoteDeletion  124/4115      HubbaBubba   pingpong
% RemoteDeletion  396/1         BigCheese    BackBone
%
%
%
% *---------------------------------------------------------------------------*
% *                           ECHO REQUEST FORWARDING                         *
% *---------------------------------------------------------------------------*
% *-----------------------------------------*
% * Forward request lists.                  * Limit: 255
% *-----------------------------------------*
%
% Valid formats: ConfMail, QMail, Opus, QuickBBS, or Text.
%
%
%               List file:               Format:  Net/Node:  Password:  From:
% ------------  -----------------------  -------  ---------  ---------  -----
% Forward_List  C:\Echoctl\Backbone.Bbs  QMail    13/13      Teepee     
% Forward_List  C:\Echoctl\EastStar.Lst  Text     265/7      Mold       13:1/200
%
%
% *-----------------------------------------*
% * Request que file.                       *
% *-----------------------------------------*
%
% Forward_Que  Areafix.Que
%
%
%                         ** End of control file **
