/*
 * ALLFIX v4.41 WPfolder Installation Program copyright (c) 1995, 1996
 * by Scott Drake of Innovative Solutions 1:2630/212
 *
 * This program creates a folder to hold program objects for ALLFIX, then
 * creates program objects for each executable.  It only needs to be run once
 * (unless you move the ALLFIX directory -- see say notes at end).  Run
 * this program in the ALLFIX directory (where you unpacked the archive).
 */

/* see if we might be in the right directory... */

'@Echo off'
'cls'

say ''
say ''
say '[0;1;34;44m[0;30;44m[40m'
say '[1;34;44m [0;30;44m [40m'
say '[1;34;44m                 [33mALLFIX v4.41 WPfolder Installation Program               [0;30;44m [40m'
say '[1;34;44m                   [36mCopyright (c) 1995, 1997 by [31mScott Drake                [0;30;44m [40m'
say '[1;34;44m   [33mALLFIX v4.41 [36mis Copyrighted (c) 1992-97 by [31mHarms Software Engineering  [0;30;44m [40m'
say '[1;34;44m                            [36mAll rights reserved                           [0;30;44m [40m'
say '[1;34;44m [0;30;44m [40m'
say '[1;34;44m [0;30;44m[1;34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m          [1;37mHave you read the ALLFIX.DOC or ALLFIX.INF file yet?           [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m           [1;37mBy running this program, you agree to the license             [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m                       [1;37mas specified in that file,                        [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m      [1;37mand it tells you how to install ALLFIX, so you should read it.     [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m                                 [1;37mPlease?                                 [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m[1;34m [0;30;44m[40m'
say '[1;34;44m[0;30;44m[0m'
say ''
say ''

/*
 * allow user to eliminate associations from being placed on AV/2.
 * seemed to upset some fellow on CIS (I guess he doesn't know about
 * Settings notebooks on WPS objects).
 */
assocfilter = ';ASSOCFILTER=*.ZIP,*.ARC,*.LZH,*.ARJ,*.ZOO,*.MO0,READ.ME,README,README.1ST,README.OS2,REGISTER.TXT'
existed = ''
parse upper arg dummy
if dummy = 'NOASSOC' then assocfilter = ''

rc = stream('allfix.exe','c','query exists')
if rc = '' then
do
  say '[0;1;31mSorry, ALLFIX.EXE not found.  Must not be the right directory.  Terminating.[0m'
  exit
end

/* tell user what we're doing, give him a chance to hit CTRL-C */

say '     [1;33mThis program creates Desktop objects for ALLFIX. If you do not want'
say '     [1;33mcreate the Desktop Objects, just press CTRL + C then press Enter.'
say ''



say '     [0;1;35mOtherwise Press [Enter] to continue with the Installation...[0m'
pull dummy .
say ''


/* save current directory */

curdir = directory()

/* load rexx utility functions */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* say it, then do it */

'cls'
say "        [0;1;5;31mCreating The ALLFIX FileEcho Processor folder and objects...[0m"
say '[0;1;34;44m[0;30;44m[40m'
say '[1;34;44m [0;30;44m [40m'
say '[1;34;44m                            [33mALLFIX for DOS v4.41                          [0;30;44m [40m'
say '[1;34;44m  [36mALLFIX is the most complete FileEcho utility available. No other program[0;30;44m [40m'
say '[1;34;44m  [36moffers the large number of features that are part of the ALLFIX package.[0;30;44m [40m'
say '[1;34;44m [0;30;44m [40m'
say '[1;34;44m [0;30;44m[1;34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37mFull support for more than 22 BBS different BBS programs              [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37mFull support for Zones and 4D points.                                 [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37mSupport for domains (5D addressing).                                  [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37mAbility to disable sending a TIC file.                                [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37mAbility to put all of the TIC files with or without the accompanying  [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37marchive into one archive.                                             [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37mALLFIX uses the FD/RA HMB sharing spec.                               [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37mDirect support for the HMB, *.MSG, Squish, PCBoard, Ezycom msg-base,  [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37mand the .PKT interface.                                               [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37mSupport for multiple compression formats.                             [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37mUser friendly setup program. ALLFIX does not require any configuration[34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37mfiles used by any other program.                                      [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37mWrites FD/DBridge/RA/SBBS/BinkleyTerm/PoP compatible log file.        [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m [1;31m* [1;37mVery HIGH quality performance, Very LOW registration fee.             [34m [0;30;44m[40m'
say '[1;34;44m [0;30;44m[1;34m [0;30;44m[40m'
say '[1;34;44m[0;30;44m[0m'

/* first, create ALLFIX folder */

rc = stream('affldr.ico','c','query exists')
title = "ALLFIX FileEcho^ Processor"
classname = 'WPFolder'
location = '<WP_DESKTOP>'
setup = 'OBJECTID=<Allfix_Folder>;OPEN=DEFAULT'
if rc \= '' then setup = setup';ICONFILE='rc
result=SysCreateObject(classname,title,location,setup,r)

/* Check to see if the ALLFIX Folder already exists... */
if result = 0 then
do
  assocfilter = ''
  existed = 'TRUE'
  say ''
  say '[0;1;31mThe ALLFIX FileEcho Processor folder already exists.'
  say '[33mShould I update the objects? (Y/n)[0m'
  parse upper pull dummy
  if left(dummy,1) = 'N' then exit
  say ''
end

/* now, create program objects in ALLFIX folder */

title = "ALLFIX v4.41^ FileEcho Processor"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'PROGTYPE=VDM;OBJECTID=<ALLFIX v4.41>;EXENAME='curdir'\ALLFIX.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

title = "ALLFIX v4.41^ Configuration"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'PROGTYPE=VDM;OBJECTID=<ALLFIX Configuration>;EXENAME='curdir'\ASETUP.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

title = "ALLFIX v4.41^ File Hatch"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'PROGTYPE=VDM;OBJECTID=<ALLFIX v4.41 File Hatch>;EXENAME='curdir'\HATCH.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

title = "ALLFIX v4.41^ Fix Utility"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'PROGTYPE=VDM;OBJECTID=<ALLFIX Utility>;EXENAME='curdir'\FIXUTIL.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

title = "ALLFIX v4.41^ Update Utility"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'PROGTYPE=VDM;OBJECTID=<ALLFIX Update Utility>;EXENAME='curdir'\UPDATE.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

title = "ALLFIX v4.41^ File Area Compilier"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'PROGTYPE=VDM;OBJECTID=<ALLFIX v4.41 File Area Compilier>;EXENAME='curdir'\FCOMP.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

title = "ALLFIX v4.41^ Cookie Baker"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'PROGTYPE=VDM;OBJECTID=<ALLFIX v4.41^ Cookie Baker>;EXENAME='curdir'\BAKE.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=COOKIE.TXT COOKIE.DAT'
call SysCreateObject classname,title,location,setup,u


rc = stream('cookie.ico','c','query exists')
title = "COOKIE.TXT"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'PROGTYPE=VDM;OBJECTID=<ALLFIX v4.41^COOKIE.TXT>;EXENAME=e.exe;PARAMETERS='curdir'\cookie.txt;STARTUPDIR='curdir
if rc \= '' then setup = setup';ICONFILE='rc
call SysCreateObject classname,title,location,setup,u

rc = stream('whatsnew.ico','c','query exists')
title = "WHATSNEW.DOC"
classname = 'WPProgram'
location = '<Allfix_Folder>'
setup = 'PROGTYPE=VDM;OBJECTID=<ALLFIX v4.41^Whats New!>;EXENAME=e.exe;PARAMETERS='curdir'\whatsnew.doc;STARTUPDIR='curdir
if rc \= '' then setup = setup';ICONFILE='rc
call SysCreateObject classname,title,location,setup,u

rc = stream('afdoc.ico','c','query exists')
if rc \= '' then
do
title = "ALLFIX v4.41^ Text Doc's"
classname = 'WPProgram'
location = '<Allfix_Folder>'
  setup = 'PROGTYPE=VDM;OBJECTID=<ALLFIX v4.41 Documentation>;EXENAME=e.exe;PARAMETERS='curdir'\allfix.doc;STARTUPDIR='curdir
if rc \='' then setup = setup';ICONFILE='rc
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('af2inf.ico','c','query exists')
if rc \= '' then
do
  title = "ALLFIX v4.41^ INF Doc's"
  classname = 'WPProgram'
  location = '<Allfix_Folder>'
  setup = 'PROGTYPE=VDM;OBJECTID=<ALLFIX v4.41 OS/2 Documentation>;EXENAME=view.exe;PARAMETERS='curdir'\allfix.inf;STARTUPDIR='curdir
if rc \='' then setup = setup';ICONFILE='rc
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('UPGRADE.LOG','c','query exists')
if rc \= '' then
do
  title = "UPGRADE.LOG"
  classname = 'WPShadow'
  location = '<Allfix_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

/* Final words */
'cls'

say ''
say ''
say ''
say ''
say ''
say '[0;30m [1;34;44m[40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m  [36mIf you find a need to move ALLFIX to a different Directory, delete the  [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m   [36mALLFIX Desktop folder and re-run INSTALL in the New ALLFIX Directory.  [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m [0;30;44m[1;34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m          [1;37mI am now done Installing the ALLFIX Desktop Folder!            [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m [1;37mPlease be sure to check all the settings for each program, as a default [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m    [1;37mall programs will be opened in a DOS Window instead of a DOS Full    [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m [1;37mScreen. Also be sure to check the parameters on such programs as Fcomp  [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m                                                                         [1;34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m   [1;31mIf you havent Registered ALLFIX yet,  please remember to do so soon.  [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m[1;34m [40m'
say '[A[79C[0;30;44m[1C[1;34m[0;30;44m[40m'
say '[A[79C[44m[0m'


