/*--------------------------------------------------------------------------*/
/*                                 AFCALCW.C                                */
/*--------------------------------------------------------------------------*/
/*                  Antenna Factor Calculator for Windows                   */
/*                               Version 1.00                               */
/*                         Written by James Eagleson                        */
/*                          Copyright - August 1995                         */
/*--------------------------------------------------------------------------*/
/* j. eagleson, WB6JNN                                                      */
/* First Release: Version 1.00,  August 1, 1995                             */
/* ------------------------------------------------------------------------ */



#include <stdio.h>
#include <conio.h>
#include <math.h>

/* FUNCTIONS */

int menu_select(void);
int af_to_gain(void);
int gain_to_af(void);

/* VARIABLES */

char ch;

int item;
int pause;

double ga_dbi;
double ga_ratio;
double frequency;
double ant_factor;


int main()
{

	clrscr();

	while(ch!='q')
	{


		if(ch=='1')
		{
			gain_to_af();
		}

		if(ch=='2')
		{
			af_to_gain();
		}

		menu_select();

	}

	clrscr();

return(0);
} /* END OF MAIN() */




/***************************  MENU_SELECT()  ****************************/

int menu_select(void)
{


	clrscr();

  gotoxy(6,3);
  printf( "            __________________________________________________");
	gotoxy(6,5);
	printf( "                ANTENNA FACTOR CALCULATOR Version 1.00  ");
	gotoxy(6,6);
	printf( "                      J. Eagleson WB6JNN c 1995");
	gotoxy(6,7);
  printf( "            __________________________________________________");
  gotoxy(6,9);
	printf( "                         CALCULATE:"            );
	gotoxy(6,11);
	printf( "                           1) Antenna Factor"   );
	gotoxy(6,12);
	printf( "                           2) Antenna Gain  "   );
	gotoxy(6,14);
	printf( "            __________________________________________________");
  gotoxy(6,17);
  printf( "            __________________________________________________");
	gotoxy(6,16);
	printf( "                           Enter selection.."  );

	ch=getch();

return(0);

} /* END OF MENU_SELECT() */




/* ******************* ANTENNA FACTOR FROM GA & FR **********************/

gain_to_af()
{

	double ga_dbi;
	double ga_ratio;
	double frequency;
	double ant_factor;

	clrscr();

  gotoxy(6,4);
  printf( "            __________________________________________________");
	gotoxy(6,6);
	printf("                      ANTENNA FACTOR CALCULATION" );
	gotoxy(6,7);
	printf("                           (Gain/Freq known)    " );
  gotoxy(6,8);
  printf( "            __________________________________________________");
  gotoxy(6,15);
  printf( "            __________________________________________________");
	gotoxy(6,10);
	printf("                           Gain (dBi) = "         );
	scanf("%lf",&ga_dbi);
	ga_ratio=pow(10,(ga_dbi/10));
	gotoxy(6,11);
	printf("                         Gain (ratio) = %3.2lf",ga_ratio);
	gotoxy(6,13);
	printf("                      Frequency (MHz) = "         );
	scanf("%lf",&frequency);
	ant_factor=(20*log10(frequency/(30.82*sqrt(ga_ratio))));
	gotoxy(6,14);
	printf("                       Antenna Factor = %3.2lf ",ant_factor);
	gotoxy(6,17);
	printf("                       <m> = menu, [=] = close ");
  gotoxy(6,18);
  printf( "            __________________________________________________");

	while((ch=getch())!='m');
  {
    /* do nothing until "m" is struck */
  }


return(0);
}




/* ***************** CALCULATE ANTENNA GAIN FROM FR & AF *****************/


af_to_gain()
{

	clrscr();

  gotoxy(6,4);
  printf( "            __________________________________________________");
	gotoxy(6,6);
	printf("                      ANTENNA GAIN CALCULATION"         );
	gotoxy(6,7);
	printf("                           (AF/Freq known)    "         );
  gotoxy(6,8);
  printf( "            __________________________________________________");
  gotoxy(6,15);
  printf( "            __________________________________________________");
	gotoxy(6,10);
	printf("                      Antenna Factor(dB) = "            );
	scanf("%lf",&ant_factor);
	gotoxy(6,11);
	printf("                         Frequency (MHz) = "            );
	scanf("%lf",&frequency);
	ga_ratio=pow(frequency/(30.82*pow(10,(ant_factor/20))),2);
	gotoxy(6,13);
	printf("                         Gain (ratio) = %3.2lf",ga_ratio);
	ga_dbi=10*log10(ga_ratio);
	gotoxy(6,14);
	printf("                         Gain (dBi)   = %3.2lf",  ga_dbi);
  gotoxy(6,18);
  printf( "            __________________________________________________");
	gotoxy(6,17);
	printf("                        <m> = menu, [=] = close "       );

  while((ch=getch())!='m')
  {
    /* do nothing unless "m" is hit */
  }

return(0);
} /* END OF AF_TO_GAIN() */




