/**/
call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs

Call SysCls

Say
Say "         AF - The Archive Folder - Installation program"
Say "         =============================================="
Say
Say "  This script will create a program object and create associations"
Say "  and templates for the Archive Folder."
Say "  The script has to be run from the directory where Archive Folder"
Say "  is installed."
Say
Call charout, "  Do you want to continue? (y/N): "

answer = SysGetKey(echo)


if answer <> "Y" then return

InstallDir = Directory()
EAT_ASCII = REVERSE('FFFD'X)

TypeText = 'Archive'
Type     = EAT_ASCII || d2c(length(TypeText)) || '00'x || TypeText
Name     = "Archive Templates"
LongName = EAT_ASCII || d2c(length(Name)) || '00'x || Name

if SysFileTree("TEMPLATE", dir, D) <> 0 then do
  Say "Not enough memory!"
  return
end

if dir.0 = 0 then do
  rc = SysCreateObject( "WPFolder", "TEMPLATE", InstallDir,"OBJECTID=<AF_TEMPS>;","r")
  if \rc then do
    Say "Error creating template folder!"
    return
  end
end

if SysPutEA( "TEMPLATE", ".LONGNAME", LongName ) <> 0 then
  Say "Error setting .LONGNAME Extended Attribute!"

if \ SysCreateObject( "WPShadow", "Archive templates", "<WP_DESKTOP>", "SHADOWID=<AF_TEMPS>;OBJECTID=<AF_TEMPS_SHADOW>;","r" ) then
  Say "Error creating shadow of template folder on the desktop!"

Call SysOpenObject "<AF_TEMPS_SHADOW>", 1, 1

rc = SysCreateObject( "WPDataFile", "Archive.Arj", "<AF_TEMPS>","TEMPLATE=YES;TYPE=Archive;OBJECTID=<AF_ARJ_TEMPLATE>;","r")
if \rc then Say "Error creating ARJ template!"
else
  if SysPutEA( "TEMPLATE\archive.arj", ".TYPE", Type ) <> 0 then
    say "Error putting .TYPE EA"

rc = SysCreateObject( "WPDataFile", "Archive.Zip", "<AF_TEMPS>","TEMPLATE=YES;TYPE=Archive;OBJECTID=<AF_ZIP_TEMPLATE>;","r")
if \rc then Say "Error creating ZIP template! It may already exist."
else
  if SysPutEA( "TEMPLATE\archive.Zip", ".TYPE", Type ) <> 0 then
    say "Error putting .TYPE EA"

rc = SysCreateObject( "WPDataFile", "Archive.Arc", "<AF_TEMPS>","TEMPLATE=YES;TYPE=Archive;OBJECTID=<AF_ARC_TEMPLATE>;","r")
if \rc then Say "Error creating ARC template! It may already exist."
else
  if SysPutEA( "TEMPLATE\archive.arc", ".TYPE", Type ) <> 0 then
    say "Error putting .TYPE EA"

rc = SysCreateObject( "WPDataFile", "Archive.Lzh", "<AF_TEMPS>","TEMPLATE=YES;TYPE=Archive;OBJECTID=<AF_LZH_TEMPLATE>;","r")
if \rc then Say "Error creating LZH template! It may already exist."
else
  if SysPutEA( "TEMPLATE\archive.lzh", ".TYPE", Type ) <> 0 then
    say "Error putting .TYPE EA"

rc = SysCreateObject( "WPDataFile", "Archive.Rar", "<AF_TEMPS>","TEMPLATE=YES;TYPE=Archive;OBJECTID=<AF_RAR_TEMPLATE>;","r")
if \rc then Say "Error creating RAR template! It may already exist."
else
  if SysPutEA( "TEMPLATE\archive.rar", ".TYPE", Type ) <> 0 then
    say "Error putting .TYPE EA"

rc = SysCreateObject( "WPProgram", "Archive Folder", "<WP_DESKTOP>","PROGTYPE=PM;EXENAME="InstallDir"\AF.EXE;STARTUPDIR="Installdir";ASSOCTYPE=Archive;ASSOCFILTER=*.lzh,*.zip,*.arc,*.arj,*.rar;OBJECTID=<AF>;","r")
if \rc then do
  Say "Error creating program object!"
  return
end

Say "  Archive Folder successfully installed!"
Say
Say "  Now copy the ARCHIVER.BB2 file to a directory in your PATH or DPATH."
Say
'@pause'


