/**********************************************************************
 *  
 *  NAME:           initscr.cpp
 *  
 *  DESCRIPTION:    initialize window library
 *
 *                  also, miscellaneous functions that
 *                  don't seem to fit anywhere else
 *  
 *  copyright (c) 1990 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  11/??/90    J. Alan Eldridge    created
 *  
 *********************************************************************/

#include    "w.h"

//  current image of display screen

vidbuf  Screen;

//  initialize the window library: MUST CALL THIS OR ELSE!
//  (the constructor for class vidbuf calls it just to be sure)
//  if it doesn't return OK, something is seriously wrong!

static int  initscrCalled = FALSE;
static int  initscrResult;

int
initscr(
    int     vidmode,
    char    *vidvar)
{
    if (initscrCalled)
        return initscrResult;

    initscrCalled = TRUE;

    //  application can override this call by calling vid_open()
    //  before calling initscr(). this works because the video interface
    //  will only initialize itself once.
    
    vid_open(vidmode, vidvar);
    
    //  set up current screen image buffer
    
    Screen.open(0, 0, vid_rows()-1, vid_cols()-1);
    Screen.clear();
    Screen.setpos(0, 0);
    Screen.refresh();
    return initscrResult = Screen.status();
}        

//  annoy the user

void
beep(
    int     nTimes,
    uint    howLong,
    uint    Hz)
{
    while (nTimes-- > 0) {
        sound(Hz);
        delay(howLong);
        nosound();
        if (nTimes > 0)
            delay(333);
    }
}


