/**********************************************************************
 *  
 *  NAME:           viewport.h
 *  
 *  DESCRIPTION:    the "active" part of a window
 *  
 *  copyright (c) 1990 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  11/29/90    J. Alan Eldridge    created
 *  
 *********************************************************************/

#ifndef __VIEWPORT_H
#define __VIEWPORT_H

class viewport {

protected:

    int yUL, xUL, yLR, xLR;

public:    
    
    //  get port boundaries
    
    void getport(int &yul, int &xul, int &ylr, int &xlr)
        { yul = yUL; xul = xUL; ylr = yLR; xlr = xLR; }
    void getport(int *box)
        { box[0] = yUL; box[1] = xUL; box[2] = yLR; box[3] = xLR; }
    viewport    &getport()
        { return *this; }
            
    //  set port boundaries
    //  these are virtual because windows are derived from
    //  this class, and they need to do more work when
    //  changing the viewport

    virtual void setport(int yul, int xul, int ylr, int xlr)
        { yUL = yul; xUL = xul; yLR = ylr; xLR = xlr; }
    virtual void setport(int *box)
        { viewport::setport(box[0],box[1],box[2],box[3]); }
    virtual void setport(viewport &vp)
        { *this = vp; }
        
    //  get size
    
    int portrows()
        { return yLR - yUL + 1; }
    int portcols()
        { return xLR - xUL + 1; }
    
    //  constructors (no destructor)
    
    viewport()
        { setport(0, 0, -1, -1); }
    viewport(int yul, int xul, int ylr, int xlr)
        { setport(yul, xul, ylr, xlr); }
    viewport(int *box) 
        { setport(box); }

    //  is it set to something reasonable?
    
    int isempty()
        { return yLR < yUL || xLR < xUL; }
        
    //  check location of pointing device

    int intheport(int &y, int &x);
};


#endif
