/**********************************************************************
 *  
 *  NAME:           video.h
 *  
 *  DESCRIPTION:    video interface to Turbo C video library
 *  
 *  copyright (c) 1990 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  08/01/90    J. Alan Eldridge    created
 *
 *  08/12/90    JAE                 removed some error checking,
 *                                  made some functions void
 *  
 *  12/21/90    JAE                 un-object-oriented it, because
 *                                  it just didn't seem to fit
 *
 *********************************************************************/

#ifndef __VIDEO_H
#define __VIDEO_H

//  return current mode
int  vid_currmode();

//  attribute handling
inline int  vid_mkatt(int f, int b) 
    { return (f&(15|BLINK))+((b&15)<<4); }

//  default video attribute
extern uchar    vid_defaultatt;

//  size of physical display
int     vid_rows();
int     vid_cols();

//  status info
int     vid_isopen();
int     vid_iscolor();

//  globals to avoid function call overhead...
//  the video driver does NOT use these, it simply
//  provides them for the application to use...
//  if the app changes them, it has no effect ...
extern int  vid_ROWS,
            vid_COLS,
            vid_ISCOLOR;

//  device i/o
int     vid_write(
    uchar   atRow,
    uchar   atCol,
    vidchr  *pBuf,
    uchar   nChrs);
int     vid_read(
    uchar   atRow,
    uchar   atCol,
    vidchr  *pBuf,
    uchar   nChrs);
void    vid_clear(uchar att);

//  cursor control
int vid_setcpos(
    uchar   atRow,
    uchar   atCol);
void    vid_getcpos(uchar *pRC);

//  startup, shutdown
void    vid_open(
    int     mode,
    char    *evar=0);
void    vid_close();
int     vid_envmode(
    int     mode,
    char    *varName);

//  control text cursor display
void    vid_hidecursor(int newcnt = 0); //  hide if not hidden
void    vid_showcursor();           //  increment hide counter, ?show
void    vid_forcecursor(int &oldcnt);   //  must show cursor, return old count
int     vid_cursortype(int type);   //  set & return old value
int     vid_cursortype();           //  return current value

#endif


