/**********************************************************************
 *  
 *  NAME:           tskfatal.cpp
 *  
 *  DESCRIPTION:    fatal error reporting function for multitasking
 *                  scheduler:
 *
 *                  writes out the name of the current task, and the
 *                  error message, then calls exit(1)
 *
 *                  the user is free to replace this routine by linking
 *                  in a new function with the same name and argument
 *                  list before linking the task library
 *  
 *  copyright (c) 1991 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  11/30/91    J. Alan Eldridge    created
 *  
 *********************************************************************/

#include    "aedef.h"
#include    "task.h"


//------------------------------------------------------------
//  TaskFatal   -- report a message and die with call to exit(1)
//------------------------------------------------------------

void TaskFatal(char *fmt, ...)
{
    va_list ap;
    char    *tname = CurrTask ? CurrTask->name() : "NO TASK RUNNING";
    
    fprintf(stderr, "\nCurrTask <%s>: ", tname);

    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap);
    va_end(ap);
    
    fprintf(stderr, "\n");
    exit(1);
}
