comment @

 *  MOVECURSTR
 *----------------------------------------------------------------------------
 *
 *  Routine to generate an ANSI move cursor string
 *
 *  Author: Tom Collins
 *          09-20-90
 *
 *  Calling Sequence:
 *
 *     A$ = SPACE$(8)
 *     CALL MoveCurStr(OldY, OldX, NewY, NewX, A$, ALen)
 *     A$ = LEFT$(A$, ALen)
 *     Call QuickTput(A$, 0)
 *
 *  Returns:
 *     ANSI string in A$
 *     Length of string in ALen
 *     OldX = NewX
 *     OldY = NewY
 *
 *  Assemble with: TASM movcstr.asm [/Zi]   or,
 *                 MASM movcstr.asm [/Zi]
 *  (Zi = Debug info for CV)
 *
	@

       .MODEL MEDIUM, BASIC

       .CODE

       PUBLIC  MOVECURSTR
       PUBLIC  ITOA

ITOA   proc USES bx

       mov      bl, 10             ; Divide AX by 10
       div      bl                 ; AL = AX/10, AH = remainder
       and      al, al             ; Set the flags
       jz       IT01               ; Skip first digit if it's zero
       add      al, '0'            ; Not zero.  Convert AL to a character
       stosb                       ; Save it in string
       inc      cx                 ; Correct the length
IT01:  mov      al, ah             ; Get remainder in AL
       add      al, '0'            ; Convert AL to a character
       stosb                       ; Save it in string
       inc      cx                 ; Correct the length
IT02:  ret                         ; Done

ITOA   endp


MOVECURSTR  proc USES es si di, OLDY:ptr, OLDX:ptr, NEWY:ptr, NEWX:ptr, A:ptr, ALEN:ptr

       push     ds                 ; Save DS
       pop      es                 ; Set ES = DS

       mov      si, A              ; DS:SI -> String descriptor
       mov      di, [si+2]         ; ES:DI -> A$

; Build the ANSI header = ESC [

       mov      al, 01Bh           ; AL = ESC
       stosb                       ; Save it to A$
       mov      al, '['            ; AL = '['
       stosb                       ; Save it to A$
       mov      cx, 2              ; CX = New ALEN

; Get NEWX and NEWY in AL and AH

       mov      si, NEWX           ; DS:SI -> NEWX
       mov      al, [si]           ; AL = NEWX
       mov      si, NEWY           ; DS:SI -> NEWY
       mov      ah, [si]           ; AH = NEWY

; See if NEWX = NEWY = 0

       and      ax, ax             ; Set the flags
       jz       MC15               ; NEWX = NEWY = 0.  Return.

       cmp      ax, 0101h          ; See if NEWX = NEWY = 1
       jnz      MC02               ; No

; NEWX = NEWY = 1.  Set string to ESC [f

       mov      BYTE PTR[di], 'f'  ; Set up the A$ string
       inc      cx                 ; Set length equal to 3
       jmp      short MC16         ; Return

; Get the differences between the OLD and NEW strings in AX

MC02:  mov      si, OLDX           ; DS:SI -> OLDX
       sub      al, [si]           ; AL = NEWX - OLDX
       mov      si, OLDY           ; DS:SI -> OLDY
       sub      ah, [si]           ; AH = NEWY - OLDY

; See whether the X or Y or both changed.

       and      ax, ax             ; Set the flags
       jz       MC15               ; Neither changed

       and      al, al             ; Set the flags
       jz       MC03               ; X didn't change.  Just Y.

       and      ah, ah             ; X changed.  See if Y did.
       jz       MC05               ; No

; Both X and Y changed.  Build a string containing ESC [ NEWY ; NEWX f

       mov      si, NEWY           ; DS:SI -> NEWY
       mov      ax, [si]           ; AX = NEWY
       call     ITOA               ; Convert NEWY to a string
       mov      al, ';'            ; Add the semicolon
       stosb                       ;
       mov      si, NEWX           ; DS:SI -> NEWX
       mov      ax, [si]           ; AX = NEWX
       call     ITOA               ; Convert NEWX to a string
       mov      BYTE PTR [di], 'f' ; Add the trailing character
       add      cx, 2              ; Correct the string length
       jmp      short MC16         ; Done

; Just the Y coordinate changed.  Build ESC [ nn B (or A)

MC03:  mov      si, OLDY           ; DS:SI -> OLDY
       mov      ax, [si]           ; AX = OLDY
       mov      si, NEWY           ; DS:SI -> NEWY
       sub      ax, [si]           ; AX = OLDY - NEWY
       mov      bl, 'A'            ; Trailing character is 'A' (move up)
       jmp      short MC06         ; Do the string

; Just the X coordinate changed.  Build ESC [ nn C (or D)

MC05:  mov      si, NEWX           ; DS:SI -> NEWX
       mov      ax, [si]           ; AX = NEWX
       mov      si, OLDX           ; DS:SI -> OLDX
       sub      ax, [si]           ; AX = NEWX - OLDX
       mov      bl, 'C'            ; Trailing character is 'C' (move right)

MC06:  cmp      ax, 0              ; See if AX is positive
       jg       MC07               ; Yes
       neg      ax                 ; No.  Make it positive
       add      bl, 1              ; Increment trailing character
MC07:  call     ITOA               ; Convert AX to a string
       mov      [di], bl           ; Add the trailing character
       inc      cx                 ; Correct the length of CX
       jmp      short MC16         ; Return

; One of the coordinates is zero, or no change is required.

MC15:  mov      si, ALEN           ; DS:SI -> ALEN
       mov      BYTE PTR[si], 0    ; New ALEN is zero
       ret                         ; Return

; Normal return

MC16:  mov      si, ALEN           ; DS:SI -> ALEN
       mov      [si], cx           ; Save CX to ALEN

       mov      si, NEWX           ; DS:SI -> NEWX
       mov      al, [si]           ; AL = NEWX
       mov      si, OLDX           ; DS:SI -> OLDX
       mov      [si], al           ; OLDX = NEWX

       mov      si, NEWY           ; DS:SI -> NEWY
       mov      al, [si]           ; AL = NEWY
       mov      si, OLDY           ; DS:SI -> OLDY
       mov      [si], al           ; OLDY = NEWY

       ret                         ; Return

MOVECURSTR   endp

        end
