/*------------------------------------------------------------
 * 
 *  winflags.c
 * 
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  set/clear curses window flags
 * 
 *----------------------------------------------------------*/

#include "curses.h"

static void
setflag(win, flag, ok)
WINDOW  *win;
int     flag, ok;
{
    if (ok)
        win->flags |= flag;
    else
        win->flags &= ~flag;
}

void
scrollok(win, ok)
WINDOW  *win;
int     ok;
{
    setflag(win, _WSCROLL, ok);
}

void
leaveok(win, ok)
WINDOW  *win;
int     ok;
{
    setflag(win, _WLEAVE, ok);
}

void
clearok(win, ok)
WINDOW  *win;
int     ok;
{
    setflag(win, _WCLEAR, ok);
}

void
wrapok(win, ok)
WINDOW  *win;
int     ok;
{
    setflag(win, _WWRAP, ok);
}

