/*------------------------------------------------------------
 * 
 *  _scroll.c
 * 
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 * 
 *  low-level scroll function for Curses! 3.X
 * 
 *----------------------------------------------------------*/

#include "curses.h"

#define ABS(n) ((n) > 0 ? (n) : -(n))

int
_scroll(win, start_line, end_line, lines)
WINDOW  *win;
int     start_line;
int     end_line;
int     lines;
{
    VIDCHR  fillch, 
            *dest, 
            *src;

    int     r, 
            c, 
            rows, 
            cols;
	
    if (win->flags & _WSCROLL == 0)
        return ERR;
	
    /* mark the area we're hitting */
	
    getyx(win, r, c);
    wmove(win, start_line, 0);
    markwin(win);
    wmove(win, end_line, getmaxc(win));
    markwin(win);
    wmove(win, r, c);
	
    /* set up fill char, rows, cols */
	
    fillch.chr = ' ';
    fillch.att = win->attrib;
    cols = getmaxc(win) + 1;
    rows = end_line - start_line + 1 - ABS(lines);
	
    /*  3 choices here: clear it, scroll up, or scroll down */
	
    if (rows <= ABS(lines)) {
        /* clear entire area */
	for (r = start_line; r <= end_line; r++)
            memsetw(win->buf[r], &fillch, cols);
    } else if (lines > 0) {
        /* scroll up */
        for (r = start_line; rows-- > 0; r++)
            memcpy(win->buf[r], win->buf[r+1], cols * sizeof(VIDCHR));
        while (r <= end_line) 
            memsetw(win->buf[r++], &fillch, cols);
    } else if (lines < 0) {
        /* scroll down */
        for (r = end_line; rows-- > 0; r--)
            memcpy(win->buf[r], win->buf[r-1], cols * sizeof(VIDCHR));
        while (r >= start_line) 
            memsetw(win->buf[r--], &fillch, cols);
    }

    return OK;
}
