/*------------------------------------------------------------
 *
 *  popmenu.c
 *
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  popup menus for Curses!
 *
 *------------------------------------------------------------
 */

#include "curses.h"

#include <stdarg.h>

#define MAX_LIST_SIZE   32

static  int     high = VID_DEFSTAND,
                norm = VID_DEFNORM;

void
init_popmenus(void)
{
    high = __DEFSTAND;
    norm = __DEFNORM;
}

void
popmenuattr(n, h)
{
    if (iscolor()) {
        if (n == -1)
            n = __DEFNORM;
        if (h == -1)
            h = __DEFSTAND;
        norm = n;
        high = h;
    }
}

int
scrollmenul(orgy, orgx, title, maxrows)
char *title;
{
    char *choices[MAX_LIST_SIZE], **cpp;
    va_list argp;

    cpp = choices;
    va_start(argp, maxrows);
    while (*cpp++ = va_arg(argp, char *))
        ;
    return scrollmenuv(orgy, orgx, title, maxrows, choices);
}
    
int
popmenul(orgy, orgx, title)
char *title;
{
    char *choices[MAX_LIST_SIZE], **cpp;
    va_list argp;

    cpp = choices;
    va_start(argp, title);
    while (*cpp++ = va_arg(argp, char *))
        ;
    return scrollmenuv(orgy, orgx, title, -1, choices);
}
    
int
popmenuv(orgy, orgx, title, array)
char *title, **array;
{
    return scrollmenuv(orgy, orgx, title, -1, array);
}

int
scrollmenuv(orgy, orgx, title, maxrows, array)
char *title, **array;
{
    int choice;
    POPUP_MENU pm;
	
    if (pm_ctor(&pm, 0, orgy, orgx, title, maxrows, array, norm, high) != OK)
        return -1;
	
    choice = pm_choose(&pm);
	
    pm_dtor(&pm);
    return choice;
}
