/*----------------------------------------------------------------------
 *
 *  expldwin.c
 *
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  "explodes" a boxed window onto the screen
 *
 *----------------------------------------------------------------------
 */

#include "curses.h"

int
expldwin(wptrs, l, c, y, x, v, h)
WINDOW  *wptrs[2];
int     l, c, y, x, v, h;
{
    int lc, cc, yc, xc, n;

    WINDOW *winp, *subp;

    lc = l % 2 ? 1 : 2;
    cc = c % 2 ? 1 : 2;
    yc = y + l / 2 - lc / 2;
    xc = x + c / 2 - cc / 2;

    for (;;) {
        int i;

        winp = newwin(lc+2,cc+2,yc-1,xc-1);

        if (!winp)
            return ERR;
        
        box(winp,v,h);
        wrefresh(winp);

        if (lc == l && cc == c)
            break;
        else
            delwin(winp);

        n = (i = l - lc) > 4 ? 6 : i;
        lc += n;
        yc -= n / 2;

        n = (i = c - cc) > 6 ? 8 : i;
        cc += n;
        xc -= n / 2;
    }

    subp = subwin(winp, lc, cc, yc, xc);
        
    if (subp) {
        wptrs[0] = winp;
        wptrs[1] = subp;
        return OK;
    } else {
        delwin(winp);
        wptrs[0] = wptrs[1] = NULL;
        return ERR;
    }
}
