/***********************************

	     AEAM v1.0

	 Copyright (c) 1994,
   by Devin Carraway (AquaMaestro)

  Source may be freely distributed
  as part of the original archive,
  or as a component in your own
  programs.

 ***********************************/


#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <process.h>
#include <io.h>
#include <fcntl.h>

typedef struct {
	char		newuserpw[21],
			systempw[21],
			msgsdir[81],
			gfilesdir[81],
			datadir[81],
			dloadsdir[81],
			ramdrive,
			tempdir[81],
			xmark,
			regcode[83],
			bbs_init_modem[51],
			answer[21],
			connect_300[21],
			connect_1200[21],
			connect_2400[21],
			connect_9600[21],
			connect_19200[21],
			no_carrier[21],
			ring[21],
			terminal[21],
			systemname[51],
			systemphone[13],
			sysopname[51],
			executestr[51];
	unsigned char	newusersl,
			newuserdsl,
			maxwaiting,
			comport[5],
			com_ISR[5],
			primaryport,
			newuploads,
			closedsystem;
	unsigned short	systemnumber,
			baudrate[5],
			com_base[5],
			maxusers,
			newuser_restrict,
			sysconfig,
			sysoplowtime,
			sysophightime,
			executetime;
	float		req_ratio,
			newusergold;
	char 		sl[1792],
			autoval[50];
	char		hangupphone[21],
			pickupphone[21];
	unsigned short  netlowtime,
			nethightime;
	char            connect_300_a[21],
			connect_1200_a[21],
			connect_2400_a[21],
			connect_9600_a[21],
			connect_19200_a[21];
	char            arcs[400];
	char            beginday_c[51],
			logon_c[51];
	short           userreclen,
			waitingoffset,
			inactoffset;
	char            newuser_c[51];
	unsigned long   wwiv_reg_number;
	char            dial_prefix[21];
	float           post_call_ratio;
	char            upload_c[51];
	char            dszbatchdl[81];
	char            modem_type[9];
	char            batchdir[81];
	short           sysstatusoffset;
	char            network_type;
	short           fuoffset,
			fsoffset,
			fnoffset;
	unsigned short  max_subs,
			max_dirs,
			qscn_len;
	unsigned char   email_storage_type;
	unsigned long   sysconfig1;
	char            res[19];
} configrec;


configrec syscfg;

char a_msg[6][81], top_line[81], l_sidebar[81], r_sidebar[81],
     bottom_line[81], text_color, name_color, end_color;

int clear_blanks;

int read_amsg(void);
void write_amsg(void);
void read_config(char *path);
void read_cfg(char *path);
unsigned char *stripcolors(unsigned char *instr);


void main(int argc, char *argv[])
{
  directvideo=1;
  printf("\r\n\n- AEAM v1.0\r\n\n");
  read_config("CONFIG.DAT");
  read_cfg((argc>=2)?argv[1]:"AEAM.CFG");
  if (read_amsg()==-1) {
    printf("% Automessage already converted.\r\n");
    exit(1);
  }
  write_amsg();
}

void read_config(char *path)
{
  char s[81];
  int f,i;

  f=open(path,O_RDONLY | O_BINARY);
  if (f<0) {
    printf("* Couldn't open CONFIG.DAT.\r\n");
    exit(1);
  }
  read(f,(void *) (&syscfg), sizeof(configrec));
  close(f);
}


void read_cfg(char *path)
{
  char s[81];
  int i;
  FILE *f;

  if ((f=fopen(path,"rt"))==NULL) {
    printf("* Couldn't open %s.\r\n",path);
    exit(2);
  }
  fgets(s,150,f);
  name_color=s[0];
  fgets(s,150,f);
  text_color=s[0];
  fgets(s,150,f);
  end_color=s[0];
  fgets(s,150,f);
  strcpy(top_line,s);
  fgets(s,150,f);
  strcpy(l_sidebar,s);
  for (i=0; i<strlen(l_sidebar); i++)
    if ((l_sidebar[i]=='\r') || (l_sidebar[i]=='\n'))
      l_sidebar[i]=0;
  fgets(s,150,f);
  strcpy(r_sidebar,s);
  for (i=0; i<strlen(r_sidebar); i++)
    if ((r_sidebar[i]=='\r') || (r_sidebar[i]=='\n'))
      r_sidebar[i]=0;
  fgets(s,150,f);
  strcpy(bottom_line,s);
  for (i=0; i<strlen(bottom_line); i++)
    if ((bottom_line[i]=='\r') || (bottom_line[i]=='\n'))
      bottom_line[i]=0;
  fgets(s,2,f);
  clear_blanks=((s[0]=='Y') || (s[0]=='y') || (s[0]=='1'));
  fclose(f);
}


int read_amsg(void)
{
  char s[81];
  int i,i1;
  FILE *f;

  sprintf(s,"%sAUTO.MSG",syscfg.gfilesdir);
  if ((f=fopen(s,"rt"))==NULL) {
    printf("* Couldn't open %s.\r\n",s);
    exit(3);
  }
  for (i=0; i<4; i++) {
    fgets(a_msg[i],80,f);
    if ((i==0) && (a_msg[i][0]==3)) {
      fclose(f);
      return(-1);
    }
    for (i1=0; i1<strlen(a_msg[i]); i1++)
      if ((a_msg[i][i1]=='\r') || (a_msg[i][i1]=='\n'))
	a_msg[i][i1]=0;
  }
  fclose(f);
  return(0);
}

void write_amsg(void)
{
  char s[81];
  int i,i1;
  FILE *f;

  sprintf(s,"%sAUTO.MSG",syscfg.gfilesdir);
  if ((f=fopen(s,"w"))==NULL) {
    printf("* Couldn't open %s for writing.\r\n",s);
    exit(4);
  }
  fprintf(f,"%c%s%c\n",name_color,a_msg[0],end_color);
  fprintf(f,top_line);
  for (i=0; i<3; i++) {
      if ((clear_blanks) && (!a_msg[i+1][0]))
	continue;
      else
	if (a_msg[i+1][0])
	  for (i1=0; i1<39-strlen(stripcolors(a_msg[i+1])); i1++)
	    strcat(a_msg[i+1]," ");
      sprintf(s,"%s%c %-39.39s %s\n",
	       l_sidebar,text_color,a_msg[i+1],r_sidebar);
      fputs(s,f);
  }
  fprintf(f,"%s%c\n",bottom_line,end_color);
  fclose(f);
}


unsigned char *stripcolors(unsigned char *instr)
{
  static unsigned char s[161];
  int i,i1;

  if (strlen(instr)==0)
    return("");

  i=0; i1=0;
  do {
    if (instr[i]==3)
      i++;
    else {
      s[i1]=instr[i];
      i1++;
    }
    i++;
  } while (i<strlen(instr));
  s[i1]=0;
  return(s);
}
