/* ===========================================================================

	FUNCTEST.CPP   Test of ADVMATH.CPP

						Cylindrical and Spherical Bessel Functions of the First
						and Second Kind, Modified Bessel Functions I and K,
						Gamma Function, Incomplete Gamma Function, Small Gamma
						Function, Digamma Function, Polygamma Function,
						Riemann Zeta Function, Exponential Integrals, various
						Orthogonal Polynomials, Associated Legendre Function,
						Error Function, Normal Probability Function, Chi-Square
						Probability Function, Bernoulli and Euler Numbers
						and Polynomials, and determinant.

 ========================================================================= */

#include <stdlib.h>
#include <conio.h>
#include <stdio.h>
#include <math.h>
#include <advmath.h>

//--------------------------------------------------------------------------

void main()
{
	int n,nu,l,m;
	double a,b,x,Xsq,
		array[]={1,3,-2,-2,-1,3,2,2,1};

	n=3;
	nu=11;
	l=3;
	m=2;
	a=.5;
	b=-1.5;
	x=1.6;
	Xsq=13.5;

	clrscr();
	printf("\nJBesCyl(%d,%lg) = \t%22.14le",n,x,JBesCyl(n,x));
	printf("\nYBesCyl(%d,%lg) = \t%22.14le",n,x,YBesCyl(n,x));
	printf("\nJBesSph(%d,%lg) = \t%22.14le",n,x,JBesSph(n,x));
	printf("\nYBesSph(%d,%lg) = \t%22.14le",n,x,YBesSph(n,x));
	printf("\nIBesCyl(%d,%lg) = \t%22.14le",n,x,IBesCyl(n,x));
	printf("\nKBesCyl(%d,%lg) = \t%18.10le",n,x,KBesCyl(n,x));
	printf("\nGammaFnc(%lg) = \t%22.14le",a,GammaFnc(a));
	printf("\nIncGamma(%lg,%lg) = \t%22.14le",a,x,IncGamma(a,x));
	printf("\nSmlGamma(%lg,%lg) = \t%22.14le",a,x,SmlGamma(a,x));
	printf("\nDigamma(%lg) = \t\t%22.14le",x,Digamma(x));
	printf("\nPolyGam(%d,%lg) = \t%22.14le",n,x,PolyGam(n,x));
	printf("\nExpInt(%d,%lg) = \t%22.14le",n,x,ExpInt(n,x));
	printf("\nEi(%lg) = \t\t%22.14le",x,Ei(x));
	printf("\nChb1Poly(%d,%lg) = \t%22.14le",n,x,Chb1Poly(n,x));
	printf("\nChb2Poly(%d,%lg) = \t%22.14le",n,x,Chb2Poly(n,x));

	printf("\n\nTo continue press any key...\n"); getch();

	printf("\nGegPoly(%lg,%d,%lg) = \t%22.14le",a,n,x,GegPoly(a,n,x));
	printf("\nHerPoly(%d,%lg) = \t%22.14le",n,x,HerPoly(n,x));
	printf("\nJacPoly(%lg,%lg,%d,%lg) =%21.14le",a,b,n,x,JacPoly(a,b,n,x));
	printf("\nLagPoly(%lg,%d,%lg) = \t%22.14le",a,n,x,LagPoly(a,n,x));
	printf("\nLegPoly(%d,%lg) = \t%22.14le",n,x,LegPoly(n,x));
	printf("\nAscLeg(%d,%d,%lg) = \t%22.14le",l,m,x-floor(x),AscLeg(l,m,x-floor(x)));
	printf("\nError(%lg) = \t\t%22.14le",x,Error(x));
	printf("\nNprob(%lg) = \t\t%22.14le",x,Nprob(x));
	printf("\nChiSqrQ(%lg,%d) = \t%22.14le",Xsq,nu,ChiSqrQ(Xsq,nu));
	printf("\nBernNum(%d) = \t\t%22.14le",2*n,BernNum(2*n));
	printf("\nBernPoly(%d,%lg) = \t%22.14le",n,x,BernPoly(n,x));
	printf("\nEulerNum(%d) = \t\t%22.14le",2*n,EulerNum(2*n));
	printf("\nEulerPoly(%d,%lg) = \t%22.14le",n,x,EulerPoly(n,x));
	printf("\nZeta(%d) = \t\t%22.14le",n+12,Zeta(n+12));
	printf("\nAdet = \t\t\t%22.14le",Adet(array,3));

	printf("\n\nPress any key..."); getch();
	return;
}
