VERSION 2.00
Begin Form frmMove 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Move File 'From' -> 'To'"
   ClientHeight    =   4725
   ClientLeft      =   3090
   ClientTop       =   1620
   ClientWidth     =   4755
   Height          =   5130
   Left            =   3030
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4725
   ScaleWidth      =   4755
   Top             =   1275
   Width           =   4875
   Begin CheckBox chkNewerRevision 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Over Write Newer Revisions."
      Height          =   255
      Left            =   240
      TabIndex        =   9
      Top             =   3600
      Width           =   4215
   End
   Begin CommandButton cmdTo 
      Caption         =   "Exists"
      Height          =   285
      Left            =   3720
      TabIndex        =   3
      Top             =   480
      Width           =   855
   End
   Begin CommandButton cmdFrom 
      Caption         =   "Exists"
      Height          =   285
      Left            =   3720
      TabIndex        =   1
      Top             =   120
      Width           =   855
   End
   Begin CheckBox chkOverWrite 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Over Write file if file already exists."
      Height          =   255
      Left            =   240
      TabIndex        =   8
      Top             =   3240
      Width           =   4215
   End
   Begin Frame Frame2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Create ? "
      Height          =   1095
      Left            =   240
      TabIndex        =   15
      Top             =   840
      Width           =   4335
      Begin OptionButton optDirectory 
         BackColor       =   &H00C0C0C0&
         Caption         =   "No Directory, No Move."
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   5
         Top             =   720
         Width           =   3975
      End
      Begin OptionButton optDirectory 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Create Directory with Move."
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   4
         Top             =   360
         Width           =   3975
      End
   End
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Delete ? "
      Height          =   1095
      Left            =   240
      TabIndex        =   14
      Top             =   2040
      Width           =   4335
      Begin OptionButton optDelete 
         BackColor       =   &H00C0C0C0&
         Caption         =   "No Not Delete File with Move."
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   7
         Top             =   720
         Width           =   3735
      End
      Begin OptionButton optDelete 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Delete 'From' File with Move"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   6
         Top             =   360
         Width           =   3735
      End
   End
   Begin CommandButton Cancel 
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   2640
      TabIndex        =   11
      Top             =   4200
      Width           =   1335
   End
   Begin TextBox txtTo 
      Height          =   285
      Left            =   1320
      TabIndex        =   2
      Text            =   "Text1"
      Top             =   480
      Width           =   2295
   End
   Begin TextBox txtFrom 
      Height          =   285
      Left            =   1320
      TabIndex        =   0
      Text            =   "Text1"
      Top             =   120
      Width           =   2295
   End
   Begin CommandButton cmdMoveCopy 
      Caption         =   "&Move/Copy"
      Height          =   375
      Left            =   600
      TabIndex        =   10
      Top             =   4200
      Width           =   1335
   End
   Begin Line Line1 
      X1              =   240
      X2              =   4560
      Y1              =   4080
      Y2              =   4080
   End
   Begin Label Label2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "File To:"
      Height          =   255
      Left            =   240
      TabIndex        =   13
      Top             =   480
      Width           =   975
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "File From:"
      Height          =   255
      Left            =   240
      TabIndex        =   12
      Top             =   120
      Width           =   975
   End
End
'''''''''''''''''''''''''''''''''''''''''''''''''
' Copyright by Advanced Applications 1994 - 1995
' All rights reserved
'
'''''''''''''''''''''''''''''''''''''''''''''''''
Dim nDirectoryCreate As Integer
Dim nDelete As Integer
Dim nOverWrite As Integer
Dim nNewerRevision As Integer

'===============================================================
' The Move/Copy File Flow:
'===============================================================
' 1. Check for the existance of the 'From' File
'    return = 104; if the 'From' File does not exist
'
' 2. Get information on the 'To' disk drive
'    return = Disk Info error code; Free Disk Space Error
'    return = 105; No Disk Space left
'
' 3. Compare 'From' File length to 'To' Drive
'    return = 106; Not enough room for file
'
' 4. Create the Directory, by user
'    return = 107; Directory Creation error
'
' 5. Directory does not exist, user asked not to create it and
'    move the file.
'    return = 108; Directory not created and file not moved
'
' 6. return = 100 - File could not be opened for the Write, or
'             101 - 'From' File could not be closed, or
'             102 - 'To' File could not be closed. or
'             103 - Could not delete the 'From' File.
'
' 7. Checks for Newer Revision of the 'To' File
'    return = 109 - The "To' File is a New Revision, operation cancelled
'
' 8. return = 0; No Errors, done.
'================================================================

Sub Cancel_Click ()
    Me.Hide
    DoEvents
End Sub

Sub chkNewerRevision_Click ()
    nNewerRevision = chkNewerRevision.Value
End Sub

Sub chkOverWrite_Click ()
    nOverWrite = chkOverWrite.Value
End Sub

Sub cmdFrom_Click ()
    If txtFrom.Text = "" Then Exit Sub

    strFrom$ = txtFrom.Text
    nReturn% = FileExists(strFrom$)

    If nReturn% = FILE_EXISTS Then
	MsgBox "File Exists"
    Else
	MsgBox "File Does Not Exist"
    End If
End Sub

Sub cmdMoveCopy_Click ()
    If txtFrom.Text = "" Or txtTo.Text = "" Then Exit Sub
    
    strFrom$ = txtFrom.Text
    strTo$ = txtTo.Text

    Screen.MousePointer = HOURGLASS
    
    lReturn& = MoveCopyFile(strFrom$, strTo$, nDirectoryCreate, nDelete, nOverWrite, nNewerRevision)
    
    Select Case lReturn&
	Case MOVE_DISK_UNFORMATTED
	    lReturn& = DiskFormat()
	Case 0
	    DisplayError lReturn&
    End Select
    
    Screen.MousePointer = DEFAULT
End Sub

'
' The FileExists([file]) can be used to test for the
' existance of the file prior to using the MoveFileTo()
' command. With the MoveFileTo setup properly, this
' command will act just like a copy.
'
Sub cmdTo_Click ()
    If txtTo.Text = "" Then Exit Sub

    strFrom$ = txtTo.Text
    nReturn% = FileExists(strFrom$)

    If nReturn% = 0 Then
	MsgBox "File Exists"
    Else
	MsgBox "File Does Not Exist"
    End If
End Sub

Sub Form_Load ()
    Left = (Screen.Width - Width) / 2   ' Center form horizontally.
    Top = (Screen.Height - Height) / 2  ' Center form vertically.

    txtFrom.Text = ""
    txtTo.Text = ""

    optDirectory(0).Value = True
    optDelete(0).Value = True
    chkOverWrite.Value = 0
    chkNewerRevision.Value = 0
End Sub

Sub optDelete_Click (Index As Integer)
    nDelete = Index
End Sub

Sub optDirectory_Click (Index As Integer)
    nDirectoryCreate = Index
End Sub

