/////////////////////////////////////////////////////////////////
// This program will browse the Xtrieve Data Dictionary files and 
// allow you to select a table to browse, and the associated sort 
// order.  No updates are allowed.
// 
// The program was compiled and linked with Clipper 5.01 and the 
// RaSQL/B Btrieve Replaceable Database Driver (RDD).
//
// RaSQL is a trademark of Communication Horizons
// Xtrieve and Btrieve are registered trademarks of Novell Inc.
// Clipper is a registered trademark of Computer Associates Inc.
/////////////////////////////////////////////////////////////////

#include "rqb.ch"

if iscolor() 
 	set color to bg+/b,b/w,,,b/n
else
	set color to w+/n,w/n,,,w/n
endif
clear
set score off
// display header
@ 1,0 to 4,79 double
cMsg1 = "RaSQL/B RDD XTrieve Browser - Copywrite 1992 Communication Horizons"
cMsg2 = "RaSQL/B distributed by Pinnacle Publishing 800-231-1293/206-251-1900"
@ 2,ch_center(cMsg1) say cMsg1
@ 3,ch_center(cMsg2) say cMsg2
clear all
use table x$file via "rqbrdd"			// open file.ddf
set order to 2					// table name order
goto top
aList := {}
do while !eof()
	aadd(aList,upper(trim(xf_name)))	// build array of table names
	skip
enddo
use
i = 0
do while .t.
	@ 5,0 clear
	@ 5,0 to 24,22 
	@ 7,1 to 7,21 double
	i = achoice(8,1,23,21,aList,.t.,.t.,i)	// select table
	if i = 0
		exit
	endif
	@ 6,1 say trim(aList[i])
	// open selected table
	use table (aList[i]) via "rqbrdd" readonly shared
	aIndex := {}
	x := 0
	do while !empty(indexkey(x+1))
		aadd(aIndex,indexkey(++x))	// build array of index keys
	enddo
	@ 5,23 to 24,79
	@ 7,24 to 7,78 double
	if x > 0
		@ 6,24 say "Select Index"
		x = achoice(8,24,23,78,aIndex)	// select controlling index
		set order to (x)
	endif
	@ 6,24 say "Active Index: "+ indexkey()
	goto top
	browse(7,0,24,79)			// browse Btrieve table
	use
enddo
clear all
@ 23,0 say ""
return
