/*******************************************************************
   	XLUTIL.H
   	=========
 	Header file for XLUTIL.C
 *******************************************************************/
#ifndef _INC_XLUTIL

#include <stdlib.h>

/*
	Normally uses std "C" memory management but alternative
	is to use SMRTHEAP.DLL memory management
*/

/* --------------------------< Memory Utils >--------------------- */

LPVOID PASCAL GetMem(WORD wBytes);
void PASCAL FreeMem(LPVOID lpPtr);

/* -------------------< Array Utils >--------------------- */

LPMULTI PASCAL InitMulti(WORD wRows, WORD wCols, WORD xlType);
LPXLOPER PASCAL InitNum(VOID);
LPXLOPER StripxlbitDLLFree(LPXLOPER lpX);
LPLPREAL PASCAL InitPointers(LPREAL lpData,WORD wRows, WORD wCols);
void FAR * FAR *AllocateArray2D(int NumberOfRows, int NumberOfColumns,
			size_t SizeOfElement, size_t SizeOfPointers);
void FreeArray2D(VOID FAR * FAR *pRow);

/* ------------------------< Error Handler >------------------------ */

BOOL PASCAL ErrorHandler(XLM_ERROR nErrorCode);
void cdecl OkMsgBox(LPSTR lpFormat, ...);
int debugShowStack(void);


/* --------------------< Pascal String Utils >------------------------- */

int PASCAL debugPrinto(LPXLOPER px);
VOID InitPascalStrings (LPSTR  *lpStr, UINT nRows, UINT nCols);
int PASCAL MakePstr(LPSTR lpPstr, LPSTR lpCstr);
int PASCAL MakeCstr(LPSTR lpCstr, LPSTR lpPstr);
LPSTR PASCAL lstrcatszsp(LPSTR lpszStr, LPSTR lpspStr);
int PASCAL lpstricmp(LPSTR s, LPSTR t);
void Find(LPXLOPER pxPos, LPXLOPER pxFindT, LPXLOPER pxFindIn);

/* -------------------< Reference Utils >--------------------- */
BOOL InitDialog(LPXLOPER lpxDialog, LPSTR *rgDlg, UINT nRows);
BOOL GetActiveSheetId(void);
void PASCAL TrimPrefix(LPXLOPER pxRefText);
int  PASCAL GetRefTextFromSelection(LPXLOPER pxRefTextIn,
							LPXLOPER pxRefTextOut, BYTE Offset);
int  PASCAL SetInitialRange(LPXLOPER pxRefText, LPXLOPER pxDlg, WORD wDlgRow);
BOOL PASCAL CreateGlobalRef(LPXLOPER pgxRef, LPXLOPER pxDialog, WORD wDlgRow);
BOOL PASCAL RefIsContinuous(LPXLOPER pxRef);
BOOL IsReferencesOverlapped(LPXLOPER pxRef1, LPXLOPER pxRef2);
void InitGlobalRefFromSRef(LPXLOPER pxRef, LPXLOPER pxSRef);
void InitGlobalRefFromRef(LPXLOPER pxRef1, LPXLOPER pxRef2);
void IncxlmRefRow(LPXLOPER pxRef);
void IncxlmRefCol(LPXLOPER pxRef);
void RefSetRectangle(LPXLOPER pxRef, WORD wRows, BYTE nCols);

/* -------------------< Miscellaneous >--------------------- */

#define _INC_XLUTIL
#endif
