/*----------------------------------------------------------------------*\
\*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*\

 XLMINIT.C

 Author:	Roy Kari
 			Dept. of Chemistry
			Laurentian University
			Sudbury, Ont.
			Canada		P3E 2C6
			(705) 675-1151
			Internet: "ROY@NICKEL.LAURENTIAN.CA"

	This modeule contains the library initialization functions 
	& basic Excel API functions
\*----------------------------------------------------------------------*/


// --------------------------< Include files >--------------------- //

#define ININIT
#define WIN31
#define _MSC_VER 700

#include <windows.h>
#include <xlcall.h>

#include <ctype.h>

#include <framewrk.h>
#include "xlmath.h"
#include <xlutil.h>


// -------------------<Windows Entry & Exit Routines>-------------- //

/*********************************************************************
 LibMain()
 =========
 This is the standard windows DLL entry routine. This allocates
 a task descriptor in the local heap and does byte counts
 ********************************************************************/
BOOL PASCAL FAR _export LibMain(HANDLE hInstance, WORD wDataSegment,
	WORD wHeapSize, LPSTR CommandLine)
{

	if (wHeapSize > 0)
		UnlockData(0);

	// init xlError which is returned for all errors
	gxlError.xltype = xltypeErr;
	gxlError.val.err = xlerrNA;

	// init the error routine help text
	gxHelpRef.xltype = xltypeStr;
	gxHelpRef.val.str = (LPSTR)gspHelpId;

	// init global references
	// all I/O with the sheet is done throught these references
	// each reference can only accomodate one range and hence
	// multiple ranges on a worksheet are NOT allowed
	gxOutRef.xltype = gxInRef.xltype = xltypeRef;
	gxOutRef.val.mref.lpmref = (LPXLMREF)&gxlmOutRef;
	gxInRef.val.mref.lpmref = (LPXLMREF)&gxlmInRef;
	gxlmOutRef.count = gxlmInRef.count = 1;
	
	// init shared memory pools
	gReturnPool = MemPoolInit(TRUE);
	gScratchPool = MemPoolInit(TRUE);

#ifdef _USE_SMARTHEAP
//	#ifdef DEBUG
	MemSetSafetyLevel(MEM_SAFETY_DEBUG,TRUE);
//	#endif
#endif

	ghLibInst = hInstance;

	// Init function strings
	// Each of the following strings are inited to PASCAL 
	// type strings with a leading byte count 
	InitPascalStrings(&rgFuncs[0][0], rgFuncsRows, 7);

	//	Init menu strings;
	InitPascalStrings(&rgMenu[0][0], rgMenuRows, 5);

	//	Init dialog strings
    InitPascalStrings(&rgDlgDiag[0][0], rgDlgDiagRows, 7);
    InitPascalStrings(&rgDlgPoly[0][0], rgPolyDlgRows, 7);
    InitPascalStrings(&rgDlgSpline[0][0], rgSplineDlgRows, 7);
    InitPascalStrings(&rgDlgSgSmooth[0][0], rgSgSmoothDlgRows, 7);
    InitPascalStrings(&rgDlgWtSmooth[0][0], rgWtSmoothDlgRows, 7);
	InitPascalStrings(&rgDlgMO[0][0], rgDlgMORows, 7);
	InitPascalStrings(&rgDlgCalcSpline[0][0], rgCalcSplineDlgRows, 7);
	InitPascalStrings(&rgDlgAbout[0][0], rgDlgAboutRows, 7);
	InitPascalStrings(&rgDlgCustomFit[0][0], rgCustomFitDlgRows, 7);
		
	// Init Framework library
	InitFramework();
	return (1);
}
#if 0
/*********************************************************************
 WEP()
 =====
 This function is the standard windows DLL exit routine
 ********************************************************************/
int PASCAL FAR _export WEP(int bSystemExit)
{
	return 1;
}
#endif
