/*******************************************************************
   	XLMATH.H
   	=========
 	Header file for XLMATH.DLL
	-- Set TABS to 4 to view --
 *******************************************************************/

#ifndef _INC_XLMATH

#ifdef _USE_SMARTHEAP
#include <smrtheap.h>
#else
#include "xlmalloc.h"	
#endif


#define MAX_ERROR_STRING 96	// maximum no. char in error messages

typedef enum				// error message id codes
{
	XLU_NO_MEMORY,
	XLU_MEMORY_ERROR,
	XLU_NO_FREE,
	XLU_NO_ACTIVESHEET,
	XLU_BAD_REF,
	XLU_OVERLAPPED_REF,
	XLU_NO_ARRAY,
	XLD_BAD_DIALOG,
	XLM_NOT_SQUARE,
	XLM_POLY,
	XLM_SMOOTHSG,
	XLM_SMOOTHWT,
	XLM_CUBIC,
	XLM_CALCSPLINE,
	XLM_MODENSITY,
	XLM_CF1,
	XLM_CF2,
	XLM_CF3,
	XLM_CF4,
	XLM_CF5,
	XLM_CF6,
	XLM_CF7,
	XLM_CF8,
} XLM_ERROR;

/* --------------------<Menu & dialog defines >--------------------- */

#define rgFuncsRows 		17
#define rgMenuRows			17
#define rgDlgDiagRows		8
#define rgDlgMORows			11
#define rgPolyDlgRows		13
#define rgSplineDlgRows		11
#define rgWtSmoothDlgRows	11
#define rgCustomFitDlgRows	11
#define rgSgSmoothDlgRows	13
#define rgCalcSplineDlgRows	13
#define rgDlgAboutRows		8

// the following define the dialog box row for default values
#define	DIAG_IN_ROW				2
#define DIAG_OUT_ROW			4
#define	MO_COEF_ROW				3
#define MO_OCC_ROW				5
#define	MO_OUT_ROW				7
#define POLY_XVAR_ROW			3
#define	POLY_YVAR_ROW			5
#define POLY_ORDER_ROW			7
#define POLY_OUT_ROW			9
#define SPLINE_XVAR_ROW			3
#define SPLINE_YVAR_ROW 		5
#define SPLINE_OUT_ROW			7
#define WTSMOOTH_DATA_ROW		3
#define WTSMOOTH_WEIGHT_ROW		5
#define WTSMOOTH_OUT_ROW		7
#define CFIT_DATA_ROW			3
#define CFIT_PARM_ROW			5
#define CFIT_OUT_ROW			7
#define SGSMOOTH_DATA_ROW		3
#define SGSMOOTH_SMOOTHNUM_ROW	5
#define SGSMOOTH_DERIVNUM_ROW	7
#define SGSMOOTH_OUT_ROW		9
#define CALCSPLINE_XORIG_ROW	3
#define CALCSPLINE_XCALC_ROW	7
#define CALCSPLINE_COEF_ROW		5
#define CALCSPLINE_OUT_ROW		9

/* -----------------<Type & structure definitions >--------------------- */

typedef double				*NPREAL;
typedef double 	FAR 		*LPREAL;
typedef double 	FAR * FAR	*LPLPREAL;
typedef int 	FAR * FAR	*LPLPINT;
typedef void 	FAR * FAR	*LPLPVOID;
typedef LPSTR 	FAR			*LPLPSTR;

/*----------------------------------------------------------------------*\

					typedef's

	The MULTI struture below differs from the Excel xltype Multi
	in that MULTI allocates memory for both the info structure
	and the array. This makes it much easier to free memory in
	xlAutoFree.
	
\*----------------------------------------------------------------------*/

typedef struct multi		// XL Multi array
{
	XLOPER	Info;			// XLOPER containing pointer to data
	XLOPER	Data[1];		// matrix of XLOPER's containing data
} MULTI;
typedef		MULTI FAR		*LPMULTI;

typedef struct fp			// XL floating point array
{
	WORD wRows;				// no rows
	WORD wCols;				// no columns
	double Data[1];			// array data
} FP;
typedef		FP FAR			*LPFP;


/* -----------------------< global variables >--------------------- */

#ifdef ININIT

HANDLE ghLibInst;

// SMARTHEAP memory pools
MEM_POOL gReturnPool = NULL;
MEM_POOL gScratchPool = NULL;

// used to return xltypeNum
XLOPER gxlNum =
{
	(double) 0.0,
	xltypeNum,
};
LPXLOPER glpxlNum = (LPXLOPER)&gxlNum;

// used for ERROR returns
XLOPER gxlError;
LPXLOPER glpxlError = (LPXLOPER)&gxlError;
char gszErrorBuf[MAX_ERROR_STRING];

// sheet ID
XLOPER gxActiveSheetName, gxActiveSheetId;
char gszActiveSheetName[80];

// global input & output references: inited in init.c
XLMREF 	gxlmOutRef;
XLOPER 	gxOutRef;	// init to point to gxlmOutRef
XLMREF	gxlmInRef;
XLOPER 	gxInRef;	// init to point to gxlmInRef

/*****************************************************
 *
 * These must be changed for each new XLL module
 *
 *****************************************************/

char gszLibName[] = "XLMATH.XLL";
char gspShortLibName[] = "\006XLMATH";
char gspLongLibName[] = "\025Xlmath Standalone DLL";
char gspHelpId[] = "\016XLMATH.HLP!101";
XLOPER gxHelpRef;
LPXLOPER gpxHelpRef = (LPXLOPER)&gxHelpRef;

// CustomFit communications with macro
LPMULTI lpMultiCfit;	// return p to macro
XLOPER xMacroRef;		// reference to CustomFitMacro
char gspCFitMacroName[] = "\017!CustomFitMacro";	// CustomFitMacro name


/* -----------------------< Function registration >--------------------- */


LPSTR rgFuncs[rgFuncsRows][7] =
{
{" CalcSpline",   	" RKKK", " CalcSpline",  " Xorig,Coef,Xcalc",
	" 1", " XLMath Add-In", " "},
{" Diagonalize",  " RK",	" Diagonalize",	" SymMat",
	" 1", " XLMath Add-In",	" "},
{" MODensity",    	" RKK", " MODensity",   " Coefficients, Occupancy",
	" 1", " XLMath Add-In", " "},
{" PolyCurveFit", " RKKH", " PolyCurvefit",	" Xvar,Yvar,Order",
	" 1", " XLMath Add-In", " "},
{" CubicSplines", " RKK",  " CubicSplines",	" Xvar,Yvar",
	" 1", " XLMath Add-In", " "},
{" SmoothSG",     " RKHH", " SmoothSG", 	" Data,SmoothNum,DerivNum",
	" 1", " XLMath Add-In", " "},
{" SmoothWeights"," RKK", " SmoothWt", 		" Data,Weights",
	" 1", " XLMath Add-In", " "},

// NOTE:	CustomFit cannot be defined as a custom function
//			because it uses macro sheet only commands. It is
//			in effect, a custom command rather than a function.
//	{" CustomFit",	  " RKK", " CustomFit",		" Data,Parameters",
//		" 1", " XLMath Add-In", " "},

{" fDiagonalize",	" A", " fDiagonalize",	" ",	" 2", " XLMath Add-In", " "},
{" fMODensity",		" A", " fMODensity",	" ",	" 2", " XLMath Add-In",	" "},
{" fPolyCurveFit",	" A", " fPolyCurvefit",	" ",	" 2", " XLMath Add-In", " "},
{" fCubicSplines",	" A", " fCubicSplines",	" ",	" 2", " XLMath Add-In", " "},
{" fSmoothSg",		" A", " fSmoothSg", 	" ",	" 2", " XLMath Add-In", " "},
{" fSmoothWt",		" A", " fSmoothWt", 	" ",	" 2", " XLMath Add-In", " "},
{" fCalcSpline",	" A", " fCalcSpline",	" ",	" 2", " XLMATH Add-In", " "},
{" fCustomFit",		" A", " fCustomFit",	" ",	" 2", " XLMATH Add-In", " "},
{" fExit",			" A", " fExit",			" ",	" 2", " XLMath Add-In",	" "},
{" fAbout",			" A", " fAbout",		" ",	" 2", " XLMATH Add-In",	" "},
};

/* -----------------------< Menu Definitions >--------------------- */

LPSTR rgMenu[rgMenuRows][5] =
{
{" &Xlmath",			" ",				" ",
	" The Xlmath Add-in",						" XLMATH.HLP!100"},
{" &PolyCurveFit...",	" fPolyCurveFit",	" ",
	" n'th order polynomial fitting", 			" XLMATH.HLP!100"},
{" -",					" ",				" ",
	" ",										" "},	
{" &CubicSplines...",	" fCubicSplines",	" ",
	" Calculate spline function coefficients",	" XLMATH.HLP!100"},
{" C&alcSpline...",	" fCalcSpline",	" ",
	" Calculate cubic spline interpolated Y values",	" XLMATH.HLP!100"},
{" -",					" ",				" ",
	" ",										" "},	
{" Smooth&Wt...",		" fSmoothWt",			" ",
	" Weights smoothing of data",				" XLMATH.HLP!100"},
{" Smooth&SG...",		" fSmoothSg",			" ",
	" Savitsky-Golay smoothing of data",		" XLMATH.HLP!100"},
{" -",					" ",				" ",
	" ",										" "},	
{" Custom&Fit...",		" fCustomFit",			" ",
	" Marquardt fitting",						" XLMATH.HLP!100"},
{" -",					" ",				" ",
	" ",										" "},	
{" &Diagonalize...",	" fDiagonalize",		" ",
	" Diagonalize real-symmetric matrix", 		" XLMATH.HLP!100"},
{" &MODensity...",		" fMODensity",			" ",
	" Calculate charges & bond orders",			" XLMATH.HLP!100"},
{" -",					" ",				" ",
	" ",										" "},	
{" E&xit",				" fExit",				" ",
	" Remove Xlmath-add-in",					" XLMATH.HLP!100"},
{" -",					" ",				" ",
	" ",										" "},	
{" A&bout...",			" fAbout",				" ",
	" About Xlmath Add-In",						" XLMATH.HLP!100"},
};


/* ---------------------< Dialog box definitions >--------------------- */

LPSTR rgDlgDiag[rgDlgDiagRows][7] =
{
{" XLMATH.HLP!1",	" "," ",	" 380",	" 110",	" Diagonalize",		" "},
{" 5",	" 15", 	" 15",	" ",	" ",	" &Input range",	" "},
{" 10",	" 185",	" 10",	" 160",	" ",	" ",				" "},
{" 5",	" 15",	" 45",	" ",	" ",	" &Output range",	" "},
{" 10",	" 185",	" 40",	" 160",	" ",	" ",				" "},
{" 1",	" 15",	" 75", 	" 88",	" ",	" OK",				" "},
{" 2",	" 135",	" 75",	" 88",	" ",	" Cancel",			" "},
{" 24",	" 260",	" 75",	" 88",	" ",	" Help",			" "},
};

LPSTR rgDlgMO[rgDlgMORows][7] =
{
{" XLMATH.HLP!6",	" "," ",	" 350",	" 180",	" MO Density",		" "},
{" 14",	" 15",	" 15",	" 300",	" 80",	" Input",			" "},
{" 5",	" 25",	" 35",	" ",	" ",	" &Coefs range",	" "},
{" 10",	" 135",	" 30",	" 160",	" ",	" ",				" "},
{" 5",	" 25",	" 65",	" ",	" ",	" O&cc range",		" "},
{" 10",	" 135",	" 60",	" 160",	" ",	" ",				" "},
{" 5",	" 25",	" 105",	" ",	" ",	" &Output range",			" "},
{" 10",	" 135",	" 100",	" 160",	" ",	" ",				" "},
{" 1",	" 15",	" 140",	" 88",	" ",	" OK",				" "},
{" 2",	" 125",	" 140",	" 88",	" ",	" Cancel",			" "},
{" 24",	" 240",	" 140",	" 88",	" ",	" Help",			" "},
};


LPSTR rgDlgPoly[rgPolyDlgRows][7] =
{
{" XLMATH.HLP!2",	" "," ",	" 380",	" 180",	" Polynomial Fit", 	" "},
{" 14",	" 15",	" 15",	" 350",	" 100",	" &Input",			" "},
{" 5",	" 25",	" 35",	" ",	" ",	" &Xvar range",		" "},
{" 10",	" 185",	" 30",	" 160",	" ",	" ",				" "},
{" 5",	" 25",	" 65",	" ",	" ",	" &Yvar range",		" "},
{" 10",	" 185",	" 60",	" 160",	" ",	" ",				" "},
{" 5",	" 25",	" 95",	" ",	" ",	" O&rder", 			" "},
{" 7",	" 185", " 90",	" 40",	" ",	" ",				" 2"},
{" 5",	" 25",	" 130",	" ",	" ",	" &Output range",	" "},
{" 10",	" 185",	" 125",	" 160",	" ",	" ",				" "},
{" 1",	" 30",	" 155",	" 88",	" ",	" OK",				" "},
{" 2",	" 150",	" 155",	" 88",	" ",	" Cancel",			" "},
{" 24",	" 270",	" 155",	" 88",	" ",	" Help",			" "},
};

LPSTR rgDlgSpline[rgSplineDlgRows][7] =
{
{" XLMATH.HLP!3",	" "," ",	" 350",	" 180",	" Spline Fitting",		" "},
{" 14",	" 15",	" 15",	" 300",	" 75",	" Input",			" "},
{" 5",	" 25",	" 35",	" ",	" ",	" &Xvar range",		" "},
{" 10",	" 135",	" 30",	" 160",	" ",	" ",				" "},
{" 5",	" 25",	" 65",	" ",	" ",	" &Yvar range",		" "},
{" 10",	" 135",	" 60",	" 160",	" ",	" ",				" "},
{" 5",	" 25",	" 110",	" ",	" ",	" &Output range",	" "},
{" 10",	" 135",	" 105",	" 160",	" ",	" ",				" "},
{" 1",	" 15",	" 140",	" 88",	" ",	" OK",				" "},
{" 2",	" 125",	" 140",	" 88",	" ",	" Cancel",			" "},
{" 24",	" 240",	" 140",	" 88",	" ",	" Help",			" "},
};

LPSTR rgDlgWtSmooth[rgWtSmoothDlgRows][7] =
{
{" XLMATH.HLP!5",	" ",	" ",	" 380",	" 180",	" Wts Smoothing",	" "},
{" 14",	" 15",	" 15",	" 350",	" 80",	" Input",			" "},
{" 5",	" 25",	" 35",	" ",	" ",	" &Data range",		" "},
{" 10",	" 185",	" 30",	" 160",	" ",	" ",				" "},
{" 5",	" 25",	" 65",	" ",	" ",	" &Weights range",		" "},
{" 10",	" 185",	" 60",	" 160",	" ",	" ",				" "},
{" 5",	" 25",	" 110",	" ",	" ",	" &Output range",			" "},
{" 10",	" 185",	" 105",	" 160",	" ",	" ",				" "},
{" 1",	" 25",	" 140",	" 88",	" ",	" OK",				" "},
{" 2",	" 145",	" 140",	" 88",	" ",	" Cancel",			" "},
{" 24",	" 270",	" 140",	" 88",	" ",	" Help",			" "},
};

LPSTR rgDlgCustomFit[rgCustomFitDlgRows][7] =
{
{" XLMATH.HLP!8",	" ",	" ",	" 380",	" 180",	" Custom Fitting",	" "},
{" 14",	" 15",	" 15",	" 350",	" 80",	" Input",			" "},
{" 5",	" 25",	" 35",	" ",	" ",	" &Data range",		" "},
{" 10",	" 185",	" 30",	" 160",	" ",	" ",				" "},
{" 5",	" 25",	" 65",	" ",	" ",	" &Parameters range",		" "},
{" 10",	" 185",	" 60",	" 160",	" ",	" ",				" "},
{" 5",	" 25",	" 110",	" ",	" ",	" &Output range",			" "},
{" 10",	" 185",	" 105",	" 160",	" ",	" ",				" "},
{" 1",	" 25",	" 140",	" 88",	" ",	" OK",				" "},
{" 2",	" 145",	" 140",	" 88",	" ",	" Cancel",			" "},
{" 24",	" 270",	" 140",	" 88",	" ",	" Help",			" "},
};

LPSTR rgDlgSgSmooth[rgSgSmoothDlgRows][7] =
{
{" XLMATH.HLP!4",	" "," ",	" 380",	" 210",	" S-G Smoothing",	" "},
{" 14",	" 15",	" 15",	" 350",	" 100",	" Input",			" "},
{" 5",	" 25",	" 35",	" ",	" ",	" &Data range",			" "},
{" 10",	" 185",	" 30",	" 160",	" ",	" ",				" "},
{" 5",	" 25",	" 65",	" ",	" ",	" &SmoothNum",		" "},
{" 7",	" 185",	" 60",	" 40",	" ",	" ",				" 2"},
{" 5",	" 25",	" 95",	" ",	" ",	" &DerivNum",		" "},
{" 7",	" 185",	" 90",	" 40",	" ",	" ",				" 0"},
{" 5",	" 25",	" 130",	" ",	" ",	" &Output range",			" "},
{" 10",	" 185",	" 125",	" 160",	" ",	" ",				" "},
{" 1",	" 25",	" 170",	" 88",	" ",	" OK",				" "},
{" 2",	" 145",	" 170",	" 88",	" ",	" Cancel",			" "},
{" 24",	" 270",	" 170",	" 88",	" ",	" Help",			" "},
};

LPSTR rgDlgCalcSpline[rgCalcSplineDlgRows][7] =
{
{" XLMATH.HLP!7",	" "," ",	" 380",	" 210",	" CalcSpline", " "},
{" 14",	" 15",	" 15",	" 350",	" 100",	" Input", 			" "},
{" 5",	" 25",	" 35",	" ",	" ",	" &Fitted X range",	" "},
{" 10",	" 185",	" 30",	" 160",	" ",	" ",				" "},
{" 5",	" 25",	" 65",	" ",	" ",	" &Coef range", 	" "},
{" 10",	" 185",	" 60",	" 160",	" ",	" ",				" "},
{" 5",	" 25",	" 95",	" ",	" ",	" &Interpolated X range"," "},
{" 10",	" 185",	" 90",	" ",	" ",	" ",				" "},
{" 5",	" 25",	" 130",	" ",	" ",	" &Output range",	" "},
{" 10",	" 185",	" 125",	" 160",	" ",	" ",				" "},
{" 1",	" 25",	" 170",	" 88",	" ",	" OK",				" "},
{" 2",	" 145",	" 170",	" 88",	" ",	" Cancel",			" "},
{" 24",	" 270",	" 170",	" 88",	" ",	" Help",			" "},
};

LPSTR rgDlgAbout[rgDlgAboutRows][7] =
{
{" ",	" ",	" ",	" 300",	" 145",	" About Xlmath",				" "},
{" 5",	" 5",	" 15",	" ",	" ",	" Author: Roy Kari",			" "},
{" 5",	" 5",	" 30",	" ",	" ",	" Copyright 1992, v2.0",		" "},
{" 5",	" 5",	" 45",	" ",	" ",	" For Support Call:",			" "},
{" 5",	" 5",	" 60",	" ",	" ",	" voice: (705)692-4059",		" "},
{" 5",	" 5",	" 75",	" ",	" ",	" fax:   (705)675-4844",		" "},
{" 5",	" 5",	" 90",	" ",	" ",	" Internet: ROY@NICKEL.LAURENTIAN.CA",	" "},
{" 1",	" 105",	" 113",	" 75",	" ",	" OK",							" "},
};

#endif

#ifndef ININIT

/*----------------------------------------------------------------------*\
				ININIT defined only in XLMINIT.C
\*----------------------------------------------------------------------*/

extern HANDLE ghLibInst;

extern MEM_POOL gReturnPool;
extern MEM_POOL gScratchPool;

extern XLOPER gxlNum;
extern LPXLOPER glpxlNum;
extern XLOPER gxlError;
extern LPXLOPER glpxlError;

extern LPSTR rgFuncs[rgFuncsRows][7];
extern LPSTR rgMenu[rgMenuRows][5];
extern LPSTR rgDlgDiag[rgDlgDiagRows][7];
extern LPSTR rgDlgMO[rgDlgMORows][7];
extern LPSTR rgDlgPoly[rgPolyDlgRows][7];
extern LPSTR rgDlgSpline[rgSplineDlgRows][7];
extern LPSTR rgDlgWtSmooth[rgWtSmoothDlgRows][7];
extern LPSTR rgDlgCustomFit[rgCustomFitDlgRows][7];
extern LPSTR rgDlgSgSmooth[rgSgSmoothDlgRows][7];
extern LPSTR rgDlgCalcSpline[rgCalcSplineDlgRows][7];
extern LPSTR rgDlgAbout[][7];

// sheet ID
extern XLOPER gxActiveSheetName, gxActiveSheetId;
extern char gszActiveSheetName[];

extern	XLOPER gxOutRef;
extern	XLMREF gxlmOutRef;
extern 	XLOPER 	gxInRef;
extern	XLMREF	gxlmInRef;

// module specific names
extern char gszLibName[];
extern char gspShortLibName[];
extern char gspLongLibName[];
extern char gszErrorBuf[];
extern char gspHelpId[];
extern XLOPER gxHelpRef;
extern LPXLOPER gpxHelpRef;

// CustomFit
extern LPMULTI lpMultiCfit;
extern XLOPER xMacroRef;
extern char gspCFitMacroName;

#endif

/* ----------------<EXPORT function prototypes>------------------ */

BOOL PASCAL FAR _export LibMain( HANDLE, WORD, WORD, LPSTR);
int PASCAL FAR _export WEP(BOOL);

void __export FAR PASCAL xlAutoFree(LPXLOPER lpMulti);
LPXLOPER PASCAL FAR __export Diagonalize(LPFP lpHmat);
LPXLOPER FAR PASCAL __export MODensity(LPFP Eivec, LPFP Occ);
LPXLOPER PASCAL FAR __export PolyCurveFit(LPFP lpIndVar, LPFP lpDepVar,
								unsigned int Order);
LPXLOPER PASCAL FAR __export CubicSplines(LPFP lpIndVar, LPFP lpDepVar);
LPXLOPER PASCAL FAR __export CalcSpline(LPFP lpXorig, LPFP lpCoef, LPFP lpXcalc);
LPXLOPER PASCAL FAR __export SmoothSG(LPFP lpData, unsigned int wSmoothNum,
								unsigned int wDerivNum);
LPXLOPER PASCAL FAR __export SmoothWeights(LPFP lpData, LPFP lpWeights);
LPXLOPER PASCAL FAR __export CustomFit(LPFP lpData, LPFP lpParms);
int PASCAL FAR      __export fExit(VOID);
int PASCAL FAR  __export fAbout(void);

#define _INC_XLMATH
#endif
