/*******************************************************************
	XLMALLOC.H
	This header file replaces all SMRTHEAP memory allocations
	with Microsoft malloc() and free() allocators to FAR 
	memory blocks. This must be compiled in the LARGE model
*******************************************************************/
#ifndef _INC_XLMALLOC

#include <malloc.h>
#include <memory.h>

typedef void	*MEM_POOL;

// prototypes
MEM_POOL PASCAL MemPoolInit(BOOL bShared);
BOOL PASCAL MemPoolFree(MEM_POOL);
DWORD PASCAL MemPoolCount(MEM_POOL);
LPVOID PASCAL MemAllocPtr(MEM_POOL pool, WORD wSize,
	BOOL bZeroInit);
LPVOID PASCAL MemReAllocPtr(LPVOID lpMem, WORD wSize,
	BOOL bZeroInit);
BOOL PASCAL MemFreePtr(LPVOID lpPtr);
BOOL PASCAL MemCheckPtr(MEM_POOL pool, LPVOID lpPtr);
BOOL PASCAL MemSetSafetyLevel(int, BOOL);

#define _INC_XLMALLOC
#endif
