typedef enum ButtonType      { LeftButton,RightButton,MidButton } ButtonType;
typedef enum MouseMode       { Hardware,Software }                MouseMode;
typedef unsigned int             MouseDef[31];
extern int                       MouseOK;
extern int                       NoButtons;
extern int                       MidPressed,RightPressed,LeftPressed;
extern MouseDef                  Mymouse;
extern int                       MouseX, MouseY;

void InitMouse();
void ShowMouse();
void HideMouse();
void MouseXY();
void MouseToXY(int xpos, int ypos);
int MousePressCount(ButtonType button, int *status);
int MouseReleaseCount(ButtonType button, int *status);
void MouseXRange(int x1, int x2);
void MouseYRange(int y1, int y2);
void DefineGraphMouse(MouseDef mouse, int xhot, int yhot);
void DefineTextMouse(MouseMode mode, int scrnmask, int cursormask);
void ReadMouseMickey(int *Xspeed, int *Yspeed);
void SetMouseMickey(int Xspeed, int Yspeed);
void TextCursorOff();
void TextCursorOn();
