/*-----------------------------------------------------------------------
;
; XRECT - header file
;
;
;
; ****** XLIB - Mode X graphics library                ****************
; ******                                               ****************
; ****** Written By Themie Gouthas                     ****************
;
; egg@dstos3.dsto.gov.au
; teg@bart.dsto.gov.au
;
;  Terminology & notes:
;         VRAM ==   Video RAM
;         SRAM ==   System RAM
;         X coordinates are in pixels unless explicitly stated
;
;-----------------------------------------------------------------------*/

#ifndef _XRECT_H_
#define _XRECT_H_

#include "xdefs.h"

/* FUNCTIONS =========================================================== */


void x_rect_pattern(      /* draw a pattern filled rectangle      */
  xScreenCoord_t StartX,
  xScreenCoord_t StartY,
  xScreenCoord_t EndX,
  xScreenCoord_t EndY,
  xPageHandle_t PageBase,
  BYTE * Pattern
);

void x_rect_pattern_clipped(  /* draw a pattern filled clipped   */
  xScreenCoord_t StartX,          /* rectangle                       */
  xScreenCoord_t StartY,
  xScreenCoord_t EndX,
  xScreenCoord_t EndY,
  xPageHandle_t PageBase,
  BYTE * Pattern
);

void  x_rect_fill(         /* draw a single colour filled rectangle */
  xScreenCoord_t StartX,
  xScreenCoord_t StartY,
  xScreenCoord_t EndX,
  xScreenCoord_t EndY,
  xPageHandle_t PageBase,
  int color
);

void  x_rect_fill_clipped(   /* draw a single colour filled */
xScreenCoord_t StartX,        /* and clipped rectangle       */
  xScreenCoord_t StartY,
  xScreenCoord_t EndX,
  xScreenCoord_t EndY,
  xPageHandle_t PageBase,
  int color
);

void  x_cp_vid_rect(       /* Copy rect region within VRAM          */
  xScreenCoord_t SourceStartX,
  xScreenCoord_t SourceStartY,
  xScreenCoord_t SourceEndX,
  xScreenCoord_t SourceEndY,
  xScreenCoord_t DestStartX,
  xScreenCoord_t DestStartY,
  xPageHandle_t SourcePageBase,
  xPageHandle_t DestPageBase,
  int SourceBitmapWidth,
  int DestBitmapWidth
);

/* Copy a rectangular region of a VGA screen, with x coordinates
rounded to the nearest byte -- source and destination may overlap. */

void  x_shift_rect (
	xScreenCoord_t SrcLeft,
	xScreenCoord_t SrcTop,
  xScreenCoord_t SrcRight,
	xScreenCoord_t SrcBottom,
  xScreenCoord_t DestLeft,
	xScreenCoord_t DestTop,
	xPageHandle_t ScreenOffs
);


#endif


