/*-----------------------------------------------------------------------
;
; XPLAIN - header file
;
; This module was written by Tiaan A Geldenhuys
; geld-ta@mella.ee.up.ac.za
;
;-----------------------------------------------------------------------*/

#ifndef _XPLAIN_H_
#define _XPLAIN_H_


#include "xdefs.h"

/* FUNCTIONS =========================================================== */


/* Check for collision between two variable sized plain bitmap structures */

char x_check_collision_plain(
  BYTE *VicStruct1,
  int X1,
  int Y1,
  BYTE *VicStruct2,
  int X2,
  int Y2);


void x_get_plain(          /* Copy a bitmap from planar VRAM to plain SRAM */
  xScreenCoord_t X,
  xScreenCoord_t Y,
  int Bw,
  int Bh,
  xPageHandle_t ScrnOffs,
  BYTE * VicStruct,
  xColor_t ColorMask
  #ifdef __cplusplus
   = 0xFF
  #endif
  );


void x_pbm_to_plain(         /* Convert from planar bitmap to plain bitmap */
  BYTE * source_pbm,
  BYTE * dest_VicStruct,
  xColor_t ColorMask
  #ifdef __cplusplus
   = 0xFF
  #endif
  );


void x_bm_to_plain(          /* Convert from linear bitmap to plain bitmap */
  BYTE * source_bm,
  BYTE * dest_VicStruct,
  xColor_t ColorMask
  #ifdef __cplusplus
   = 0xFF
  #endif
  );


void x_put_plain(   /* Copy a VIC bitmap (variable size) from SRAM to VRAM */
  int X,
  int Y,
  xPageHandle_t ScrnOffs,
  BYTE * VicStruct,
  xColor_t Color);



/* VARIABLES =========================================================== */

extern int CollideX;   /* Coordinate of pixel that caused last collision */
extern int CollideY;

#endif
