/*-----------------------------------------------------------------------
;
; XPBMCLIP - header file
;
;
;
; ****** XLIB - Mode X graphics library                ****************
; ******                                               ****************
; ****** Written By Themie Gouthas                     ****************
;
; egg@dstos3.dsto.gov.au
; teg@bart.dsto.gov.au
;
;  Terminology & notes:
;         VRAM ==   Video RAM
;         SRAM ==   System RAM
;         X coordinates are in pixels unless explicitly stated
;
;-----------------------------------------------------------------------*/

#ifndef _XPBMCLIP_H_
#define _XPBMCLIP_H_

#include "xdefs.h"

/* FUNCTIONS =========================================================== */


int x_put_masked_pbm_clipxy( /* Copy a planar bitmap from SRAM masking */
  xScreenCoord_t X,          /* only non zero pixels to VRAM           */
  xScreenCoord_t Y,          /* Supports clipping in the Y direction   */
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap);


int x_put_pbm_clipxy(   /* Copy a planar bitmap from SRAM masking */
  xScreenCoord_t X,     /* Supports clipping in the X&Y directions */
  xScreenCoord_t Y,
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap);


#endif


