/*----------------------------------------------------------------------
;
; XLIB - header file
;
;
;
; ****** XLIB - Mode X graphics library                ****************
; ******                                               ****************
; ****** Written By Themie Gouthas                     ****************
;
; egg@dstos3.dsto.gov.au
; teg@bart.dsto.gov.au
;
; Header file contributed by Darren Lyon (darren@nicky.DIALix.oz.au)
;
;
;  Terminology & notes:
;         VRAM ==   Video RAM
;         SRAM ==   System RAM
;         X coordinates are in pixels unless explicitly stated
;
;----------------------------------------------------------------------*/

#ifndef _XLIB_H_
#define _XLIB_H_

#include "xdefs.h"

#define X_MODE_320x200  0
#define X_MODE_320x240  1
#define X_MODE_360x200  2
#define X_MODE_360x240  3
#define X_MODE_376x282  4
#define X_MODE_320x400  5
#define X_MODE_320x480  6
#define X_MODE_360x400  7
#define X_MODE_360x480  8
#define X_MODE_360x360  9
#define X_MODE_376x308  10
#define X_MODE_376x564  11
#define X_MODE_256x400  12
#define X_MODE_256x480  13


#define BACKWARD 0
#define FORWARD  1

#define X_MODE_INVALID  -1
#define ERROR            1
#define OK               0

/* FUNCTIONS =========================================================== */


 int x_set_mode(
    int mode,                /* Initialize x mode           */
    int WidthInPixels);

 void x_select_default_plane( /*Enables Read/Write access to a    */
    BYTE plane);   /* a specified plane                */

 void x_set_splitscreen(            /* set the split screen start  */
    xScreenCoord_t line);         /*scan line (initialize)       */

 void x_set_start_addr(
    xScreenCoord_t X,             /* Set the screen start        */
    xScreenCoord_t Y);            /* address in video ram        */

 void x_hide_splitscreen(void); /* Disable the split screen (Split */
        /* Screen RAM remains reserved)    */

 void x_show_splitscreen(void); /* Enable the split screen (given it */
        /* was previously "hidden")          */


 void x_adjust_splitscreen(   /* Adjust the start scan line of the */
    xScreenCoord_t line);   /* split screen                      */


 int x_set_doublebuffer(         /* Enable double buffering with a    */
    int PageHeight); /* specified page height             */

 int x_set_tripplebuffer(         /* Enable tripple buffering with a    */
        int PageHeight); /* specified page height             */


 void x_page_flip(        /* Swap visible page (only when double   */
    xScreenCoord_t X,   /* buffering is active) & sets virt start*/
    xScreenCoord_t Y);

 void x_set_cliprect(      /* Define the clipping rectangle */
    xScreenCoord_t left, /* NOTE: left and right are in bytes */
    xScreenCoord_t top,
    xScreenCoord_t righ,
    xScreenCoord_t bottom);

 void x_text_mode(void);   /* return to text mode */
 void x_wait_vsync(void);  /* wait for vsync */


/* VARIABLES =========================================================== */

extern BYTE InGraphics;             /* non zero if in X graphics mode      */
extern int CurrXMode;              /* contains current X graphics mode id */
extern int ScrnPhysicalByteWidth;  /* Physical screen width in bytes      */
extern int ScrnPhysicalPixelWidth; /* Physical screen width in pixels     */
extern int ScrnPhysicalHeight;     /* Physical screen height in pixels    */
extern int ErrorValue;             /* Error return value                  */
extern xPageHandle_t SplitScrnOffs;          /* Offset in VRAM  of split screen     */
extern xScreenCoord_t SplitScrnScanLine;      /* Scan line split screen starts at    */
            /* initially. Resizing the split scrn  */
            /* using the other functions does not  */
            /* change this value                   */
extern int SplitScrnVisibleHeight; /* Height of the visible portion of the*/
            /* split screen.                       */
extern xPageHandle_t Page0_Offs;             /* Offset in VRAM of main virt. screen */
extern xPageHandle_t Page1_Offs;             /* Offset in VRAM of 2nd virt. screen  */
extern xPageHandle_t Page2_Offs;             /* Offset in VRAM of 3rd virt. screen  */
extern int ScrnLogicalByteWidth;   /* Virtual screen width in bytes       */
extern int ScrnLogicalPixelWidth;  /* Virtual screen width in pixels      */
extern int ScrnLogicalHeight;      /* Virtual screen height in pixels     */
extern xScreenCoord_t MaxScrollX;             /* Max X position of physical screen   */
            /*  within virtual screen              */
extern xScreenCoord_t MaxScrollY;             /* Max Y position of physical screen   */
            /*  within virtual screen              */
extern int DoubleBufferActive;     /* Indicates whether double buffering  */
                  /* is active                           */
extern int TrippleBufferActive;    /* Indicates whether tripple           */
            /* buffering is active                 */
extern int VisiblePageIdx;         /* Index number of visible page 0 or 1 */
extern xPageHandle_t HiddenPageOffs;         /* Offset of Hidden Pg | only valid    */
extern xPageHandle_t VisiblePageOffs;        /* Offset of Visible Pg| for D.B. mode */
extern xPageHandle_t WaitingPageOffs;        /* Offset of Waiting Pg| for T.B. mode */
extern xPageHandle_t NonVisual_Offs;         /* Offset of first non-visible VRAM    */

extern int StartAddressFlag;

extern xScreenCoord_t TopClip;                /* Clipping rectangle                  */
extern xScreenCoord_t BottomClip;
extern xScreenCoord_t LeftClip;
extern xScreenCoord_t RightClip;

extern xScreenCoord_t PhysicalStartPixelX;    /* Coordinates of physical (visible) */
extern int PhysicalStartByteX;     /* screen relative to the virtual    */
extern xScreenCoord_t PhysicalStartY;         /* screen's U.L. corner              */

extern char* VsyncPaletteBuffer;


#endif


